/******************************************************************************
 *
 *    FILE NAME:  EYP.H  (IPFAF WorkStation API External include file)
 *
 *=============================================================================
 *
 *    5655-A27
 *    Copyright (C) IBM Corp. 1997.  All Rights Reserved.
 *
 *    US Government Users Restricted Rights - Use, duplication or
 *    disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 *    Licensed Materials - Property of IBM
 *
 *=============================================================================
 *
 *    DESCRIPTION:
 *       This is the external header file for the IPFAF Workstation Client
 *       API module. It defines structures, #typedefs, global data, etc.,
 *       needed to program to the IPFAF Workstation API module.
 *
 *****************************************************************************/

/*---------------------------------------------------------------------------*/
/*    If this file has already been presented to the compiler, then don't    */
/*    compile the statements in this file again. If __EYP_H__ has already    */
/*    been defined, then all the statements in this file are ignored.        */
/*---------------------------------------------------------------------------*/
#ifndef __EYP_H__
#define __EYP_H__

/*---------------------------------------------------------------------------*/
/*    Include the appropriate Operating System header file.                  */
/*---------------------------------------------------------------------------*/
#ifdef _WIN32
  #include <windows.h>
  #if !defined(__DLLBLD__)
    #define APIEXPORT __declspec( dllimport )
  #else
    #define APIEXPORT __declspec( dllexport )
  #endif
  #define FAFENTRY __stdcall
#else
  #include <os2.h>
  #define APIEXPORT
  #if !defined(__DLLBLD__)
    #define FAFENTRY _System
  #else
    #define FAFENTRY _System _Export
  #endif
#endif

/*===========================================================================*/
/*                                                                           */
/*                  IPFAF WorkStation API Return Codes                       */
/*                                                                           */
/*===========================================================================*/
/*    1000-1499 = Common Information Warning Codes                           */
/*    1500-1999 = Common Warning Codes                                       */
/*    2000-2999 = Common Error codes                                         */
/*    3000-9999 = API Area Specifc Error codes                               */
/*                3000-3999 - Session Management                             */
/*                4000-4999 - Folder Management                              */
/*                5000-5999 - Note Management                                */
/*                6000-6999 - Document Management                            */
/*                7000-7999 - Pending Document Management                    */
/*                8000-8999 - Event Management                               */
/*                9000-9999 - Workflow Management                            */
/*---------------------------------------------------------------------------*/
#define FAF_RC_OK                                     0
#define FAF_RC_ASYNC_STARTED                       1000
#define FAF_RC_API_UNDER_CONSTRUCTION              1001
#define FAF_RC_MORE_DATA                           1002
#define FAF_RC_HOST_API_WARNING                    1500
#define FAF_RC_IODM_FAILURE                        1501

#define FAF_RC_INVALID_CLIENT_PARAMETER            2000
#define FAF_RC_HOST_API_ERROR                      2001
#define FAF_RC_INVALID_HFSESSION                   2002
#define FAF_RC_INVALID_FAFRESULT                   2003
#define FAF_RC_INVALID_ODMCOMPLETE                 2004
#define FAF_RC_INTERNAL_ERROR                      2005
#define FAF_RC_HOST_TIMEOUT                        2006
#define FAF_RC_NETWORK_PROTOCOL_INSTALL_ERROR      2007
#define FAF_RC_NETWORK_PROTOCOL_ERROR              2008
#define FAF_RC_NETWORK_PROTOCOL_UNDER_CONSTRUCTION 2009
#define FAF_RC_NETWORK_PROTOCOL_UNSUPPORTED        2010
#define FAF_RC_HOST_API_PROTOCOL_ERROR             2011
#define FAF_RC_INVALID_HOST_RETURN_VALUE           2012
#define FAF_RC_INVALID_WS_OS_VERSION               2013
#define FAF_RC_OS_ERROR                            2014
#define FAF_RC_INVALID_IODM_RETURN_VALUE           2015
#define FAF_RC_FILE_OPEN_ERROR                     2016
#define FAF_RC_FILE_WRITE_ERROR                    2017
#define FAF_RC_FILE_READ_ERROR                     2018
#define FAF_RC_INVALID_CODEPAGE                    2019
#define FAF_RC_INVALID_FCALLBACK                   2020
#define FAF_RC_ASYNC_FAILED                        2021
#define FAF_RC_HOST_CANT_COMPLETE                  2022
#define FAF_RC_OVERLAYS_MISSING                    2023
#define FAF_RC_IMS_ERROR                           2024
#define FAF_RC_IMS_OTMA_ERROR                      2025
#define FAF_RC_ANNOTATION_MISSING                  2026
#define FAF_RC_INVALID_ANNOTATION_INDEX            2027

#define FAF_RC_INVALID_USERID                      3000
#define FAF_RC_INVALID_PASSWORD                    3001
#define FAF_RC_INVALID_NEWPSWD_TOO_LONG            3002
#define FAF_RC_INVALID_FAFCONNECTPARMS             3003
#define FAF_RC_INVALID_RESOURCE                    3004
#define FAF_RC_MISSING_CUSTOMER_DATA               3005
#define FAF_RC_INVALID_CUSTOMER_DATA_LENGTH        3006
#define FAF_RC_INVALID_APPLID                      3007
#define FAF_RC_TOO_MANY_CONNECTIONS                3008
#define FAF_RC_IODM_NOT_AVAILABLE                  3009
#define FAF_RC_IPFAF_NOT_AVAILABLE                 3010
#define FAF_RC_INVALID_ODM_USERID                  3011
#define FAF_RC_INVALID_ODM_PASSWORD                3012
#define FAF_RC_INVALID_ODM_TERMID                  3013

#define FAF_RC_INVALID_FOLDERATTRS                 4000
#define FAF_RC_INVALID_INDEXDEFSTRUCT              4001
#define FAF_RC_INVALID_FOLDERCURSOR                4002
#define FAF_RC_INVALID_2NDARYINDEX                 4003
#define FAF_RC_INVALID_NUMBER_OF_INDICES           4004
#define FAF_RC_INVALID_RDEFFOLDERATTRS             4005
#define FAF_RC_INVALID_FOLDERIDSTRUCT              4006
#define FAF_RC_INVALID_INDEXGETSTRUCT              4007

#define FAF_RC_INVALID_DOCIDSTRUCT                 6000
#define FAF_RC_INVALID_DOCTIMEID                   6001
#define FAF_RC_INVALID_DOCWKSPARMS                 6002
#define FAF_RC_INVALID_DOCATTRS                    6003
#define FAF_RC_INVALID_DOCSTORAGE                  6004
#define FAF_RC_INVALID_DOCEVENT                    6005
#define FAF_RC_INVALID_TEMPIDFORMAT                6006
#define FAF_RC_INVALID_DOCDISPLAY                  6007
#define FAF_RC_INVALID_PAGERANGE                   6008
#define FAF_RC_INVALID_DOCUMENTCURSOR              6009
#define FAF_RC_INVALID_DOCPRNTPARMS                6010
#define FAF_RC_INVALID_RDEFDOCATTRS                6011
#define FAF_RC_INVALID_NUMBER_OF_DOCDISPLAYS       6012
#define FAF_RC_INVALID_NUMBER_OF_PAGERANGES        6013
#define FAF_RC_INVALID_LOCOPTS                     6014
#define FAF_RC_INVALID_BUFFER                      6015
#define FAF_RC_INVALID_BUFFERLENGTH                6016
#define FAF_RC_INVALID_FILENAME                    6017
#define FAF_RC_INVALID_DOCOVERLAYS                 6018
#define FAF_RC_BUFFER_TOOSMALL                     6019

#define FAF_RC_INVALID_TIMESTAMP_RANGE             7000
#define FAF_RC_INVALID_TEMPCURSOR                  7001

#define FAF_RC_INVALID_EVENT                       8000

#define FAF_RC_INVALID_WQ_ID                       9000
#define FAF_RC_INVALID_WORKROUTING                 9001
#define FAF_RC_INVALID_WORKITEMPRIORITY            9002
#define FAF_RC_INVALID_WORKITEMINIT                9003
#define FAF_RC_INVALID_FINDWORK_CURSOR             9004
#define FAF_RC_INVALID_GETWORK_CURSOR              9005
#define FAF_RC_INVALID_WORKASGN_CURSOR             9006
#define FAF_RC_INVALID_RDEFWORKRATTRS              9007

/*---------------------------------------------------------------------------*/
/*    FAF_RC_INVALID_CLIENT_PARAMETER -- Reason Code 1 Ids                   */
/*---------------------------------------------------------------------------*/
#define IPFAF_WS_PARM_ALLVERS    1001
#define IPFAF_WS_PARM_APPLIDCD   1002
#define IPFAF_WS_PARM_SENDOVLY   1003
#define IPFAF_WS_PARM_BTRANAME   1004
#define IPFAF_WS_PARM_CLEARWS    1005
#define IPFAF_WS_PARM_CODEPAGE   1006
#define IPFAF_WS_PARM_CDPGSRCH   1007
#define IPFAF_WS_PARM_CRTEDATE   1008
#define IPFAF_WS_PARM_CRTESITE   1009
#define IPFAF_WS_PARM_DLTEOPTN   1010
#define IPFAF_WS_PARM_DESTID     1011
#define IPFAF_WS_PARM_WKSTATFS   1012
#define IPFAF_WS_PARM_DFOLDTKN   1013
#define IPFAF_WS_PARM_DOBJTKN    1014
#define IPFAF_WS_PARM_DOBJVERS   1015
#define IPFAF_WS_PARM_DRECVDTE   1016
#define IPFAF_WS_PARM_DTIMECHG   1017
#define IPFAF_WS_PARM_EMPTFOLD   1018
#define IPFAF_WS_PARM_ENDDATE    1019
#define IPFAF_WS_PARM_EVNTCD     1020
#define IPFAF_WS_PARM_EVNTCNTL   1021
#define IPFAF_WS_PARM_FILEDATE   1022
#define IPFAF_WS_PARM_FOLDTKN    1023
#define IPFAF_WS_PARM_FOLDTYCD   1024
#define IPFAF_WS_PARM_FORMCD     1025
#define IPFAF_WS_PARM_RSPPSRCH   1026
#define IPFAF_WS_PARM_FTKNSRCH   1027
#define IPFAF_WS_PARM_FTYPSRCH   1028
#define IPFAF_WS_PARM_GTRANAME   1029
#define IPFAF_WS_PARM_MGMTCL     1030
#define IPFAF_WS_PARM_MODLEAVE   1031
#define IPFAF_WS_PARM_NEXTSET    1032
#define IPFAF_WS_PARM_IGNEGRSP   1033
#define IPFAF_WS_PARM_NUMENTRY   1034
#define IPFAF_WS_PARM_NUMPAGES   1035
#define IPFAF_WS_PARM_OBJCNTL    1036
#define IPFAF_WS_PARM_OBJSTAT    1037
#define IPFAF_WS_PARM_OBJTKN     1038
#define IPFAF_WS_PARM_OBJCLASS   1039
#define IPFAF_WS_PARM_OBJVERS    1040
#define IPFAF_WS_PARM_ORIGKEPT   1041
#define IPFAF_WS_PARM_NSTORSIT   1042
#define IPFAF_WS_PARM_OTKNSRCH   1043
#define IPFAF_WS_PARM_PREFIXD    1044
#define IPFAF_WS_PARM_PRTALT     1045
#define IPFAF_WS_PARM_PRTID      1046
#define IPFAF_WS_PARM_DLTECNTL   1047
#define IPFAF_WS_PARM_RECVDATE   1048
#define IPFAF_WS_PARM_RESPPEND   1049
#define IPFAF_WS_PARM_RETAREA    1050
#define IPFAF_WS_PARM_RETPER     1051
#define IPFAF_WS_PARM_RETRYCNT   1052
#define IPFAF_WS_PARM_SECURCL    1053
#define IPFAF_WS_PARM_STGCL      1054
#define IPFAF_WS_PARM_STORSITE   1055
#define IPFAF_WS_PARM_STRTDATE   1056
#define IPFAF_WS_PARM_TABCD      1057
#define IPFAF_WS_PARM_TABSRCH    1058
#define IPFAF_WS_PARM_TEMPID     1059
#define IPFAF_WS_PARM_TEMPTYPE   1060
#define IPFAF_WS_PARM_TIDFORMT   1061
#define IPFAF_WS_PARM_TIMECHGD   1062
#define IPFAF_WS_PARM_TIMECRTE   1063
#define IPFAF_WS_PARM_TOTENTRY   1064
#define IPFAF_WS_PARM_TRANSNUM   1065
#define IPFAF_WS_PARM_USERDATE   1066
#define IPFAF_WS_PARM_USERID     1067
#define IPFAF_WS_PARM_VEREXIST   1068
#define IPFAF_WS_PARM_VERSSRCH   1069
#define IPFAF_WS_PARM_CMDNAME    1070
#define IPFAF_WS_PARM_WKSTATID   1071
#define IPFAF_WS_PARM_ENDDTTM    1072
#define IPFAF_WS_PARM_STRTDTTM   1073
#define IPFAF_WS_PARM_TIDSRCH    1074
#define IPFAF_WS_PARM_PURGETID   1075
#define IPFAF_WS_PARM_COLLNAME   1076
#define IPFAF_WS_PARM_VCOLLNAM   1077
#define IPFAF_WS_PARM_VMGMTCL    1078
#define IPFAF_WS_PARM_VRETPER    1079
#define IPFAF_WS_PARM_VSTGCL     1080
#define IPFAF_WS_PARM_VSTORSIT   1081
#define IPFAF_WS_PARM_WKSTMSG    1082
#define IPFAF_WS_PARM_ALTPCB     1083
#define IPFAF_WS_PARM_NRECVDTE   1084
#define IPFAF_WS_PARM_AGEPRHG    1101
#define IPFAF_WS_PARM_AGEPRLW    1102
#define IPFAF_WS_PARM_AGEPRMD    1103
#define IPFAF_WS_PARM_AGEPRNM    1104
#define IPFAF_WS_PARM_AGINGDTE   1105
#define IPFAF_WS_PARM_ASGNACT    1106
#define IPFAF_WS_PARM_ASGNEMPL   1107
#define IPFAF_WS_PARM_BASEPRHG   1108
#define IPFAF_WS_PARM_BASEPRLW   1109
#define IPFAF_WS_PARM_BASEPRMD   1110
#define IPFAF_WS_PARM_BASEPRNM   1112
#define IPFAF_WS_PARM_CATWORK    1113
#define IPFAF_WS_PARM_DATESRCH   1114
#define IPFAF_WS_PARM_RUNIT      1115
#define IPFAF_WS_PARM_UNITSRCH   1116
#define IPFAF_WS_PARM_DOCNO      1117
#define IPFAF_WS_PARM_STRTPRTY   1118
#define IPFAF_WS_PARM_ENDPRTY    1119
#define IPFAF_WS_PARM_EXPRDATE   1120
#define IPFAF_WS_PARM_OPERFLAG   1121
#define IPFAF_WS_PARM_HOLDACT    1122
#define IPFAF_WS_PARM_HOLDDATE   1123
#define IPFAF_WS_PARM_HOLDTIME   1124
#define IPFAF_WS_PARM_NEXTRLOB   1125
#define IPFAF_WS_PARM_NEXTTRAN   1126
#define IPFAF_WS_PARM_OVERPIND   1127
#define IPFAF_WS_PARM_PRIORITY   1128
#define IPFAF_WS_PARM_PROCACT    1129
#define IPFAF_WS_PARM_PROCEMPL   1130
#define IPFAF_WS_PARM_PROCRSET   1131
#define IPFAF_WS_PARM_PRTYSRCH   1132
#define IPFAF_WS_PARM_RCDSRCH    1133
#define IPFAF_WS_PARM_RCODE      1134
#define IPFAF_WS_PARM_RLOB       1135
#define IPFAF_WS_PARM_STRTRCD    1136
#define IPFAF_WS_PARM_ENDRCD     1137
#define IPFAF_WS_PARM_TRANTYPE   1138
#define IPFAF_WS_PARM_USERPRM1   1139
#define IPFAF_WS_PARM_USERSRCH   1140
#define IPFAF_WS_PARM_AGEPRIO    1141
#define IPFAF_WS_PARM_BASEPRIO   1142
#define IPFAF_WS_PARM_USERPRM2   1143
#define IPFAF_WS_PARM_FINDACT    1144
#define IPFAF_WS_PARM_USERSTAT   1145
#define IPFAF_WS_PARM_USTASRCH   1146
#define IPFAF_WS_PARM_USERDET    1147
#define IPFAF_WS_PARM_DLTEACT    1148
#define IPFAF_WS_PARM_DROPACT    1149
#define IPFAF_WS_PARM_APPLDATA   1151
#define IPFAF_WS_PARM_TERMID     1152
#define IPFAF_WS_PARM_EVNTCDSO   1153
#define IPFAF_WS_PARM_BATCHEXT   1201
#define IPFAF_WS_PARM_BATCHSEQ   1202
#define IPFAF_WS_PARM_BATCHID    1203
#define IPFAF_WS_PARM_BATISRCH   1204
#define IPFAF_WS_PARM_BATCHMTD   1205
#define IPFAF_WS_PARM_BATSSRCH   1206
#define IPFAF_WS_PARM_BATCHSTA   1207
#define IPFAF_WS_PARM_CENDDTTM   1208
#define IPFAF_WS_PARM_CSTRDTTM   1209
#define IPFAF_WS_PARM_DOCSEQ     1210
#define IPFAF_WS_PARM_RESTART2   1211
#define IPFAF_WS_PARM_LANGID     1212
#define IPFAF_WS_PARM_CSYSID     1213
#define IPFAF_WS_PARM_COPYTYPE   1214
#define IPFAF_WS_PARM_TENDDTTM   1215
#define IPFAF_WS_PARM_TSTRDTTM   1216
#define IPFAF_WS_PARM_FILETAB    1217
#define IPFAF_WS_PARM_BATDSRCH   1218
#define IPFAF_WS_PARM_OBJTIME    1219
#define IPFAF_WS_PARM_CSIDSRCH   1220
#define IPFAF_WS_PARM_ROUTFLAG   1229
#define IPFAF_WS_PARM_ASGNSTAT   1232
#define IPFAF_WS_PARM_PROCSRCH   1236
#define IPFAF_WS_PARM_ASGNSRCH   1237
#define IPFAF_WS_PARM_STATSRCH   1238
#define IPFAF_WS_PARM_UASGNACT   1239
#define IPFAF_WS_PARM_MORENTRY   1240
#define IPFAF_WS_PARM_QPRTY      1241
#define IPFAF_WS_PARM_SEQSRCH    1242
#define IPFAF_WS_PARM_QPRTYSRCH  1243
#define IPFAF_WS_PARM_BATCHACT   1244
#define IPFAF_WS_PARM_STRTDSEQ   1245
#define IPFAF_WS_PARM_ENDDSEQ    1246
#define IPFAF_WS_PARM_RTRYCNTL   1247
#define IPFAF_WS_PARM_ACTVPROC   1248
#define IPFAF_WS_PARM_ACTVASGN   1249
#define IPFAF_WS_PARM_DFOLDID    2001
#define IPFAF_WS_PARM_EVNTDESC   2002
#define IPFAF_WS_PARM_FOLDDESC   2003
#define IPFAF_WS_PARM_FOLDID     2004
#define IPFAF_WS_PARM_FOLDSRCH   2005
#define IPFAF_WS_PARM_EVNTDATA   2006
#define IPFAF_WS_PARM_NOTETEXT   2007
#define IPFAF_WS_PARM_OBJDESC    2008
#define IPFAF_WS_PARM_OBJNAME    2009
#define IPFAF_WS_PARM_SHRTDESC   2010
#define IPFAF_WS_PARM_TRANDATA   2011
#define IPFAF_WS_PARM_USERDATA   2012
#define IPFAF_WS_PARM_FORMNUM    2014
#define IPFAF_WS_PARM_SENDDATA   2015
#define IPFAF_WS_PARM_WQUEDESC   2101
#define IPFAF_WS_PARM_OBJINFO    2102
#define IPFAF_WS_PARM_USEXDATA   2201
#define IPFAF_WS_PARM_REJTFOLD   2202
#define IPFAF_WS_PARM_INDXVAL1   2206
#define IPFAF_WS_PARM_INDXVAL2   2207
#define IPFAF_WS_PARM_INDXVAL3   2208
#define IPFAF_WS_PARM_INDXLIST   3101
#define IPFAF_WS_PARM_OBJTKNL    3201
#define IPFAF_WS_PARM_PAGEMOD    3301
#define IPFAF_WS_PARM_OBJNLIST   3501
#define IPFAF_WS_PARM_OBJCONT    4101
#define IPFAF_WS_PARM_INDXSRCH   5001

#define IODM_WS_PARM_RETURNC     0x0009
#define IODM_WS_PARM_OBJTMPID    0x000A
#define IODM_WS_PARM_OBJSIZE     0x000B
#define IODM_WS_PARM_SCALDEF     0x000C
#define IODM_WS_PARM_NUMPAGES    0x000D
#define IODM_WS_PARM_MSGID       0x000E
#define IODM_WS_PARM_MDFYFLAG    0x0012
#define IODM_WS_PARM_TERMID      0x0013
#define IODM_WS_PARM_APUSERID    0x0014
#define IODM_WS_PARM_OSYSID      0x0016
#define IODM_WS_PARM_OBJNAME     0x0017
#define IODM_WS_PARM_DESCRIPT    0x0019
#define IODM_WS_PARM_STATCOND    0x001D
#define IODM_WS_PARM_COLLNAME    0x0032
#define IODM_WS_PARM_SCANID      0x0041
#define IODM_WS_PARM_OBJCLASS    0x0063
#define IODM_WS_PARM_REACODE     0x0070
#define IODM_WS_PARM_RESPLEVL    0x0072
#define IODM_WS_PARM_FORMFLAG    0x0073
#define IODM_WS_PARM_OBJSTART    0x0074
#define IODM_WS_PARM_COPYTYPE    0x0075
#define IODM_WS_PARM_RETRTIME    0x0076
#define IODM_WS_PARM_OBJDATA     0x0077
#define IODM_WS_PARM_STORCLAS    0x0078
#define IODM_WS_PARM_MGMTCLAS    0x0079
#define IODM_WS_PARM_RETPD       0x007A
#define IODM_WS_PARM_NAMEFLAG    0x007B
#define IODM_WS_PARM_SYNCPT      0x007C
#define IODM_WS_PARM_OBJTIME     0x007D
#define IODM_WS_PARM_FEAKEY      0x0201
#define IODM_WS_PARM_ANNOTIME    0x0203
#define IODM_WS_PARM_SSYSID      0x0204
#define IODM_WS_PARM_LOCKTYPE    0x0205
#define IODM_WS_PARM_DOCCHGE     0x0206
#define IODM_WS_PARM_LOCKREL     0x0207
#define IODM_WS_PARM_NFEAKEY     0x020D
#define IODM_WS_PARM_AOBJSIZE    0x0210
#define IODM_WS_PARM_ANNOFLLW    0x0211

/*---------------------------------------------------------------------------*/
/*    FAF_RC_NETWORK_PROTOCOL_ERROR -- TCP/IP Error Reason Code 1 Ids        */
/*    Error Reason Code 2 is actual error from TCP/IP                        */
/*---------------------------------------------------------------------------*/
typedef enum {
   TCPIP_STARTUP = 5400,
   TCPIP_SOCKET,
   TCPIP_CLOSE,
   TCPIP_SHUTDOWN,
   TCPIP_CONNECT,
   TCPIP_SEND_LISTENER,
   TCPIP_RECEIVE_LISTENER,
   TCPIP_SEND_REQUEST_HEADER,
   TCPIP_RECEIVE_REQUEST_HEADER,
   TCPIP_SEND_ICRP,
   TCPIP_RECEIVE_ICRP,
   TCPIP_RECEIVE_RESP_HDR,
   TCPIP_SEND_RESP_HDR_ACK
} TCPIPERRORS;

/*===========================================================================*/
/*                                                                           */
/*                   IPFAF WorkStation Defines                               */
/*                   -------------------------                               */
/*    These are the C Defines for the IPFAF WorkStation API.                 */
/*                                                                           */
/*===========================================================================*/
#define DEFAULT_DOC_CURRENT_VERSION          "0"  // Current Version of Doc
#define DOCUMENT_DEFAULT_CONTENT_CLASS     32768  // MO:DCA
#define IPFAF_FOLDER_MAX_INDEX_VALUES         10
#define MAX_DOC_OVERLAYS                     100  // Max number of overlays

/*---------------------------------------------------------------------------*/
/*    INI File Variable Names   (Names NOT case sensitive)                   */
/*---------------------------------------------------------------------------*/
#define INI_FAFPATH              "IPFAFPath" /* Path of the IPFAF files      */
#define INI_LOGGING                "Logging" /* ON/OFF switch for logging    */
#define INI_LOG_FAFTYPES       "FafTypeLogs" /* ON/OFF for FafType logging   */
#define INI_TCPIP_TIMEOUT     "TimeOutTCPIP" /* TCPIP Timeout for Send/Recv  */
#define INI_IPFAF_REQUIRED    "RequireIPFAF" /* Successful IPFAF connect req.*/
#define INI_IODM_REQUIRED      "RequireIODM" /* Successful IODM connect req. */
#define INI_HOST_CODEPAGE     "HostCodePage" /* Default Host Codepage        */
#define INI_WKST_CODEPAGE     "WkStCodePage" /* Default Workstation Codepage */
#define INI_IPFAF_TRANID       "IPFAFTranId" /* IPFAF Transaction ID         */
#define INI_IPFAF_TRANID_IMS  "IPFAFTranIMS" /* IPFAF IMS Transaction ID     */
#define INI_IODMTRAN_BEGBATCH "IodmBEGBATCH" /* IODM Transaction for BEGBATCH*/
#define INI_IODMTRAN_PRINTW     "IodmPRINTW" /* IODM Transaction for PRINTW  */
#define INI_IODMTRAN_LOCK         "IodmLOCK" /* IODM Transaction for LOCK    */
#define INI_IODMTRAN_SRETOBJ   "IodmSRETOBJ" /* IODM Transaction for SRETOBJ */
#define INI_IODMTRAN_SSTROBJ   "IodmSSTROBJ" /* IODM Transaction for SSTROBJ */
#define INI_IODMTRAN_STATUS     "IodmSTATUS" /* IODM Transaction for STATUS  */
#define INI_IODMTRAN_STOREC     "IodmSTOREC" /* IODM Transaction for STOREC  */
#define INI_IODMTRAN_STOROBJU "IodmSTOROBJU" /* IODM Transaction for STOROBJU*/
#define INI_IODMTRAN_TEMPIDC   "IodmTEMPIDC" /* IODM Transaction for TEMPIDC */
#define INI_IPFAF_DEFDOCID   "DefDocUsingId" /* DocID for FafDefineStoredDoc */

/*---------------------------------------------------------------------------*/
/*    FAFCONNECTPARMS Protocol Identifiers                                   */
/*---------------------------------------------------------------------------*/
typedef enum {
   FAF_CONN_TCPIP     = 4000,
   FAF_IMS_CONN_TCPIP = 4500,
   FAF_CONN_APPC      = 5000
} FAFCONN, *PFAFCONN;

/*---------------------------------------------------------------------------*/
/*    FCALLBACK Asynchronous Method Identifiers                              */
/*---------------------------------------------------------------------------*/
typedef enum {
   FAF_ASYNC_SEM = 1,
   FAF_ASYNC_MSG = 2
} FAFASYNCOPTS, *PFAFASYNCOPTS;

/*---------------------------------------------------------------------------*/
/*    FafQueryOutcome OutComeStatus Identifiers                              */
/*---------------------------------------------------------------------------*/
typedef enum {
   IODM_NOT_YET_RESPONDED       = 1,
   IODM_RESPONDED_FOR_GTRAN     = 2,
   IODM_RESPONDED_FOR_BTRAN     = 3,
   IODM_RESPONDED_GTRAN_STARTED = 4,
   IODM_RESPONDED_BTRAN_STARTED = 5
} OUTCOMESTATUS;

/*---------------------------------------------------------------------------*/
/*    INDEXACTION Parameters                                                 */
/*---------------------------------------------------------------------------*/
typedef enum {
   I_DO_NOTHING,                      // Default
   I_CREATE_INDEX,
   I_UPDATE_INDEX,
   I_DELETE_INDEX,
   I_GET_INDEX
} INDEXACTION, *PINDEXACTION;

/*---------------------------------------------------------------------------*/
/*    RDEFFOLD Parameters                                                    */
/*---------------------------------------------------------------------------*/
typedef enum {
   F_CODEPAGE = 1006,
   F_CRTEDATE = 1008,
   F_EMPTFOLD = 1018,
   F_FOLDTYCD = 1024,
   F_SECURCL  = 1053,
   F_FOLDDESC = 2003,
   F_FOLDERID = 2004,
   F_USERDATA = 2012
} RDEFFOLD_PARMS, *PRDEFFOLD_PARMS;

/*---------------------------------------------------------------------------*/
/*    RDEFOBJ Parameters                                                     */
/*---------------------------------------------------------------------------*/
typedef enum {
   D_CODEPAGE = 1006,
   D_FILEDATE = 1022,
   D_FORMCD   = 1025,
   D_ORIGKEPT = 1041,
   D_SECURCL  = 1053,
   D_TABCD    = 1057,
   D_USERDATE = 1066,
   D_NRECVDTE = 1084,
   D_USERSTAT = 1145,
   D_OBJDESC  = 2008,
   D_USERDATA = 2012,
   D_FORMNUM  = 2014
} RDEFOBJ_PARMS, *PRDEFOBJ_PARMS;

/*---------------------------------------------------------------------------*/
/*    Document DELETE Options                                                */
/*---------------------------------------------------------------------------*/
typedef enum {
   DLTE_ALL_IN_FOLDER = 1,            // Delete all Documents in Folder
   DLTE_ALL_VERSIONS,                 // Delete all Versions of a Document
   DLTE_SINGLE_VERSION,               // Delete Single Version of a Document
   DLTE_IODM_COPY,                    // Delete IODM Copies of Document
   DLTE_IODM_WORKING_COPY             // Delete IODM Copies of Document
} DLTEOPTN, *PDLTEOPTN;

/*---------------------------------------------------------------------------*/
/*    Document DELETE Control Options -- Faf and Optical                     */
/*---------------------------------------------------------------------------*/
typedef enum {
   DLTE_CNTL_BOTH = 1,                // Delete from Both Faf and Optical
   DLTE_CNTL_FAF_ONLY                 // Delete from Faf Only not Optical
} DLTECNTL, *PDLTECNTL;

/*---------------------------------------------------------------------------*/
/*    Form Overlay Options FafSendDocument(), FafGetDocument()               */
/*---------------------------------------------------------------------------*/
typedef enum {
   FORM_SEND,                         // Send the Form Overlay
   FORM_DONT_SEND                     // Don't Send the Form Overlay
} FORMOVERLAY, *PFORMOVERLAY;

/*---------------------------------------------------------------------------*/
/*    Document COPYTYPE Options                                              */
/*---------------------------------------------------------------------------*/
typedef enum {
   COPY_IODM_DECIDES,                 // IODM Determines which copy to use
   COPY_COPIED_VERSION,               // Use a COPIED version
   COPY_BACKUP_COPY,                  // Use a BACKUP copy
   COPY_ANNOTATION_INDEX              // Use the Annotation index
} COPYTYPE, *PCOPYTYPE;

/*---------------------------------------------------------------------------*/
/*    Document LOCKTYPE Options                                              */
/*---------------------------------------------------------------------------*/
typedef enum {
   LOCK_DOC_ANNOTATIONS        = 0x00,// Lock Document for annotations
   LOCK_DOC_ANNOTATIONS_ALWAYS = 0x10,// Always Lock Document for annotations
   LOCK_DOC_ABORT              = 0xAA,// Abort previous lock document request
   LOCK_ITEM_QUERY             = 0xAC,// Query lock state
   LOCK_ITEM                   = 0xE0,// Lock Item
   LOCK_ITEM_ABORT             = 0xEA,// UnLock Item
   /*           Future types of locks -- not implemented yet                 */
   LOCK_DOC_UPDATE             = 0x01,// Lock Document for update
   LOCK_DOC_UPDATE_ALWAYS      = 0x11,// Always Lock Document for update
   LOCK_DOC_NEW_VERSION        = 0x02,// Lock Document for new version
   LOCK_DOC_NEW_VERSION_ALWAYS = 0x12 // Always Lock Document for new version
} DOCLOCKTYPE, *PDOCLOCKTYPE;

/*---------------------------------------------------------------------------*/
/*    IODM LOCK Responses  (In HostRC)                                       */
/*---------------------------------------------------------------------------*/
#define LOCKR_OK                     "00"
#define LOCKR_ALREADY_LOCKED         "80"
#define LOCKR_NOT_AUTHORIZED         "81"
#define LOCKR_OBJECT_OLD             "82"
#define LOCKR_ANNOTATION_OLD         "83"
#define LOCKR_OBJECT_SIZE_ERROR      "84"
#define LOCKR_ANNOTATION_SIZE_ERROR  "85"
#define LOCKR_UNKNOWN_ITEM           "86"
#define LOCKR_CICS_FAILURE           "92"
#define LOCKR_EXIT_FAILURE           "94"
#define LOCKR_IODM_FAILURE           "95"

/*---------------------------------------------------------------------------*/
/*    Document CHANGETYPE Options                                            */
/*---------------------------------------------------------------------------*/
typedef enum {
   CHG_UNLOCK                 = 0x00,// UnLock Document
   CHG_ANNOTATIONS_ADDED      = 0x01,// Document annotations added
   CHG_ANNOTATIONS_CLEARED    = 0xFF,// Document annotations deleted
   /*           Future types of changes -- not implemented yet               */
   CHG_ANNOTATIONS_DELETED    = 0x08,// Document annotations deleted
   CHG_MASKS_ADDED            = 0x10,// Document Masks added
   CHG_MASKS_DELETED          = 0x80 // Document Masks deleted
} DOCCHGTYPE, *PDOCCHGTYPE;

/*---------------------------------------------------------------------------*/
/*    Document OBJCNTL Options -- Location Limitation                        */
/*---------------------------------------------------------------------------*/
typedef enum {
   CNTL_DASD_ONLY=1,                  // Display and Retrieval
   CNTL_DASD_OR_OPTICAL,              // Display and Retrieval
   CNTL_DASD_OR_IODM_PRF,             // Display only not Retrieval
   CNTL_DASD_OPTICAL_OR_SHELF         // Display and Retrieval
} OBJCNTL, *POBJCNTL;

/*---------------------------------------------------------------------------*/
/*    Document Modify -- Page Change or Extract Options                      */
/*---------------------------------------------------------------------------*/
typedef enum {
   PAGES_DELETE = 1,                  // Delete Pages
   PAGES_INSERT,                      // Insert Pages
   PAGES_REPLACE,                     // Replace Pages
   PAGES_RESEQUENCE,                  // Resequence Pages
   PAGES_EXTRACT                      // Extract Pages
} FPGINFO, *PFPGINFO;

/*---------------------------------------------------------------------------*/
/*    DOCUMENT Temporary ID Format -- Used in the Creation of a New Doc.     */
/*---------------------------------------------------------------------------*/
typedef enum {
   TID_FOLDERID = 1,                  // TEMPID = FOLDERID
   TID_FOLDERID_PLUS3,                // TEMPID = FOLDERID+3 random digits
   TID_RANDOM_6,                      // TEMPID = 6 Random digits (default)
   TID_PREFIXD_PLUS_6                 // TEMPID - "PREFIXD" + 6 Random digits
} TIDOPTION, *PTIDOPTION;

/*---------------------------------------------------------------------------*/
/*    DOCUMENT Storage Struct - Used to Select where a document is stored    */
/*---------------------------------------------------------------------------*/
typedef enum {
   CNTL_CREATE_BUFFER,                // Document Buffer is to be created
   CNTL_USE_BUFFER,                   // Document Buffer is passed as param
   CNTL_USE_FILE                      // Document is in a file
} LOCOPTS, *PLOCOPTS;

/*---------------------------------------------------------------------------*/
/*    Pending Document DELETE Options                                        */
/*---------------------------------------------------------------------------*/
typedef enum {
   PURGE_FAF_AND_ODM,                 // Delete from IPFAF and IODM
   PURGE_ODM_ONLY,                    // Delete from IODM only
   PURGE_FAF_ONLY                     // Delete from FAF only
} PURGETID, *PPURGETID;

/*---------------------------------------------------------------------------*/
/*    Pending Document Type -- MODIFY or SCAN                                */
/*---------------------------------------------------------------------------*/
typedef enum {
   TEMP_SCAN_ONLY = 1,                // SCAN Pending Only
   TEMP_MODIFY_ONLY                   // MODIFY Pending Only
} TEMPTYPE, *PTEMPTYPE;

/*---------------------------------------------------------------------------*/
/*    FafDropWorkItem -- Drop Action Options                                 */
/*---------------------------------------------------------------------------*/
typedef enum {
   DROP_IODM_NO_ACTION,               // IODM does nothing (Default)
   DROP_IODM_WORKING_COPY,            // IODM deletes the Working Copy
   DROP_IODM_CHANGE_SMS               // IODM changes the Docs SMS Options
} DROPACT, *PDROPACT;


/*---------------------------------------------------------------------------*/
/*    FafDropWorkItem -- Delete Action Options                               */
/*---------------------------------------------------------------------------*/
typedef enum {
   WI_DLTE_ONLY = 1,                  // Delete the WorkItem Only (Default)
   WI_DLTE_AND_FILEDATE               // Delete WI and Update FileDate
} DLTEACT, *PDLTEACT;


/*---------------------------------------------------------------------------*/
/*    FafFindWorkxxxxxx -- ASSIGNED Selection Options                        */
/*---------------------------------------------------------------------------*/
typedef enum {
   FIND_IN_ASGN_ONLY = 1,             // Find Assigned Documents Only
   FIND_NOT_ASGN_ONLY,                // Find Unassigned Documents Only
   FIND_BOTH_ASGN_NOASGN              // Find Both (Default)
} ASGNACT, *PASGNACT;

/*---------------------------------------------------------------------------*/
/*    FafFindWorkxxxxxx -- HOLD Selection Options                            */
/*---------------------------------------------------------------------------*/
typedef enum {
   FIND_ON_HOLD_ONLY=1,               // Find Documents on Hold Only
   FIND_NOT_ON_HOLD_ONLY,             // Find Documents Not on Hold Only
   FIND_BOTH_HOLD_NOHOLD              // Find Both (Default)
} HOLDACT, *PHOLDACT;

/*---------------------------------------------------------------------------*/
/*    FafFindWorkxxxxxx -- PROCESS Selection Options                         */
/*---------------------------------------------------------------------------*/
typedef enum {
   FIND_IN_PROC_ONLY = 1,             // Find Documents in Process Only
   FIND_NOT_IN_PROC_ONLY,             // Find Documents Not in Process Only
   FIND_BOTH_PROC_NOPROC              // Find Both (Default)
} PROCACT, *PPROCACT;

/*---------------------------------------------------------------------------*/
/*    WORKQUEUE Assignment Status -- Selection Options                       */
/*---------------------------------------------------------------------------*/
typedef enum {
   STAT_INACTIVE_ONLY,                // (Default) Inactv Assignments Only
   STAT_ACTIVE_ONLY,                  // Active Assignmente Only
   STAT_BOTH_ACTV_INACTV              // Both Active and Inactive
} STATSRCH, *PSTATSRCH;

/*---------------------------------------------------------------------------*/
/*    RDEFWORK Parameters                                                    */
/*---------------------------------------------------------------------------*/
typedef enum {
   W_RECVDATE = 1048,
   W_AGINGDTE = 1105,
   W_ASGNEMPL = 1107,
   W_RUNIT    = 1115,
   W_DOCNO    = 1117,
   W_EXPRDATE = 1120,
   W_HOLDDATE = 1123,
   W_HOLDTIME = 1124,
   W_OVERPIND = 1127,
   W_PRIORITY = 1128,
   W_PROCRSET = 1131,
   W_RCODE    = 1134,
   W_RLOB     = 1135,
   W_TRANTYPE = 1138,
   W_USERPRM1 = 1139,
   W_AGEPRIO  = 1141,
   W_BASEPRIO = 1142,
   W_USERPRM2 = 1143,
   W_USERDET  = 1147
} RDEFWORK_PARMS, *PRDEFWORK_PARMS;

/*---------------------------------------------------------------------------*/
/*    RDEFASGN Parameters                                                    */
/*---------------------------------------------------------------------------*/
typedef enum {
   A_ASGNSTAT = 1048,
   A_QPRTY    = 1105,
   A_ASGNEMPL = 1107,
   A_RUNIT    = 1115,
   A_DOCNO    = 1117,
   A_EXPRDATE = 1120,
   A_HOLDDATE = 1123,
   A_HOLDTIME = 1124,
   A_OVERPIND = 1127,
   A_PRIORITY = 1128,
   A_PROCRSET = 1131,
   A_RCODE    = 1134,
   A_RLOB     = 1135,
   A_TRANTYPE = 1138,
   A_USERPRM1 = 1139,
   A_AGEPRIO  = 1141,
   A_BASEPRIO = 1142,
   A_USERPRM2 = 1143,
   A_USERDET  = 1147
} RDEFASGN_PARMS, *PRDEFASGN_PARMS;


/*===========================================================================*/
/*                                                                           */
/*                   IPFAF WorkStation Data Types                            */
/*                   ----------------------------                            */
/*    These are the data type definitions for the IPFAF WorkStation API.     */
/*                                                                           */
/*===========================================================================*/
typedef  char  APPLIDCD[5+1],    *PAPPLIDCD;      // APPLID Code
typedef  char  DOCID[30+1],      *PDOCID;         // Time+Date+CreateSite
typedef  char  DOCNAME[40+1],    *PDOCNAME;       // Doc Name in IODM
typedef  char  DOCNUM[5+1],      *PDOCNUM;        // Document Number
typedef  char  DOCVERSION[5+1],  *PDOCVERSION;    // Document Version
typedef  char  ERRORPRODUCT[5+1],*PERRORPRODUCT;  // OUTCOMEINFO returned
typedef  char  EVENTCODE[5+1],   *PEVENTCODE;     // Event Code
typedef  char  FAFDATE[10+1],    *PFAFDATE;       // IPFAF Date Type
typedef  char  FAFSTRL[10+1],    *PFAFSTRL;       // IPFAF Long String
typedef  char  FAFSTRS[5+1],     *PFAFSTRS;       // IPFAF Short String
typedef  char  FAFTIME[8+1],     *PFAFTIME;       // IPFAF Time Type
typedef  char  FCODEPAGE[5+1],   *PFCODEPAGE;     // Code Page
typedef  char  FEAKEY[128],      *PFEAKEY;        // IPFAF FEA Object Index Key
typedef  char  FILETAB[5+1],     *PFILETAB;       // File Tab Code
typedef  char  FOLDERID[40+1],   *PFOLDERID;      // User Supplied
typedef  char  FOLDERTOKEN[26+1],*PFOLDERTOKEN;   // System Supplied
typedef  char  FOLDERTYPE[5+1],  *PFOLDERTYPE;    // Folder Type
typedef  char  FORMCODE[5+1],    *PFORMCODE;      // Form Code
typedef  char  FORMNUM[16+1],    *PFORMNUM;       // Document Form Number
typedef  char  HOSTRC[2+1],      *PHOSTRC;        // Host Return Code
typedef  char  HOSTREASON[4+1],  *PHOSTREASON;    // Host Reason Code
typedef  char  INDEXID[5+1],     *PINDEXID;       // Secondary IndexID
typedef  char  RCODE[6+1],       *PRCODE;         // Route Code within Unit
typedef  char  RETPERIOD[10+1],  *PRETPERIOD;     // Retention Period
typedef  char  RETRYCNT[5+1],    *PRETRYCNT;      // Retry Count
typedef  char  RLOB[6+1],        *PRLOB;          // Routing Line Of Business
typedef  char  RUNIT[10+1],      *PRUNIT;         // Routing Unit
typedef  char  TEMPID[55+1],     *PTEMPID;        // Doc Pending TEMPORARY ID.
typedef  char  TIMESTAMP[26+1],  *PTIMESTAMP;     // DB2 Timestamp
typedef  char  TRANSNUM[26+1],   *PTRANSNUM;      // Time+Date of Faf-ODM Req.
typedef  char  USERSTATUS[1+1],  *PUSERSTATUS;    // User Status
typedef  char  WIPRIORITY[5+1],  *PWIPRIORITY;    // WorkItem Priority

typedef  unsigned char           *PHBUF;          // Pointer to Buffer

typedef ULONG  HFSESSION,        *PHFSESSION;     // User Session with FAF


/*===========================================================================*/
/*                                                                           */
/*                   IPFAF WorkStation Structures                            */
/*                   ----------------------------                            */
/*    These are the data structure for the IPFAF WorkStation API.            */
/*                                                                           */
/*===========================================================================*/
/*    FAFRESULT -- API Return Structure                                      */
/*---------------------------------------------------------------------------*/
typedef struct _FAFRESULT {
   ULONG         ulStruct;            // Size of this data structure
   ULONG         ulClientRC;          // Faf Client API Return Code
   ULONG         ulClientReas1;       // Faf Client API Reason Code 1
   ULONG         ulClientReas2;       // Faf Client API Reason Code 2
   USHORT        usCount1;            // Count of items returned 1
   PVOID         pRetVals1;           // Pointer to item(s) returned 1
   USHORT        usCount2;            // Count of items returned 2
   PVOID         pRetVals2;           // Pointer to item(s) returned 2
   USHORT        usCount3;            // Count of items returned 3
   PVOID         pRetVals3;           // Pointer to item(s) returned 3
   USHORT        usCount4;            // Count of items returned 4     (RETAREA)
   PVOID         pRetVals4;           // Pointer to item(s) returned 4 (RETAREA)
   USHORT        usCount5;            // Count of items returned 5     (TIMEDATA)
   PVOID         pRetVals5;           // Pointer to item(s) returned 5 (TIMEDATA)
   HOSTRC        HostRC;              // Faf API Host Return code
   HOSTREASON    HostReas1;           // Faf API Host Reason Code 1
   HOSTREASON    HostReas2;           // Faf API Host Reason Code 2
} FAFRESULT, *PFAFRESULT;

/*---------------------------------------------------------------------------*/
/*    FCALLBACK -- Asynchronous Execution Control Structure                  */
/*---------------------------------------------------------------------------*/
typedef struct _FCALLBACK {
   ULONG         ulStruct;            // Size of this data structure
   FAFASYNCOPTS  fOption;             // Asynchronous Method flag
   PVOID         hSync;               // Window handle or Event or Semaphore
   ULONG         ulMsgId;             // ID of message to post
   ULONG         ulMsgparm1;          // optional message parameter
   ULONG         ulMsgparm2;          // optional message parameter
} FCALLBACK, *PFCALLBACK;

/*---------------------------------------------------------------------------*/
/*    Timestamp Range                                                        */
/*---------------------------------------------------------------------------*/
typedef struct _tsrange {
   ULONG         ulStruct;            // Size of this data structure
   TIMESTAMP     tsStartTime;         // Start time
   TIMESTAMP     tsEndTime;           // End time
} TSRANGE, *PTSRANGE;

/*---------------------------------------------------------------------------*/
/*    FAFCONNECTPARMS -- Faf Session Connection Parameters (FafSessionLogon) */
/*---------------------------------------------------------------------------*/
typedef struct _FAFCONNECTPARMS {
   ULONG         ulStruct;            // Size of this data structure
   FAFCONN       FafProtocol;         // FAF_CONN_TCPIP or FAF_CONN_APPC
   USHORT        usFafIpPort;         // TCP/IP Port for IPFAF Host Listener
   char          szFafIP[15+1];       // TCP/IP nnn.nnn.nnn.nnn (FAF)
   FAFCONN       IodmProtocol;        // FAF_CONN_TCPIP or FAF_CONN_APPC
   USHORT        usIodmIpPort;        // TCP/IP Iodm Port for IODM Listener
   char          szIodmIP[15+1];      // TCP/IP nnn.nnn.nnn.nnn (IODM)
} FAFCONNECTPARMS, *PFAFCONNECTPARMS;

/*---------------------------------------------------------------------------*/
/*    ODMCOMPLETION -- Allows the Caller to Be Notified of and to designate  */
/*    some host process for the successful or unsuccessful completion of a   */
/*    document related action in ODM.  This action began as a Faf API that   */
/*    returned control to the caller following the asynchronous completion   */
/*    of the action in IODM.  The only way the caller can know of the        */
/*    ultimate outcome is to use this structure on the applicable Faf APIs.  */
/*    The notification is asynchronous to the completion of the FAF API.     */
/*---------------------------------------------------------------------------*/
typedef struct _ODMCOMPLETE {
   ULONG         ulStruct;            // Size of this data structure
   BOOL          fInterest;           // Interest in IODM Outcome TRUE or FALSE
   char          szHostProcess[8+1];  // Opt: trigger this process in the Host
   char          szInputData[253+1];  // Opt: GOODTRAN Input Data
} ODMCOMPLETE, *PODMCOMPLETE;

/*---------------------------------------------------------------------------*/
/*    OUTCOMEINFO -- Returned by the FafQueryOutcome API.  The user calls    */
/*    this API to determine the IODM outcome of a previous IPFAF API that    */
/*    returns control to the caller when the IPFAF API initiates some action */
/*    in IODM.  The caller later needs the ultimate outcome of the API.      */
/*---------------------------------------------------------------------------*/
typedef struct _OUTCOMEINFO {
   ULONG         ulStruct;            // Size of this data structure
   OUTCOMESTATUS RespStatus;          // Status of API OUTCOME in IODM
   TRANSNUM      tOdmProcess;         // ODM Transaction Number
   ERRORPRODUCT  ErrorProduct;        // What Returned Error or Warning RC
   HOSTRC        OdmRc;               // ODM Return Code
   HOSTREASON    OdmRea1;             // ODM Reason Code 1
   HOSTREASON    OdmRea2;             // ODM Reason Code 2
   HOSTRC        DB2Rc;               // DB2 Return Code
   HOSTREASON    DB2Rea1;             // DB2 Reason Code 1
   HOSTREASON    DB2Rea2;             // DB2 Reason Code 2
   HOSTRC        FafRc;               // FAF Host API Return Code
   HOSTREASON    FafRea1;             // FAF Host API Reason Code 1
   HOSTREASON    FafRea2;             // FAF Host API Reason Code 2
} OUTCOMEINFO, *POUTCOMEINFO;

/*---------------------------------------------------------------------------*/
/*    Folder ID Structure -- Identify a Folder either with the user defined  */
/*    FOLDERID or the system supplied FOLDERTOKEN.  WARNING - if both the    */
/*    FOLDERID and FOLDERTOKEN are supplied, the FOLDERID will be ignored.   */
/*---------------------------------------------------------------------------*/
typedef struct _folderidstruct {
   ULONG         ulStruct;            // Data structure Size
   FOLDERTOKEN   FolderToken;         // Folder Token
   FOLDERID      FolderID;            // Folder ID
} FOLDERIDSTRUCT, *PFOLDERIDSTRUCT;

/*---------------------------------------------------------------------------*/
/*    FOLDERATTRS -- The Folder Attributes other than Secondary Index Vals.  */
/*---------------------------------------------------------------------------*/
typedef struct _folderattrs {
   ULONG         ulStruct;            // Data structure Size
   FCODEPAGE     CodePage;            // Code Page
   FAFDATE       dCreateDate;         // Creation Date
   BOOL          fEmptyFolder;        // FALSE=Empty-Delete TRUE=Empty-Keep
   char          szFolderDesc[253+1]; // Folder Description
   FOLDERTYPE    FolderType;          // FolderType Code
   char          szUserData[253+1];   // User Data
   char          szFolderSec[2+1];    // Folder Security Code-User Defined
} FOLDERATTRS, *PFOLDERATTRS;

/*---------------------------------------------------------------------------*/
/*    FOLDERINFO -- Folder Information other than Secondary Indices          */
/*---------------------------------------------------------------------------*/
typedef struct _folderinfo {
   ULONG         BlockID;             // Structure Identifier
   ULONG         ulStruct;            // size of this data structure
   FOLDERID      FolderID;            // Folder ID
   FOLDERTOKEN   FolderToken;         // Folder Token
   USHORT        usCodePage;          // Code Page
   FAFDATE       dCreateDate;         // Creation Date
   BOOL          fEmptyFolder;        // TRUE=Empty-Delete FALSE=Empty-Keep
   char          szFolderDesc[253+1]; // Description
   USHORT        usFolderType;        // FolderType Code
   char          szFolderSec[2+1];    // Folder Security Code-User Defined
   char          szUserData[253+1];   // User Data
   TIMESTAMP     tsTimeChanged;       // Time and Date of Last Change.
   PVOID         Tracker;             // Reserved
} FOLDERINFO, *PFOLDERINFO;

/*---------------------------------------------------------------------------*/
/*    2ndAryIndex -- An Individual Secondary Index Structure for a Folder    */
/*---------------------------------------------------------------------------*/
typedef struct _S2ndAryIndex {
   ULONG         ulStruct;            // Size of this data structure
   INDEXID       IndexID;             // Index Identifier
   char          szIndexValue[40+1];  // Folder Index Value.
} S2NDARYINDEX, *PS2NDARYINDEX;

/*---------------------------------------------------------------------------*/
/*    INDEXDEFSTRUCT -- Definition Activity for the selected Secondary Index */
/*---------------------------------------------------------------------------*/
typedef struct _indexdefine {
   ULONG         ulStruct;            // Size of this data structure
   INDEXACTION   IndexAction;         // Index Action
   INDEXID       IndexID;             // Index Identifier
   char          szIndexValue[40+1];  // Folder Index Value.
} INDEXDEFSTRUCT, *PINDEXDEFSTRUCT;

/*---------------------------------------------------------------------------*/
/*    INDEXGETSTRUCT -- Request to get the requested Folder Secondary Index  */
/*---------------------------------------------------------------------------*/
typedef struct _indexget {
   ULONG         ulStruct;            // Size of this data structure
   INDEXID       IndexID;             // Index Identifier
} INDEXGETSTRUCT, *PINDEXGETSTRUCT;

/*---------------------------------------------------------------------------*/
/*    FOLDERCURSOR -- Used to Continue a Prior Listing of Folders            */
/*---------------------------------------------------------------------------*/
typedef struct _foldercursor {
   ULONG         BlockID;             // Structure Identifier
   ULONG         ulStruct;            // size of this data structure
   FOLDERTOKEN   FolderToken;         // Folder Token
   FCODEPAGE     CodePage;            // Code Page
   FAFDATE       dStartDate;          // Start Date
   FOLDERTYPE    FolderType;          // FolderType Code
   PVOID         Tracker;             // Reserved
} FOLDERCURSOR, *PFOLDERCURSOR;

/*---------------------------------------------------------------------------*/
/*    Folder Attribute RDEF Structure                                        */
/*---------------------------------------------------------------------------*/
typedef struct _rdeffolderattrs {
   RDEFFOLD_PARMS AttrID;             // Attribute ID
   char           szAttrValue[256+1]; // String Rep of Attribute Value
} RDEFFOLDERATTRS, *PRDEFFOLDERATTRS;

/*---------------------------------------------------------------------------*/
/*    Document Attribute RDEF Structure                                      */
/*---------------------------------------------------------------------------*/
typedef struct _rdefdocattrs {
   RDEFOBJ_PARMS AttrID;              // Attribute ID
   char          szAttrValue[256+1];  // String Rep of Attribute Value
} RDEFDOCATTRS, *PRDEFDOCATTRS;

/*---------------------------------------------------------------------------*/
/*    DOCIDSTRUCT -- Provides both the DOCID and FOLDERTOKEN (or FOLDERID)   */
/*    when both are required as parameters to a Faf API to uniquely identify */
/*    a Document.  You can specify either FOLDERID or FOLDERTOKEN but not    */
/*    both.  If both are specified, FOLDERID will be ignored.                */
/*---------------------------------------------------------------------------*/
typedef struct _docidstruct {
   ULONG         ulStruct;            // Size of this data structure
   DOCID         DocID;               // Document ID
   FOLDERTOKEN   FolderToken;         // Specify This or FOLDERID
   FOLDERID      FolderID;            // Specify This or FOLDERTOKEN
} DOCIDSTRUCT, *PDOCIDSTRUCT;

/*---------------------------------------------------------------------------*/
/*    DOCUMENTCURSOR -- Used to Continue a Prior Listing of Documents        */
/*---------------------------------------------------------------------------*/
typedef struct _documentcursor {
   ULONG         BlockID;             // Structure Identifier
   ULONG         ulStruct;            // size of this data structure
   DOCID         docid;               // Document ID = Create Site+Timestamp.
   DOCVERSION    DocVersion;          // Document Version
   FAFDATE       ReceiveDate;         // Receive Date
   FILETAB       FileTabCode;         // File Tab Code
   USERSTATUS    UserStatus;          // User Defined and Interpreted.
   PVOID         Tracker;             // Reserved
} DOCUMENTCURSOR, *PDOCUMENTCURSOR;

/*---------------------------------------------------------------------------*/
/*    DOCUMENT STORAGE Definitions                                           */
/*---------------------------------------------------------------------------*/
typedef struct _docstorage {
   ULONG         ulStruct;            // Size of this data structure
   char          szCollName[44+1];    // Collection Name  (MVS OAM)
   RETPERIOD     RetPer;              // Retention Period (MVS OAM)
   char          szMgmtCl[8+1];       // Management Class (MVS OAM)
   char          szStgClass[8+1];     // Storage Class (MVS OAM)
   char          szStoreSite[4+1];    // Store Site -- IODM ID
} DOCSTORAGE, *PDOCSTORAGE;

/*---------------------------------------------------------------------------*/
/*    DOCUMENT Time Related Identification                                   */
/*---------------------------------------------------------------------------*/
typedef struct _doctimeid {
   ULONG         ulStruct;            // Size of this data structure
   FAFDATE       ReceiveDate;         // Receive Date
   TIMESTAMP     tsTimeChanged;       // Date and Time of Last Change.
} DOCTIMEID, *PDOCTIMEID;

/*---------------------------------------------------------------------------*/
/*    DOCUMENT Display Struct - Used to Select a Document to Display -- IWP  */
/*---------------------------------------------------------------------------*/
typedef struct _docdisplay {
   ULONG         ulStruct;            // Size of this data structure
   DOCID         docid;               // Document ID = Create Site+Timestamp
   DOCVERSION    DocVersion;          // Document Version
   FAFDATE       ReceiveDate;         // Receive Date
   TIMESTAMP     tsTimeChanged;       // Date and Time of Last Change.
   OBJCNTL       StrgLocOpts;         // Dasd, Optical,Shelf
   COPYTYPE      CopyOpts;            // IODM Copy Options
   char          szWksMsg[40+1];      // IWP Message for this Document
   HOSTRC        HostRC;              // Return Code for this Document
   HOSTREASON    HostReasonCode1;     // Reason Code 1 for this Document
   HOSTREASON    HostReasonCode2;     // Reason Code 2 for this Document
} DOCDISPLAY, *PDOCDISPLAY;

/*---------------------------------------------------------------------------*/
/*    DOCUMENT WorkStation Parameters -- For IWP Related Faf APIs            */
/*---------------------------------------------------------------------------*/
typedef struct _docwksparms {
   ULONG         ulStruct;            // Size of this data structure
   BOOL          fModLeave;           // TRUE=Leave; FALSE=Clear Doc from IWP
   char          szWorkStation[8+1];  // Target IWP WorkStation
   char          szFileServer[4+1];   // Workstation File Server(Optional)
   char          szWksMsg[40+1];      // WorkStation Message (Optional)
} DOCWKSPARMS, *PDOCWKSPARMS;

/*---------------------------------------------------------------------------*/
/*    DOCUMENT Print Location Parameters -- For FafPrintDocument             */
/*---------------------------------------------------------------------------*/
typedef struct _docprntparms {
   ULONG         ulStruct;            // Size of this data structure
   char          szWorkStation[8+1];  // Target IWP WorkStation
   char          szFileServer[4+1];   // Workstation File Server(Optional)
   char          szWksMsg[40+1];      // WorkStation Message (Optional)
} DOCPRNTPARMS, *PDOCPRNTPARMS;

/*---------------------------------------------------------------------------*/
/*    DOCUMENT Attributes -- Used on Document Definition                     */
/*---------------------------------------------------------------------------*/
typedef struct _docattrs {
   ULONG         ulStruct;            // Size of this data structure
   FCODEPAGE     CodePage;            // Document Code Page
   FAFDATE       ReceiveDate;         // Receive Date
   FAFDATE       UserDate;            // User Specified
   FAFDATE       FileDate;            // User Specified.
   char          szDocDesc[253+1];    // Document Description
   USERSTATUS    UserStatus;          // User Defined and Interpreted.
   FILETAB       TabCode;             // File Tab Code
   FORMCODE      FormCode;            // Form Code.
   char          szUserData[253+1];   // Application Dependent
   char          szFormNumber[16+1];  // Form Number Info.
   char          szSecClass[2+1];     // Security Class.
} DOCATTRS, *PDOCATTRS;

/*---------------------------------------------------------------------------*/
/*    DOCUMENT PageRange -- Used on Extract and Modify Operations            */
/*---------------------------------------------------------------------------*/
typedef struct _pagerange {
   ULONG         ulStruct;            // Size of this data structure
   FPGINFO       PageModOp;           // Page Modify Type
   USHORT        usStartPage;
   USHORT        usAfterPage;
   USHORT        usNumPages;
} PAGERANGE, *PPAGERANGE;

/*---------------------------------------------------------------------------*/
/*    Document Event -- For APIs that Add Events vs Specific Event APIs      */
/*---------------------------------------------------------------------------*/
typedef struct _docevent {
   ULONG         ulStruct;            // Data Structure including this Field
   EVENTCODE     EventCode;           // Event Code
   BOOL          fCreateEntry;        // False(Default)=NO,TRUE=YES
   char          szEventDesc[253+1];  // Event Short Description
   char          szEventData[253+1];  // Event Data
} DOCEVENT, *PDOCEVENT;

/*---------------------------------------------------------------------------*/
/*    DOCUMENT Info -- Returned on Find, Get or List Operations              */
/*---------------------------------------------------------------------------*/
typedef struct _Documentinfo {
   ULONG         BlockID;             // Structure Identifier
   ULONG         ulStruct;            // size of this data structure
   DOCID         docid;               // Document ID + Folder
   USHORT        usVersion;           // Document Version
   char          szDocName[253+1];    // Name of the Document
   char          szCollName[44+1];    // Collection Name
   USHORT        usDocClass;          // Document Content Class
   FAFDATE       ReceiveDate;         // Receive Date
   USERSTATUS    UserStatus;          // User Defined and Interpreted.
   USHORT        usCodePage;          // Code Page
   BOOL          fOrigKept;           // FALSE=No Original; TRUE=Orig. Kept.
   BOOL          fDocStatus;          // FALSE=No Mod. Pend; TRUE=Mod. Pend.
   FAFDATE       UserDate;            // User Specified
   USHORT        usNumPages;          // Size in number of pages.
   FAFDATE       FileDate;            // User Specified.
   char          szDocDesc[253+1];    // Document Description
   USHORT        usVersions;          // Number of Versions
   USHORT        usTabCode;           // File Tab Code
   USHORT        usFormCode;          // Form Code.
   FORMNUM       FormNumber;          // Form Number Info.
   char          szUserData[253+1];   // User Data
   char          szStoreSite[4+1];    // Store Site IODM
   char          szSecClass[2+1];     // Security Class.
   TIMESTAMP     tsTimeChanged;       // Date and Time of Last Change.
   PVOID         Tracker;             // Reserved
} DOCUMENTINFO, *PDOCUMENTINFO;

/*---------------------------------------------------------------------------*/
/*    ANNOTATIONs Storage Structure                                          */
/*---------------------------------------------------------------------------*/
typedef struct _annotationstorage {
   char          szIdxName[255+1];    // Annotation index path and file name
   ULONG         ulIdxLength;         // Length of annotation index buffer
   PBYTE         pIdxBuffer;          // Pointer to annotation index buffer
   ULONG         ulIdxRC;             // ReturnCode for annotation index
   HOSTRC        IdxHostRC;           // Return Code for annotation index
   HOSTREASON    IdxHostReas1;        // Reason Code 1 for annotation index
   HOSTREASON    IdxHostReas2;        // Reason Code 2 for annotation index
   char          szObjName[255+1];    // Annotation object path and file name
   ULONG         ulObjLength;         // Length of annotation object buffer
   PBYTE         pObjBuffer;          // Pointer to annotation object buffer
   ULONG         ulObjRC;             // ReturnCode for annotation object
   HOSTRC        ObjHostRC;           // Return Code for annotation object
   HOSTREASON    ObjHostReas1;        // Reason Code 1 for annotation object
   HOSTREASON    ObjHostReas2;        // Reason Code 2 for annotation object
} ANNOTATIONS, *PANNOTATIONS;

/*---------------------------------------------------------------------------*/
/*    DOCUMENT Storage Struct - Used to Select where a document is stored    */
/*---------------------------------------------------------------------------*/
typedef struct _locationcntl {
   ULONG         ulStruct;            // size of this data structure
   LOCOPTS       LocOpts;             // Document storage location option
   char          szFileName[255+1];   // Document Path and File name
   ULONG         ulBuflen;            // Length of Document Buffer
   PBYTE         pBuffer;             // Pointer to Document Buffer
   ANNOTATIONS   Annotations;         // Annotation storage structure
} LOCCNTL, *PLOCCNTL;

/*---------------------------------------------------------------------------*/
/*    OVERLAYs Storage Structure                                             */
/*---------------------------------------------------------------------------*/
typedef struct _overlaystorage {
   ULONG         ulOverLen;           // Length of Overlay Buffer
   PBYTE         pOverBuf;            // Pointer to Overlay Buffer
   HOSTRC        HostRC;              // Return Code for this Overlay
   HOSTREASON    HostReas1;           // Reason Code 1 for this Overlay
   HOSTREASON    HostReas2;           // Reason Code 2 for this Overlay
} OVERLAYSTRG, *POVERLAYSTRG;

/*---------------------------------------------------------------------------*/
/*    DOCUMENT and OVERLAYs Storage Structure                                */
/*---------------------------------------------------------------------------*/
typedef struct _docoverlaystorage {
   ULONG         ulStruct;            // size of this data structure
   ULONG         ulDocLength;         // Length of Document Buffer
   PBYTE         pDocument;           // Pointer to Document Buffer
   ULONG         ulNumOverlays;       // Number of Overlays returned
   OVERLAYSTRG   aOverlays[MAX_DOC_OVERLAYS]; // Array of Overlay sizes + ptrs
   ANNOTATIONS   Annotations;         // Annotation storage structure
} DOCOVERSTRG, *PDOCOVERSTRG;

/*---------------------------------------------------------------------------*/
/*    DOCUMENT Temporary ID Format -- Used in the Creation of a New Doc.     */
/*---------------------------------------------------------------------------*/
typedef struct _tempidformat {
   ULONG         ulStruct;            // Data Structure including this Field
   TIDOPTION     TidOpt;              // Other TID Format Alternatives
   char          szTidPrefixD[1+1];   // Concatenate with system random number
} TEMPIDFORMAT, *PTEMPIDFORMAT;

/*---------------------------------------------------------------------------*/
/*    Temporary or Pending Document ID Structure. Collection of these        */
/*    structures are the output of the FafFindPendxxx APIs. There is enough  */
/*    information in this structure to issue subsequent FafxxxPend APIs.     */
/*---------------------------------------------------------------------------*/
typedef struct _pendidstruct {
   ULONG         BlockID;             // Structure Identifier
   ULONG         ulStruct;            // size of this data structure
   TEMPID        TempID;              // Id of Temp or Pend Document
   TRANSNUM      TempTrans;           // Temporary Transaction Number
   FOLDERTOKEN   FolderToken;         // Folder Token
   char          szCreateSite[4+1];   // Document Create Site - IODM ID
   char          szStoreSite[4+1];    // Store Site -- IODM ID
   DOCID         DestDocID;           // Dest. DocID+Folder-Mod. Pending Only
   FOLDERTOKEN   DestFolderToken;     // Dest Folder Token
   PVOID         Tracker;             // Reserved
} PENDIDSTRUCT, *PPENDIDSTRUCT;

/*---------------------------------------------------------------------------*/
/*    Temporary or Pending Document Info -- Returned on Find Get or List     */
/*---------------------------------------------------------------------------*/
typedef struct _tempdocinfo {
   ULONG         BlockID;             // Structure Identifier
   ULONG         ulStruct;            // size of this data structure
   TEMPID        TempID;              // Id of Temp or Pend Document
   TRANSNUM      TempTrans;           // Temporary Transaction Number
   char          szCmdName[8+1];      // Tran Name for Pending Document
   BOOL          fRespPending;        // ODM Resp. Pending FALSE=No,TRUE=YES
   USHORT        usRetryCnt;          // IODM Retry Count
   USHORT        usEvent;             // Event Code
   USHORT        usEventSource;       // Event Code for Source Document
   BOOL          fCreateEntry;        // False(Default)=NO,TRUE=YES
   char          szEventDesc[253+1];  // Event Short Description
   char          szEventData[253+1];  // Event Data
   FOLDERTOKEN   FolderToken;         // Folder Token
   DOCID         DocID;               // Document+Folder Identification
   char          szCreateSite[4+1];   // Document Create Site - IODM ID
   USHORT        usDocVersion;        // Version
   FAFDATE       RecvDate;            // Receive Date
   USHORT        usCodePage;
   BOOL          fOrigKept;           // FALSE=No; TRUE=Yes.
   FAFDATE       UserDate;            // User Specified
   FAFDATE       FileDate;            // User Specified.
   char          szDocDesc[253+1];
   char          szUserID[8+1];       // Modifying or Scanning User.
   char          szGoodTran[8+1];     // Associated Good Tran. IODM Compl.
   char          szTranData[253+1];   // GOOD/TRAN Input Data
   char          szBadTran[8+1];      // Associated Bad Tran. IODM Completion
   USHORT        usUserStatus;        // Status User Defined and Interpreted.
   USHORT        usTabCode;           // File Tab Code
   USHORT        usFormCode;          // Form Code
   char          szUserData[253+1];   // Application Dependent
   char          szFormNumber[16+1];  // Form Number Info.
   char          szSecClass[2+1];     // Security Class.
   char          szCollName[44+1];    // Collection Name  (MVS OAM)
   ULONG         ulRetPer;            // Retention Period (MVS OAM)
   char          szMgmtCl[8+1];       // Management Class (MVS OAM)
   char          szStgClass[8+1];     // Storage Class (MVS OAM)
   char          szNewStorSite[4+1];  // New Store Site -- IODM ID
   char          szStoreSite[4+1];    // Store Site -- IODM ID
   DOCID         DestDocID;           // Dest. DocID+Folder-Mod. Pending Only
   FOLDERTOKEN   DestFolderToken;     // Dest Folder Token
   USHORT        usDestDocVersion;    // Dest. Version-Mod Pending Only
   FAFDATE       DestRecvDate;        // Modify Pending Only
   char          szVersCollName[44+1];// Collection Name  (MVS OAM)
   ULONG         ulVersRetPer;        // Retention Period (MVS OAM)
   char          szVersMgmtCl[8+1];   // Management Class (MVS OAM)
   char          szVersStgClass[8+1]; // Storage Class (MVS OAM)
   char          szVersStoreSite[4+1];// Store Site -- IODM ID
   char          szWorkStation[8+1];  // Target IWP WorkStation
   char          szFileServer[4+1];   // Workstation File Server(Optional)
   char          szWksMsg[40+1];      // WorkStation Message (Optional)
   PVOID         Tracker;             // Reserved
} TEMPDOCINFO, *PTEMPDOCINFO;

/*---------------------------------------------------------------------------*/
/*  Temporary or Pending Document Cursor -- Used to Continue a Prior Find    */
/*---------------------------------------------------------------------------*/
typedef struct _tempcursor {
   ULONG         BlockID;             // Structure Identifier
   ULONG         ulStruct;            // size of this data structure
   TIMESTAMP     StartDTTM;           // Continue Date and Time
   FOLDERTOKEN   Folder;              // Folder Token
   PVOID         Tracker;             // Reserved
} TEMPCURSOR, *PTEMPCURSOR;

/*---------------------------------------------------------------------------*/
/*    Folder NOTEINFO -- Contains Attributes related to a Note.              */
/*---------------------------------------------------------------------------*/
typedef struct _noteinfo {
   ULONG         BlockID;             // Structure Identifier
   ULONG         ulStruct;            // size of this data structure
   USHORT        usCodePage;          // Note Code Page
   char          szShortDesc[253+1];  // Short Description of the Notes
   TIMESTAMP     tsTimeCrte;          // Create Time+Date -- Note ID.
   char          szUserId[8+1];       // Creating Userid.
   PVOID         Tracker;             // Reserved
} NOTEINFO, *PNOTEINFO;

/*---------------------------------------------------------------------------*/
/*    Folder NOTETEXT -- Contains the length and actual text of the Note     */
/*---------------------------------------------------------------------------*/
typedef struct _notetext
{  ULONG         BlockID;             // Structure Identifier
   ULONG         ulStruct;            // size of this data structure
   USHORT        usCodePage;          // Note Code Page
   char          szShortDesc[253+1];  // Short Descript
   char          szUserId[8+1];       // Creating Userid.
   ULONG         ulNoteLength;        // The Note Length
   char          pNoteContent[3500+1];// Actual Note Content.
   PVOID         Tracker;             // Reserved
} NOTETEXT, *PNOTETEXT;

/*---------------------------------------------------------------------------*/
/*    Document Event Types                                                   */
/*---------------------------------------------------------------------------*/
typedef struct _event {
   ULONG         BlockID;             // Block ID - Ignored on Input
   ULONG         ulStruct;            // Data Structure Length
   DOCVERSION    DocVersion;          // Document Version
   EVENTCODE     EventCode;           // Event Code
   char          szEventDesc[253+1];  // Event Short Description
   char          szEventData[253+1];  // Event Data
   TIMESTAMP     tsTimeCrte;          // Event Creation
   char          szUser[8+1];         // User who created the event
   char          szWkStation[8+1];    // Event Workstation.
   FCODEPAGE     CodePage;            // Event Code Page.
   PVOID         Tracker;             // Reserved Ignored on Input
} EVENT, *PEVENT;

/*---------------------------------------------------------------------------*/
/*    WORKQUEUE ID -- Identifies Queue of Documents (WorkItems)              */
/*---------------------------------------------------------------------------*/
typedef struct _wqid {
   ULONG         ulStruct;            // size of this data structure
   RUNIT         RoutingUnit;         // Organizational Unit
   RCODE         RouteCode;           // Route Code within Unit
} WQID, *PWQID;

/*---------------------------------------------------------------------------*/
/*    Document Attribute RDEF Structure                                      */
/*---------------------------------------------------------------------------*/
typedef struct _rdefworkattrs {
   RDEFWORK_PARMS AttrID;             // Attribute ID
   char           szAttrValue[256+1]; // String Rep of Attribute Value
} RDEFWORKATTRS, *PRDEFWORKATTRS;

/*---------------------------------------------------------------------------*/
/*    WORKQUEUE -- A Queue of Documents (WorkItems) to be Processed.         */
/*---------------------------------------------------------------------------*/
typedef struct _workqueue {
   ULONG         BlockID;             // Structure Identifier
   ULONG         ulStruct;            // size of this data structure
   ULONG         ulRoutingUnit;       // Organizational Unit
   RCODE         RouteCode;           // Route Code within Unit
   char          szWqDesc[253+1];     // WQ Description
   TIMESTAMP     tsTimeChanged;       // Time and Date of Last Change.
   PVOID         Tracker;             // Reserved
} WORKQUEUE, *PWORKQUEUE;

/*---------------------------------------------------------------------------*/
/*    WORKQUEUE ASSIGNMENT -- A User Assigned to a WorkQueue                 */
/*---------------------------------------------------------------------------*/
typedef struct _wqassign {
   ULONG         BlockID;             // Structure Identifier
   ULONG         ulStruct;            // size of this data structure
   RUNIT         RoutingUnit;         // Organizational Unit
   RCODE         RouteCode;           // Route Code within Unit
   char          szUserid[8+1];       // Userid.
   USHORT        usQueuePrty;         // Assignment Priority
   BOOL          fWqAsgnStatus;       // "FALSE = Inactive" or "TRUE = Active"
   PVOID         Tracker;             // Reserved
} WQASSIGN, *PWQASSIGN;

/*---------------------------------------------------------------------------*/
/*    WORK ASSIGNMENT Cursor -- Used to Continue a List WorkAssignment API   */
/*---------------------------------------------------------------------------*/
typedef struct _workasgncursor {
   ULONG         BlockID;             // Structure Identifier
   ULONG         ulStruct;            // size of this data structure
   RUNIT         RoutingUnit;         // Organizational Unit
   RCODE         RouteCode;           // Route Code within Unit
   char          szUserid[8+1];       // Userid.
   USHORT        usQueuePrty;         // Assignment Priority
   PVOID         Tracker;             // Reserved
} WORKASGNCURSOR, *PWORKASGNCURSOR;

/*---------------------------------------------------------------------------*/
/*    Work ITEM Routing - Control for WorkItem assigned to a WorkQueue       */
/*---------------------------------------------------------------------------*/
typedef struct _workrouting {
   ULONG         ulStruct;            // size of this data structure
   RLOB          RoutingLOB;          // Routing Line of Business
   char          szTranType[6+1];     // Transaction Type
   char          szUserPrm1[4+1];     // User Parameter One
   ULONG         ulUserPrm2;          // User Parameter Two
} WORKROUTING, *PWORKROUTING;

/*---------------------------------------------------------------------------*/
/*    WORKITEM RoutingInfo - Used by FafGetRoutingInfo                       */
/*---------------------------------------------------------------------------*/
typedef struct _routinginfo {
   ULONG         BlockID;             // Structure Identifier
   ULONG         ulStruct;            // size of this data structure
   USHORT        usAgingHigh;         // High Aging Factor
   USHORT        usAgingLow;          // Low Aging Factor
   USHORT        usAgingMedium;       // Medium Aging Factor
   USHORT        usAgingNormal;       // Normal Aging Factor
   char          szAssignedEmpl[8+1]; // WorkItem Assigned to this User
   USHORT        usBasePrtyHigh;      // High Base Priority
   USHORT        usBasePrtyLow;       // Low Base Priority
   USHORT        usBasePrtyMedium;    // Medium Base Priority
   USHORT        usBasePrtyNormal;    // Normal Base Priority
   char          szWorkCategory[2+1]; // Category of Work
   RLOB          rNextRLOB;           // Next Routing Line of Business
   char          szTranType[6+1];     // Transaction Type
   BOOL          fOperational;        // Application Dependent
   RCODE         RouteCode;           // Routing Code
   PVOID         Tracker;             // Reserved
} ROUTINGINFO, *PROUTINGINFO;

/*---------------------------------------------------------------------------*/
/*    WORKITEM PRIORITY -- Control Fields that Set the WorkItem Priority     */
/*---------------------------------------------------------------------------*/
typedef struct _workitempriority {
   ULONG         ulStruct;            // size of this data structure
   WIPRIORITY    Priority;            // Priority of WorkItem
   WIPRIORITY    AgingPriority;       // Aging Priority
   WIPRIORITY    BasePriority;        // Base Priority
   WIPRIORITY    PrtyOverride;        // Priority Override Indicator
} WORKITEMPRIORITY, *PWORKITEMPRIORITY;

/*---------------------------------------------------------------------------*/
/*    WORKITEM INIT - Work Item Initialization Parameters                    */
/*---------------------------------------------------------------------------*/
typedef struct _workiteminit {
   ULONG         ulStruct;            // size of this data structure
   char          szAssignedEmpl[8+1]; // WorkItem Assigned to this User
   FAFDATE       AgingDate;           // User Specified Aging Date
   FAFDATE       ExpireDate;          // User Specified Expiration Date
   TIMESTAMP     tsHold;              // Hold Process until this time and date
   DOCNUM        DocNumber;           // User Supplied Document Number
   char          szUserDetail[40+1];  // User Defined
} WORKITEMINIT, *PWORKITEMINIT;

/*---------------------------------------------------------------------------*/
/*    WORKITEM  -- "A Document Assigned to a WorkQueue for Routing"          */
/*---------------------------------------------------------------------------*/
typedef struct _workitem {
   ULONG         BlockID;              // Structure Identifier
   ULONG         ulStruct;             // size of this data structure
   ULONG         ulRoutingUnit;        // Organizational Unit
   RCODE         RouteCode;            // Route Code within Unit
   DOCID         DocID;                // Document ID
   FAFDATE       ReceiveDate;          // Receive Date
   FOLDERTOKEN   Folder;               // Folder that Contains the Doc.
   char          szAssignedEmpl[8+1];  // WorkItem Assigned to this User
   char          szProcessingEmpl[8+1];// WorkItem Checked-Out to this User
   FAFTIME       tHoldTime;            // Hold Process until this Time
   FAFDATE       dHoldDate;            // Hold Process until this Date
   FAFDATE       AgingDate;            // User Specified Aging Date
   FAFDATE       ExpireDate;           // User Specified Expiration Date
   USHORT        usPriority;           // Priority of WorkItem
   USHORT        usAgingPriority;      // Aging Priority
   USHORT        usBasePriority;       // Base Priority
   USHORT        usPrtyOverride;       // Priority Override Indicator
   USHORT        usDocNumber;          // User Supplied Document Number
   char          szUserDetail[40+1];   // User Defined
   RLOB          RoutingLOB;           // Routing Line of Business
   char          szTranType[6+1];      // Transaction Type
   char          szUserPrm1[4+1];      // User Parameter One
   ULONG         ulUserPrm2;           // User Parameter Two
   TIMESTAMP     tsTimeChanged;        // Time and Date of Last Change.
   PVOID         Tracker;              // Reserved
} WORKITEM, *PWORKITEM;

/*---------------------------------------------------------------------------*/
/*    WORKITEM GETWORK Cursor -- Used to Continue a Prior "GETWORK" API      */
/*---------------------------------------------------------------------------*/
typedef struct _getworkcursor {
   ULONG         BlockID;              // Structure Identifier
   ULONG         ulStruct;             // size of this data structure
   RUNIT         RoutingUnit;          // Organizational Unit
   RCODE         RouteCode;            // Route Code within Unit
   DOCID         DocID;                // Document ID
   char          szAssignedEmpl[8+1];  // WorkItem Assigned to this User
   char          szProcessingEmpl[8+1];// WorkItem Checked-Out to this User
   FAFDATE       AgingDate;            // User Specified Aging Date
   WIPRIORITY    Priority;             // Priority of WorkItem
   PVOID         Tracker;              // Reserved
} GETWORKCURSOR, *PGETWORKCURSOR;

/*---------------------------------------------------------------------------*/
/*    WORKITEM WORK Cursor -- Used to Continue a Prior ListWork Variant API  */
/*---------------------------------------------------------------------------*/
typedef struct _workcursor {
   ULONG         BlockID;              // Structure Identifier
   ULONG         ulStruct;             // size of this data structure
   RUNIT         RoutingUnit;          // Organizational Unit
   RCODE         RouteCode;            // Route Code within Unit
   DOCID         DocID;                // Document ID
   FOLDERTOKEN   FolderToken;          // Folder that Contains the Doc.
   char          szAssignedEmpl[8+1];  // WorkItem Assigned to this User
   char          szProcessingEmpl[8+1];// WorkItem Checked-Out to this User
   FAFDATE       AgingDate;            // User Specified Aging Date
   WIPRIORITY    Priority;             // Priority of WorkItem
   PVOID         Tracker;              // Reserved
} WORKCURSOR, *PWORKCURSOR;

/*---------------------------------------------------------------------------*/
/*    The following is to support C++ compilers                              */
/*---------------------------------------------------------------------------*/
#ifdef __cplusplus
   extern "C" {
#endif

/*---------------------------------------------------------------------------*/
/*    IPFAF Workstation Client Session Management APIs                       */
/*---------------------------------------------------------------------------*/
APIEXPORT ULONG  FAFENTRY  FafCustomerConduit(
                                       HFSESSION         hFSession,
                                       PVOID             pCustomerData,
                                       USHORT            usDataLength,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafFreeResource(
                                       HFSESSION         hFSession,
                                       PVOID             pResource,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafQueryOutcome(
                                       HFSESSION         hFSession,
                                       PTRANSNUM         pTransNum,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafSessionConnect(
                                       APPLIDCD          ApplidCD,
                                       PSZ               pszUserid,
                                       PSZ               pszPassWord,
                                       PSZ               pszNewPswd,
                                       PSZ               pszOdmTermid,
                                       PSZ               pszOdmUserid,
                                       PSZ               pszOdmPassWord,
                                       PSZ               pszOdmNewPswd,
                                       PFAFCONNECTPARMS  pFafConn,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafSessionDisconnect(
                                       HFSESSION         hFSession,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );

/*---------------------------------------------------------------------------*/
/*    IPFAF Workstation Client Folder Management APIs                        */
/*---------------------------------------------------------------------------*/
APIEXPORT ULONG  FAFENTRY  FafDefineFolder(
                                       HFSESSION         hFSession,
                                       PFOLDERID         folderID,
                                       PFOLDERATTRS      pFolderAttrs,
                                       USHORT            usNumIndices,
                                       PINDEXDEFSTRUCT   pIndexDefs,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafDeleteFolder(
                                       HFSESSION         hFSession,
                                       PFOLDERIDSTRUCT   pFolder,
                                       BOOL              fNoOdmDelete,
                                       PODMCOMPLETE      pBadODMResp,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafFindFolders(
                                       HFSESSION         hFSession,
                                       PFOLDERCURSOR     pFolderCursor,
                                       PS2NDARYINDEX     pIndexVal,
                                       PFOLDERTYPE       pFolderType,
                                       PFAFDATE          pDsStartDate,
                                       PFAFDATE          pdsEndDate,
                                       PFCODEPAGE        CodePage,
                                       USHORT            usToBeRet,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafFindFolderSingle(
                                       HFSESSION         hFSession,
                                       PFOLDERIDSTRUCT   pFolder,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafGetFolderIndexValues(
                                       HFSESSION         hFSession,
                                       PFOLDERIDSTRUCT   pFolder,
                                       USHORT            usNumIndices,
                                       PINDEXGETSTRUCT   pIndices,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafRedefineFolderAttrs(
                                       HFSESSION         hFSession,
                                       PFOLDERIDSTRUCT   pFolder,
                                       USHORT            usNumAttrs,
                                       PRDEFFOLDERATTRS  pAttrStruct,
                                       PTIMESTAMP        pTsTimeChgd,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafRedefineFolderIndices(
                                       HFSESSION         hFSession,
                                       PFOLDERIDSTRUCT   pFolder,
                                       USHORT            usNumIndices,
                                       PINDEXDEFSTRUCT   pIndexDefs,
                                       PTIMESTAMP        pTsTimeChgd,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );

/*---------------------------------------------------------------------------*/
/*    IPFAF Workstation Client Folder Note Management APIs                   */
/*---------------------------------------------------------------------------*/
APIEXPORT ULONG  FAFENTRY  FafAddNote( HFSESSION         hFSession,
                                       PFOLDERIDSTRUCT   pFolder,
                                       PHBUF             pBuffer,
                                       ULONG             ulBytesCount,
                                       PSZ               pszDescription,
                                       PFCODEPAGE        CodePage,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafCountNotes(
                                       HFSESSION         hFSession,
                                       PFOLDERIDSTRUCT   pFolder,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafDeleteNotes(
                                       HFSESSION         hFSession,
                                       PFOLDERIDSTRUCT   pFolder,
                                       PTIMESTAMP        pTsCreate,
                                       PTIMESTAMP        pTsStart,
                                       PTIMESTAMP        ptsEnd,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafFindNotes(
                                       HFSESSION         hFSession,
                                       PFOLDERIDSTRUCT   pFolder,
                                       PTIMESTAMP        pTsStart,
                                       PTIMESTAMP        ptsEnd,
                                       PTIMESTAMP        pTsContinue,
                                       USHORT            usToBeRet,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafGetNoteContent(
                                       HFSESSION         hFSession,
                                       PFOLDERIDSTRUCT   pFolder,
                                       PTIMESTAMP        pTsCreate,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );

/*---------------------------------------------------------------------------*/
/*    IPFAF Workstation Client Document Management APIs                      */
/*---------------------------------------------------------------------------*/
APIEXPORT ULONG  FAFENTRY  FafCopyDocument(
                                       HFSESSION         hFSession,
                                       PFOLDERIDSTRUCT   pDestFolder,
                                       PDOCIDSTRUCT      pDocID,
                                       PDOCTIMEID        pDocTimeID,
                                       PDOCWKSPARMS      pWksParms,
                                       DOCVERSION        DocVersion,
                                       PDOCATTRS         pDestAttrs,
                                       PDOCSTORAGE       pDocStorage,
                                       BOOL              fIgnBadResp,
                                       PDOCEVENT         pEvent,
                                       PEVENTCODE        pEventSource,
                                       PODMCOMPLETE      pBadODMResp,
                                       PODMCOMPLETE      pOkODMResp,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafCountDocuments(
                                       HFSESSION         hFSession,
                                       PFOLDERIDSTRUCT   pFolder,
                                       BOOL              fAllVersions,
                                       PFILETAB          pFileTab,
                                       PFAFDATE          pDsStartDate,
                                       PFAFDATE          pDsEndDate,
                                       PUSERSTATUS       pUserStatus,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafCountDocumentsAll(
                                       HFSESSION         hFSession,
                                       PFOLDERIDSTRUCT   pFolder,
                                       BOOL              fAllVersions,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafCountDocVersions(
                                       HFSESSION         hFSession,
                                       PDOCIDSTRUCT      pDocID,
                                       PFAFDATE          pDsRecvDate,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafDefineDocument(
                                       HFSESSION         hFSession,
                                       PFOLDERIDSTRUCT   pFolder,
                                       PSZ               pszCreateSite,
                                       PDOCSTORAGE       pDocStorage,
                                       USHORT            usDocClass,
                                       PDOCATTRS         pDocAttrs,
                                       BOOL              fIgnBadResp,
                                       BOOL              fKeepOriginal,
                                       PTEMPIDFORMAT     pTempidFmt,
                                       PDOCEVENT         pEvent,
                                       PODMCOMPLETE      pBadODMResp,
                                       PODMCOMPLETE      pOkODMResp,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafDefineStoredDoc(
                                       HFSESSION         hFSession,
                                       PFOLDERIDSTRUCT   pFolder,
                                       PSZ               pszOAMname,
                                       USHORT            usDocClass,
                                       PSZ               pszCollname,
                                       PSZ               pszStoreSite,
                                       PDOCATTRS         pDocAttrs,
                                       BOOL              fKeepOriginal,
                                       USHORT            usNumPages,
                                       PSZ               pszWkStatID,
                                       PDOCEVENT         pEvent,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafDeleteDocsByFolder(
                                       HFSESSION         hFSession,
                                       PFOLDERIDSTRUCT   pFolder,
                                       DLTECNTL          DlteCntl,
                                       PDOCEVENT         pEvent,
                                       PODMCOMPLETE      pBadODMResp,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafDeleteDocument(
                                       HFSESSION         hFSession,
                                       PDOCIDSTRUCT      pDocID,
                                       PDOCTIMEID        pDocTimeID,
                                       DLTEOPTN          DeleteOption,
                                       DOCVERSION        DocVersion,
                                       DLTECNTL          DlteCntl,
                                       PDOCEVENT         pEvent,
                                       PODMCOMPLETE      pBadODMResp,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafDisplayDocuments(
                                       HFSESSION         hFSession,
                                       PFOLDERIDSTRUCT   pFolder,
                                       USHORT            usNumDocs,
                                       PDOCDISPLAY       pDocsDisplay,
                                       PDOCWKSPARMS      pWksParms,
                                       BOOL              fClearWks,
                                       PODMCOMPLETE      pBadODMResp,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafExtractDocument(
                                       HFSESSION         hFSession,
                                       PDOCIDSTRUCT      pDocID,
                                       PDOCTIMEID        pDocTimeID,
                                       PPAGERANGE        pPageRange,
                                       USHORT            usNumPageRanges,
                                       PDOCWKSPARMS      pWksParms,
                                       PFOLDERIDSTRUCT   pDestFolder,
                                       DOCVERSION        DocVersion,
                                       PDOCATTRS         pDestAttrs,
                                       PDOCSTORAGE       pDocStorage,
                                       BOOL              fIgnBadResp,
                                       PDOCSTORAGE       pVersStgPrms,
                                       PDOCEVENT         pEvent,
                                       PEVENTCODE        pEventSource,
                                       PODMCOMPLETE      pBadODMResp,
                                       PODMCOMPLETE      pOkODMResp,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafFetchDocument(
                                       HFSESSION         hFSession,
                                       PDOCIDSTRUCT      pDocID,
                                       PDOCTIMEID        pDocTimeID,
                                       DOCVERSION        DocVersion,
                                       PODMCOMPLETE      pBadODMResp,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafFindDocuments(
                                       HFSESSION         hFSession,
                                       PFOLDERIDSTRUCT   pFolder,
                                       PFILETAB          pFileTab,
                                       PFAFDATE          pDsStartDate,
                                       PFAFDATE          pDsEndDate,
                                       PUSERSTATUS       pUserStatus,
                                       PDOCUMENTCURSOR   pDocCursor,
                                       USHORT            usToBeRet,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafFindDocumentsAll(
                                       HFSESSION         hFSession,
                                       PFOLDERIDSTRUCT   pFolder,
                                       PFAFDATE          pDsStartDate,
                                       PFAFDATE          pDsEndDate,
                                       PDOCUMENTCURSOR   pDocCursor,
                                       USHORT            usToBeRet,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafFindDocumentSingle(
                                       HFSESSION         hFSession,
                                       PDOCIDSTRUCT      pDocID,
                                       PFAFDATE          pDsRecvDate,
                                       DOCVERSION        DocVersion,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafFindDocVersions(
                                       HFSESSION         hFSession,
                                       PDOCIDSTRUCT      pDocID,
                                       PFAFDATE          pDsRecvDate,
                                       PDOCUMENTCURSOR   pDocCursor,
                                       USHORT            usToBeRet,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafMergeDocuments(
                                       HFSESSION         hFSession,
                                       PDOCIDSTRUCT      pDstDocID,
                                       PDOCTIMEID        pDstTimeID,
                                       PDOCIDSTRUCT      pSrcDocID,
                                       PDOCTIMEID        pSrcTimeID,
                                       PDOCWKSPARMS      pWksParms,
                                       DOCVERSION        DstVersion,
                                       DOCVERSION        SrcVersion,
                                       PDOCSTORAGE       pVersStgPrms,
                                       BOOL              fIgnBadResp,
                                       PDOCEVENT         pEvent,
                                       PEVENTCODE        pEventSource,
                                       PODMCOMPLETE      pBadODMResp,
                                       PODMCOMPLETE      pOkODMResp,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafModifyDocument(
                                       HFSESSION         hFSession,
                                       PDOCIDSTRUCT      pDocID,
                                       DOCVERSION        DocVersion,
                                       PDOCTIMEID        pDocTimeID,
                                       PPAGERANGE        pPageRange,
                                       USHORT            usNumPageRanges,
                                       PDOCWKSPARMS      pWksParms,
                                       PDOCSTORAGE       pVersStgPrms,
                                       PTEMPIDFORMAT     pTempidFmt,
                                       BOOL              fIgnBadResp,
                                       PDOCEVENT         pEvent,
                                       PODMCOMPLETE      pBadODMResp,
                                       PODMCOMPLETE      pOkODMResp,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafMoveDocument(
                                       HFSESSION         hFSession,
                                       PFOLDERIDSTRUCT   pDestFolder,
                                       PDOCIDSTRUCT      pDocID,
                                       PDOCTIMEID        pDocTimeID,
                                       PDOCATTRS         pDestAttrs,
                                       PDOCEVENT         pEvent,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafPrintDocument(
                                       HFSESSION         hFSession,
                                       PDOCIDSTRUCT      pDocID,
                                       PDOCTIMEID        pDocTimeID,
                                       PDOCPRNTPARMS     pPrntParms,
                                       PSZ               pszPrtDest,
                                       DOCVERSION        DocVersion,
                                       BOOL              fAltWksPrt,
                                       COPYTYPE          CopyType,
                                       PODMCOMPLETE      pBadODMResp,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafRedefineDocument(
                                       HFSESSION         hFSession,
                                       PDOCIDSTRUCT      pDocID,
                                       PDOCTIMEID        pDocTimeID,
                                       USHORT            usNumAttrs,
                                       PRDEFDOCATTRS     pAttrStruct,
                                       PDOCEVENT         pEvent,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafRedefineStorage(
                                       HFSESSION         hFSession,
                                       PDOCIDSTRUCT      pDocID,
                                       PDOCTIMEID        pDocTimeID,
                                       PSZ               pszMgmtClass,
                                       PSZ               pszStgClass,
                                       PRETPERIOD        pRetPeriod,
                                       PODMCOMPLETE      pBadODMResp,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafSendDocument(
                                       HFSESSION         hFSession,
                                       PDOCIDSTRUCT      pDocID,
                                       PDOCTIMEID        pDocTimeID,
                                       PSZ               pszDestination,
                                       DOCVERSION        DocVersion,
                                       PSZ               pszSendData,
                                       FORMOVERLAY       SendOverlay,
                                       COPYTYPE          CopyType,
                                       PODMCOMPLETE      pBadODMResp,
                                       PODMCOMPLETE      pOkODMResp,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );

/*----------------------------------------------------------------------------*/
/*    IPFAF Workstation Client Document Management APIs (IODM Interface)      */
/*----------------------------------------------------------------------------*/
APIEXPORT ULONG  FAFENTRY  FafCreateFEAKey(
                                       HFSESSION         hFSession,
                                       PFOLDERTOKEN      pFolderToken,
                                       PDOCID            pDocID,
                                       USHORT            usDocVersion,
                                       PFEAKEY           pDocLockKey,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafGetDocument(
                                       HFSESSION         hFSession,
                                       PSZ               pszDocName,
                                       USHORT            usDocClass,
                                       PSZ               pszCollName,
                                       PSZ               pszStoreSite,
                                       COPYTYPE          CopyType,
                                       OBJCNTL           StrgLocOpts,
                                       ULONG             ulObjStart,
                                       ULONG             ulObjLength,
                                       PLOCCNTL          pRcvLocOpts,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafGetDocAndOverlays(
                                       HFSESSION         hFSession,
                                       PSZ               pszDocName,
                                       USHORT            usDocClass,
                                       PSZ               pszCollName,
                                       PSZ               pszStoreSite,
                                       COPYTYPE          CopyType,
                                       OBJCNTL           StrgLocOpts,
                                       PDOCOVERSTRG      pDocOverlays,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafGetDocumentSize(
                                       HFSESSION         hFSession,
                                       PSZ               pszDocName,
                                       USHORT            usDocClass,
                                       PSZ               pszCollName,
                                       PSZ               pszStoreSite,
                                       PULONG            pulObjLength,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafGetDefinedDocName(
                                       HFSESSION         hFSession,
                                       PTEMPID           pTempId,
                                       PDOCNAME          pDocName,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafLockDocAnnotation(
                                       HFSESSION         hFSession,
                                       USHORT            usDocClass,
                                       PSZ               pszDocName,
                                       PSZ               pszCollName,
                                       PSZ               pszStoreSite,
                                       PSZ               pszFafSite,
                                       DOCLOCKTYPE       LockType,
                                       PFEAKEY           pDocLockKey,
                                       PLOCCNTL          pLocOpts,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafStoreDefinedDoc(
                                       HFSESSION         hFSession,
                                       PLOCCNTL          pLocOpts,
                                       PLOCCNTL          pLowResOpts,
                                       USHORT            usDocClass,
                                       USHORT            usNumPages,
                                       PTEMPID           pTempId,
                                       PSZ               pszDocName,
                                       PSZ               pszScanId,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafStoreDocument(
                                       HFSESSION         hFSession,
                                       PLOCCNTL          pLocOpts,
                                       USHORT            usDocClass,
                                       PDOCSTORAGE       pDocStorage,
                                       PDOCNAME          pDocName,
                                       PDOCID            pDocId,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafUpdateDocAnnotation(
                                       HFSESSION         hFSession,
                                       BOOL              fKeepLock,
                                       ULONG             ulChangeType,
                                       USHORT            usDocClass,
                                       PSZ               pszDocName,
                                       PSZ               pszCollName,
                                       PSZ               pszStoreSite,
                                       PSZ               pszFafSite,
                                       PFEAKEY           pDocLockKey,
                                       PLOCCNTL          pLocOpts,
                                       PDOCOVERSTRG      pDocOverlays,
                                       PSZ               pszDescription,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafUpdateItemLock(
                                       HFSESSION         hFSession,
                                       PSZ               pszFafSite,
                                       DOCLOCKTYPE       LockType,
                                       PFEAKEY           pDocLockKey,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );

/*---------------------------------------------------------------------------*/
/*    IPFAF Workstation Client Pending or Temporary Document Management APIs */
/*---------------------------------------------------------------------------*/
APIEXPORT ULONG  FAFENTRY  FafDeletePendDoc(
                                       HFSESSION         hFSession,
                                       PTEMPID           pTempID,
                                       PURGETID          PurgeOpts,
                                       TEMPTYPE          TempType,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafDeletePendDocs(
                                       HFSESSION         hFSession,
                                       PTSRANGE          pTsRange,
                                       PRETRYCNT         pRetryCnt,
                                       PURGETID          PurgeOpts,
                                       TEMPTYPE          TempType,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafDeletePendDocsByFolder(
                                       HFSESSION         hFSession,
                                       PFOLDERIDSTRUCT   pFolder,
                                       PTSRANGE          pTsRange,
                                       PRETRYCNT         pRetryCnt,
                                       PURGETID          PurgeOpts,
                                       TEMPTYPE          TempType,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafFindPendDocs(
                                       HFSESSION         hFSession,
                                       PTIMESTAMP        pStartDttm,
                                       PTIMESTAMP        pEndDttm,
                                       PTEMPCURSOR       pTempCursor,
                                       TEMPTYPE          TempType,
                                       USHORT            usToBeRet,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafFindPendDocSingle(
                                       HFSESSION         hFSession,
                                       PTEMPID           pTempID,
                                       TEMPTYPE          TempType,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafFindPendDocsByFolder(
                                       HFSESSION         hFSession,
                                       PFOLDERIDSTRUCT   pFolder,
                                       PTIMESTAMP        pStartDttm,
                                       PTIMESTAMP        pEndDttm,
                                       PTEMPCURSOR       pTempCursor,
                                       TEMPTYPE          TempType,
                                       USHORT            usToBeRet,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafFindPendDocsByResp(
                                       HFSESSION         hFSession,
                                       BOOL              fRespPend,
                                       PTIMESTAMP        pStartDttm,
                                       PTIMESTAMP        pEndDttm,
                                       PTEMPCURSOR       pTempCursor,
                                       TEMPTYPE          TempType,
                                       USHORT            usToBeRet,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafRetryPend(
                                       HFSESSION         hFSession,
                                       PTEMPID           pTempID,
                                       PSZ               pszODM,
                                       PTIMESTAMP        pTsODMTrans,
                                       BOOL              fRetryCntl,
                                       TEMPTYPE          TempType,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );

/*---------------------------------------------------------------------------*/
/*    IPFAF Workstation Client Document Event Management APIs                */
/*---------------------------------------------------------------------------*/
APIEXPORT ULONG  FAFENTRY  FafAddEvent(
                                       HFSESSION         hFSession,
                                       PDOCIDSTRUCT      pDocID,
                                       PFAFDATE          pDsRecvDate,
                                       PEVENT            pEvent,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafDeleteEvent(
                                       HFSESSION         hFSession,
                                       PDOCID            pDocID,
                                       PTIMESTAMP        ptsStart,
                                       PTIMESTAMP        ptsEnd,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafGetEvents(
                                       HFSESSION         hFSession,
                                       PDOCID            pDocID,
                                       PTIMESTAMP        ptsStart,
                                       PTIMESTAMP        ptsEnd,
                                       PTIMESTAMP        ptsContinue,
                                       USHORT            usToBeRet,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );

/*---------------------------------------------------------------------------*/
/*    IPFAF Workstation Client WorkFlow Management WorkQueue APIs            */
/*---------------------------------------------------------------------------*/
APIEXPORT ULONG  FAFENTRY  FafDefineWorkQueue(
                                       HFSESSION         hFSession,
                                       PWQID             pWqID,
                                       PSZ               pszDescription,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafDeleteWorkQueue(
                                       HFSESSION         hFSession,
                                       PWQID             pWqID,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafFindWorkQueues(
                                       HFSESSION         hFSession,
                                       PRUNIT            pRoutingUnit,
                                       PRCODE            pRcode,
                                       PRCODE            pStartRcode,
                                       PRCODE            pEndRcode,
                                       PWQID             pNextWqID,
                                       USHORT            usToBeRet,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafFindWorkQueueSingle(
                                       HFSESSION         hFSession,
                                       PWQID             pWqID,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafRedefineWorkQueue(
                                       HFSESSION         hFSession,
                                       PWQID             pWqID,
                                       PTIMESTAMP        pTsTimeChgd,
                                       PSZ               pszDescription,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );

/*---------------------------------------------------------------------------*/
/*    IPFAF Workstation Client WorkFlow Management WorkQueue Assignment APIs */
/*---------------------------------------------------------------------------*/
APIEXPORT ULONG  FAFENTRY  FafDefineWqAsgn(
                                       HFSESSION         hFSession,
                                       PWQID             pWqID,
                                       PSZ               pszUserid,
                                       USHORT            usQueuePrty,
                                       BOOL              fAsgnStatus,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafDeleteWqAsgn(
                                       HFSESSION         hFSession,
                                       STATSRCH          AsgnStatus,
                                       PSZ               pszUserid,
                                       PRUNIT            pRoutingUnit,
                                       PRCODE            pRcode,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafFindWqAsgnsByUnit(
                                       HFSESSION         hFSession,
                                       PRUNIT            pRoutingUnit,
                                       PRCODE            pRcode,
                                       STATSRCH          AsgnStatus,
                                       PWORKASGNCURSOR   pWrkAsgnCrsr,
                                       USHORT            usToBeRet,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafFindWqAsgnsByUser(
                                       HFSESSION         hFSession,
                                       PSZ               pszUserid,
                                       PRUNIT            pRoutingUnit,
                                       STATSRCH          AsgnStatus,
                                       PWORKASGNCURSOR   pWrkAsgnCrsr,
                                       USHORT            usToBeRet,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafFindWqAsgnSingle(
                                       HFSESSION         hFSession,
                                       PSZ               pszUserid,
                                       PRUNIT            pRoutingUnit,
                                       PRCODE            pRcode,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafRedefineWqAsgn(
                                       HFSESSION         hFSession,
                                       PSZ               pszUserid,
                                       PRUNIT            pRoutingUnit,
                                       PRCODE            pRcode,
                                       USHORT            usQueuePrty,
                                       BOOL              fAsgnStatus,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );

/*---------------------------------------------------------------------------*/
/*    IPFAF Workstation Client WorkFlow Management WorkItem APIs             */
/*---------------------------------------------------------------------------*/
APIEXPORT ULONG  FAFENTRY  FafAddWorkItem(
                                       HFSESSION         hFSession,
                                       PDOCIDSTRUCT      pDocID,
                                       PFAFDATE          pDsRecvDate,
                                       PWQID             pWqID,
                                       PWORKROUTING      pRouting,
                                       PWORKITEMPRIORITY pWiPriority,
                                       PWORKITEMINIT     pWitemInit,
                                       PDOCEVENT         pEvent,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafCheckOutWorkItem(
                                       HFSESSION         hFSession,
                                       PDOCIDSTRUCT      pDocID,
                                       PTIMESTAMP        pTsTimeChgd,
                                       PDOCEVENT         pEvent,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafCheckWorkByAsgnEmpl(
                                       HFSESSION         hFSession,
                                       PSZ               pszUserid,
                                       ASGNACT           AsgnActv,
                                       HOLDACT           HoldActv,
                                       PWIPRIORITY       pStartPrty,
                                       PWIPRIORITY       pEndPrty,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafCheckWorkByProcEmpl(
                                       HFSESSION         hFSession,
                                       PSZ               pszUserid,
                                       PROCACT           ProcessActv,
                                       PWIPRIORITY       pStartPrty,
                                       PWIPRIORITY       pEndPrty,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafCheckWqByAsgnEmpl(
                                       HFSESSION         hFSession,
                                       PWQID             pWqID,
                                       PSZ               pszUserid,
                                       HOLDACT           HoldActv,
                                       PWIPRIORITY       pStartPrty,
                                       PWIPRIORITY       pEndPrty,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafCheckWqByProcEmpl(
                                       HFSESSION         hFSession,
                                       PWQID             pWqID,
                                       PSZ               pszUserid,
                                       PWIPRIORITY       pStartPrty,
                                       PWIPRIORITY       pEndPrty,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafCountWorkByFolder(
                                       HFSESSION         hFSession,
                                       PFOLDERIDSTRUCT   pFolder,
                                       HOLDACT           HoldActv,
                                       PWIPRIORITY       pStartPrty,
                                       PWIPRIORITY       pEndPrty,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafCountWorkByWq(
                                       HFSESSION         hFSession,
                                       PWQID             pWqID,
                                       HOLDACT           HoldActv,
                                       PWIPRIORITY       pStartPrty,
                                       PWIPRIORITY       pEndPrty,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafDropWorkItem(
                                       HFSESSION         hFSession,
                                       PDOCIDSTRUCT      pDocID,
                                       PFAFDATE          pDsRecvDate,
                                       DLTEACT           DeleteAction,
                                       PFAFDATE          pDsFileDate,
                                       DROPACT           DropAction,
                                       PSZ               pszMgmtClass,
                                       PSZ               pszStgClass,
                                       PRETPERIOD        pRetPer,
                                       PDOCEVENT         pEvent,
                                       PODMCOMPLETE      pBadODMResp,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafFindWorkByAsgnEmpl(
                                       HFSESSION         hFSession,
                                       PSZ               pszUserid,
                                       HOLDACT           HoldActv,
                                       PWORKCURSOR       pFindWorkCrsr,
                                       USHORT            usToBeRet,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafFindWorkByDocument(
                                       HFSESSION         hFSession,
                                       PDOCIDSTRUCT      pDocID,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafFindWorkByFolder(
                                       HFSESSION         hFSession,
                                       PFOLDERIDSTRUCT   pFolder,
                                       ASGNACT           AsgnActv,
                                       HOLDACT           HoldActv,
                                       PROCACT           ProcessActv,
                                       PWORKCURSOR       pFindWorkCrsr,
                                       USHORT            usToBeRet,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafFindWorkByProcEmpl(
                                       HFSESSION         hFSession,
                                       PSZ               pszUserid,
                                       HOLDACT           HoldActv,
                                       PWORKCURSOR       pFindWorkCrsr,
                                       USHORT            usToBeRet,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafFindWorkByUnit(
                                       HFSESSION         hFSession,
                                       PRUNIT            pRoutingUnit,
                                       HOLDACT           HoldActv,
                                       PROCACT           ProcessActv,
                                       PRCODE            pStartRcode,
                                       PRCODE            pEndRcode,
                                       PFAFDATE          pDsStartDate,
                                       PFAFDATE          pDsEndDate,
                                       PWIPRIORITY       pStartPrty,
                                       PWIPRIORITY       pEndPrty,
                                       PWORKCURSOR       pFindWorkCrsr,
                                       USHORT            usToBeRet,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafGetRoutingInfo(
                                       HFSESSION         hFSession,
                                       PRLOB             pRlob,
                                       PSZ               pszTranType,
                                       PSZ               pszUserPrm1,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafGetRoutingUnit(
                                       HFSESSION         hFSession,
                                       PSZ               pszWorkCategory,
                                       PSZ               pszUserPrm1,
                                       ULONG             ulUserPrm2,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafGetWorkItems(
                                       HFSESSION         hFSession,
                                       PSZ               pszUserid,
                                       BOOL              fAsgnActv,
                                       BOOL              fProcActv,
                                       PGETWORKCURSOR    pGetWorkCrsr,
                                       USHORT            usToBeRet,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );
APIEXPORT ULONG  FAFENTRY  FafRedefineWorkItem(
                                       HFSESSION         hFSession,
                                       PDOCIDSTRUCT      pDocID,
                                       PTIMESTAMP        pTsTimeChgd,
                                       USHORT            usNumAttrs,
                                       PRDEFWORKATTRS    pAttrStruct,
                                       PDOCEVENT         pEvent,
                                       PFCALLBACK        pFCallBack,
                                       PFAFRESULT        pFR );

/*---------------------------------------------------------------------------*/
/*                 Function  Prototypes  (Utility processes)                 */
/*---------------------------------------------------------------------------*/
ULONG   OpenLog( VOID );
ULONG   CloseLog( VOID );
APIEXPORT ULONG FAFENTRY StoreLog(
               ULONG            FR,            /* I Return code              */
               PSZ              pszProc,       /* I Calling procedure name   */
               PSZ              pszParams );   /* I Api parameters or descrip*/
APIEXPORT ULONG FAFENTRY WriteLog(
               PFAFRESULT       pFR,           /* I Return structure         */
               PSZ              pszProc,       /* I Calling procedure name   */
               PSZ              pszParams );   /* I Api parameters or descrip*/
ULONG   ReadINI( VOID );
ULONG   SearchINI(
               PSZ              pszSearchItem, /* I Name of cnfg variable    */
               PSZ              *ppszValue );  /* O Addr of pntr to INI info */

VOID    ProcessWait( VOID );
VOID    ProcessRelease( VOID );

/*---------------------------------------------------------------------------*/
/*    End the support for C++ compilers                                      */
/*---------------------------------------------------------------------------*/
#ifdef __cplusplus
   }
#endif

#endif

