
#ifndef WPSchemePalette_Source
#define WPSchemePalette_Source

#include <wppalet.hh>
#pragma off(dts_class);
#pragma on(somobject_assignment_operators);
#pragma on(somobject_constructors);
#pragma on(somobject_destructor);
#pragma off(case_insensitive_class_names);

#pragma on(som_bindings);
class WPSchemePalette : public WPPalette {

     #pragma SOMMap (WPSchemePalette, "WPSchemePalette", "M_WPSchemePalette")

     #pragma SOMClassVersion (WPSchemePalette, 1, 2)

     #pragma SOMCallstyle (WPSchemePalette, oidl)

     #pragma off(som_bindings);
     #pragma pop(som_bindings);
  public :

#pragma off(use_override_signature)
     virtual void wpPaintCell(PCELL pCell, HPS hps, PRECTL prcl,
                              BOOL fHilite);
     virtual BOOL wpEditCell(PCELL pCell, HWND hwndPal);
     virtual BOOL wpSetupCell(PVOID pCellData, ULONG cb, ULONG x,
                              ULONG y);
     virtual BOOL wpDragCell(PCELL pCell, HWND hwndPal, PPOINTL ptlDrag);
     virtual ULONG wpQueryPaletteHelp();
     virtual BOOL wpSetup(PSZ pszSetupString);
     virtual BOOL wpMenuItemHelpSelected(ULONG MenuId);
#pragma pop(use_override_signature)

     #pragma SOMReleaseOrder ()

};

#pragma pop(som_bindings);

#pragma pop(dts_class);
#pragma pop(somobject_assignment_operators);
#pragma pop(somobject_constructors);
#pragma pop(somobject_destructor);
#pragma pop(case_insensitive_class_names);
#endif /* WPSchemePalette_Source */

#pragma off(som_bindings);
   /*
    * Scheme palette entry
    */

   #define CCHSCHEMENAME 30
   #define CCHFONTNAME   60

   typedef struct _SCHEME
   {
      CELL  cell;           /* Size of the data that follows */
      ULONG RGBSysColor[SYSCLR_CSYSCOLORS];
      ULONG cxBorder;
      ULONG cyBorder;
      CHAR  szName[CCHSCHEMENAME+1];  /* Name of this scheme */
      CHAR  szWindowFont[CCHFONTNAME+1];    /* System font */
      CHAR  szTitleFont[CCHFONTNAME+1];     /* System font */
      CHAR  szMenuFont[CCHFONTNAME+1];      /* System font */
      CHAR  szIconFont[CCHFONTNAME+1];      /* System font */
   } SCHEME;
   typedef SCHEME *PSCHEME;

   /*
    *  Macros to extract RGB colors from a given scheme
    */

   #define SYSCLR_TO_INDEX(s) (s - SYSCLR_HELPHILITE + SYSCLR_CSYSCOLORS - 1)

   #define INDEX_TO_SYSCLR(s) (s + SYSCLR_HELPHILITE - SYSCLR_CSYSCOLORS + 1)

   #define RGB_FROM_SYSCLR(psch,sysclr)                       \
             ( psch ? ( psch->RGBSysColor[ SYSCLR_TO_INDEX(sysclr) ] ) \
                    : WinQuerySysColor( HWND_DESKTOP, sysclr, 0 ) )
#pragma pop(som_bindings);


#ifndef M_WPSchemePalette_Source
#define M_WPSchemePalette_Source

#include <wppalet.hh>
#include <somcls.hh>
#pragma off(dts_class);
#pragma on(somobject_assignment_operators);
#pragma on(somobject_constructors);
#pragma on(somobject_destructor);
#pragma off(case_insensitive_class_names);

#pragma on(som_bindings);
class M_WPSchemePalette : public M_WPPalette {

     #pragma SOMClassVersion (M_WPSchemePalette, 1, 2)

     #pragma SOMCallstyle (M_WPSchemePalette, oidl)

     #pragma off(som_bindings);
     #pragma pop(som_bindings);
  public :

#pragma off(use_override_signature)
     virtual PSZ wpclsQueryEditString();
     virtual PSZ wpclsQueryTitle();
     virtual ULONG wpclsQueryStyle();
     virtual BOOL wpclsQueryDefaultHelp(PULONG pHelpPanelId,
                                        PSZ pszHelpLibrary);
     virtual ULONG wpclsQueryIconData(PICONINFO pIconInfo);
#pragma pop(use_override_signature)

     #pragma SOMReleaseOrder ()

};
#pragma pop(som_bindings);

#pragma pop(dts_class);
#pragma pop(somobject_assignment_operators);
#pragma pop(somobject_constructors);
#pragma pop(somobject_destructor);
#pragma pop(case_insensitive_class_names);
#endif /* M_WPSchemePalette_Source */

