
/*
 *@@sourcefile launcher.cpp:
 *      This is the source file for the program that extracts
 *      the included packages and launches WarpIN with the
 *      first of them.
 *
 *      It does this by scanning its own resources, i.e. the
 *      resources contained in the executable. Those resources
 *      will be created by the WPI2EXE program, see wpi2exe.cpp
 *      for a description of the expected resources.
 *
 *      <B>Note:</B>This program is not for stand-alone usage,
 *      but will be included in WPI2EXE's resources. WPI2EXE will then
 *      use it as the startup block for the created executable.
 *      As a result, it is not distributed with the WarpIN package
 *      separately, but only "hidden" in WPI2EXE's resources.
 *
 *      Changes by Ulrich Mller: Optimized the thing for size.
 *      With VAC, I managed to squeeze LAUNCHER.EXE from about 64K
 *      to 29K now by throwing out many C runtime functions, playing
 *      with compiler options and using the VAC subsystem libraries.
 */

/*
 *      Copyright (C) 2000 Christoph Schulte Mnting.
 *      Copyright (C) 2000 Ulrich Mller.
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation, in version 2 as it comes in the COPYING
 *      file of this distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *      GNU General Public License for more details.
 */

// OS2 includes
#define OS2EMX_PLAIN_CHAR
#define INCL_DOSERRORS
#define INCL_DOSSESMGR
#define INCL_DOSFILEMGR
#define INCL_DOSMISC
#define INCL_WINSHELLDATA
#include <os2.h>

// standard C library includes
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "setup.h"

// helpers includes
#include "helpers\dosh.h"
#include "helpers\prfh.h"
#include "helpers\resh.h"

// own includes
#include "rc_types.h"

#pragma hdrstop

const char *G_pcszTempPath = NULL;
CHAR    G_szTemp[CCHMAXPATH];

HAB     G_hab;

CHAR    G_szWarpInPath[CCHMAXPATH];
CHAR    G_szArchiveToLaunch[CCHMAXPATH];

/*
 *@@ checkForWarpIn:
 *      Checks if WarpIN exists by calling prfhQueryProfileData() to look
 *      for the value of "HINI_USER\WarpIN\Path".
 *      If WarpIN is not installed, this function will print a help message
 *      to the screen, including a reference where to find WarpIN.
 *
 *@@added V0.9.4 [csm]
 */

BOOL checkForWarpIn()
{
    ULONG cb = sizeof(G_szWarpInPath);

    if (PrfQueryProfileData(HINI_USER, "WarpIN", "Path", G_szWarpInPath, &cb)
            == FALSE)
    {
        printf("To install this archive, you will need the WarpIN installer, which is a Netlabs\n"
               "project. For more information and download, please visit"
               "\n\n    http://warpin.netlabs.org/"
               "\n\nInstall WarpIN first and then run this executable again, which will run WarpIN\n"
               "in turn.\n");
        return (FALSE);
    }

    return (TRUE);
}

/*
 *@@ extractFiles:
 *      Extracts the files stored in the resources to disk. The filenames
 *      will be read from the STRINGTABLE.
 *
 *@@added V0.9.4 [csm]
 */

BOOL extractFiles()
{
    BOOL brc = FALSE;
    // Write all archives to files
    CHAR  szArchiveName[CCHMAXPATH],
          szOutputFile[CCHMAXPATH];
    ULONG ulArchiveNumber = 1;
    ULONG ulTotalArchives = 0;

    APIRET  arc = NO_ERROR;
    while (WinLoadString(G_hab,
                         (HMODULE)0,
                         ulArchiveNumber,
                         sizeof(szArchiveName),
                         szArchiveName))
    {
        strcpy(szOutputFile, G_szTemp);
        strcat(szOutputFile, szArchiveName);

        printf("Extracting '%s'... ", szOutputFile);
        arc =  reshWriteResourceToFile(NULLHANDLE,  // hmod
                                       RT_WPIARCHIVE,
                                       ulArchiveNumber,
                                       szOutputFile,  // in: output filename
                                       NULL);       // out: no. of bytes written
        if (arc == NO_ERROR)
        {
            printf("OK\n");
            if (ulArchiveNumber == 1)
            {
                // first archive: copy to default archive name
                // which is launched later
                strcpy(G_szArchiveToLaunch, szArchiveName);
                brc = TRUE;
            }
        }
        else
        {
            printf("Error %d occured loading/writing resource.\n", arc);
            break;
        }

        ulArchiveNumber++;
        ulTotalArchives++;
    }

    return (brc);
}

/*
 *@@ deleteFiles:
 *      Deletes all the previously extracted files from disk. The filenames
 *      will be read from the STRINGTABLE.
 *
 *@@added V0.9.4 [csm]
 */

VOID deleteFiles()
{
    CHAR  szArchiveName[CCHMAXPATH];
    ULONG ulArchiveNumber = 1;

    while (WinLoadString(G_hab, (HMODULE)0,
                         ulArchiveNumber,
                         sizeof(szArchiveName),
                         szArchiveName))
    {
        CHAR    szOutputFile[CCHMAXPATH];
        strcpy(szOutputFile, G_szTemp);
        strcat(szOutputFile, szArchiveName);

        printf("Deleting %s ...", szOutputFile);

        if (DosDelete(szOutputFile) == NO_ERROR)
            printf("done\n");
        else
            printf("ERROR: could not delete %s\n", szOutputFile);

        ulArchiveNumber++;
    }
}

/*
 *@@ launchWarpIn:
 *      Launches WarpIN with the indicated wpi archive. This is
 *      done by calling doshQuickStartSession().
 *
 *@@added V0.9.4 [csm]
 */

VOID launchWarpIn()  // in: archive to launch WarpIN with
{
    // Allocate enough space

    CHAR szProgram[2*CCHMAXPATH];
    strcpy(szProgram, G_szWarpInPath);
    strcat(szProgram, "\\WARPIN.EXE");

    // Launch WarpIn

    printf("Launching '%s %s'... ",
           szProgram, G_szArchiveToLaunch);

    ULONG ulSessionID;
    PID   pidProcessID;

    ULONG ulRC = doshQuickStartSession(szProgram,                   // program
                                       G_szArchiveToLaunch,         // params
                                       FALSE,                       // foreground
                                       SSF_CONTROL_VISIBLE,         // PgmControl
                                       TRUE,                        // wait
                                       &ulSessionID,
                                       &pidProcessID,
                                       NULL);
    if (ulRC != NO_ERROR)
        printf("DosStartSession returned %d.\n", ulRC);
    else
        printf("OK\n");
}

/*
 *@@ main:
 *      Program entry point.
 *      The following steps are taken:
 *
 *      --  Check if WarpIN is installed. Fail with a help message if
 *          it cannot be found, else continue.
 *
 *      --  Extract the included files to disk.
 *
 *      --  If there has been no error while extracting, launch
 *          WarpIN with the first archive. The program will wait
 *          until WarpIN has ended.
 *
 *      --  Clean up (delete the extracted files).
 *
 *@@added V0.9.4 [csm]
 */

int main()
{
    G_szTemp[0] = 0;
    if (DosScanEnv("TEMP", &G_pcszTempPath)
             != NO_ERROR)
        printf("Warning: TEMP environment variable not set.\nExtracting to current directory.\n");
    else
        sprintf(G_szTemp, "%s\\", G_pcszTempPath);

    if (checkForWarpIn())
    {
        G_hab = WinInitialize(0);

        if (extractFiles())
        {
            launchWarpIn();

            deleteFiles();
        }
        else
            printf("There have been no archives to extract!\n");

        WinTerminate(G_hab);
    }

    return 0;
}


