/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end; else do
        call VROptions 'ImplicitNames'
        call VROptions 'NoEchoQuit'
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary:
    __vrlsWait = abbrev( 'WAIT', translate(arg(2)), 1 )
    if __vrlsWait then do
        call VRFlush
    end
    __vrlsHWnd = VRLoad( VRWindow(), VRWindowPath(), arg(1) )
    if __vrlsHWnd = '' then signal __vrlsDone
    if __vrlsWait \= 1 then signal __vrlsDone
    call VRSet __vrlsHWnd, 'WindowMode', 'Modal' 
    __vrlsTmp = __vrlsWindows.0
    if( DataType(__vrlsTmp) \= 'NUM' ) then do
        __vrlsTmp = 1
    end
    else do
        __vrlsTmp = __vrlsTmp + 1
    end
    __vrlsWindows.__vrlsTmp = VRWindow( __vrlsHWnd )
    __vrlsWindows.0 = __vrlsTmp
    do while( VRIsValidObject( VRWindow() ) = 1 )
        __vrlsEvent = VREvent()
        interpret __vrlsEvent
    end
    __vrlsTmp = __vrlsWindows.0
    __vrlsWindows.0 = __vrlsTmp - 1
    call VRWindow __vrlsWindows.__vrlsTmp 
    __vrlsHWnd = ''
__vrlsDone:
return __vrlsHWnd

/*:VRX         Fini
*/
Fini:
    window = VRWindow()
    call VRSet window, "Visible", 0
    drop window
return 0

/*:VRX         GoButton_Click
*/
GoButton_Click: 
    /* Wizilla, by Kevin McCoy, IDK, Inc.  Released as open source.  Use at your own risk! */
    /* 5-21-2000 */
    /* Questions or comments to kgmccoy@idk-inc.com */

    /* create path strings to Netscape program directory INI files */
    NSCIniPath =  VRParseFilePath( VRGet("NSCPath", "Value"), "DP" ) || "\NETSCAPE.INI"
    /* get ready to make a backup */
    NSCBackup = VRParseFilePath( VRGet("NSCPath", "Value"), "DP" ) || "\NETSCAPE.INO"

    /* check for ini file in Netscape program directory */
    if VRFileExists( NSCINIPATH ) <> 1 THEN DO
        Buttons.1 = "Ok"
        Buttons.0 = 1
        id = VRMessage( VRWindow(), "Invalid path to NETSCAPE.EXE", "Warning!", "Warning", "Buttons.", 1, 1 )
        return
    END

    /* check for warpin executable */
    if VRFileExists(VRGet("WIPath", "Value")) <> 1 THEN DO
        Buttons.1 = "Ok"
        Buttons.0 = 1
        id = VRMessage( VRWindow(), "Invalid path to WARPIN.EXE", "Warning!", "Warning", "Buttons.", 1, 1 )
        return
    END

    /* double check that it is actually warpin.exe and not some other program */
    IF TRANSLATE(VRParseFilePath( VRGet("WIPATH", "Value"), "NE" )) <> "WARPIN.EXE" THEN DO
        Buttons.1 = "Ok"
        Buttons.0 = 1
        id = VRMessage( VRWindow(), "Invalid path to WARPIN.EXE", "Warning!", "Warning", "Buttons.", 1, 1 )
        return
    END

    /* is another NETSCAPE.INI backup file floating around (NETSCAPE.INO) ? */
    /* ask the user what to do with the backup */
    if VRFileExists( NSCBackup) = 1 then do
        Buttons.1 = "Overwrite"
        Buttons.2 = "Skip"
        Buttons.3 = "Quit"
        Buttons.0 = 3
        id = VRMessage( VRWindow(), "NETSCAPE.INI backup file exists.  Overwrite the backup?", "Warning!", "Warning", "Buttons.", 1, 3 )
        select
            when id = 1 then do
                ok = VRCopyFile( NSCIniPath, NSCBackup ) /* overwrite it */
            end
            when id = 2 then do
            end
            when id = 3 then do
                call quit
            end
            otherwise do
            end
         end
    end
    else do
        ok = VRCopyFile( NSCIniPath, NSCBackup ) /* no backup found so create one */
    end
    
    /* insert/update some new INI entries */
    Ok = VRSetIni( "Suffixes", "application/warpin", "*.WPI", NSCIniPath)
    Ok = VRSetIni( "Viewers", "application/warpin", VRGet("WIPath", Value),  NSCIniPath )

    /* this is a bit iffy.  I am not sure if this is actually used by Netscape (its a really dumb thing) */
    /* I have only seen TYPE0...TYPE7 in the ini file, and I am not sure of its exact purpose. */
    /* The types are frequently incorrect for existing helpers, so we will just jam ours in, in the first */
    /* available slot */
    DO I = 0 to 7 
        Value = VRGetIni("Viewers", "TYPE" || I, NSCIniPath)
        if Value = "" then do
            Ok = VRSetIni("Viewers", "TYPE" || I, "application/warpin", NSCIniPath)
            LEAVE
        end
    END
    
    /* create a path to the "registry" INI file in the OS/2 directory */
    NSCPPath = OS2Dir || "NSCP.INI"
    NSCPBackup = OS2Dir || "NSCP.INO"

    /* ask the user what to do with existing NSCP.INO file (if any) */
    if VRFileExists( NSCPBackup) = 1 then do
        Buttons.1 = "Overwrite"
        Buttons.2 = "Skip"
        Buttons.3 = "Quit"
        Buttons.0 = 3
        id = VRMessage( VRWindow(), "NSCP.INI backup file exists.  Overwrite the backup?", "Warning!", "Warning", "Buttons.", 1, 3 )
        select
            when id = 1 then do
                ok = VRCopyFile( NSCPPath, NSCPBackup )
            end
            when id = 2 then do
            end
            when id = 3 then do
                call quit
            end
            otherwise do
            end
         end
    end
    else do
        ok = VRCopyFile( NSCPPath, NSCPBackup )
    end

    /* create the "registry" entries in NSCP.INI */
    WI = VRGet("WIPath", "Value")
    
    Ok = VRSetIni( "Registry", "\HKEY_CLASSES_ROOT\.wpi", "WPIFile", NSCPPath)
    Ok = VRSetIni( "Registry", "\HKEY_CLASSES_ROOT\wpifile", "WarpIN", NSCPPath)
    Ok = VRSetIni( "Registry", "\HKEY_CLASSES_ROOT\wpifile\shell", d2c(0,1), NSCPPath)
    Ok = VRSetIni( "Registry", "\HKEY_CLASSES_ROOT\wpifile\shell\open", "WarpIN", NSCPPath)
    Ok = VRSetIni( "Registry", "\HKEY_CLASSES_ROOT\wpifile\shell\open\command", WI, NSCPPath);
    
    Lines.1 = "All Done!"
    Lines.2 = ""
    Lines.3 = "Now go run Netscape and download a WPI file."
    Lines.4 = "WarpIN should launch automatically."
    Lines.0 = 4
    Buttons.1 = "Ok"
    Buttons.0 = 1
    id = VRMessageStem( VRWindow(), "Lines.", "Note", "Information", "Buttons.", 1, 1 )
    
    call Quit
return

/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         HelpButton_Click
*/
HelpButton_Click: 
    Lines.1 = "Wizilla v1.1"
    Lines.2 = "Freeware by Kevin McCoy, IDK, Inc."
    Lines.3 = ""
    Lines.4 = "Wizilla configures Netscape 4.6x to automatically launch WarpIN when"
    Lines.5 = "you download a WPI file. This utility updates your NETSCAPE.INI and"
    Lines.6 = "NSCP.INI files."
    Lines.7 = ""
    Lines.8 = "This utility backs up your NETSCAPE.INI->NETSCAPE.INO; It also backs"
    Lines.9 = "up your NSCP.INI->NSCP.INO.  Restore the backup to remove Wizilla's"
    Lines.10 = "changes."

    Lines.0 = 10
    Buttons.1 = "Ok"
    Buttons.0 = 1
    id = VRMessageStem( VRWindow(), "Lines.", "Help", "Information", "Buttons.", 1, 1 )
return


/*:VRX         Init
*/
Init:
    window = VRWindow()
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
    drop window

    call RxFuncAdd "SysSearchPath", "Rexxutil", "SysSearchPath"

    os2bootPath = SysSearchPath('PATH', 'os2boot')
    if os2bootpath \= '' then do
        bootDrive = filespec('drive', os2bootPath)
    end
    else do
        Buttons.1 = "Ok"
        Buttons.0 = 1
        BootDrive = VRPrompt( VRWindow(), "Please enter the OS/2 boot drive letter", "BootDrive", "OS/2 Boot Drive", "Buttons.", ,  ) || ":"
    end
    Os2Dir = bootDrive || '\os2\'
    Buttons.1 = "Ok"
    Buttons.0 = 1
    id = VRMessage( VRWindow(), "Shut Netscape 4.6x down before running this utility.", "Note", "Information", "Buttons.", 1, 1 )
    
return

/*:VRX         NSCBrowseButton_Click
*/
NSCBrowseButton_Click: 
    Ok = VRSet("NSCPath", "Value", VRFileDialog( VRWindow(), "Enter the path to NETSCAPE.EXE", "Open", "NETSCAPE.EXE", , ,  ))
return

/*:VRX         Quit
*/
Quit:
    window = VRWindow()
    call VRSet window, "Shutdown", 1
    drop window
return

/*:VRX         QuitButton_Click
*/
QuitButton_Click: 
    call quit
return

/*:VRX         WIBrowseButton_Click
*/
WIBrowseButton_Click: 
    Ok = VRSet("WIPath", "Value", VRFileDialog( VRWindow(), "Enter Path to WarpIN.EXE", "Open", "WARPIN.EXE", , ,  ))
return

/*:VRX         WizillaWin_Close
*/
WizillaWin_Close:
    call Quit
return

