#define INCL_DOSPROCESS
#define INCL_DOSQUEUES
#define INCL_DOSERRORS
#define INCL_DOSSEMAPHORES
#define INCL_DOSNMPIPES

#include <os2.h>
#include "setup.h"
#include <deque>
#include <vector>
#include <map>
#include <string.h>

#include <io.h>
#include <limits.h>
#include <time.h>               // needed for WIFileHeader

#include "libbz2\bzlib.h"

#include "base\bs_base.h"
#include "base\bs_list.h"

#include "wiarchive\wiarchive.h"

#include "helpers\stringh.h"
#include "helpers\xstring.h"
#include "base\bs_string.h"

#include "helpers\eah.h"

#include "wipengine\wipebase.h"
#include "wipengine\fdu.h"
#include "wipengine\threadbase.h"
#include "wipengine\mlu.h"
#include "wipengine\arcsubsys.h"
#include "wipengine\arcunit.h"


void main (void) {

    FileClass fc;
    MsgLoggingUnit log;
    MsgClass msg, msg2, msg3, msg4, *pmsg;
    USHORT us;
    MsgClass *testi;
    int i;
    MsgInfo *pMsgInfo = NULL;
    FileVector *filvec = NULL;

    //log.SetCallBackData(callback, NULL);
    printf("Start the execution of the thread.\n");
    fflush(stdout);
    log.Start();
    printf("Message queue handler: %i\n", log._hQReceiver);
    printf("Do some tests.\n\n");
    fflush(stdout);


    ArcSubSystem asubsys(log._hQReceiver,NULL,NULL);
    asubsys.Start();

    /* WIArchive tests starts */
    HEV _hevTestArcOpen;
    DosCreateEventSem(NULL, &_hevTestArcOpen, 0L, FALSE);
    BSString ArcFilename = "test\\koe.wpi";
    asubsys.OpenArchiveFile(ArcFilename, _hevTestArcOpen);
    DosWaitEventSem(_hevTestArcOpen, SEM_INDEFINITE_WAIT);



    asubsys.AddPackage(1,NULLHANDLE, NULL);

    HEV _hevTestArcQuery;

    /* WIArcvive tests ends */

    FileVector *fv = new FileVector;
    fc._bssFileName = "wpi_prog.inf";
    fc._bssFilePath.erase();
    fc._bssInstallPath.erase();
    fc._sPackage = 1;
    fv->push_back(fc);
    fc._bssFileName = "wicpm.exe";
    fc._bssFilePath.erase();
    fc._bssInstallPath.erase();
    fc._sPackage = 1;
    fv->push_back(fc);
    fc._bssFileName = "cleanup.cmd";
    fc._bssFilePath.erase();
    fc._bssInstallPath.erase();
    fc._sPackage = 1;
    fv->push_back(fc);
    fc._bssFileName = "envwic.cmd";
    fc._bssFilePath.erase();
    fc._bssInstallPath.erase();
    fc._sPackage = 1;
    fv->push_back(fc);

    asubsys.InsertFiles(fv, NULLHANDLE);

    HEV _hevTest2;
    DosCreateEventSem(NULL, &_hevTest2, 0L, FALSE);
    filvec = new FileVector;
    FileVector *deletedFiles = new FileVector;
    asubsys.QueryFiles(filvec, _hevTest2);
    FileVector *fv2 = NULL;
    DosWaitEventSem(_hevTest2, SEM_INDEFINITE_WAIT);
    if (filvec) {
        for (i=0;i<filvec->size();i++) {
            printf("Filename 1st test: %s  Path: %s  Archived: %i\n",
                (*filvec)[i]._bssFileName.c_str(),
                (*filvec)[i]._bssFilePath.c_str(),
                (*filvec)[i]._bArchived);
            fflush(stdout);
            if ((*filvec)[i]._bArchived == TRUE)
                deletedFiles->push_back((*filvec)[i]);
            }
        }
    HEV _hevTest4;
    DosCreateEventSem(NULL, &_hevTest4, 0L, FALSE);
    asubsys.DeleteFiles(deletedFiles, _hevTest4);
    DosWaitEventSem(_hevTest4, SEM_INDEFINITE_WAIT);

    HEV _hevTest5;
    DosCreateEventSem(NULL, &_hevTest5, 0L, FALSE);
    filvec = new FileVector;
    asubsys.QueryFiles(filvec, _hevTest5);
    DosWaitEventSem(_hevTest5, SEM_INDEFINITE_WAIT);
    if (filvec) {
        for (i=0;i<filvec->size();i++) {
            printf("Filename 2nd test: %s  Path: %s  Archived: %i\n",
                (*filvec)[i]._bssFileName.c_str(),
                (*filvec)[i]._bssFilePath.c_str(),
                (*filvec)[i]._bArchived);
            fflush(stdout);
            }
        }


    HEV _hevTest;
    DosCreateEventSem(NULL, &_hevTest, 0L, FALSE);
    MessageVector *pv = new MessageVector;
    /*MsgLoggingUnit::FindMessage(NULLHANDLE,
                                pv,
                                log._hQReceiver,
                                _hevTest);



    printf("\nWait a while.\n");
    fflush(stdout);

    DosWaitEventSem(_hevTest, SEM_INDEFINITE_WAIT);
    //DosSleep(1000);
    MessageVector *tv;

    //log.FindMessages(&tv, 300);

    printf("\nPrint messages NOW!\n");
    fflush(stdout);

    if (pv) {
        for (i=0;i<pv->size();i++) {
            printf("Message type: %i  sender: %i  detail: %i  text: %s\n", (*pv)[i]._usMessageType, (*pv)[i]._aidSender, (*pv)[i]._lDetailInfo,(*pv)[i]._bssMessage.c_str());
            fflush(stdout);
            }
        }*/



    printf("\n The End.\n");

    asubsys.CloseArchive(_hevTest,NULL);

    DosWaitEventSem(_hevTest, SEM_INDEFINITE_WAIT);

    //#endif
    }
