/*
 *@@sourcefile fdu.cpp:
 *  The file database unit or MLU for the WicPM back-end engine. This unit is
 *  responsible to keep a file database in each Archive Subsystem.
 *  <B>Note:</B> This is not thread safe code so you should use mutex semaphores
 *  or related to prevent several threads trying to use FileClass object or
 *  FileDatabaseUnit object.
 *
 *  <B>Using:</B>
 *
 *  Insert file:
 *      FileClass file;
 *      FileDatabaseUnit database;
 *      file._bssFileName = "filename.txt";
 *      file._bssFilePath = "c:\filepath\";
 *      file._bssInstallPath = "\installpath\"
 *      database.InsertFile(file);
 *
 *
 */
/*      This file Copyright (C) 2000-2001 Teemu Ahola.
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation, in version 2 as it comes in the COPYING
 *      file of this distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

#define INCL_DOSQUEUES
#include <os2.h>
#include "setup.h"
#include <deque>
#include <vector>

#include "helpers\stringh.h"
#include "helpers\xstring.h"
#include "base\bs_base.h"
#include "base\bs_string.h"

#include "wipengine\wipebase.h"
#include "wipengine\fdu.h"


/*
 *@@compare:
 *  returns 0 if the two FileClasses are the same,
 *  -1 if "this" is smaller, 1 if "p_file" is smaller.
 */
int FileClass::compare(const FileClass &p_file // Reference to a MsgClass object
                                              // to be compared with.
                     ) const {
    if (_bssFileName == p_file._bssFileName)
        if (_bssFilePath == p_file._bssFilePath)
            if (_bssInstallPath == p_file._bssInstallPath)
                return 0;
            else if (_bssFilePath < p_file._bssFilePath)
                return -1;
            else
                return 1;
        else if (_bssInstallPath < p_file._bssInstallPath)
            return -1;
        else
            return 1;
    else if (_bssFileName < p_file._bssFileName)
        return -1;
    else
        return 1;
    }



/*
 *@@InsertFile:
 *  inserts FileClass object to the _Files list.
 */
USHORT FileDatabaseUnit::InsertFile(
                            const FileClass &p_fileClass // A reference to a FileClass.
                                   ) {
    _Files.push_back(p_fileClass);
    return RET_OK;
    }


/*
 *@@DeleteFile:
 *  deletes FileClass object from _Files list.
 */
USHORT FileDatabaseUnit::DeleteFile(
                            const FileClass &p_fileClass // A refence to a FileClass.
                                    ) {
    // Get iterator to the first element of the _Files deque.
    FileDeque::iterator i = _Files.begin();

    // Loop until the iterator specifies the end of the queue or
    // the iterator or the iterator points to a FileClass object
    // which 'looks like' it.
    while (i != _Files.end()) {
        if (*i == p_fileClass)
            break;
        i++;
        }
    // If a FileClass element was found, remove it.
    if (i != _Files.end())
        _Files.erase(i);
    else
        return RET_ERR_NOT_FOUND;

    return RET_OK;
    }


/*
 *@@DeleteFile:
 *  deletes specified FileClass element from _Files list.
 */
USHORT FileDatabaseUnit::DeleteFile(ULONG p_ulElementIndex) {
    ULONG ulIndex = 0;
    FileDeque::iterator itFiles = _Files.begin(),
                        itEnd = _Files.end();

    // Get an iterator to a p_ulElementIndex element.
    while ((itFiles < itEnd) && (ulIndex < p_ulElementIndex)) {
        ulIndex++;
        itFiles++;
        }

    if (p_ulElementIndex == ulIndex) {
        _Files.erase(itFiles);
        return RET_OK;
        }

    return RET_ERR_NOT_FOUND;
    }


/*
 *@@ReplaceFile:
 *  replaces a file element with a specified one.
 */
USHORT FileDatabaseUnit::ReplaceFile(const FileClass &p_fileDest,
                                     const FileClass &p_fileSource
                                    ) {
    FileDeque::iterator i = _Files.begin();


    // Loop until the iterator specifies the end of the queue or
    // the iterator or the iterator points to a FileClass object
    // which 'looks like' it.
    while (i != _Files.end()) {
        if (*i == p_fileDest)
            break;
        i ++;
        }

    // Replace the destination FileClass object with the source
    // object.
    if (i != _Files.end()) {
        *i = p_fileSource;
        return RET_OK;
        }

    return RET_ERR_NOT_FOUND;
    }


/*
 *@@ReplaceFile:
 *  replaces specified FileClass element in _Files list.
 */
USHORT FileDatabaseUnit::ReplaceFile(ULONG p_ulElementIndex,
                                     const FileClass &p_fileSource
                                     ) {
    ULONG ulIndex = 0;
    FileDeque::iterator itFiles = _Files.begin(),
                        itEnd = _Files.end();

    // Get an iterator to a p_ulElementIndex element.
    while ((itFiles < itEnd) && (ulIndex < p_ulElementIndex)) {
        ulIndex++;
        itFiles++;
        }

    // Replace the destination FileClass object with the source
    // object.
    if (p_ulElementIndex == ulIndex) {
        *itFiles = p_fileSource;
        return RET_OK;
        }

    return RET_ERR_NOT_FOUND;
    }



/*
 *@@QueryFiles:
 *  query all elements and returns a copies them if a FileVector.
 */
USHORT FileDatabaseUnit::QueryFiles(FileVector &p_fileVector) {
    FileDeque::iterator i;

    i = _Files.begin();

    // Copy all FileClasses to the vector.
    for (;i < _Files.end(); i++)
        p_fileVector.push_back((FileClass)*i);

    return RET_OK;

    }


/*
 *@@QueryFile:
 *  queries a element and returns a copy of it.
 */
USHORT FileDatabaseUnit::QueryFile(ULONG p_ulIndex, FileClass &p_ppClass) {
    ULONG ulIndex = 0;
    FileDeque::iterator itFiles, itEnd;

    itFiles = _Files.begin();
    itEnd = _Files.end();

    // Get an iterator to a p_ulElementIndex element.
    while ((itFiles < itEnd) && (ulIndex < p_ulIndex)) {
        ulIndex++;
        itFiles++;
        }

    // Replace the destination FileClass object with the source
    // object.
    if (p_ulIndex == ulIndex) {
        p_ppClass = (FileClass)*itFiles;
        return RET_OK;
        }

    return RET_OK;

    }


int operator<(const FileClass &s1, const FileClass &s2) {
    return (s1.compare(s2) < 0);
    }

int operator==(const FileClass &s1, const FileClass &s2) {
    return (s1.compare(s2) == 0);
    }

int operator<=(const FileClass &s1, const FileClass &s2) {
    return (s1.compare(s2) <= 0);
    }

int operator!=(const FileClass &s1, const FileClass &s2) {
    return (s1.compare(s2) != 0);
    }

int operator>(const FileClass &s1, const FileClass &s2) {
    return (s1.compare(s2) > 0);
    }

int operator>=(const FileClass &s1, const FileClass &s2) {
    return (s1.compare(s2) >= 0);
    }






