/*
 *@@sourcefile cxmlsubsidizer.cpp:
 *  The XML Subsidizer class.
 *
 *
 */

/*      Copyright (C) 2000-2001 Teemu Ahola.
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation, in version 2 as it comes in the COPYING
 *      file of this distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

#define ENABLE_ERROR_PRINTING_CXMLSUBSIDIZER

#include "wipengine\cxmlsubsidizer.h"



CXmlSubsidizer::CXmlSubsidizer() {

#ifdef ENABLE_ERROR_PRINTING_CXMLSUBSIDIZER
    printf("CXmlSubsidizer::CXmlSubsidizer()\n");
    fflush(stdout);
#endif

    _pDom = new CDomSubsidizer();

#ifdef ENABLE_ERROR_PRINTING_CXMLSUBSIDIZER
    printf(" _pDom = 0x%X\n\n", _pDom);
    fflush(stdout);
#endif


}


CXmlSubsidizer::~CXmlSubsidizer() {


}


USHORT CXmlSubsidizer::Parse(const BSString &p_bssDocument) {

    APIRET rc = NO_ERROR;

#ifdef ENABLE_ERROR_PRINTING_CXMLSUBSIDIZER
    printf("CXmlSubsidizer::Parse(const BSString &p_bssDocument)\n");
    fflush(stdout);
#endif

    rc = xmlParse(_pDom->_pDom->getXmlDom(), p_bssDocument.c_str(),
                  p_bssDocument.length(), TRUE);

#ifdef ENABLE_ERROR_PRINTING_CXMLSUBSIDIZER
    printf(" rc = %i\n\n", rc);
    fflush(stdout);
#endif


    return rc;
}




