/*
 *@@sourcefile arcunit.cpp:
 *  archive unit
 *
 *
 */

/*      Copyright (C) 2000-2001 Teemu Ahola.
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation, in version 2 as it comes in the COPYING
 *      file of this distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

#define INCL_DOSPROCESS
#define INCL_DOSERRORS
#define INCL_DOSQUEUES
#define INCL_DOSSEMAPHORES
#include <os2.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "setup.h"
#include <deque>
#include <vector>
#include <map>

#include <io.h>
#include <limits.h>
#include <time.h>               // needed for WIFileHeader

#include "libbz2\bzlib.h"

#include "base\bs_base.h"
#include "base\bs_list.h"

#include "helpers\stringh.h"
#include "helpers\xstring.h"
#include "base\bs_string.h"

#include "helpers\eah.h"

// Oh yes! The new WIArchive2 which I have wait for.
#include "wiarchive\wiarchive.h"

// Base include
#include "wipengine\wipebase.h"
// File database unit include
#include "wipengine\fdu.h"
// Thread base include
#include "wipengine\threadbase.h"
// Archive subsystem include
#include "wipengine\arcsubsys.h"
// Message log unit include.
#include "wipengine\mlu.h"

#include "wipengine\arcunit.h"




LONG ArcSubSysCallBack(SHORT p_sType, // Call-back type
                       LONG p_lType, // Type-related information
                       PVOID p_pvData, // A pointer to a type-related data
                       PVOID p_pvUserData // A pointer to a user data
                       ) {


    switch (p_sType) {
        case CB_TYPE_FILE_ADDING_COMPLETED: {

            break;
            }
        case CB_TYPE_FILE_QUERYING_COMPLETED: {

            break;
            }
        case CB_TYPE_FILE_DELETING_COMPLETED: {

            break;
            }
        case CB_TYPE_ERR_INITIALIZATION: {
            // Note: User data in the user data map of the ArchiveUnit
            // is not valid during initialization phase, since
            // it has not yet been inserted to the user data map.
            ((ArchiveUnit *)p_pvUserData)->_ulArcSubSysRc = p_lType;
            break;
            }
        }
    return 0;
    }



ArchiveUnit::ArchiveUnit(HQUEUE p_hQMsgLogger,
                         PFNWIPECALLBACK p_pfnArcUnitCB,
                         PVOID p_pvUserData
                         ) :
                         _hQMessageLogger(p_hQMsgLogger),
                         _pfnWipeCallBack(p_pfnArcUnitCB),
                         _pvUserData(p_pvUserData) {

    BSString bssMessage;

    _ulArcSubSysRc = 0;

    // We need the handler of MLU's message queue and if
    // a user does not provide it, the initialization will
    // fail. Also if the handler is missing there must
    // something weird going on.
    if (p_hQMsgLogger == NULLHANDLE) {
        p_pvUserData = NULL;
        p_pfnArcUnitCB = NULL;
        return;
        }

    // Send message to the Message Logger Unit.
    MsgLoggingUnit::LogMessage(NULLHANDLE,
                               bssMessage,
                               TYPE_MSG_INFORMATIVE,
                               DETAIL_MSG_ARCUNIT_INITIALIZED,
                               p_hQMsgLogger);
    }



AID ArchiveUnit::CreateArchive(BSString p_bssFullFileName,
                               PVOID p_pUserData
                               ) {
    BSString bssMessage;
    CHAR temp[10];
    // Chech that this ArchiveUnit instance has been properly
    // initialized.
    if (_hQMessageLogger == NULLHANDLE)
        return NULLHANDLE;

    // Create a new instance of ArcSubSystem.
    ArcSubSystem* pASS = new ArcSubSystem(_hQMessageLogger, ArcSubSysCallBack,
                                          this);

    // Start it.
    if (pASS->Start() != RET_OK) {
        // OOps! Houston! We have a problem.
        // Depending in which point the error occurred there
        // may be an error information in the MLU. _aidSender
        // is NULLHANDLE. Error code is returned by the call-back function and
        // can be found from _ulArcSubSysRc.
        delete pASS;
        pASS = NULL;
        bssMessage = STATUS_MSG_FAIL;
        bssMessage += " in ";
        bssMessage += __FILE__;
        bssMessage += "\nCaused by a creation of an Archive Subsystem.";
        bssMessage += "\nNumber of Archive Subsystems: ";
        sprintf(temp, "%i", _assPtrMap.size());
        bssMessage += temp;
        bssMessage += "\nError code returned by the call-back: ";
        sprintf(temp, "%i", _ulArcSubSysRc);
        bssMessage += temp;
        // Log the error to MLU. Sender in NULLHANDLE and type is critical.
        MsgLoggingUnit::LogMessage(NULLHANDLE, bssMessage, TYPE_MSG_CRITICAL,
                                   RET_ERR_INITIALIZATION_FAILED, _hQMessageLogger);

        return RET_ERR_ASS_START_FAILED;
        }

    // It is certain that a message queue was created by the start
    // method so we can use a message queue handler in the instance.
    // So add the pointer of the instance to the map.
    _assPtrMap.insert(pair<const AID, ArcSubSystem*>(pASS->_hQReceiver, pASS));

    // Add user data to the user data map.
    _userDataPtrMap.insert(pair<const AID, PVOID>(pASS->_hQReceiver, p_pUserData));

    // Compose a message.
    bssMessage = STATUS_MSG_SUCCESSFULL;
    bssMessage += " in ";
    bssMessage += __FILE__;
    bssMessage += "\nCaused by a creation of an Archive Subsystem.";
    bssMessage += "\nNumber of Archive Subsystems: ";
    sprintf(temp, "%i", _assPtrMap.size());
    bssMessage += temp;
    // Log the error to MLU. Sender in NULLHANDLE and type is critical.
    MsgLoggingUnit::LogMessage(NULLHANDLE, bssMessage, TYPE_MSG_INFORMATIVE,
                               RET_OK, _hQMessageLogger);


    return pASS->_hQReceiver;
    }

USHORT ArchiveUnit::DeleteArchive(AID p_aidASS) {

    ArcSubSystemPtrMap::iterator itrASSP;
    UserDataPtrMap::iterator itrUserDataPtr;

    // Check that the specified archive exists.
    itrASSP = _assPtrMap.find(p_aidASS);

    // If so, delete it and remove the pointer to it from
    // the map.
    if (itrASSP != _assPtrMap.end()) {
        delete (ArcSubSystem*)((*itrASSP).second);
        _assPtrMap.erase(itrASSP);
        }

    // Check that the specified archive exists.
    itrASSP = _assPtrMap.find(p_aidASS);

    // If so, delete it and remove the pointer to it from
    // the map.
    if (itrASSP != _assPtrMap.end()) {
        delete (ArcSubSystem*)((*itrASSP).second);
        _assPtrMap.erase(itrASSP);
        }
    return RET_OK;
    }



/*
 * Helper methods:
 */

/*
 *@@AddFiles:
 */
USHORT ArchiveUnit::AddFiles(AID p_aidASS,
                             FileVector *p_pFileVector,
                             HEV p_hevSem
                             ) {
    ArcSubSystemPtrMap::iterator itrASSP;

    if (!p_pFileVector)
        return RET_ERR_PARAMETER_ERROR;

    // Check that the specified archive exists.
    itrASSP = _assPtrMap.find(p_aidASS);

    // If so, do the deed.
    if (itrASSP != _assPtrMap.end())
        (ArcSubSystem*)((*itrASSP).second)->InsertFiles(p_pFileVector,
                                                        p_hevSem);
    else
        return RET_ERR_ASS_NOT_FOUND;

    return RET_OK;
    }


/*
 *@@DeleteFiles:
 */
USHORT ArchiveUnit::DeleteFiles(AID p_aidASS,
                                FileVector *p_pFileVector,
                                HEV p_hevSem
                                ) {
    ArcSubSystemPtrMap::iterator itrASSP;

    if (!p_pFileVector)
        return RET_ERR_PARAMETER_ERROR;

    // Check that the specified archive exists.
    itrASSP = _assPtrMap.find(p_aidASS);

    // If so, do the deed.
    if (itrASSP != _assPtrMap.end())
        ((ArcSubSystem*)((*itrASSP).second))->DeleteFiles(p_pFileVector,
                                                          p_hevSem);
    else
        return RET_ERR_ASS_NOT_FOUND;
    return RET_OK;
    }

USHORT ArchiveUnit::QueryFiles(AID p_aidASS,
                               FileVector *p_pFileVector,
                               HEV p_hevSem
                               ) {
    ArcSubSystemPtrMap::iterator itrASSP;

    if (!p_pFileVector)
        return RET_ERR_PARAMETER_ERROR;

    // Check that the specified archive exists.
    itrASSP = _assPtrMap.find(p_aidASS);

    // If so, do the deed.
    if (itrASSP != _assPtrMap.end())
        ((ArcSubSystem*)((*itrASSP).second))->QueryFiles(p_pFileVector,
                                                         p_hevSem);
    else
        return RET_ERR_ASS_NOT_FOUND;

    return RET_OK;
    }

ArchiveUnit::~ArchiveUnit() {
    }





