#define INCL_WINLISTBOXES
#define INCL_WINWINDOWMGR
#define INCL_WINMESSAGEMGR
#define INCL_DOSSEMAPHORES
#define INCL_WINSTDCNR
#define INCL_WINSYS
#define INCL_WINSTDFILE
#define INCL_WINDIALOGS
#define INCL_WINENTRYFIELDS
#define INCL_WINMLE             // Needed in gui_helpers.h.
#define INCL_DOSEXCEPTIONS      // Needed for execpt.h.
#define INCL_DOSPROCESS         // Needed for execpt.h.
#include <os2.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <limits.h>
#include <time.h>               // needed for WIFileHeader

#include <setjmp.h>                 // needed for except.h.
#include <assert.h>                 // needed for except.h.

#include "setup.h"

#include "helpers\comctl.h"
#include "helpers\cnrh.h"
#include "helpers\linklist.h"
#include "helpers\dosh.h"
#include "helpers\stringh.h"
// #include <list>                  // V0.9.14 (2001-07-07) [umoeller]
#include "helpers\stringh.h"
#include "helpers\xstring.h"

#include "base\bs_base.h"           // V0.9.14 (2001-07-07) [umoeller]
#include "base\bs_string.h"
#include "base\bs_list.h"       // V0.9.14 (2001-07-07) [umoeller]

#include "wicpm\wicpm.h"

#include "wicpm\script.hpp"

#include "wiarchive\wiarchive.h"    // WIArchive created by Jens Bckman.

#include "wicpm\gui_trad_cntr.h"
#include "wicpm\gui_objwnd.h"
#include "wicpm\gui_wicpm.h"
#include "wicpm\gui_helpers.h"
#include "wicpm\wicpmres.h"

#include "helpers\except.h"


MRESULT EXPENTRY fnObjectWndProc (HWND, ULONG, MPARAM, MPARAM);
MRESULT EXPENTRY fnConfirmPathDlgProc (HWND, ULONG, MPARAM, MPARAM);


VOID _Optlink thObjectWndThread (PVOID pThreadArg)
    {
    ULONG rc = 0;
    QMSG qmsg;
    HWND hwndObject;
    CHAR szObjectClass[] = "ObjClass";
    POBJWNDTHREADINFO pThreadInfo = (POBJWNDTHREADINFO)pThreadArg;

    //TRY_LOUD(exept2, NULL)
    //{

    pThreadInfo->bThreadBusy = TRUE;
    pThreadInfo->bThreadInitialized = FALSE;
    pThreadInfo->bThreadKilled = FALSE;
    pThreadInfo->usThreadError = 0;

    pThreadInfo->habThread = WinInitialize(0);

    // Create message queue.
    pThreadInfo->hmqThread = WinCreateMsgQueue (pThreadInfo->habThread, 0);

    WinRegisterClass (pThreadInfo->habThread, szObjectClass, fnObjectWndProc,
        CS_SIZEREDRAW, sizeof(POBJWNDTHREADINFO));

    // Create the "famous" object window.
    pThreadInfo->hwndObjectWnd = WinCreateWindow (HWND_OBJECT, szObjectClass,
        NULL, 0, 0, 0, 0, 0, NULL, HWND_BOTTOM, IDD_OBJECTWND, NULL, NULL);

    WinSetWindowPtr (pThreadInfo->hwndObjectWnd, 0, pThreadInfo);

    // Wait here until main thread is finished initialization otherwice
    // USER_THREADINITIALIZED message may be sended too early and main
    // window is not yet ready. You see OS/2 is multithreaded so we can not
    // be sure which thread initializes itself first. There is another way
    // to bypass this problem but I use this method now so no critisism
    // is allowed.
    rc = DosWaitEventSem (pThreadInfo->hevEventMainInitialized, SEM_INDEFINITE_WAIT);

    pThreadInfo->bThreadInitialized = TRUE;
    WinPostMsg (pThreadInfo->hwndMainWndClient, USER_THREADINITIALIZED,
        MPFROMLONG(pThreadInfo->hwndObjectWnd), 0);

    // Because the message queue should not receive any WM_QUIT messages
    // sended by the system WinCancelSuthdown is required. Otherwice this
    // thread could be killed before main thread kills it and this could
    // cause problems.
    WinCancelShutdown (pThreadInfo->hmqThread, TRUE);

    pThreadInfo->bThreadBusy = FALSE;

    while (WinGetMsg (pThreadInfo->habThread, &qmsg, NULLHANDLE, 0, 0))
        WinDispatchMsg (pThreadInfo->habThread, &qmsg);

    //}
    //CATCH(exept2)
    //    {
    //    } END_CATCH();
    // Main thread has sent WM_QUIT message so destroy this thread.
    WinDestroyWindow (pThreadInfo->hwndObjectWnd);
    WinDestroyMsgQueue (pThreadInfo->hmqThread);
    WinTerminate (pThreadInfo->habThread);
    pThreadInfo->bThreadKilled = TRUE;
    pThreadInfo->bThreadBusy = FALSE;
    _endthread();
    }



MRESULT EXPENTRY fnObjectWndProc (HWND hwndWnd, ULONG msg, MPARAM mp1, MPARAM mp2)
    {
    USHORT usRet;
    MRESULT mrc = 0;
    POBJWNDTHREADINFO pThreadInfo = (POBJWNDTHREADINFO)WinQueryWindowPtr (hwndWnd, 0);

    switch (msg)
        {
        case USER_INITMAINCNTRS:
            {
            pThreadInfo->bThreadBusy = TRUE;
            CHAR szFontNameSize[8] = "10.Helv";
            PCONTAINERINFO pContInfo = NULL;

            // Set presentation parameters for the containers.
            pContInfo = (PCONTAINERINFO)mp1;
            WinSetPresParam(pContInfo->hwndContainer, PP_FONTNAMESIZE,
                            (ULONG)sizeof(szFontNameSize), (PVOID)szFontNameSize);
            pContInfo = (PCONTAINERINFO)mp2;
            WinSetPresParam(pContInfo->hwndContainer, PP_FONTNAMESIZE,
                            (ULONG)sizeof(szFontNameSize), (PVOID)szFontNameSize);

            // Initialize containers.
            pContInfo = (PCONTAINERINFO)mp1;
            usRet = guiInitializePckContainer(pContInfo, NULL);
            pContInfo = (PCONTAINERINFO)mp2;
            usRet = guiInitializeFileContainer(pContInfo, NULL);

            // Tell the main thread that initialization is ready.
            WinPostMsg(pThreadInfo->hwndMainWndClient, USER_MAINCNTRSINITIALIZED,
                       0, 0);
            pThreadInfo->bThreadBusy = FALSE;
            break;
            }
        case USER_ADDFILES:
            {
            pThreadInfo->bThreadBusy = TRUE;
            /*PFILEDATA pFirstFileData;
            PFILENAMETABLE pFilename = (PFILENAMETABLE)PVOIDFROMMP(mp1);
            AddFiles ((PPCKDATA)PVOIDFROMMP(mp2), pFilename->papszFQFileName,
                     pFilename->ulFQFCount, &pFirstFileData, pThreadInfo->hwndMainWndClient);
            WinFreeFileDlgList(pFilename->papszFQFileName); // Free file list memory allocated by
                                                            // the file dialog
            WinPostMsg (pThreadInfo->hwndMainWnd, USER_CM_ADDFILERECORD,
                        MPFROMP(pFirstFileData),
                        MPFROMSHORT(pFilename->ulFQFCount));
            free (pFilename);*/
            pThreadInfo->bThreadBusy = FALSE;
            break;
            }
        case USER_INIT_OBJECT_LISTBOX:
            {
            pThreadInfo->bThreadBusy = TRUE;
            PMSGDATA pMsgData = (PMSGDATA)PVOIDFROMMP(mp1);
            ScriptPackage *pPackage = (ScriptPackage*)pMsgData->pData;
            HWND hwndListBox = pMsgData->hwndObject;
            ScriptCreateObject *pObject = NULL;
            USHORT usIndex = 0;
            PSZ pszScript = NULL;
            // Go throug all crate object objects and make script text from every one of
            // them and put the text to the list box.
            for (usIndex = 1; usIndex <= pPackage->ReturnCreateObjectObjectCount();
                usIndex ++)
                {
                pObject = pPackage->ReturnCreateObjectObject(usIndex);
                if (pObject)
                    {
                    pszScript = pObject->MakeScriptText(FALSE);
                    WinInsertLboxItem (hwndListBox, pObject->ReturnIndex() - 1,
                        pszScript);
                    delete [] pszScript;
                    }
                }
            // Post the initialized message to the sender dialog.
            WinPostMsg(pMsgData->hwndSender, USER_OBJECT_LISTBOX_INITIALIZED,
                MPFROMSHORT(pPackage->ReturnCreateObjectObjectCount()), 0);
            delete pMsgData;
            pThreadInfo->bThreadBusy = FALSE;
            break;
            }
        case USER_INIT_REGCLASS_LISTBOX:
            {
            pThreadInfo->bThreadBusy = TRUE;
            PMSGDATA pMsgData = (PMSGDATA)PVOIDFROMMP(mp1);
            ScriptPackage *pPackage = (ScriptPackage*)pMsgData->pData;
            HWND hwndListBox = pMsgData->hwndObject;
            ScriptRegisterClass *pClass = NULL;
            USHORT usIndex = 0;
            PSZ pszScript = NULL;
            // Go throug all register class objects and make script text from every one of
            // them and put the text to the list box.
            for (usIndex = 1; usIndex <= pPackage->ReturnRegisterClassObjectCount();
                usIndex ++)
                {
                pClass = pPackage->ReturnRegisterClassObject(usIndex);
                if (pClass)
                    {
                    pszScript = pClass->MakeScriptText(FALSE);
                    WinInsertLboxItem (hwndListBox, pClass->ReturnIndex() - 1,
                        pszScript);
                    delete [] pszScript;
                    }
                }
            // Post the initialized message to the sender dialog.
            WinPostMsg(pMsgData->hwndSender, USER_REGCLASS_LISTBOX_INITIALIZED,
                MPFROMSHORT(pPackage->ReturnRegisterClassObjectCount()), 0);
            delete pMsgData;
            pThreadInfo->bThreadBusy = FALSE;
            break;
            }
        case USER_INIT_REPCLASS_LISTBOX:
            {
            pThreadInfo->bThreadBusy = TRUE;
            PMSGDATA pMsgData = (PMSGDATA)PVOIDFROMMP(mp1);
            ScriptPackage *pPackage = (ScriptPackage*)pMsgData->pData;
            HWND hwndListBox = pMsgData->hwndObject;
            ScriptReplaceClass *pClass = NULL;
            USHORT usIndex = 0;
            PSZ pszScript = NULL;
            // Go throug all replace class objects and make script text from every one of
            // them and put the text to the list box.
            for (usIndex = 1; usIndex <= pPackage->ReturnReplaceClassObjectCount();
                usIndex ++)
                {
                pClass = pPackage->ReturnReplaceClassObject(usIndex);
                if (pClass)
                    {
                    pszScript = pClass->MakeScriptText(FALSE);
                    WinInsertLboxItem (hwndListBox, pClass->ReturnIndex() - 1,
                        pszScript);
                    delete [] pszScript;
                    }
                }
            // Post the initialized message to the sender dialog.
            WinPostMsg(pMsgData->hwndSender, USER_REPCLASS_LISTBOX_INITIALIZED,
                MPFROMSHORT(pPackage->ReturnReplaceClassObjectCount()), 0);
            delete pMsgData;
            pThreadInfo->bThreadBusy = FALSE;
            break;
            }
        case USER_INIT_REQUIRES_LISTBOX:
            {
            pThreadInfo->bThreadBusy = TRUE;
            PMSGDATA pMsgData = (PMSGDATA)PVOIDFROMMP(mp1);
            ScriptPackage *pPackage = (ScriptPackage*)pMsgData->pData;
            HWND hwndListBox = pMsgData->hwndObject;
            ScriptRequires *pReq = NULL;
            USHORT usIndex = 0;
            PSZ pszScript = NULL;
            // Go throug all requires objects and make script text from every one of
            // them and put the text to the list box.
            for (usIndex = 1; usIndex <= pPackage->ReturnRequiresObjectCount();
                usIndex ++)
                {
                pReq = pPackage->ReturnRequiresObject(usIndex);
                if (pReq)
                    {
                    pszScript = pReq->MakeScriptText(FALSE);
                    WinInsertLboxItem (hwndListBox, pReq->ReturnIndex() - 1,
                        pszScript);
                    delete [] pszScript;
                    }
                }
            // Post the initialized message to the sender dialog with count of
            // added items.
            WinPostMsg(pMsgData->hwndSender, USER_REQUIRES_LISTBOX_INITIALIZED,
                MPFROMSHORT(pPackage->ReturnRequiresObjectCount()), 0);
            delete pMsgData;
            pThreadInfo->bThreadBusy = FALSE;
            break;
            }
        case USER_INIT_EXECUTE_LISTBOX:
            {
            pThreadInfo->bThreadBusy = TRUE;
            PMSGDATA pMsgData = (PMSGDATA)PVOIDFROMMP(mp1);
            ScriptPackage *pPackage = (ScriptPackage*)pMsgData->pData;
            HWND hwndListBox = pMsgData->hwndObject;
            ScriptExecute *pExec = NULL;
            USHORT usIndex = 0;
            PSZ pszScript = NULL;
            // Go throug all requires objects and make script text from every one of
            // them and put the text to the list box.
            for (usIndex = 1; usIndex <= pPackage->ReturnExecuteObjectCount();
                usIndex ++)
                {
                pExec = pPackage->ReturnExecuteObject(usIndex);
                if (pExec)
                    {
                    pszScript = pExec->MakeScriptText(FALSE);
                    WinInsertLboxItem (hwndListBox, pExec->ReturnIndex() - 1,
                        pszScript);
                    delete [] pszScript;
                    }
                }
            // Post the initialized message to the sender dialog with count of
            // added items.
            WinPostMsg(pMsgData->hwndSender, USER_EXECUTE_LISTBOX_INITIALIZED,
                MPFROMSHORT(pPackage->ReturnExecuteObjectCount()), 0);
            delete pMsgData;
            pThreadInfo->bThreadBusy = FALSE;
            break;
            }
        case USER_INIT_CLEARPROFILE_LISTBOX:
            {
            pThreadInfo->bThreadBusy = TRUE;
            PMSGDATA pMsgData = (PMSGDATA)PVOIDFROMMP(mp1);
            ScriptPackage *pPackage = (ScriptPackage*)pMsgData->pData;
            HWND hwndListBox = pMsgData->hwndObject;
            ScriptClearProfile *pClear = NULL;
            USHORT usIndex = 0;
            PSZ pszScript = NULL;
            // Go throug all requires objects and make script text from every one of
            // them and put the text to the list box.
            for (usIndex = 1; usIndex <= pPackage->ReturnClearProfileObjectCount();
                usIndex ++)
                {
                pClear = pPackage->ReturnClearProfileObject(usIndex);
                if (pClear)
                    {
                    pszScript = pClear->MakeScriptText(FALSE);
                    WinInsertLboxItem (hwndListBox, pClear->ReturnIndex() - 1,
                        pszScript);
                    delete [] pszScript;
                    }
                }
            // Post the initialized message to the sender dialog with count of
            // added items.
            WinPostMsg(pMsgData->hwndSender, USER_CLEARPROFILE_LISTBOX_INITIALIZED,
                MPFROMSHORT(pPackage->ReturnClearProfileObjectCount()), 0);
            delete pMsgData;
            pThreadInfo->bThreadBusy = FALSE;
            break;
            }
        case USER_INIT_WRITEPROFILE_LISTBOX:
            {
            pThreadInfo->bThreadBusy = TRUE;
            PMSGDATA pMsgData = (PMSGDATA)PVOIDFROMMP(mp1);
            ScriptPackage *pPackage = (ScriptPackage*)pMsgData->pData;
            HWND hwndListBox = pMsgData->hwndObject;
            ScriptWriteProfile *pWrite = NULL;
            USHORT usIndex = 0;
            PSZ pszScript = NULL;
            // Go throug all requires objects and make script text from every one of
            // them and put the text to the list box.
            for (usIndex = 1; usIndex <= pPackage->ReturnWriteProfileObjectCount();
                usIndex ++)
                {
                pWrite = pPackage->ReturnWriteProfileObject(usIndex);
                if (pWrite)
                    {
                    pszScript = pWrite->MakeScriptText(FALSE);
                    WinInsertLboxItem (hwndListBox, pWrite->ReturnIndex() - 1,
                        pszScript);
                    delete [] pszScript;
                    }
                }
            // Post the initialized message to the sender dialog with count of
            // added items.
            WinPostMsg(pMsgData->hwndSender, USER_WRITEPROFILE_LISTBOX_INITIALIZED,
                MPFROMSHORT(pPackage->ReturnWriteProfileObjectCount()), 0);
            delete pMsgData;
            pThreadInfo->bThreadBusy = FALSE;
            break;
            }
        case USER_ADDRECORDS_PACKAGECNTR:
            {
            pThreadInfo->bThreadBusy = TRUE;
            PMSGDATA pMsgData = (PMSGDATA)PVOIDFROMMP(mp1);
            HWND hwndCntr = pMsgData->hwndObject;
            PLINKLIST plDBPck = (PLINKLIST)pMsgData->pData;
            guiSetPckContainerRecords(hwndCntr, plDBPck);

            // The list can be freed because fItemsFreeable == FALSE so list items
            // will not be freed.
            lstFree(&plDBPck);

            WinPostMsg(pMsgData->hwndSender, USER_PACKAGECNTR_RECORDSADDED, 0, 0);

            delete pMsgData;

            pThreadInfo->bThreadBusy = FALSE;
            break;
            }
        case USER_UPDATERECORD_PACKAGECNTR:
            {
            pThreadInfo->bThreadBusy = TRUE;
            PMSGDATA pMsgData = (PMSGDATA)PVOIDFROMMP(mp1);
            HWND hwndCntr = pMsgData->hwndObject;
            DBPackage *pDBPck = (DBPackage *)PVOIDFROMMP(pMsgData->mp1);
            PPCKRECORD pPckRec = (PPCKRECORD)PVOIDFROMMP(pMsgData->mp2);

            guiUpdatePckContRecord(hwndCntr, pPckRec, pDBPck, TRUE);

            WinPostMsg(pMsgData->hwndSender, USER_PACKAGECNTR_RECORDUPDATED, 0, 0);

            delete pMsgData;

            pThreadInfo->bThreadBusy = FALSE;
            break;
            }
        // Adds records builded from linked list of DBFile structures to file container.
        // If ulData in pMsgData is set to REMOVE_PREV_RECORDS, all previous records in
        // the container are removed first.
        case USER_ADDRECORDS_FILECNTR:
            {
            pThreadInfo->bThreadBusy = TRUE;
            PMSGDATA pMsgData = (PMSGDATA)PVOIDFROMMP(mp1);
            HWND hwndCntr = pMsgData->hwndObject;

            PLINKLIST plDBFile = (PLINKLIST)pMsgData->pData;

            if (pMsgData->ulData == REMOVE_PREV_RECORDS)
                guiRemoveContainerRecords(hwndCntr, NULL, NULL);

            if (lstCountItems(plDBFile) > 0)
                guiSetFileContainerRecords(hwndCntr, plDBFile);

            WinPostMsg(pMsgData->hwndSender, USER_FILECNTR_RECORDSADDED, 0, 0);

            delete pMsgData;

            pThreadInfo->bThreadBusy = FALSE;
            break;
            }
        // Adds files to database in DBPackage structure and adds files with
        // needed information to the file container.
        case USER_ADDFILES_DBRECCNTR:
            {
            pThreadInfo->bThreadBusy = TRUE;
            PMSGDATA pMsgData = (PMSGDATA)PVOIDFROMMP(mp1);
            HWND hwndFileCntr = pMsgData->hwndObject;
            HWND hwndPckCntr = pMsgData->hwndObject2;
            ULONG ulIndex = 0, ulResult = 0;
            DBFile *pDBFile = NULL;
            CHAR szDriver[_MAX_DRIVE], szDir[_MAX_DIR];
            CHAR szFName[_MAX_FNAME], szExt[_MAX_EXT];
            PSZ pszPath = NULL;
            PLINKLIST pTempList = lstCreate(FALSE);

            PAPSZ papszFQFileName = (PAPSZ)pMsgData->pData;
            ULONG ulFQFCount = pMsgData->ulData;
            DBPackage *pDBPck = (DBPackage *)PVOIDFROMMP(pMsgData->mp2);
            PPCKRECORD pPckRec = (PPCKRECORD)PVOIDFROMMP(pMsgData->mp1);

            // Get the directory of the first file and ask from user if the installation
            // path is correct. But remove leading backslash first.
            _splitpath((*papszFQFileName)[0], szDriver, szDir, szFName, szExt);
            ulIndex = 0;
            while(szDir[ulIndex] != '\0')
                {
                szDir[ulIndex] = szDir[ulIndex + 1];
                ulIndex++;
                }

            pszPath = szDir;

            // Query from user that the installation path is correct.
            ulResult = WinDlgBox(HWND_DESKTOP, pThreadInfo->hwndMainWndClient,
                fnConfirmPathDlgProc, NULLHANDLE, IDD_CONFIRMPATH_DIALOG, (PVOID)&pszPath);

            if (ulResult)
                {
                // Go through all files and split their paths. Also query file sizes.
                for (ulIndex = 0; ulIndex < ulFQFCount; ulIndex ++)
                    {
                    _splitpath((*papszFQFileName)[ulIndex], szDriver, szDir,
                        szFName, szExt);
                    pDBFile = new DBFile;
                    sprintf(pDBFile->szFileName, "%s%s", szFName, szExt);
                    sprintf(pDBFile->szFilePath, "%s%s", szDriver, szDir);
                    strcpy(pDBFile->szFileInstallPath, pszPath);
                    doshQueryPathSize((*papszFQFileName)[ulIndex],
                                      &pDBFile->ulFileSize);        // V0.9.16 (2001-10-25) [umoeller]
                    pDBPck->ulTotalSize += pDBFile->ulFileSize;
                    lstAppendItem(pDBPck->plFileList, pDBFile);
                    lstAppendItem(pTempList, pDBFile);
                    }

                pDBPck->ulFiles += ulFQFCount;

                 //pTempList is used because we don't want to set all records again
                 //to the container, only the new ones.
                guiSetFileContainerRecords(hwndFileCntr, pTempList);
                 //Update package container also.
                guiUpdatePckContRecord(hwndPckCntr, pPckRec, pDBPck, TRUE);
                }

            WinFreeFileDlgList(papszFQFileName);

            // List items are not freed because when creating the list, parameter was
            // FALSE.
            lstFree(&pTempList);

            WinPostMsg(pMsgData->hwndSender, USER_DBRECCNTR_FILESADDED,
                MPFROMLONG(ulResult), 0);
            delete pMsgData;
            pThreadInfo->bThreadBusy = FALSE;
            break;
            }
        case USER_REMOVEFILE_DBRECCNTR:
            {
            pThreadInfo->bThreadBusy = TRUE;
            PMSGDATA pMsgData = (PMSGDATA)PVOIDFROMMP(mp1);
            HWND hwndFileCntr = pMsgData->hwndObject;
            HWND hwndPckCntr = pMsgData->hwndObject2;
            PPCKRECORD pPckRecord = (PPCKRECORD)PVOIDFROMMP(pMsgData->mp2);
            PFILERECORD pFileRecord = (PFILERECORD)PVOIDFROMMP(pMsgData->mp1);
            PLINKLIST plDBPackage = (PLINKLIST)pMsgData->pData;
            DBFile *pDBFile = pFileRecord->pDBFile;
            DBPackage *pDBPck = NULL;

            pDBPck = FindDBPckItem(plDBPackage, pPckRecord->sPackage);

            pDBPck->ulTotalSize -= pDBFile->ulFileSize;
            pDBPck->ulFiles --;

            lstRemoveItem(plDBPackage, (PVOID)pDBFile);

            guiRemoveContainerRecords(hwndFileCntr, (PVOID)pFileRecord, 1);

            guiUpdatePckContRecord(hwndPckCntr, pPckRecord, pDBPck, TRUE);

            WinPostMsg(pMsgData->hwndSender, USER_DBRECCNTR_FILEREMOVED,
                0, 0);

            delete pMsgData;

            pThreadInfo->bThreadBusy = FALSE;
            break;
            }
        case USER_INIT_PAGE_CONTAINER:
            {
            pThreadInfo->bThreadBusy = TRUE;
            PMSGDATA pMsgData = (PMSGDATA)PVOIDFROMMP(mp1);
            ScriptBody *pBody = (ScriptBody*)pMsgData->pData;
            ScriptPage *pPage = NULL;
            HWND hwndCntr = pMsgData->hwndObject;
            USHORT usIndex = 1;
            list<ScriptPage*> listPageAddToCntr(SHADOW);

            // Put page objects to list. (pointers)
            pPage = pBody->ReturnPageObject(usIndex);
            while(pPage)
                {
                listPageAddToCntr.push_back(pPage);
                usIndex++;
                pPage = pBody->ReturnPageObject(usIndex);
                }

            guiSetPageContainerRecords(hwndCntr, &listPageAddToCntr, usIndex - 1);

            // Post the initialized message to the sender dialog.
            WinPostMsg(pMsgData->hwndSender, USER_PAGE_CONTAINER_INITIALIZED, 0, 0);
            delete pMsgData;
            pThreadInfo->bThreadBusy = FALSE;
            break;
            }
        default:
            {
            mrc = WinDefWindowProc (hwndWnd, msg, mp1, mp2);
            break;
            }
        }
    return mrc;
    }




MRESULT EXPENTRY fnConfirmPathDlgProc(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2)
    {
    MRESULT mrc = 0;

    switch (msg)
       {
        case WM_INITDLG:
            {
            PSZ *pszPath = (PSZ*)mp2;
            WinSetWindowPtr(hwndDlg, 0, (PVOID)pszPath);
            WinSendDlgItemMsg(hwndDlg, IDD_CONFIRMPATH_PATH, EM_SETTEXTLIMIT,
                                MPFROMSHORT(CCHMAXPATH), 0);
            WinSetDlgItemText(hwndDlg, IDD_CONFIRMPATH_PATH, *pszPath);
            WinSendDlgItemMsg(hwndDlg, IDD_CONFIRMPATH_PATH, EM_SETSEL, MPFROM2SHORT(0,
                             CCHMAXPATH), 0);
            break;
            }
        case WM_COMMAND:
            {
            switch (SHORT1FROMMP(mp1))
                {
                case DID_OK:
                    {
                    CHAR szPath[CCHMAXPATH];
                    CHAR szDriver[_MAX_DRIVE], szDir[_MAX_DIR], szFName[_MAX_FNAME];
                    CHAR szExt[_MAX_EXT];
                    PSZ *pszPath = (PSZ *)WinQueryWindowPtr(hwndDlg, 0);
                    WinQueryDlgItemText(hwndDlg, IDD_CONFIRMPATH_PATH, CCHMAXPATH, szPath);
                    _splitpath(szPath, szDriver, szDir, szFName, szExt);
                    if (szDriver[0] != 0)
                        {
                        WinSetFocus (HWND_DESKTOP, WinWindowFromID (hwndDlg, IDD_CONFIRMPATH_PATH));
                        WinSendDlgItemMsg (hwndDlg, IDD_CONFIRMPATH_PATH, EM_SETSEL,
                                         MPFROM2SHORT(0,CCHMAXPATH), 0);
                        guiShowMessageBox(hwndDlg, "Path name error.",
                                         "You cannot store absolute driver "
                                         "specifications in an archive because "
                                         "this would require the user to have "
                                         "the same driver letters.");
                        }
                    else
                        {
                        *pszPath = strhdup(szPath, NULL);
                        WinDismissDlg(hwndDlg, TRUE);
                        }
                    break;
                    }
                case DID_CANCEL:
                    {
                    WinDismissDlg(hwndDlg, FALSE);
                    break;
                    }
                }
            break;
            }
        default:
            {
            mrc = WinDefDlgProc (hwndDlg, msg, mp1, mp2);
            break;
            }
        }
    return mrc;
    }






