/*
 *              WicPM - WarpIN Archive Creator for PM
 *                  (c) Copyright Teemu Ahola 2000
 *
 * gui_notebook.cpp
 *  This file contains PM-specific stuff for notebook handling.
 */

#define INCL_PM
#define INCL_WIN
#include <os2.h>
#include <string.h>
#include <stdlib.h>
#include "setup.h"
#include "helpers\dosh.h"

#include "wicpm\gui_notebook.h"

#include "bl_wicpm.h"





BOOL SizeTabs(HWND hwndNb)
    {
    HPS hpsTemp;
    SIZEL szlMax;
    ULONG ulMajor;
    ULONG ulPage;
    CHAR achText[256];
    BOOKTEXT btText;
    POINTL aptlBox[TXTBOX_COUNT];
    ULONG ulStyle;

    hpsTemp = WinGetPS (hwndNb);

    szlMax.cx = 0;
    szlMax.cy = 0;

    ulMajor = LONGFROMMR (WinSendMsg(hwndNb,
                                  BKM_QUERYPAGEID,
                                  MPFROMLONG (0),
                                  MPFROM2SHORT (BKA_FIRST, BKA_MAJOR)));
    while (ulMajor != 0) {
       ulPage = ulMajor;

       while (ulPage != 0) {
          btText.pString = achText;
          btText.textLen = sizeof (achText);

          WinSendMsg (hwndNb,
                      BKM_QUERYTABTEXT,
                      MPFROMLONG (ulPage),
                      MPFROMP (&btText));

          GpiQueryTextBox (hpsTemp,
                           strlen (btText.pString),
                           btText.pString,
                           TXTBOX_COUNT,
                           aptlBox);

          aptlBox[TXTBOX_TOPRIGHT].x -= aptlBox[TXTBOX_BOTTOMLEFT].x;
          aptlBox[TXTBOX_TOPRIGHT].y -= aptlBox[TXTBOX_BOTTOMLEFT].y;

          szlMax.cx = max(szlMax.cx, aptlBox[TXTBOX_TOPRIGHT].x);
          szlMax.cy = max(szlMax.cy, aptlBox[TXTBOX_TOPRIGHT].y);


          ulPage = LONGFROMMR (WinSendMsg (hwndNb,
                                       BKM_QUERYPAGEID,
                                       MPFROMLONG (ulPage),
                                       MPFROM2SHORT (BKA_NEXT,0)));
          if (ulPage != 0) {
             ulStyle = LONGFROMMR (WinSendMsg (hwndNb,
                                           BKM_QUERYPAGESTYLE,
                                           MPFROMLONG (ulPage),
                                           0));
             if ((ulStyle & BKA_MAJOR)!=0) {
                ulPage=0;
             } /* endif */
          } /* endif */
       } /* endwhile */

       ulMajor = LONGFROMMR (WinSendMsg (hwndNb,
                                     BKM_QUERYPAGEID,
                                     MPFROMLONG (ulMajor),
                                     MPFROM2SHORT (BKA_NEXT, BKA_MAJOR)));
    } /* endwhile */

    WinReleasePS (hpsTemp);

    WinSendMsg (hwndNb,
                BKM_SETDIMENSIONS,
                MPFROM2SHORT (szlMax.cx, szlMax.cy*3/2),
                MPFROMSHORT (BKA_MAJORTAB));

    WinSendMsg (hwndNb,
                BKM_SETDIMENSIONS,
                MPFROM2SHORT (szlMax.cx, szlMax.cy*3/2),
                MPFROMSHORT (BKA_MINORTAB));


    return TRUE;
    }




/****************************************************************************
 *@@ InitializeNotebook
 *  This function initializes a notebook. Required informations of notebook's
 *  pages are in NOTEBOOKINFO structure.
 *      In:     PNOTEBOOKINFO pNBInfo
 *      return: RET_NB_OK                 no errors
 *              RET_NB_SLSETERROR         statusline text set error
 *              RET_NB_TABTEXTINSERTERROR tab text set error
 *              RET_NB_DIALOGLOADERROR    dialog loading error
 *              RET_NB_SETPAGEWINDOWERROR page window setting error
 *              RET_NB_TABSIZINGERROR     tab sizing error
 */
USHORT InitializeNotebook (PNOTEBOOKINFO pNbInfo)
    {
    ULONG ulPageID;
    HWND hwndPage;
    HWND hwndNotebook;
    ULONG ulNbPIndex;
    ULONG ulNBStyle;
    USHORT usNbStyle;
    PFNWP pNbPageDlgProc;

    if (!pNbInfo)
        return RET_NB_NULLPOINTERERROR;

    hwndNotebook = pNbInfo->hwndNotebook;

    for (ulNbPIndex = 0; ulNbPIndex < pNbInfo->usNbPageCount; ulNbPIndex ++)
        {
        if (pNbInfo->nbPage[ulNbPIndex].usNbPageStyle == NBP_STYLE_MAJOR)
            usNbStyle = BKA_STATUSTEXTON | BKA_AUTOPAGESIZE | BKA_MAJOR;
        else usNbStyle = BKA_STATUSTEXTON | BKA_AUTOPAGESIZE | BKA_MINOR;

        if (!(pNbPageDlgProc = pNbInfo->nbPage[ulNbPIndex].pNbPageDlgProc))
            pNbPageDlgProc = WinDefDlgProc;

        if (!(ulPageID = (ULONG)WinSendMsg (hwndNotebook, BKM_INSERTPAGE, NULL,
                                            MPFROM2SHORT((usNbStyle),
                                            BKA_LAST))))
            return RET_NB_PAGEINSERTERROR;
        pNbInfo->nbPage[ulNbPIndex].ulNBPageID = ulPageID;

        WinSendMsg (hwndNotebook, BKM_SETSTATUSLINETEXT, MPFROMLONG(ulPageID),
            MPFROMP(pNbInfo->nbPage[ulNbPIndex].pszStatusLine));

        WinSendMsg (hwndNotebook, BKM_SETTABTEXT, MPFROMLONG(ulPageID),
            MPFROMP(pNbInfo->nbPage[ulNbPIndex].pszTab));

        if (!(hwndPage = WinLoadDlg(hwndNotebook, hwndNotebook, pNbPageDlgProc, NULLHANDLE,
                                    pNbInfo->nbPage[ulNbPIndex].ulIDDialogPage,
                                    pNbInfo->nbPage[ulNbPIndex].pCreateParams)))
            return RET_NB_DIALOGLOADERROR;
        pNbInfo->nbPage[ulNbPIndex].hwndNbPage = hwndPage;

        if ((pNbInfo->nbPage[ulNbPIndex].pNbPageDlgProc) &&
            (pNbInfo->nbPage[ulNbPIndex].pWinPtrData))
            WinSetWindowPtr (hwndPage, 0, pNbInfo->nbPage[ulNbPIndex].pWinPtrData);

        if (!WinSendMsg(hwndNotebook, BKM_SETPAGEWINDOWHWND, MPFROMLONG(ulPageID),
                        MPFROMHWND(hwndPage)))
            return RET_NB_SETPAGEWINDOWERROR;
        }

    /*ulNBStyle = WinQueryWindowULong (hwndNotebook, QWL_STYLE);
    ulNBStyle &= 0xffff0000;

    if (doshIsWarp4())
        ulNBStyle |= 0x800 | BKS_BACKPAGESBR | BKS_TABTEXTCENTER | WS_GROUP;
    else
        ulNBStyle |= BKS_SOLIDBIND | BKS_BACKPAGESBR | BKS_MAJORTABTOP |
                     BKS_SQUARETABS | BKS_TABTEXTCENTER | BKS_STATUSTEXTLEFT |
                     WS_GROUP;

    WinSetWindowULong (hwndNotebook, QWL_STYLE, ulNBStyle);
    WinInvalidateRect (hwndNotebook, NULL, TRUE);*/

    if (!SizeTabs (hwndNotebook))
         return RET_NB_TABSIZINGERROR;

    return RET_NB_OK;
    }




