
/*
 *@@sourcefile wic_install.cpp:
 *
 */

/*
 *      This file Copyright (C) 1998-2001 Ulrich Mller.
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation, in version 2 as it comes in the COPYING
 *      file of this distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

#define OS2EMX_PLAIN_CHAR
    // this is needed for "os2emx.h"; if this is defined,
    // emx will define PSZ as _signed_ char, otherwise
    // as unsigned char

#define INCL_DOS
#define INCL_DOSERRORS
#define INCL_REXXSAA
#include <os2.h>
#ifdef __IBMCPP__
    #include <rexxsaa.h>    // EMX has this in os2.h already
#endif

#include <stdio.h>
#include <limits.h>
#include <stdarg.h>
#include <time.h>               // needed for WIFileHeader
#include <io.h>
#include <signal.h>             // added V0.9.12 (2001-06-11) [bird]

#ifdef __IBMCPP__
    #include <direct.h>
#endif

#include "setup.h"              // added V0.9.2 (2000-03-15) [umoeller]

#include "helpers\ansiscrn.h"
#include "helpers\configsys.h"
#include "helpers\dosh.h"
#include "helpers\linklist.h"
#include "helpers\nls.h"
#include "helpers\standards.h"
#include "helpers\stringh.h"
#include "helpers\xstring.h"

#include "base\bs_base.h"
#include "base\bs_list.h"
#include "base\bs_string.h"
#include "base\bs_errors.h"
#include "base\bs_logger.h"
#include "base\bs_config.h"
#include "base\bs_config_impl.h"

#include "bldlevel.h"

#include "wiarchive\wiarchive.h"

// front-end includes
#include "engine\fe_base.h"

#include "engine\fe_script.h"

#include "engine\fe_package.h"
#include "engine\fe_package_arc.h"
#include "engine\fe_package_db.h"
#include "engine\fe_archive.h"
#include "engine\fe_job.h"
#include "engine\fe_database.h"

#include "engine\fe_engine.h"
#include "engine\fe_cid.h"
#include "engine\fe_rexx.h"

#include "wic.h"

#pragma hdrstop

/* ******************************************************************
 *
 *  WICLocals
 *
 ********************************************************************/

/*
 *@@ WICLocals:
 *
 *@@added V0.9.18 (2002-03-03) [umoeller]
 */

class WICLocals : virtual public FELocals
{
    public:
        WICLocals(HAB habThread1,
                  CHAR cThousands)
            : FELocals(habThread1,
                       cThousands,
                       NULL,
                       0)
        {
        };

        virtual ULONG ShowMessage(const ustring &ustrTitle,
                                  const ustring &ustrMessage,
                                  ULONG fl)
        {
            printf("%s: %s",
                   ustrTitle.GetBuffer(),
                   ustrMessage.GetBuffer());

            throw WICExcpt(-1);
        }

        virtual BOOL ConfirmRexxAllowed(const ustring &ustrScript)
        {
            // fail if -R wasn't specified
            if (!G_fRexxAllowed)
            {
                Error(CID_INCORRECT_INVOCATION,
                      "This script contains active REXX code. For safety, wic will not install\n"
                      "such scripts unless you also specify the -R option in addition to -i to allow\n"
                      "REXX scripts to execute.\n"
                      );
                return FALSE;
            }

            return TRUE;
        }

        virtual VOID OnJobSelectionChanged(FEJobBase *pJob)
        {
        }

        virtual VOID Sleep(ULONG ul)
        {
            DosSleep(ul);
        }

        virtual APIRET Execute(BSExecute *pExec)
        {
            return 0;
        }

        virtual BSUniCodec& QueryGuiCodec()
        {
            return *_pCodecProcess;
        }
};

/*
 *@@ WICInstallEngine:
 *
 *@@added V0.9.20 (2002-07-03) [umoeller]
 */

class WICInstallEngine : public FEInstallEngine
{
    public:
        WICInstallEngine(FEDatabase &Database,
                         WICLocals &Locals)
            : FEInstallEngine(Database,
                              Locals)
        {
        }

        string      _strCurrentJobPath,
                    _strLastLockedFile;

        /*
         *@@ UpdateGlobalStatus:
         *
         *@@added V0.9.20 (2002-07-03) [umoeller]
         */

        virtual VOID UpdateGlobalStatus(BYTE bStatus)
        {
            PCSZ pcsz = NULL;

            switch (bStatus)
            {
                case GSTAT_LOADINGARCHIVE:
                    pcsz = "Loading archive...";
                break;

                case GSTAT_COLLECTING:
                    pcsz = "Retrieving information...";
                break;

                case GSTAT_REMOVING:
                    pcsz = "Deinstalling packages...";
                break;
                case GSTAT_UNPACKING:
                    pcsz = "Unpacking files...";
                break;

                case GSTAT_CONFIGSYS:
                    pcsz = "Updating CONFIG.SYS...";
                break;

                case GSTAT_WPSCLASSES:
                    pcsz = "Registering WPS classes...";
                break;

                case GSTAT_WPSOBJECTS:
                    pcsz = "Creating WPS objects...";
                break;

                case GSTAT_UPDATINGDATABASE:
                    pcsz = "Updating database...";
                break;

                case GSTAT_DONEWITHALL:
                    pcsz = "Done!";
                break;
            }

            if (pcsz)
                printf("### %s\n", pcsz);
        }

        /*
         *@@ VarPrompt:
         *
         *@@added V0.9.20 (2002-07-03) [umoeller]
         */

        virtual PSZ VarPrompt(FEVarPrompt &VarPrompt)
        {
            Error(CID_INCORRECT_INVOCATION,
                  "Environment variable \"%s\"referenced, but not defined.",
                  VarPrompt._strVarName.c_str());

            return 0;       // keep compiler happy
        }

        /*
         *@@ UpdatePackage:
         *
         *@@added V0.9.20 (2002-07-03) [umoeller]
         */

        virtual VOID UpdatePackage(FEInstallJob *pJob,
                                   ULONG ulPckThis,
                                   ULONG ulPcksTotal)
        {
            string strID;
            strID.assignUtf8(_Locals._pCodecProcess, pJob->QueryPckPackageID());
            _strCurrentJobPath.assignUtf8(_Locals._pCodecProcess, pJob->QueryTargetPath());
            printf("Extracting package %d/%d (%s)\nto \"%s\"\n",
                   ulPckThis,
                   ulPcksTotal,
                   strID.c_str(),
                   _strCurrentJobPath.c_str());
        }

        /*
         *@@ UpdateFile:
         *
         *@@added V0.9.20 (2002-07-03) [umoeller]
         */

        virtual VOID UpdateFile(WIFileHeader *pwifh,
                                ULONG ulFileThis,
                                ULONG ulFilesTotal)
        {
            string str;
            str._itoa10(pwifh->origsize,
                        _Locals._cThousands);
            printf("  %s\\%s (%s bytes)\n",
                   _strCurrentJobPath.c_str(),
                   pwifh->name,
                   str.c_str());
        }

        /*
         *@@ OnFileExists:
         *      callback from FEInstallEngine::Install to confirm
         *      whether a file should be replaced.
         *
         *      This only gets called if EngineWICallback has
         *      determined that the user should be prompted
         *      for what to do, depending on the overwrite
         *      settings in FELocals.
         *
         *      This must return one of the following:
         *
         *      --  CBRC_PROCEED:   replace this file
         *
         *      --  CBRC_SKIP:      skip this file
         *
         *@@added V0.9.20 (2002-07-03) [umoeller]
         */

        virtual int OnFileExists(FEFileError *pfi)
        {
            Error(CID_UNEXPECTED_CONDITION,
                  "File \"%s\" exists and does not match the current overwrite settings.",
                  pfi->_strFilename.c_str());

            return 0;       // keep compiler happy
        }

        /*
         *@@ OnFileError:
         *      callback from FEInstallEngine::Install when
         *      some major error occurs.
         *
         *      FEInstallEngine now composes a meaningful
         *      error message for us, which we only need to
         *      display.
         *
         *      iErrorRsp signals if the error is recoverable:
         *
         *      --  CBREC_RETRYCANCEL
         *
         *      --  CBREC_ABORTRETRYIGNORE
         *
         *      --  CBREC_CANCEL
         *
         *      This must return one of the following:
         *
         *      --  CBRC_RETRY     retry the failing operation
         *
         *@@added V0.9.20 (2002-07-03) [umoeller]
         */

        virtual int OnFileError(FEInstallJob *pJob,    // in: current install job, ptr can be NULL!
                                const ustring &ustrErrorMsg,
                                int iErrorRsp)      // in: possible response (ERSP_* flags)
        {
            string str;
            str.assignUtf8(_Locals._pCodecProcess, ustrErrorMsg);
            Error(CID_UNEXPECTED_CONDITION,
                  str.c_str());

            return 0;       // keep compiler happy
        }

        /*
         *@@ OnFileError:
         *      callback from FEInstallEngine::Install when
         *      the disk is full. This is fatal, and we
         *      cannot recover. This should display a
         *      message to the user; the engine will
         *      exit afterwards.
         *
         *@@added V0.9.20 (2002-07-03) [umoeller]
         */

        virtual VOID OnDiskFull(char cDriveLetter)
        {
            Error(CID_NOT_ENOUGH_DISK_SPACE,
                  "Disk %c: is full.",
                  cDriveLetter);
        }

        /*
         *@@ OnFileLockedError:
         *      this is a special case of file error when
         *      the FEInstallEngine::Install has detected
         *      that a file should be overwritten which is
         *      currently in use by another process.
         *
         *      This must return one of these:
         *
         *      --  CBRC_SKIP:    ignore the error, go on (skip the file).
         *
         *      --  CBRC_RETRY:   have the engine retry.
         *
         *      --  CBRC_UNLOCK:  have the engine unlock the file (DosReplaceModule).
         *
         *      --  CBRC_DEFER:   have the engine defer processing thru CONFIG.SYS.
         *
         *@@added V0.9.20 (2002-07-03) [umoeller]
         */

        virtual int OnFileLockedError(FEFileError *pfi,
                                      int iErrorCode)
        {
            // check if we got here for the second time
            // for the same file; that means
            // DosReplaceModule failed
            if (pfi->_strFilename == _strLastLockedFile)
                Error(CID_UNEXPECTED_CONDITION,
                      "Unlocking of file \"%s\" FAILED\n",
                      pfi->_strFilename.c_str());

            _strLastLockedFile = pfi->_strFilename;

            printf("    File \"%s\" is locked, unlocking\n",
                   pfi->_strFilename.c_str());

            return CBRC_UNLOCK;
        }

        virtual void DoneWithInstall(void)
        {
            printf("Done extracting files\n");
        }
};

/* ******************************************************************
 *
 *  Test Mode (-t)
 *
 ********************************************************************/

/*
 *@@ TestScriptMode:
 *
 *@@added V0.9.14 (2001-08-25) [umoeller]
 */

VOID TestScriptMode(const char *pcszScriptName,
                    string &strWICPath)
{
    PSZ     pszScript = NULL;
    APIRET  arc = NO_ERROR;

    if (!(arc = doshLoadTextFile(pcszScriptName,
                                 &pszScript,
                                 NULL)))
    {
        string      strMsgFile;
        HAB         hab = WinInitialize(0);
        WICLocals   Locals(hab,
                           '.');

        try
        {
            FERexx rexx(Locals);
            FEScriptBase *pScript = FEScriptBase::CreateScript(pszScript,
                                                               Locals,
                                                               rexx);
            // validate the pages and such
            // (new method V0.9.15 (2001-08-26) [umoeller])
            pScript->Validate();
        }
        catch (BSExcptBase &X)
        {
            // base exception class: all exception classes
            // are derived from this
            printf("%s\n", X._ustrDescription.GetBuffer());
            throw WICExcpt(CID_UNEXPECTED_CONDITION);
        }

        free(pszScript);

        printf("wic: Script looks OK to me.\n");
    }
}

/* ******************************************************************
 *
 *  Install Mode (-i)
 *
 ********************************************************************/

/*
 * InstallMode:
 *      implementation for install mode ("wic -i").
 *
 *@@added V0.9.16 (2001-09-20) [umoeller]
 */

VOID InstallMode(PCSZ pcszCID,          // in: CID file name
                 string &strWICPath)    // in: WIC path
{
    string      strMsgFile;
    strMsgFile._printf("%s\\warpin.tmf", strWICPath.c_str());

    HAB         hab = WinInitialize(0);

    WICLocals   Locals(hab,
                       '.');

    ustring     ustrDatabasePath;
    ustrDatabasePath.assignCP(Locals._pCodecProcess, strWICPath);

    try
    {
        // initialize the database
        FEDatabase Database(Locals,
                            ustrDatabasePath);

        // set log file name V0.9.20 (2002-07-03) [umoeller]
        ustring ustrLogFilename(ustrDatabasePath);
                            // use database path also
        ustrLogFilename.appendUtf8("\\install.log");
        Locals.SetLogFilename(ustrLogFilename);

        // create an instance of the install engine
        WICInstallEngine Engine(Database,
                                Locals);

        ustring ustrCID;
        ustrCID.assignCP(Locals._pCodecProcess,
                         pcszCID);

        // apply the cid file on the engine
        FECID cid(Engine,
                  ustrCID);
        cid.Apply();

        // check if the selections are OK
        if (Engine.VerifySelections(FALSE))   // do not prompt for missing dirs
        {
            // 1) process KILLPROCESS attributes
            Engine.ConfigKillProcesses();

            // create a list of FEDBPackage instances
            // from all the FEArcPackages which have
            // been selected for de-installation
            list<FEDBPackage*> DeinstallPackagesList(STORE);

            if (Engine.CreateDeinstallPackagesList(DeinstallPackagesList))
            {
                // anything to be deinstalled:
                Engine.UpdateGlobalStatus(GSTAT_REMOVING);

                // anything selected for removal:
                /* guiStartRemove(Engine._pLocals,
                               &DeinstallPackagesList,
                               PCK_CONFIGSYS
                                    | PCK_WPSCLASSES
                                    | PCK_WPSOBJECTS,
                               TRUE);       // modal
                               */
            }

            // clean up list
            DeinstallPackagesList.clear();

            // 2) unpack files

            // TRUE means go ahead:
            Engine.Install(NULL);              // use FEInstallEngine's WICallback

            FEInstallJob *pWarpINSelfInstallJob = NULL;

            // success so far:
            // configure (CONFIG.SYS, WPS classes, objects)
            Engine.Configure(hab);

            // store packages in database
            Engine.Store(&pWarpINSelfInstallJob);
        }
    }
    catch (BSExcptBase &X)
    {
        // base exception class: all exception classes
        // are derived from this
        Error(CID_UNEXPECTED_CONDITION,
              "%s\n",
              X._ustrDescription.GetBuffer());
    }

    WinTerminate(hab);
}

/*
 *@@ QueryArcMode:
 *      implementation for query mode ("wic -q").
 *
 *@@added V0.9.16 (2001-01-23) [umoeller]
 */

VOID QueryArcMode(PCSZ pcszArchive,
                  string &strWICPath)
{
    string      strMsgFile;
    strMsgFile._printf("%s\\warpin.tmf", strWICPath.c_str());

    HAB         hab = WinInitialize(0);

    WICLocals   Locals(hab,
                       '.');

    ustring     ustrDatabasePath;
    ustrDatabasePath.assignCP(Locals._pCodecProcess, strWICPath);

    try
    {
        // initialize the database
        FEDatabase Database(Locals,
                            ustrDatabasePath);

        ustring ustrArchiveFile;
        ustrArchiveFile.assignCP(Locals._pCodecProcess, pcszArchive);

        // create an instance of the install engine
        WICInstallEngine Engine(Database,
                                Locals);

        // go parse the script
        Engine.AppendArchive(ustrArchiveFile);

        // now go dump the packages in the archive

        list<FEJobBase*>::iterator JobStart = Engine._pAllJobsList->begin(),
                                   JobEnd = Engine._pAllJobsList->end();
        for (;
             JobStart != JobEnd;
             JobStart++)
        {
            FEJobBase *pTemp = *JobStart;
            FEInstallJob *pJobThis;
            if (pJobThis = pTemp->IsInstallJob())
            {
                ustring ustr;
                pJobThis->_ArcPackage._PckID.CreateStringSix(ustr);

                // added conversion V0.9.20 (2002-07-03) [umoeller]
                string str(Locals._pCodecProcess, ustr),
                       strInstalled;
                printf("%s\n", str.c_str());

                switch (pJobThis->_ulInstallStatus)
                {
                    case INSTALLED_UNKNOWN:
                        printf("  Unknown install status\n");
                    break;

                    case INSTALLED_NO:
                        printf("  Not installed\n");
                    break;

                    case INSTALLED_IS_OLDER:
                        strInstalled.assignUtf8(Locals._pCodecProcess,
                                                pJobThis->_pDBPackageInstalled->QueryTargetPath());
                        printf("  Installed version in \"%s\" is older (%s)\n",
                               strInstalled.c_str(),
                               pJobThis->_pDBPackageInstalled->_PckID._strVersion.c_str());
                    break;

                    case INSTALLED_IS_NEWER:
                        strInstalled.assignUtf8(Locals._pCodecProcess,
                                                pJobThis->_pDBPackageInstalled->QueryTargetPath());
                        printf("  Installed version in \"%s\" is newer (%s)\n",
                               strInstalled.c_str(),
                               pJobThis->_pDBPackageInstalled->_PckID._strVersion.c_str());
                    break;

                    case INSTALLED_IS_SAME:
                        strInstalled.assignUtf8(Locals._pCodecProcess,
                                                pJobThis->_pDBPackageInstalled->QueryTargetPath());
                        printf("  Current version installed in \"%s\"\n",
                               strInstalled.c_str());
                    break;
                }
            }
        }
    }
    catch (BSExcptBase &X)
    {
        // base exception class: all exception classes
        // are derived from this
        printf("%s\n", X._ustrDescription.GetBuffer());
        throw WICExcpt(CID_UNEXPECTED_CONDITION);
    }

    WinTerminate(hab);
}

