/**
 * $Id: wipackheader.cpp,v 1.5 2001/07/01 20:49:05 jens Exp $
 *
 * Package header class for WarpIN Archive
 *
 * This file Copyright (C) 1999-2001 Jens B&auml;ckman.
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, in version 2 as it comes in the COPYING
 * file of this distribution.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include "wiarchive2/wiarchive.h"

/****************************************************************************
 * Constructor.
 */
WIPackHeader::WIPackHeader()
{
    origSize = 0;
    compSize = 0;
    oldFiles = 0;
    number   = 0;
    files    = 0;
    pos      = 0;
}

/****************************************************************************
 * Read this object from file.
 */
void WIPackHeader::read(fstream &file) {
    file.read((char *)&number, sizeof(short));
    file.read((char *)&files, sizeof(short));
    file.read((char *)&pos, sizeof(long));
    file.read((char *)&origSize, sizeof(long));
    file.read((char *)&compSize, sizeof(long));
    file.read((char *)&name, 32);
    oldFiles = files;
}

/****************************************************************************
 * Put this object into storage
 *
 * Arguments - file: Yes, this is the file we are going to use.
 */
void WIPackHeader::write(fstream &file)
{
    file.write((char *)&number, sizeof(short));
    file.write((char *)&files, sizeof(short));
    file.write((char *)&pos, sizeof(long));
    file.write((char *)&origSize, sizeof(long));
    file.write((char *)&compSize, sizeof(long));
    file.write((char *)&name, 32);
}

