/**
 * $Id: wiheader.cpp,v 1.6 2001/07/01 20:49:05 jens Exp $
 *
 * Archive header class for WarpIN Archive
 *
 * This file Copyright (C) 1999-2001 Jens B&auml;ckman.
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, in version 2 as it comes in the COPYING
 * file of this distribution.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include "wiarchive2/wiarchive.h"

/****************************************************************************
 * Constructor
 */
WIHeader::WIHeader()
{
    revisionNeeded = WIARCHIVE_REVISION_NEEDED;
    #if defined(XP_OS2)
        os = WIARCHIVE_OS_OS2;
    #elif defined(XP_UNIX)
        os = WIARCHIVE_OS_UNIX;
    #elif defined(XP_WIN32)
        os = WIARCHIVE_OS_WIN32;
    #endif

    v1 = 0x77;
    v2 = 0x04;
    v3 = 0x02;
    v4 = 0xBE;
    extendedDataSize = 0;
    origScriptSize   = 0;
    compScriptSize   = 0;
    packs            = 0;
    revision         = 0;
}

/****************************************************************************
 * Copy operator
 */
WIHeader &WIHeader::operator=(const WIHeader &head)
{
    char *cp;

    v1 = head.v1;
    v2 = head.v2;
    v3 = head.v3;
    v4 = head.v4;

    revisionNeeded   = head.revisionNeeded;
    strcpy(path, head.path);
    revision         = head.revision;
    os               = head.os;
    packs            = head.packs;
    origScriptSize   = head.origScriptSize;
    compScriptSize   = head.compScriptSize;
    extendedDataSize = head.extendedDataSize;

    // Check that the path ends with a path separator - but only if we have a path
    if (path == "")  return *this;

    #if defined(XP_OS2) || defined(XP_WIN)
        // Examine drive letter
        cp = strrchr(path, ':');
        cp++;
        if (*cp != '\\' && *cp != '\0') {
            // Now check for path
            cp = strrchr(path, '\\');
            if (cp == NULL) {
                strcat(path, "\\");
            } else {
                cp++;
                if (*cp != '\0')  strcat(path, "\\");
            }
        }
    #elif defined(XP_UNIX)
        cp = strrchr(path, '/');
        if (cp == NULL) {
            path += "/";
        } else {
            cp++;
            if (*cp != '\0')  path += "/";
        }
    #endif

    return *this;
}

/****************************************************************************
 * Read the information - please?
 *
 * Arguments - file: Where to read from
 */
void WIHeader::read(fstream &file)
{
    file.read((char *)&v1, 1);
    file.read((char *)&v2, 1);
    file.read((char *)&v3, 1);
    file.read((char *)&v4, 1);
    file.read((char *)&revisionNeeded, sizeof(short));

    file.read((char *)path, 256);
    file.read((char *)dummy,  256);

    file.read((char *)&revision, sizeof(short));
    file.read((char *)&os, sizeof(short));
    file.read((char *)&packs, sizeof(short));
    file.read((char *)&origScriptSize, sizeof(short));
    file.read((char *)&compScriptSize, sizeof(short));
    file.read((char *)&extendedDataSize, sizeof(long));
}

/****************************************************************************
 * Verify that the archive header is correct
 *
 * Return - If the archive header is found correct, true is returned.  You
 *          can make a qualified guess about what it will return otherwise.
 */
bool WIHeader::verify()
{
    if (v1 == 0x77 && v2 == 0x04 && v3 == 0x02 && v4 == 0xBE)
        return true;
    else
        return false;
}

/****************************************************************************
 * Write WarpIN archive header to storage
 *
 * Arguments - file: Write all to this place
 */
void WIHeader::write(fstream &file)
{
    file.write((char *)&v1, 1);
    file.write((char *)&v2, 1);
    file.write((char *)&v3, 1);
    file.write((char *)&v4, 1);
    file.write((char *)&revisionNeeded, sizeof(short));

    file.write((char *)path, 256);
    file.write((char *)dummy, 256);

    file.write((char *)&revision, sizeof(short));
    file.write((char *)&os, sizeof(short));
    file.write((char *)&packs, sizeof(short));
    file.write((char *)&origScriptSize, sizeof(short));
    file.write((char *)&compScriptSize, sizeof(short));
    file.write((char *)&extendedDataSize, sizeof(long));
}

