/**
 * $Id: wifileheader.cpp,v 1.5 2001/07/01 20:49:04 jens Exp $
 *
 * File header class for WarpIN Archive
 *
 * This file Copyright (C) 1999-2001 Jens B&auml;ckman.
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, in version 2 as it comes in the COPYING
 * file of this distribution.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include "wiarchive2/wiarchive.h"

/****************************************************************************
 * Constructor
 */
WIFileHeader::WIFileHeader()
{
    magic    = 0xF012;
    checksum = 0;
    method   = 0;
    package  = 0;
    origSize = 0;
    compSize = 0;
    crc      = 0;
    extended = 0;
    time(&lastwrite);
    time(&creation);
}

/****************************************************************************
 *
 *
 */
short WIFileHeader::calculateChecksum()
{
    short c = 0;

    c += method;
    c += package;
    c += origSize;
    c += compSize;
    c += crc;
    c += lastwrite;
    c += creation;

    return c;
}

/****************************************************************************
 * Read file header from a WarpIN archive
 *
 * Arguments - file: Where to read stuff from
 */
void WIFileHeader::read(fstream &file) {
    file.read((char *)&magic, sizeof(short));
    file.read((char *)&checksum, sizeof(short));
    file.read((char *)&method, sizeof(short));
    file.read((char *)&package, sizeof(short));
    file.read((char *)&origSize, sizeof(long));
    file.read((char *)&compSize, sizeof(long));
    file.read((char *)&crc, sizeof(long));
    file.read((char *)&name, 256);
    file.read((char *)&lastwrite, sizeof(long));
    file.read((char *)&creation, sizeof(long));
    file.read((char *)&extended, sizeof(char));
}

/****************************************************************************
 * Verify that the file header hasn't been corrupted
 *
 * Return - True if file header seems fine, otherwise false
 */
bool WIFileHeader::verify()
{
    if (magic != (short)0xF012)  return false;
    if (checksum != calculateChecksum())  return false;
    return true;
}

/****************************************************************************
 * Write file header to a WarpIN archive
 *
 * Arguments - file: Where to read stuff from
 */
void WIFileHeader::write(fstream &file) {
    // Now write to file
    checksum = calculateChecksum();
    file.write((char *)&magic,     sizeof(short));
    file.write((char *)&checksum,  sizeof(short));
    file.write((char *)&method,    sizeof(short));
    file.write((char *)&package,   sizeof(short));
    file.write((char *)&origSize,  sizeof(long));
    file.write((char *)&compSize,  sizeof(long));
    file.write((char *)&crc,       sizeof(long));
    file.write((char *)&name,      256);
    file.write((char *)&lastwrite, sizeof(long));
    file.write((char *)&creation,  sizeof(long));
    file.write((char *)&extended,  sizeof(char));
}

