/*
 * $Id: main.c,v 1.2 2001/07/15 20:33:45 jens Exp $
 *
 * Main function for SelfIN application.
 *
 * While WarpIN is a very good utility for installing other applications, you
 * can't install WarpIN itself using WarpIN. This small utility, named SelfIN,
 * will remedy that. By using the same powerful BZ2 compression code that is
 * used in WarpIN itself, the installer will be very small. Best of all, you no
 * longer have to use Zip archives for distributing WarpIN. Finally, WarpIN can
 * be installed by using (an extremely compact version of) itself.
 *
 * This file Copyright (C) 2001 Jens B&auml;ckman
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, in version 2 as it comes in the COPYING
 * file of this distribution.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include "selfin/selfin.h"

/*****************************************************************************
 * Application entry point.
 **/
int main(int argc, char *argv[])
{
    int retval;

    if (argc != 2) {
        // TODO: Get install path
        retval = selfinstall(argv[0], argv[0]);
    } else {
        retval = selfinstall(argv[0], argv[1]);
    }

    /* Take different actions for the returned values */
    switch (retval) {
        case SELFIN_OK:
            // TODO: Execute warpin.exe
            break;

        case SELFIN_CORRUPT:
            printf("The install file has been corrupted! WarpIN can not be installed by using\n"
                    "this file. If you downloaded it from the Internet, try again. Chances are, it\n"
                    "might have been damaged during transfer. Better luck next time!\n");
            break;
    }
    return retval;
}

