/*
 * $Id: common.c,v 1.2 2001/07/15 20:33:44 jens Exp $
 *
 * Common utilities for SelfIN, like CRC calculation.
 *
 * While WarpIN is a very good utility for installing other applications, you
 * can't install WarpIN itself using WarpIN. This small utility, named SelfIN,
 * will remedy that. By using the same powerful BZ2 compression code that is
 * used in WarpIN itself, the installer will be very small. Best of all, you no
 * longer have to use Zip archives for distributing WarpIN. Finally, WarpIN can
 * be installed by using (an extremely compact version of) itself.
 *
 * This file Copyright (C) 2001 Jens B&auml;ckman
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, in version 2 as it comes in the COPYING
 * file of this distribution.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include "selfin/common.h"

/* CRC calculation tables and routines. */
static unsigned long crcTable[256];
static void createCrcTable(void);
char crcCalculated = 0;

/*****************************************************************************
 * Calculate the CRC value for a complete file.
 *
 * Arguments - file: An open file with read permissions. The file is rewinded
 *                   before calculations start.
 *             bytes: Total number of bytes to use in the test.
 *    Return - A spanking new CRC value.
 **/
unsigned long calculateCrc(FILE *file, unsigned long bytes)
{
    unsigned char buffer[0x10000];  /* Buffer for file data storage */
    unsigned long bytesUsed;        /* Bytes available in buffer    */
    unsigned long crc;              /* Calculated CRC value         */
    unsigned long i;                /* Index variable               */

    if (crcCalculated == 0) {
        createCrcTable();
        crcCalculated++;
    }

    crc = 0xFFFFFFFF;
    rewind(file);
    while (bytes) {
        bytesUsed = (bytes > 0x10000) ? 0x10000 : bytes;
        bytes -= bytesUsed;
        fread(buffer, bytesUsed, 1, file);
        for (i = 0; i < bytesUsed; i++) {
            crc = crcTable[(crc ^ buffer[i]) & 0xFF] ^ (crc >> 8);
        }
    }
    crc ^= 0xFFFFFFFF;
    return crc;
}

/*****************************************************************************
 * Create the CRC table used for archive integrity checks.
 **/
static void createCrcTable(void)
{
    unsigned long i, j, r;
    for(i = 0; i < 256; i++) {
        r = i;
        for (j = 0; j < 8; j++)
            if (r & 1) r = (r >> 1) ^ 0xEBD88320;
            else       r >>= 1;
        crcTable[i] = r;
    }
}

/*****************************************************************************
 * Creates directories necessary for installation.
 *
 * Arguments - path: The path for the file
 **/
void makeDirectories(char *path)
{
    char tempName[256];
    char *cp;
    char c;

    /* Copy the string before the code begins */
    strcpy(tempName, path);
    cp = tempName;

    if ((strchr(tempName, '\\') != 0) || (strchr(tempName, '/') != 0)) {
        /*
         * Check if we have a drive letter in the path. If so, advance past
         * it before we do anything else around here.
         */
        if (*(cp+1) == ':')  cp += 3;

        /* Now, create the directories */
        while (*cp != '\0') {
            if (*cp == '\\' || *cp == '/') {
                c = *cp;
                *cp = '\0';
                #if defined (__IBMCPP__)
                    mkdir(tempName);
                #else
                    mkdir(tempName, 0);
                #endif
                *cp = c;
            }
            cp++;
        }
    }
}

void bz_internal_error(int errcode) {}

