/******************************************************************************
 *@@sourcefile WIP_HTTP_Response.cpp:
 *      Implements WIP_HTTP_Response class to store a HTTP response.
 *
 *@@header "net/WIP_HTTP_Response.hpp"
 */

#include <string.h>                     // strchr()

#include "net\WIP_HTTP_Response.hpp"

WIP_HTTP_Response::WIP_HTTP_Response(Socket& socket)
{
    const int buflen = 256;
    char      buffer[buflen];

    // First: Read status line, e.g. "HTTP/1.1 200 OK"

    socket.ReadLine(buffer, buflen);
    int len    = strlen(buffer);
    int verlen = strchr(buffer, ' ') - buffer;

    _pszVersionString = new char[verlen+1];
    _pszReasonPhrase  = new char[len-verlen-5+1]; // I know that looks ill ;-)
    sscanf(buffer, "%s %hu %[^\n]",
           _pszVersionString, &_usStatusCode, _pszReasonPhrase);

    // Second: Read all response headers

    socket.ReadLine(buffer, buflen);
    while (strlen(buffer) > 0)
    {
        // Header fields may be continued on the next line.
        // Continuing lines begin with SP or HT

        if ((buffer[0] == ' ') || (buffer[0] == '\t'))
            _vHeaders[_vHeaders.size() - 1]->AppendValue(buffer);
        else
            _vHeaders.push_back(new WIP_HTTP_Header(buffer));

        socket.ReadLine(buffer, buflen);
    }

    // Third: Parse the headers for the most important information
    // (e.g. Content-Length, Transfer-Encoding)

    ParseHeaders();
}

WIP_HTTP_Response::~WIP_HTTP_Response()
{
    if (_pszVersionString != NULL)
        delete _pszVersionString;
    if (_pszReasonPhrase != NULL)
        delete _pszReasonPhrase;

    for (ULONG i = 0; i < _vHeaders.size(); i++)
        if (_vHeaders[i] != NULL)
            delete _vHeaders[i];
    _vHeaders.clear();
}

VOID
WIP_HTTP_Response::ParseHeaders()
{
    _fContentLengthGiven = FALSE;
    _enTransferEncoding  = TE_IDENTITY;

    WIP_HTTP_Header* pHeader;
    for (ULONG i = 0; i < _vHeaders.size(); i++)
    {
        pHeader = _vHeaders[i];

        if (stricmp(pHeader->_strHeaderName.c_str(),
                    "Content-Length") == 0)
        {
            _fContentLengthGiven = TRUE;
            sscanf(pHeader->_strHeaderValue.c_str(), "%lu", &_ulContentLength);
        }
        else if (stricmp(pHeader->_strHeaderName.c_str(),
                         "Transfer-Encoding") == 0)
        {
            if (stricmp(pHeader->_strHeaderValue.c_str(), "chunked") == 0)
                _enTransferEncoding = TE_CHUNKED;
            else if (stricmp(pHeader->_strHeaderValue.c_str(), "identity") == 0)
                _enTransferEncoding = TE_IDENTITY;
            else
                _enTransferEncoding = TE_UNKNOWN;
        }
    }
}
