#include <iostream>
#include <exceptio>

#include "net/WINet.hpp"

BOOL
Callback(USHORT       usMsgType,
         ULONG        ulMsgValue,
         const WIURL& wiURL)
{
    cout << "CALLBACK: ";

    switch(usMsgType)
    {
        case CBM_NET_DNSLOOKUP:
            cout << "Looking up host " << wiURL.GetServerName() << endl;
            break;

        case CBM_NET_DNSLOOKUP_FAILED:
            cout << "Lookup of host " << wiURL.GetServerName()
                 << " failed (h_errno = " << ulMsgValue << ")" << endl;
            break;

        case CBM_NET_CONNECT:
            cout << "Connecting to host " << wiURL.GetServerName() << endl;
            break;

        case CBM_NET_CONNECT_FAILED:
            cout << "Connect to host " << wiURL.GetServerName()
                 << " failed (errno = " << ulMsgValue << ")" << endl;
            break;

        case CBM_NET_REQUEST:
            cout << "Requesting file " << wiURL.GetDocumentPath() << endl;
            break;

        case CBM_NET_REQUEST_FAILED:
            cout << "Request of file " << wiURL.GetDocumentPath()
                 << " failed (status = " << ulMsgValue << ")" << endl;
            break;

        case CBM_NET_FILESIZE:
            cout << "Filesize is ";
            if (ulMsgValue)
                cout << ulMsgValue << " bytes" << endl;
            else
                cout << "unknown" << endl;
            break;

        case CBM_NET_BYTES_TRANSFERRED:
            cout << ulMsgValue << " bytes transferred" << endl;
            break;

        case CBM_NET_TRANSFER_COMPLETE:
            cout << "Transfer complete" << endl;
            break;

        case CBM_NET_TRANSFER_BROKEN:
            cout << "Transfer broken" << endl;
            break;

        default:
            cout << "usMsgType " << usMsgType << " " << ulMsgValue << endl;
    }

    return false;
}

int
main(int   argc,
     char* argv[])
{
  if (argc != 3)
  {
    cout << "Usage:   winet-test URL savefile" << endl;
    cout << "Example: winet-test http://www.netlabs.org index.html" << endl; 
    return 0;
  }

  try
  {
    WINet wiNet(&Callback);

    WIURL wiURL(argv[1]);

    if (wiNet.FetchURL(wiURL, argv[2], FALSE))
        cout << endl << "Success" << endl;
    else
        cout << endl << "Failure" << endl;
  }
  catch (BSExcptBase& e)
  {
    cout << e._strDescription.c_str() << endl;
  }

  return 0;
}
