
/*
 *@@sourcefile gui_shared.cpp:
 *      code shared by the various gui* files.
 *      These things are prototyped in gui.h.
 *
 *      All functions in here have the gshr* prefix.
 *
 *@@added V0.9.0 (99-10-24) [umoeller]
 *@@header "frontend\gui.h"
 */

/*
 *
 *      This file Copyright (C) 1998-2002 Ulrich Mller.
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation, in version 2 as it comes in the COPYING
 *      file of this distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

#define OS2EMX_PLAIN_CHAR
    // this is needed for "os2emx.h"; if this is defined,
    // emx will define PSZ as _signed_ char, otherwise
    // as unsigned char

#define INCL_DOS
#define INCL_WIN
#include <os2.h>

#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <limits.h>
#include <time.h>               // needed for WIFileHeader

#include "setup.h"
#include "bldlevel.h"

// include's from helpers
#include "helpers\dosh.h"
#include "helpers\dialog.h"
#include "helpers\gpih.h"
#include "helpers\nls.h"
#include "helpers\nlscache.h"
#include "helpers\prfh.h"
#include "helpers\winh.h"
#include "helpers\threads.h"
#include "helpers\standards.h"
#include "helpers\stringh.h"
#include "helpers\textview.h"
#include "helpers\textv_html.h"
#include "helpers\xstring.h"

#include "encodings\base.h"

// base includes (99-11-07) [umoeller]
#include "base\bs_base.h"
#include "base\bs_list.h"
#include "base\bs_string.h"
#include "base\bs_errors.h"
#include "base\bs_logger.h"
#include "base\bs_config.h"

#include "base\bs_config.h"

// back-end includes
#include "wiarchive\wiarchive.h"

// front-end includes
#include "engine\fe_base.h"

#include "engine\fe_script.h"

#include "engine\fe_package.h"
#include "engine\fe_package_arc.h"
#include "engine\fe_package_db.h"
#include "engine\fe_archive.h"
#include "engine\fe_job.h"
#include "engine\fe_database.h"

#include "frontend\warpin.h"
#include "frontend\calbacks.h"

#include "frontend\dlgids.h"
#include "frontend\gui.h"

#pragma hdrstop

/* ******************************************************************
 *
 *  Global variables
 *
 ********************************************************************/

GUISETTINGS         G_GuiSettings = {0};  // implementation

HWND                G_hwndSplashDlg = NULLHANDLE;

static CONTROLDEF
    G_Bitmap =  {
                    WC_STATIC,
                    NULL,
                    WS_VISIBLE | SS_BITMAP,
                    0,          // ID
                    NULL,       // no font
                    0,
                    { SZL_AUTOSIZE, SZL_AUTOSIZE },
                    COMMON_SPACING
                },
    G_InfoText =
                {
                    WC_STATIC,
                    NULL,
                    WS_VISIBLE | SS_TEXT | DT_WORDBREAK | DT_CENTER | DT_TOP,
                    ID_WIDI_INFOTEXT,          // ID
                    CTL_COMMON_FONT,
                    0,
                    { SZL_AUTOSIZE, SZL_AUTOSIZE },
                    COMMON_SPACING
                };

static DLGHITEM G_SplashDialogTemplate[] =
             {
                START_TABLE,
                    START_ROW(ROW_VALIGN_CENTER),
                        // column 1: bitmap
                        CONTROL_DEF(&G_Bitmap),

                        // column 2: info
                        CONTROL_DEF(&G_InfoText),
                END_TABLE
             };

/* ******************************************************************
 *
 *  Shared functions
 *
 ********************************************************************/

const char *G_pcszSplash
    = "WarpIN V" BLDLEVEL_VERSION " (built " __DATE__ ")\n"
      "(C) 1998-2002 Ulrich Mller, Jens Bckman,\n"
      "Cornelis Bockemhl and others";

HBITMAP     G_hbmSplash = NULLHANDLE;

/*
 *@@ gshrCreateSplash:
 *
 *@@added V0.9.9 (2001-04-01) [umoeller]
 *@@changed V0.9.20 (2002-07-03) [umoeller]: fixed HPS leak
 *@@changed V0.9.20 (2002-07-06) [umoeller]: added FCF_TASKLIST
 */

VOID gshrCreateSplash(HMQ hmq)
{
    GUIWaitPointer wp;

    if (!G_hwndSplashDlg)
    {
        APIRET arc;
        HPS hps = WinGetScreenPS(HWND_DESKTOP);
        if (G_hbmSplash = GpiLoadBitmap(hps,
                                        NULLHANDLE,
                                        IDB_WARPINLOGO,
                                        0, 0))
            // bad hack
            G_Bitmap.pcszText = (const char *)G_hbmSplash;

        WinReleasePS(hps);      // was missing V0.9.20 (2002-07-03) [umoeller]

        // load copyright string
        ULONG ulCodepage = WinQueryCp(hmq);
        string str;
        if (ulCodepage == 850)
            str = G_pcszSplash;
        else
        {
            BSUniCodec Codec850(850);
            BSUniCodec CodecHMQ(ulCodepage);
            ustring ustr;
            ustr.assignCP(&Codec850, G_pcszSplash);

            str.assignUtf8(&CodecHMQ, ustr);
        }

        G_InfoText.pcszText = str.c_str();

        if (!(arc = dlghCreateDlg(&G_hwndSplashDlg,
                                  NULLHANDLE,
                                  FCF_DLGBORDER | FCF_NOBYTEALIGN | FCF_TASKLIST,
                                        // added FCF_TASKLIST V0.9.20 (2002-07-06) [umoeller]
                                  WinDefDlgProc,
                                  "WarpIN",
                                  G_SplashDialogTemplate,
                                  ARRAYITEMCOUNT(G_SplashDialogTemplate),
                                  NULL,
                                  gshrQueryBoldFont())))
        {
            LONG lColor = 0xFFFFFF;     // white
            WinSetPresParam(G_hwndSplashDlg,
                            PP_BACKGROUNDCOLOR,
                            sizeof(lColor),
                            &lColor);
            winhCenterWindow(G_hwndSplashDlg);
            WinShowWindow(G_hwndSplashDlg, TRUE);
        }
        else
        {
            CHAR szErr[100];
            sprintf(szErr, "Error %d", arc);
            winhDebugBox(NULLHANDLE, "Error", szErr);
        }
    }
}

/*
 *@@ gshrDestroySplash:
 *
 *@@added V0.9.9 (2001-04-01) [umoeller]
 */

VOID gshrDestroySplash(VOID)
{
    WinDestroyWindow(G_hwndSplashDlg);
    G_hwndSplashDlg = NULLHANDLE;

    GpiDeleteBitmap(G_hbmSplash);
    G_hbmSplash = NULLHANDLE;
}

/*
 *@@ gshrLoadDlg:
 *      wrapper for WinLoadDlg which throws
 *      FEFatalErrorExcpt on errors. I've had
 *      this fail recently, so this was added
 *      for future problems.
 *
 *@@added V0.9.3 (2000-04-28) [umoeller]
 */

HWND gshrLoadDlg(HWND hwndParent,
                 HWND hwndOwner,
                 PFNWP pfnDlgProc,
                 HMODULE hmod,
                 ULONG idDlg,
                 PVOID pCreateParams)
{
    GUIWaitPointer wp;
    HWND hwnd;
    if (!(hwnd = WinLoadDlg(hwndParent,
                           hwndOwner,
                           pfnDlgProc,
                           hmod,
                           idDlg,
                           pCreateParams)))
        throw (BSExcptBase("WinLoadDlg failed."));

    return (hwnd);
}

/*
 *@@ gshrQueryDefaultFont:
 *
 *@@added V0.9.18 (2002-03-08) [umoeller]
 */

PCSZ gshrQueryDefaultFont()
{
    return (doshIsWarp4())
               ? "9.WarpSans"
               : "8.Helv";
}

/*
 *@@ gshrQueryBoldFont:
 *
 *@@added V0.9.18 (2002-03-08) [umoeller]
 */

PCSZ gshrQueryBoldFont()
{
    return (doshIsWarp4())
               ? "9.WarpSans Bold"
               : "8.Helv Bold";
}

/*
 *@@ gshrMakeHeading:
 *
 *@@added V0.9.18 (2002-03-08) [umoeller]
 */

VOID gshrMakeHeading(HWND hwndDlg, ULONG id)
{
    HWND hwndThis = WinWindowFromID(hwndDlg, id);
    winhSetWindowFont(hwndThis, gshrQueryBoldFont());
    winhSetPresColor(hwndThis, PP_BACKGROUNDCOLOR,
                     MAKE_RGB(127,127,127));
    winhSetPresColor(hwndThis, PP_FOREGROUNDCOLOR,
                     RGBCOL_WHITE);
}

/*
 *@@ gshrLoadMLE:
 *      loads the MLE dialog template and creates a textview
 *      control in it.
 *
 *@@added V0.9.7 (2001-01-06) [umoeller]
 */

HWND gshrLoadMLE(GUILocals *pLocals,
                 ULONG ulDlgTemplateID,
                 ustring &ustrText,
                 BOOL fHTML)            // convert strText from HTML?
{
    GUIWaitPointer wp;

    HWND hwndOwner = G_hwndMainFrame;
    if (!WinIsWindowVisible(hwndOwner))
        hwndOwner = NULLHANDLE;

    HWND hwnd = gshrLoadDlg(HWND_DESKTOP,
                            hwndOwner,
                            WinDefDlgProc,
                            NULLHANDLE,
                            ulDlgTemplateID,
                            NULL);
    HWND hwndTextView = txvReplaceWithTextView(hwnd,
                                               ID_WIDI_INFOTEXT,
                                               WS_VISIBLE | WS_TABSTOP
                                                    | XS_VSCROLL | XS_AUTOVHIDE,
                                               2);

    string strText;
    strText.assignUtf8(pLocals->_pCodecGui, ustrText);

    PSZ psz = strdup(strText.c_str());
    if (fHTML)
    {
        // set format
        XFMTPARAGRAPH xfmtp = {0};
        xfmtp.fWordWrap = TRUE;
        xfmtp.lSpaceBefore = 5;
        xfmtp.lSpaceAfter = 5;
        WinSendMsg(hwndTextView,
                   TXM_SETPARFORMAT,
                   (MPARAM)0,
                   (MPARAM)(&xfmtp));
        txvConvertFromHTML(&psz, NULL, NULL, NULL);
    }
    else
    {
        WinSendMsg(hwndTextView,
                   TXM_SETWORDWRAP,
                   (MPARAM)(TRUE),
                   0);
        txvStripLinefeeds(&psz, 4);
    }
    WinSetWindowText(hwndTextView, psz);
    free(psz);

    return (hwnd);
}


/*
 *@@ gshrMLEMessageBox:
 *      this displays a dialog with an MLE and
 *      fills the MLE with a text from the TMF
 *      message file.
 *
 *      Used in various places, most notably the
 *      "Product info" and "Install WarpIN" dialogs.
 *
 *      Note: the internal buffer is limited to
 *      4000 characters.
 *
 *      Returns DID_OK or DID_CANCEL, depending on
 *      the user selection.
 */

ULONG gshrMLEMessageBox(GUILocals *pLocals,
                        ULONG ulTitleID,     // msg id from TMF file for title
                        ULONG ulMsgID,       // msg id from TMF file to display in MLE
                        BOOL fShowCancel,    // TRUE: OK and Cancel buttons, FALSE: OK only
                        ustring *paStrings,  // in: ustring array (def: 0)
                        ULONG cbTable)       // defaults to 0
{
    GUIWaitPointer wp;

    ULONG   ulrc = 0;

    // create install text
    ustring ustrInstallInfo;
    pLocals->GetMessage(ustrInstallInfo,
                        ulMsgID,
                        paStrings,
                        cbTable);

    HWND hwndProdInfo = gshrLoadMLE(pLocals,
                                    ID_WID_PRODUCTINFO,
                                    ustrInstallInfo,
                                    FALSE);     // no HTML

    // set window title
    ustring strTitle;
    pLocals->GetMessage(strTitle,
                        ulTitleID);
    pLocals->SetWindowTextU(hwndProdInfo,
                            strTitle);

    // hide "Cancel" button
    if (!fShowCancel)
        WinShowWindow(WinWindowFromID(hwndProdInfo, DID_CANCEL), FALSE);

    winhCenterWindow(hwndProdInfo);

    // go!!
    ulrc = WinProcessDlg(hwndProdInfo);
    WinDestroyWindow(hwndProdInfo);

    return (ulrc);
}

/*
 *@@ fnwpDialogWithHelp:
 *      same as WinDefDlgProc, but with help button support.
 *
 *      You _must_ pass a DLGWITHHELP struct pointer as
 *      the create param to WM_INITDLG.
 *
 *@@added V0.9.4 (2000-07-26) [umoeller]
 */

MRESULT EXPENTRY gshr_fnwpDialogWithHelp(HWND hwndDlg,
                                         ULONG msg,
                                         MPARAM mp1,
                                         MPARAM mp2)
{
    MRESULT mrc = 0;

    switch (msg)
    {
        case WM_INITDLG:
            WinSetWindowPtr(hwndDlg, QWL_USER, mp2);        // DLGWITHHELP
        break;

        case WM_HELP:
        {
            PDLGWITHHELP pdwh;
            if (pdwh = (PDLGWITHHELP)WinQueryWindowPtr(hwndDlg, QWL_USER))
            {
                gshrDisplayHelp(pdwh->pLocals,
                                pdwh->ulHelpPanel);
            }
        }
        break;

        default:
            mrc = WinDefDlgProc(hwndDlg, msg, mp1, mp2);
    }

    return (mrc);
}

/*
 *@@ InsertCodepage:
 *
 *@@added V0.9.18 (2002-03-08) [umoeller]
 */

LONG InsertCodepage(GUILocals *pLocals,
                    HWND hwndCombo,
                    ULONG ulCPThis,
                    PCSZ pcsz)
{
    LONG l = WinInsertLboxItem(hwndCombo,
                               LIT_SORTASCENDING,
                               pcsz);
    winhSetLboxItemHandle(hwndCombo, l, ulCPThis);
    if (ulCPThis == pLocals->_ulDisplayCodepage)
        winhSetLboxSelectedItem(hwndCombo, l, TRUE);

    return l;
}

/*
 *@@ gshrPreferencesDlg:
 *      this shows the "Confirmations" dialog and
 *      updates the flags in G_WpiGlobals, if necessary.
 *
 *@@changed V0.9.12 (2001-05-31) [umoeller]: added REXX confirm
 *@@changed V0.9.18 (2002-03-08) [umoeller]: added codepage
 */

VOID gshrPreferencesDlg(GUILocals *pLocals,
                        HWND hwndOwner)
{
    GUIWaitPointer wp;

    // set help panel for fnwpDialogWithHelp
    DLGWITHHELP dwh;
    dwh.pLocals = pLocals;
    dwh.ulHelpPanel = IDHI_CONFIRMATIONS_DLG;
    HWND hwndDlg = gshrLoadDlg(HWND_DESKTOP,
                               hwndOwner,
                               gshr_fnwpDialogWithHelp,
                               NULLHANDLE,
                               ID_WID_PREFERENCES,
                               &dwh);
    winhCenterWindow(hwndDlg);
    winhSetControlsFont(hwndDlg, 0, 2000,
                        gshrQueryDefaultFont());

    ULONG ulOldCodepage = pLocals->_ulDisplayCodepage;

    // set controls
    ULONG idSet = 0;
    switch (pLocals->_ulIfExistingOlder)
    {
        case 0:  idSet = ID_WID_EXISTOLDER_PROMPT; break;
        case 1:  idSet = ID_WID_EXISTOLDER_SKIP; break;
        case 2:  idSet = ID_WID_EXISTOLDER_OVERWRITE; break;
    }
    winhSetDlgItemChecked(hwndDlg, idSet, TRUE);
    switch (pLocals->_ulIfSameDate)
    {
        case 0:  idSet = ID_WID_EXISTSAME_PROMPT; break;
        case 1:  idSet = ID_WID_EXISTSAME_SKIP; break;
        case 2:  idSet = ID_WID_EXISTSAME_OVERWRITE; break;
    }
    winhSetDlgItemChecked(hwndDlg, idSet, TRUE);
    switch (pLocals->_ulIfExistingNewer)
    {
        case 0:  idSet = ID_WID_EXISTNEWER_PROMPT; break;
        case 1:  idSet = ID_WID_EXISTNEWER_SKIP; break;
        case 2:  idSet = ID_WID_EXISTNEWER_OVERWRITE; break;
    }
    winhSetDlgItemChecked(hwndDlg, idSet, TRUE);

    // V0.9.12 (2001-05-31) [umoeller]
    winhSetDlgItemChecked(hwndDlg,
                          ID_WID_SHOWREXXCONFIRM,
                          (!G_WpiGlobals.fSuppressREXXConfirm));

    // log file name
    HWND hwndEF = WinWindowFromID(hwndDlg, ID_WID_LOGFILE_ENTRY);
    winhSetEntryFieldLimit(hwndEF, CCHMAXPATH);
    pLocals->SetWindowTextU(hwndEF,
                            pLocals->QueryLogFilename());

    // display codepage V0.9.18 (2002-03-08) [umoeller]
    ULONG cCodepages;
    HWND hwndCombo = WinWindowFromID(hwndDlg, ID_WID_CODEPAGE_DROPLIST);
    if (cCodepages = WinQueryCpList(pLocals->_habThread1,
                                    0,
                                    NULL))
    {
        PULONG paulCodepages;
        if (paulCodepages = (PULONG)malloc(cCodepages * sizeof(ULONG)))
        {
            if (WinQueryCpList(pLocals->_habThread1,
                               cCodepages,
                               paulCodepages))
            {
                LONG l;

                ULONG ul;
                string str;
                for (ul = 0;
                     ul < cCodepages;
                     ul++)
                {
                    // insert the codepage only if the conversion engine
                    // supports it
                    PCSZ pcszDescription;
                    ULONG ulCPThis = paulCodepages[ul];
                    ENCBYTECOUNT bc;
                    ENCID id = encFindIdForCodepage(ulCPThis,
                                                    &pcszDescription,
                                                    &bc);
                    if (    (id != UNSUPPORTED)
                         // && (bc == SINGLE)
                       )
                    {
                        str._printf("%s - %u", pcszDescription, ulCPThis);
                        InsertCodepage(pLocals, hwndCombo, ulCPThis, str.c_str());
                    }
                }

                str._printf(" Use process codepage (currently %u)",
                            pLocals->_pCodecProcess->QueryCodepage());
                InsertCodepage(pLocals, hwndCombo, 0, str.c_str());
            }
        }

        free(paulCodepages);
    }

    // go!
    if (WinProcessDlg(hwndDlg) == DID_OK)
    {
        // read controls
        if (winhIsDlgItemChecked(hwndDlg, ID_WID_EXISTOLDER_PROMPT))
            pLocals->_ulIfExistingOlder = 0;
        if (winhIsDlgItemChecked(hwndDlg, ID_WID_EXISTOLDER_SKIP))
            pLocals->_ulIfExistingOlder = 1;
        if (winhIsDlgItemChecked(hwndDlg, ID_WID_EXISTOLDER_OVERWRITE))
            pLocals->_ulIfExistingOlder = 2;
        if (winhIsDlgItemChecked(hwndDlg, ID_WID_EXISTSAME_PROMPT))
            pLocals->_ulIfSameDate = 0;
        if (winhIsDlgItemChecked(hwndDlg, ID_WID_EXISTSAME_SKIP))
            pLocals->_ulIfSameDate = 1;
        if (winhIsDlgItemChecked(hwndDlg, ID_WID_EXISTSAME_OVERWRITE))
            pLocals->_ulIfSameDate = 2;
        if (winhIsDlgItemChecked(hwndDlg, ID_WID_EXISTNEWER_PROMPT))
            pLocals->_ulIfExistingNewer = 0;
        if (winhIsDlgItemChecked(hwndDlg, ID_WID_EXISTNEWER_SKIP))
            pLocals->_ulIfExistingNewer = 1;
        if (winhIsDlgItemChecked(hwndDlg, ID_WID_EXISTNEWER_OVERWRITE))
            pLocals->_ulIfExistingNewer = 2;

        // V0.9.12 (2001-05-31) [umoeller]
        G_WpiGlobals.fSuppressREXXConfirm
                = !winhIsDlgItemChecked(hwndDlg,
                                        ID_WID_SHOWREXXCONFIRM);

        ULONG fl = 0;

        ustring ustrLogFilename;
        PSZ pszLogFilename;
        if (pszLogFilename = winhQueryWindowText(hwndEF))
        {
            ustrLogFilename.assignCP(pLocals->_pCodecGui, pszLogFilename);
            if (ustrLogFilename != pLocals->QueryLogFilename())
            {
                // changed:
                if (0 == doshIsValidFileName(pszLogFilename,
                                             TRUE))
                {
                    // valid file name:
                    pLocals->SetLogFilename(ustrLogFilename);
                    fl |= SETFL_SAVELOGFILEPATH;
                }
                else
                    pLocals->MessageBox(102,      // error
                                        204,      // invalid log file name
                                        MSG_WARNING_OK);
            }

            free(pszLogFilename);
        }
        else
        {
            // no log file specified:
            pLocals->SetLogFilename(ustrLogFilename);       // empty
            fl |= SETFL_SAVELOGFILEPATH;
        }

        // codepage
        SHORT s = winhQueryLboxSelectedItem(hwndCombo, LIT_FIRST);
        pLocals->_ulDisplayCodepage = winhQueryLboxItemHandle(hwndCombo, s);

        pLocals->SaveSettings(fl);

        if (pLocals->_ulDisplayCodepage != ulOldCodepage)
            // ask if user wants to restart WarpIN
            if (pLocals->MessageBox(100,
                                    274,        // restart?
                                    MSG_CONFIRM_YESNO_DEFYES)
                    == MBID_YES)
            {
                *pLocals->_pfRestart = TRUE;
            }
    }
    WinDestroyWindow(hwndDlg);

    if (*pLocals->_pfRestart)
        throw BSCancelExcpt();
}

/*
 *@@ gshrDefaultPathsDlg:
 *      this shows the "default directories" dialog
 *      and updates G_WpiGlobals.
 *
 *@@added V0.9.4 (2000-07-26) [umoeller]
 */

VOID gshrDefaultPathsDlg(GUILocals *pLocals,
                         HWND hwndOwner)
{
    // set help panel for fnwpDialogWithHelp
    DLGWITHHELP dwh;
    dwh.pLocals = pLocals;
    dwh.ulHelpPanel = IDHI_DEFAULTPATHS_DLG; // IDHI_CONFIRMATIONS_DLG;
                            // help panel fixed V0.9.20 (2002-07-19) [umoeller]
    HWND hwndDlg = gshrLoadDlg(HWND_DESKTOP,
                               hwndOwner,
                               gshr_fnwpDialogWithHelp,
                               NULLHANDLE,
                               ID_WID_DEFAULTPATHS,
                               &dwh);
    // set help panel for fnwpDialogWithHelp
    winhCenterWindow(hwndDlg);
    winhSetControlsFont(hwndDlg, 0, 2000,
                        gshrQueryDefaultFont());

    HWND    hwndApps = WinWindowFromID(hwndDlg, ID_WIDI_DEFAULTAPPSPATH),
            hwndTools = WinWindowFromID(hwndDlg, ID_WIDI_DEFAULTTOOLSPATH);

    PSZ p = getenv("WARPIN_DEFAULTAPPSPATH");
    WinSetWindowText(hwndApps, p);
    p = getenv("WARPIN_DEFAULTTOOLSPATH");
    WinSetWindowText(hwndTools, p);

    if (WinProcessDlg(hwndDlg) == DID_OK)
    {
        PSZ psz;
        if (psz = winhQueryWindowText(hwndApps))
        {
            pLocals->_strDefaultAppsPath._printf(
                    "WARPIN_DEFAULTAPPSPATH=%s", psz);
            putenv(pLocals->_strDefaultAppsPath.c_str());
            free(psz);
        }

        if (psz = winhQueryWindowText(hwndTools))
        {
            pLocals->_strDefaultToolsPath._printf(
                    "WARPIN_DEFAULTTOOLSPATH=%s", psz);
            putenv(pLocals->_strDefaultToolsPath.c_str());
            free(psz);
        }

        pLocals->SaveSettings(0);
    }

    WinDestroyWindow(hwndDlg);
}

/*
 *@@ gshrLoadConfirmDlg:
 *      loads the specified confirmation window
 *      and sets the dialog fields according to
 *      the file data.
 *
 *      This is shared by ShowFileExistsDlg and
 *      ShowFileLockedDlg.
 *
 *@@added V0.9.0 (99-10-26) [umoeller]
 */

HWND gshrLoadConfirmDlg(HWND hwndOwner,
                        ULONG ulDlgID,
                        PFNWP pfnwp,
                        FEFileError *pfi)
{
    HWND hwndConfirm = gshrLoadDlg(HWND_DESKTOP, hwndOwner,
                                   pfnwp, // fnwpFileExistsOrLocked,
                                   NULLHANDLE,
                                   ulDlgID,          // variable
                                   NULL);
    WinSetWindowPtr(hwndConfirm, QWL_USER, pfi);
    winhSetControlsFont(hwndConfirm, 0, 1003,
                        gshrQueryDefaultFont());

    // now set fields in dialog
    // 1)   existing file
    CHAR szTemp[300];
    nlsFileDate(szTemp,
                &(pfi->_fs3Existing.fdateLastWrite),
                G_ulDateFormat,
                G_szDateSep[0]);
    WinSetDlgItemText(hwndConfirm, ID_WIDI_EXISTS_DATEOLD,
                    szTemp);
    nlsFileTime(szTemp,
                &(pfi->_fs3Existing.ftimeLastWrite),
                G_ulTimeFormat,
                G_szTimeSep[0]);
    WinSetDlgItemText(hwndConfirm, ID_WIDI_EXISTS_TIMEOLD,
                      szTemp);

    WinSetDlgItemText(hwndConfirm, ID_WIDI_EXISTS_SIZEOLD,
                      nlsThousandsULong(szTemp,
                                        pfi->_fs3Existing.cbFile,
                                        G_szThousand[0]));

    // 2)   file in archive
    nlsFileDate(szTemp,
                &pfi->_fDateHeader,
                G_ulDateFormat,
                G_szDateSep[0]);
    WinSetDlgItemText(hwndConfirm, ID_WIDI_EXISTS_DATENEW,
                    szTemp);
    nlsFileTime(szTemp,
                &pfi->_fTimeHeader,
                G_ulTimeFormat,
                G_szTimeSep[0]);
    WinSetDlgItemText(hwndConfirm, ID_WIDI_EXISTS_TIMENEW,
                    szTemp);

    WinSetDlgItemText(hwndConfirm, ID_WIDI_EXISTS_SIZENEW,
                      nlsThousandsULong(szTemp,
                                        pfi->_pwifh->origsize,
                                        G_szThousand[0]));

    // 3)  issue warning text?
    HWND hwndInfoText = WinWindowFromID(hwndConfirm, ID_WIDI_EXISTS_INFOTEXT);
    if (pfi->_iComp < 0)
    {
        WinSetWindowText(hwndInfoText,
                         nlsGetString(WPSI_WARNINGEXISTINGNEWER));
                                // "Warning: The existing file is newer!"
        WinShowWindow(hwndInfoText, TRUE);
    }
    else
        WinShowWindow(hwndInfoText, FALSE);

    return (hwndConfirm);
}

/*
 *@@ gshrDisplayHelp:
 *
 *      If ulHelpPanel == 0, the "Using Help" panel
 *      is displayed.
 *
 *@@added V0.9.4 (2000-07-26) [umoeller]
 *@@changed V0.9.14 (2001-08-09) [umoeller]: now loading help instance dynamically
 */

BOOL gshrDisplayHelp(GUILocals *pLocals,
                     ULONG ulHelpPanel)
{
    BOOL brc = FALSE;

    if (!G_hwndHelpInstance)
    {
        // help instance not yet loaded:
        // load help instance
        if (    (G_hwndHelpInstance = winhCreateHelp(NULLHANDLE, // frame
                                                     NULL, // file name
                                                     NULLHANDLE, // module
                                                     (PHELPTABLE)MAKELONG(WPH_FULLINSTALL, 0xffff),
                                                     "WarpIN"))
             == NULLHANDLE)
        {
            pLocals->MessageBox(102,
                              195,
                              MSG_WARNING_OK);
        }
    }

    if (G_hwndHelpInstance)
        brc = (!WinSendMsg(G_hwndHelpInstance,
                           HM_DISPLAY_HELP,
                           (MPARAM)ulHelpPanel,
                           (MPARAM)(    (ulHelpPanel != 0)
                                        ? HM_RESOURCEID
                                        : 0)));

    return (brc);
}

/*
 *@@ gshrProcessDefMenuItems:
 *      common message handler for all window procs
 *      which handle the items from the WarpIN main
 *      menu plus help messages.
 *
 *      This returns TRUE if the item was processed,
 *      FALSE otherwise.
 *
 *@@added V0.9.0 (99-10-25) [umoeller]
 *@@changed V0.9.3 (2000-05-11) [umoeller]: "Cancel" didn't close main window; fixed
 *@@changed V0.9.4 (2000-07-26) [umoeller]: added "default dirs" settings
 *@@changed V0.9.4 (2000-07-26) [umoeller]: changed prototype, added help handling
 *@@changed V0.9.20 (2002-07-19) [umoeller]: made close confirmation more consistent
 */

BOOL gshrDefWindowProc(GUILocals *pLocals,
                       HWND hwnd,             // in: from msg proc
                       ULONG msg,             // in: from msg proc
                       MPARAM mp1,
                       MPARAM mp2,
                       ULONG ulDefHelpPanel)  // in: help
{
    BOOL brc = TRUE;        // processed

    switch (msg)
    {
        case WM_COMMAND:
        {
            SHORT sCommand = SHORT1FROMMP(mp1);
            switch (sCommand)
            {
                /*
                 * ID_WIMI_PREFERENCES:
                 *      "Confirmations" settings menu item
                 */

                case ID_WIMI_PREFERENCES:
                    gshrPreferencesDlg(pLocals, hwnd);
                break;

                /*
                 * ID_WIMI_DEFAULTPATHS:
                 *      "default directories" settings menu item
                 */

                case ID_WIMI_DEFAULTPATHS:
                    gshrDefaultPathsDlg(pLocals, hwnd);
                break;

                case ID_WIMI_HELPINDEX:
                break;

                case ID_WIMI_HELPGENERAL:
                    gshrDisplayHelp(pLocals, ulDefHelpPanel);
                break;

                case ID_WIMI_HELPUSINGHELP:
                    gshrDisplayHelp(pLocals, 0);
                break;

                case ID_WIMI_HELPPRODUCTINFO:
                    guiProductInfo(hwnd, pLocals, FALSE);
                break;

                /*
                 * ID_WIMI_EXIT:
                 *      "exit" menu item from "WarpIN" menu.
                 *      We used to display a confirmation here,
                 *      however, this was garbage for several
                 *      reasons... for one, the confirmation was
                 *      only displayed when the menu item was
                 *      selected, not with the system close
                 *      button, and secondly, we want the
                 *      confirmation only in install mode.
                 *
                 *      So instead, we now post WM_CLOSE, and
                 *      there's a handler in fnwpPages now
                 *      that displays the confirmation then
                 *      for install mode only.
                 *      V0.9.20 (2002-07-19) [umoeller]
                 */

                case ID_WIMI_EXIT:
                    WinPostMsg(hwnd, WM_CLOSE, 0, 0);
                        // V0.9.20 (2002-07-19) [umoeller]
                break;

                default:
                    brc = FALSE;        // not processed
            } // switch (sCommand)
        }
        break;  // case WM_COMMAND:

        case WM_HELP:
            gshrDisplayHelp(pLocals, ulDefHelpPanel);
        break;

        default:
            brc = FALSE;
    }

    return (brc);
}


