
/*
 *@@sourcefile fe_package_db.cpp:
 *      this implements the "database package" class, which
 *      is a subclass for FEPackageBase.
 *      See fe_package.cpp for details.
 *
 *      This has been separated from fe_package.cpp to reduce
 *      source code dependencies and speed up compile times.
 *
 *@@added V0.9.1 (2000-02-08) [umoeller]
 *@@header "engine\fe_package_db.h"
 */

/*
 *      This file Copyright (C) 1999-2002 Ulrich Mller.
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation, in version 2 as it comes in the COPYING
 *      file of this distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

#define OS2EMX_PLAIN_CHAR
    // this is needed for "os2emx.h"; if this is defined,
    // emx will define PSZ as _signed_ char, otherwise
    // as unsigned char

#define INCL_WINSHELLDATA
#define INCL_WINWORKPLACE
#include <os2.h>

#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#include <limits.h>
#include <time.h>               // needed for WIFileHeader

#include "setup.h"

// include's from helpers
#include "helpers\configsys.h"
#include "helpers\nls.h"
#include "helpers\prfh.h"
#include "helpers\xstring.h"

// base includes (99-11-07) [umoeller]
#include "base\bs_base.h"
#include "base\bs_list.h"
#include "base\bs_string.h"
#include "base\bs_errors.h"

#include "base\bs_logger.h"
#include "base\bs_config.h"
#include "base\bs_config_impl.h"

// back-end includes
#include "wiarchive\wiarchive.h"

// front-end includes
#include "engine\fe_base.h"

#include "engine\fe_script.h"

#include "engine\fe_package.h"
#include "engine\fe_package_db.h"
#include "engine\fe_database.h"

#pragma hdrstop

DEFINE_CLASS(FEDBPackage, FEPackageBase);

/* ******************************************************************
 *
 *  FEDBPackage implementation
 *
 ********************************************************************/

/*
 *@@ FEPackage:
 *      constructor for creating an FEPackage from
 *      the database, given a full package ID.
 *
 *      Use FEDatabase::FindPackageID to search the
 *      database if you don't know the exact package
 *      version which is installed.
 *
 *      Upon errors, a FEConstructorExcpt is thrown.
 *
 *      This initializes all fields in the returned
 *      FEDBPackage structure, including the WIPackHeader
 *      substructure.
 *
 *      Throws:
 *      -- FEDatabaseExcpt.
 *
 *@@changed V0.9.0 (99-10-26) [umoeller]: six-part ID support added
 *@@changed V0.9.0 (99-11-03) [umoeller]: now using FEPackageID
 *@@changed V0.9.1 (2000-01-08) [umoeller]: switched back to string ID for exception handling
 *@@changed V0.9.18 (2002-03-08) [umoeller]: changed prototype for Unicode support
 */

FEDBPackage::FEDBPackage(FEDatabase &Database,
                         const string &strIniKey,   // in: codepaged INI key that db is to be loaded from
                         BSUniCodec *pCodec,       // in: conversion object or NULL if package is utf-8 already
                         const ustring ustrID)      // in: converted Unicode ini key (package ID)
             : FEPackageBase(NULL,     // pDecl, created later
                             tFEDBPackage),
               _PckID(Database._Locals,
                      ustrID,
                      __FILE__, __LINE__,
                      FALSE),        // no short format
                        // this throws if id is invalid
               _listUndoConfig(STORE)
{
    _ulStatus = 0;
    _pvGuiData = 0;

    // store the exact string of the package ID (ini app) that
    // we were created from so we can kill that app on remove
    // (this might not work with normalized keys)
    // V0.9.18 (2002-03-08) [umoeller]
    _strAppLoadedFrom = strIniKey;

    Load(Database,
         pCodec);
}

/*
 *@@ Load:
 *      private helper method called from the constructors
 *      to load data from the database.
 *
 *      The data which is retrieved here must exactly match
 *      the data which has been stored in FEInstallJob::Store.
 *
 *      Returns FALSE upon errors.
 *
 *      Throws:
 *      -- FEDatabaseExcpt.
 *
 *@@added V0.9.1 (2000-01-08) [umoeller]
 *@@changed V0.9.1 (2000-01-07) [umoeller]: changed "requires" storage
 *@@changed V0.9.1 (2000-02-03) [umoeller]: added "execute" loggers support
 *@@changed V0.9.2 (2000-03-11) [umoeller]: added description and codepage
 *@@changed V0.9.4 (2000-07-01) [umoeller]: restore of "kill processes" was missing; fixed.
 *@@changed V0.9.18 (2002-03-08) [umoeller]: changed prototype for Unicode support
 *@@changed V0.9.20 (2002-07-22) [umoeller]: added created directories
 */

void FEDBPackage::Load(FEDatabase &Database,       // in: database
                       BSUniCodec *pCodec)         // in: conversion object or NULL if package is utf-8 already
{
    /* BSString strIDSix;
    PckID.CreateStringSix(strIDSix);
    const char *pcszIDSix = strIDSix.c_str(); */

    const char *pcszID = _strAppLoadedFrom.c_str();

    HINI hiniDB = Database._hiniDatabase;

    // check if file list exists in database
    if (_pszFilesList = prfhQueryProfileData(hiniDB,
                                             pcszID,
                                             WPIKEY_FILESLIST,
                                             &_cbFilesList))
    {
        // create pseudo-package declaration so we can access
        // the data

        // all the static AddToUndoList methods can throw
        // exceptions, so protect this
        try
        {
            // codepage V0.9.2 (2000-03-11) [umoeller]
            // V0.9.18 (2002-03-08) [umoeller]: removed,
            // we now get the codec as input
            /* _ulCodepage = PrfQueryProfileInt(hiniDB,
                                             pcszID,
                                             WPIKEY_CODEPAGE,
                                             // 850);      // default
                                             0);        // use 0 for utf-8!
                                                    // V0.9.18 (2002-03-08) [umoeller]
               */

            // create pseudo-package declaration V0.9.9 (2001-02-28) [umoeller]
            // and use converted ID V0.9.18 (2002-03-08) [umoeller]

            // create normalized package ID
            ustring ustrID;
            _PckID.CreateStringSix(ustrID);

            _pDecl = new FEDBPckDecl(ustrID);

            // target path
            PSZ pszTargetPath;
            if (!(pszTargetPath = prfhQueryProfileData(hiniDB,
                                                       pcszID,
                                                       WPIKEY_TARGETPATH,
                                                       NULL)))
                throw FEFatalErrorExcpt(Database._Locals,
                                        266, // Package has no target path stored.
                                        &ustrID);
            else
            {
                if (pCodec)
                    _pDecl->_ustrTargetPath.assignCP(pCodec, pszTargetPath);
                else
                    _pDecl->_ustrTargetPath.assignUtf8(pszTargetPath);

                free(pszTargetPath);
            }

            _logRequiresIDs.Load(hiniDB,
                                 pcszID,
                                 WPIKEY_REQUIRES);

            // decode the requires IDs into package IDs because
            // we use a list now
            // V0.9.18 (2002-02-06) [umoeller]
            PSZ     pszLogStart = _logRequiresIDs._pabLogString,
                    pszDBRequiresIDThis = pszLogStart;
            while (pszDBRequiresIDThis < pszLogStart + _logRequiresIDs._cbLogString)
            {
                ULONG   cbLogThis = strlen(pszDBRequiresIDThis);
                ustring strReqID;

                if (pCodec)
                    strReqID.assignCP(pCodec,
                                      pszDBRequiresIDThis);
                else
                    strReqID.assignUtf8(pszDBRequiresIDThis);

                FEPackageID *pID;
                if (pID = new FEPackageID(Database._Locals,
                                          strReqID,
                                          __FILE__, __LINE__,
                                          FALSE))       // do not allow short format
                    _RequiresIDs.push_back(pID);

                pszDBRequiresIDThis += cbLogThis + 1;    // go beyond null byte
            }

            _pDecl->_logCfgSysAttrs.Load(hiniDB,
                                         pcszID,
                                         WPIKEY_CONFIGATTRS);
            _logCfgSysDone.Load(hiniDB,
                                pcszID,
                                WPIKEY_CONFIGDONE);
            // create undo list
            BSCfgSysManip::AddToUndoList(_listUndoConfig,  // list to append to
                                         _logCfgSysDone);  // logger restored above

            _pDecl->_logRegisterClassAttrs.Load(hiniDB,
                                                pcszID,
                                                WPIKEY_REGISTERATTRS);
            _logRegisterClassesDone.Load(hiniDB,
                                         pcszID,
                                         WPIKEY_REGISTERDONE);
            // create undo list
            BSDeregisterClass::AddToUndoList(_listUndoConfig,  // list to append to
                                             _logRegisterClassesDone);  // logger restored above

            // class replacements
            _pDecl->_logReplaceClassAttrs.Load(hiniDB,
                                               pcszID,
                                               WPIKEY_REPLACEATTRS);
            _logReplaceClassDone.Load(hiniDB,
                                      pcszID,
                                      WPIKEY_REPLACEDONE);
            // create undo list
            BSUnreplaceClass::AddToUndoList(_listUndoConfig,  // list to append to
                                            _logReplaceClassDone);  // logger restored above

            // WPS objects
            _pDecl->_logWPSObjectAttrs.Load(hiniDB,
                                            pcszID,
                                            WPIKEY_WPSOBJECTATTRS);
            _logWPSObjectsDone.Load(hiniDB,
                                    pcszID,
                                    WPIKEY_WPSOBJECTDONE);
            BSDeleteWPSObject::AddToUndoList(_listUndoConfig,
                                         _logWPSObjectsDone);

            // clear profiles
            _pDecl->_logClearPrfAttrs.Load(hiniDB,
                                           pcszID,
                                           WPIKEY_CLEARPRFATTRS);
            // create BSClearProfile instances for the _attributes_!
            BSClearProfile::AddToUndoList(_listUndoConfig,
                                      _pDecl->_logClearPrfAttrs);

            _pDecl->_logWritePrfAttrs.Load(hiniDB,
                                           pcszID,
                                           WPIKEY_WRITEPRFATTRS);
            _logWritePrfsDone.Load(hiniDB,
                                   pcszID,
                                   WPIKEY_WRITEPRFDONE);
            // create BSClearProfile instances for the done BSWriteProfile's
            BSClearProfile::AddToUndoList(_listUndoConfig,
                                      _logWritePrfsDone);

            // executes
            _pDecl->_logExecuteAttrs.Load(hiniDB,
                                          pcszID,
                                          WPIKEY_EXECUTEATTRS);
            _logExecutesDone.Load(hiniDB,
                                  pcszID,
                                  WPIKEY_EXECUTEDONE);

            // de-executes V0.9.9 (2001-03-27) [umoeller]
            _pDecl->_logDeExecuteAttrs.Load(hiniDB,
                                          pcszID,
                                          WPIKEY_DEEXECUTEATTRS);
            _logDeExecutesResolved.Load(hiniDB,
                                        pcszID,
                                        WPIKEY_DEEXECUTERESOLVED);
            // create BSDeExecute instances for those attribs
            BSDeExecute::AddToUndoList(_listUndoConfig,
                                   _logDeExecutesResolved);

            // kill processes
            _pDecl->_logKillProcessAttrs.Load(hiniDB,
                                              pcszID,
                                              WPIKEY_KILLPROCESSATTRS);
                                        // V0.9.4 (2000-07-01) [umoeller]
            BSKillProcess::AddToUndoList(_listUndoConfig,
                                     _pDecl->_logKillProcessAttrs);

            // package header
            ULONG cbPackHeader = sizeof(WIPackHeader);
            PrfQueryProfileData(hiniDB,
                                pcszID,
                                WPIKEY_WIPACKHEADER,
                                &_PackHeader,
                                &cbPackHeader);

            // install date/time
            ULONG cbDateTime = sizeof(DATETIME);
            PrfQueryProfileData(hiniDB,
                                pcszID,
                                WPIKEY_INSTALLDATETIME,
                                &_InstallDateTime,
                                &cbDateTime);

            // description V0.9.2 (2000-03-11) [umoeller]
            PSZ pszInfo;
            if (pszInfo = prfhQueryProfileData(hiniDB,
                                               pcszID,
                                               WPIKEY_DESCRIPTION,
                                               NULL))
            {
                if (pCodec)
                    _pDecl->_ustrDescription.assignCP(pCodec, pszInfo);
                else
                    _pDecl->_ustrDescription.assignUtf8(pszInfo);

                free(pszInfo);
            }

            // load directories that were created
            // V0.9.20 (2002-07-22) [umoeller]
            _logDirsCreated.Load(hiniDB,
                                 pcszID,
                                 WPIKEY_DIRSCREATED);

        } // end try
        catch(BSConfigExcpt &X)
        {
            throw FEFatalErrorExcpt(Database._Locals,
                                    179); // Invalid system configuration data in database.
        }
    }
    else
        throw FEFatalErrorExcpt(Database._Locals,
                                164);       // file list is empty
}

/*
 *@@ GetFileHeaders:
 *      quite reverse to FEArcPackagePck::AddFileHeader, this
 *      creates a new list of WIFileHeaders which have all
 *      the files in this package which have already
 *      been installed. The list is in STORE mode and
 *      must be deleted by the caller.
 *
 *      If this package is not yet installed, NULL is
 *      returned.
 *
 *      If this package was created from an archive,
 *      this returns
 *
 *      The number of list items is returned in *pulHeaderCount.
 *
 *      Returns NULL upon errors.
 *
 *      Each file header on the list is created using new,
 *      just as the returned list itself.
 *      Note: With the new list implementation in V0.9.14,
 *      you can simply run clear() on the returned list
 *      to clean up the data.
 *
 *@@changed V0.9.0 (99-10-26) [umoeller]: this used to be datAddFileHeader; made this a FEPackage method
 */

list<WIFileHeaderLI*>* FEDBPackage::GetFileHeaders(PULONG pulHeaderCount)   // out: no. of list items
                                                                // in returned list
{
    list<WIFileHeaderLI*>   *pList = 0;
    ULONG                   ulHeaderCount = 0;

    if (_cbFilesList)
    {
        pList = new list<WIFileHeaderLI*>(STORE);

        PSZ p = _pszFilesList;

        while (p < (_pszFilesList + _cbFilesList) - 1)
        {
            WIFileHeader* pHeader = new WIFileHeader;

            // format of each entry:
            //    CHAR[x]   BYTE time_t  time_t  ULONG    BYTE
            //    filename   0   writedt creatdt filesize  0
            //                                   (uncompressed)

            // p now points to the filename
            strcpy(pHeader->name, p);
            p += strlen(p) + 1;     // go beyond null terminator

            // p now points to last write date
            pHeader->lastwrite = *((time_t*)p);
            p += sizeof(time_t);

            // p now points to last write date
            pHeader->creation = *((time_t*)p);
            p += sizeof(time_t);

            // p now points to the uncompressed file size
            pHeader->origsize = *((long*)p);

            p += sizeof(long);
            if (*p != 0)
            {
                pList->clear();
                delete pList;
                return NULL;
            }

            ++p;    // go beyond last null terminator

            pList->push_back(new WIFileHeaderLI(pHeader));
            ++ulHeaderCount;
        }

        if (pulHeaderCount)
            *pulHeaderCount = ulHeaderCount;
    }

    return pList;
}


