
/*
 *@@sourcefile fe_cid.cpp:
 *      implementation of the FECID class.
 *
 *@@added V0.9.18 (2002-03-08) [umoeller]
 *@@header "engine\fe_cid.h"
 */

/*
 *      This file Copyright (C) 2002 Ulrich Mller.
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation, in version 2 as it comes in the COPYING
 *      file of this distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

#define OS2EMX_PLAIN_CHAR
    // this is needed for "os2emx.h"; if this is defined,
    // emx will define PSZ as _signed_ char, otherwise
    // as unsigned char

#define INCL_DOSEXCEPTIONS
#define INCL_DOSPROCESS
#define INCL_DOSERRORS
#include <os2.h>

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#include <limits.h>
#include <time.h>               // needed for WIFileHeader
#include <setjmp.h>             // needed for except.h
#include <assert.h>             // needed for except.h

#include "setup.h"              // was missing (99-12-23) [umoeller]

// include's from helpers
#include "helpers\dosh.h"
#include "helpers\linklist.h"
#include "helpers\nls.h"
#include "helpers\tree.h"
#include "helpers\xstring.h"

#include "expat\expat.h"                // must come before xml.h
#include "helpers\xml.h"

#include "helpers\tmsgfile.h"

// base includes (99-11-07) [umoeller]
#include "base\bs_base.h"
#include "base\bs_list.h"
#include "base\bs_string.h"
#include "base\bs_errors.h"
#include "base\bs_logger.h"
#include "base\bs_config.h"

// back-end includes
#include "wiarchive\wiarchive.h"

// front-end includes
#include "engine\fe_base.h"
#include "engine\fe_script.h"
#include "engine\fe_package.h"
#include "engine\fe_package_arc.h"
#include "engine\fe_archive.h"
#include "engine\fe_job.h"

#include "engine\fe_engine.h"

#include "engine\fe_cid.h"

#pragma hdrstop

/* ******************************************************************
 *
 *  FELocals implementation
 *
 ********************************************************************/

DEFINE_CLASS(FECID, BSRoot);

#define CID_SYSTEMID "warpincid.dtd"

static PCSZ G_pcszDoctype =
"<!DOCTYPE warpincid SYSTEM \"" CID_SYSTEMID "\">";

static const STATICSYSTEMID SysIds =
    {
        CID_SYSTEMID,
        "<!ELEMENT warpincid (archive | var)*>\n"
        "\n"
        "<!ELEMENT archive (job)* >\n"
        "    <!ATTLIST archive\n"
        "        filename CDATA #REQUIRED >\n"
        "<!ELEMENT job EMPTY >\n"
        "    <!ATTLIST job\n"
        "        pckid ID #REQUIRED >\n"
        "    <!ATTLIST job\n"
        "        path CDATA #REQUIRED >\n"
        "    <!ATTLIST job\n"
        "        action ( install | deinstall | none ) #REQUIRED >\n"
        "<!ELEMENT var EMPTY >\n"
        "    <!ATTLIST var\n"
        "        key CDATA #REQUIRED >\n"
        "    <!ATTLIST var\n"
        "        value CDATA #REQUIRED >\n"
    };

/*
 *@@ FECID:
 *      constructor to create an instance of FECID.
 *
 *@@changed V0.9.20 (2002-07-03) [umoeller]: now using ustring for filename
 */

FECID::FECID(FEInstallEngine &Engine,       // in: install engine with all settings set
             const ustring &ustrFilename)   // in: output filename
    : BSRoot(tFECID),
      _Engine(Engine),
      _ustrFilename(ustrFilename)
{
    APIRET arc;

    // create a DOM
    if (!(arc = xmlCreateDocument("warpincid",
                                  (PDOMDOCUMENTNODE*)&_pDocument,
                                  (PDOMNODE*)&_pRootElement)))
    {
    }

    if (arc)
        throw FEFatalErrorExcpt(_Engine._Locals,
                                268);   // Cannot create XML document node.
}

/*
 *@@ ~FECID:
 *      the destructor.
 */

FECID::~FECID()
{
    // kill the DOM document
    if (_pDocument)
    {
        xmlDeleteNode((PNODEBASE)_pDocument);
        _pDocument = NULL;
        _pRootElement = NULL;
    }
}

/*
 *@@ Write:
 *      writes the XML document to disk under the filename
 *      given to the constructor,
 *
 */

VOID FECID::Write()
{
    APIRET  arc = NO_ERROR;

    // dump jobs

    list<FEArchive*>::iterator arcBegin = _Engine._pArchivesList->begin(),
                               arcEnd = _Engine._pArchivesList->end();
    for (;
         arcBegin != arcEnd;
         ++arcBegin)
    {
        FEArchive *pArcThis = *arcBegin;

        PDOMNODE pArcElement;
        PDOMNODE pAttribute;
        if (    (arc = xmlCreateElementNode((PDOMNODE)_pRootElement,
                                            "archive",
                                            &pArcElement))
             || (arc = xmlCreateAttributeNode(pArcElement,
                                              "filename",
                                              pArcThis->_ustrArcFilename.GetBuffer(),
                                              &pAttribute))
           )
            throw BSExcptBase("Cannot create archive DOM nodes for CID response file.");

        list<FEArcPackageBase*>::iterator pckBegin = pArcThis->_pPackagesList->begin(),
                                          pckEnd = pArcThis->_pPackagesList->end();
        for (;
             pckBegin != pckEnd;
             ++pckBegin)
        {
            DYNAMIC_CAST(FEArcPackagePck, pPckThis, *pckBegin);
            if (!pPckThis)
                // group job probably:
                continue;

            FEInstallJob *pInstallJob;
            if (!(pInstallJob = _Engine.FindInstallJob(pPckThis)))
            {
                ustring aStrings;
                pPckThis->_PckID.CreateStringSix(aStrings);
                throw FEFatalErrorExcpt(_Engine._Locals,
                                        291, // Error composing jobs list for CID response file: Cannot find install job for package ID "%1".
                                        &aStrings, 1);
            }

            PDOMNODE pJobElement;
            PCSZ pcszSel = NULL;
            switch (pInstallJob->QuerySelection())
            {
                case JOB_INSTALL:
                    pcszSel = "install";
                break;

                case JOB_DEINSTALL:
                    pcszSel = "deinstall";
                break;

                case JOB_INSTALL_IGNORE:
                    pcszSel = "none";
                break;
            }

            if (    (arc = xmlCreateElementNode(pArcElement,
                                                "job",
                                                &pJobElement))
                 || (arc = xmlCreateAttributeNode(pJobElement,
                                                  "pckid",
                                                  pInstallJob->QueryPckPackageID().GetBuffer(),
                                                  &pAttribute))
                 || (arc = xmlCreateAttributeNode(pJobElement,
                                                  "path",
                                                  pInstallJob->QueryTargetPath().GetBuffer(),
                                                  &pAttribute))
                 || (arc = xmlCreateAttributeNode(pJobElement,
                                                  "action",
                                                  pcszSel,
                                                  &pAttribute))
               )
                throw BSExcptBase("Cannot create job DOM nodes for CID response file.");
        }
    }

    /*
    list<FEJobBase*>::iterator jobBegin = _Engine._pAllJobsList->begin(),
                               jobEnd = _Engine._pAllJobsList->end();
    for (;
         jobBegin != jobEnd;
         ++jobBegin)
    {
        FEJobBase *pJob = *jobBegin;
        FEInstallJob *pInstallJob;
        if (pInstallJob = pJob->IsInstallJob())
        {
            PDOMNODE pJobElement;
            PDOMNODE pAttribute;
            PCSZ pcszSel = NULL;
            switch (pInstallJob->QuerySelection())
            {
                case JOB_INSTALL:
                    pcszSel = "install";
                break;

                case JOB_DEINSTALL:
                    pcszSel = "deinstall";
                break;

                case JOB_INSTALL_IGNORE:
                    pcszSel = "none";
                break;
            }

            if (    (!(arc = xmlCreateElementNode((PDOMNODE)_pRootElement,
                                                  "job",
                                                  &pJobElement)))
                 && (!(arc = xmlCreateAttributeNode(pJobElement,
                                                    "pckid",
                                                    pInstallJob->QueryPckPackageID().GetBuffer(),
                                                    &pAttribute)))
                 && (!(arc = xmlCreateAttributeNode(pJobElement,
                                                    "path",
                                                    pInstallJob->QueryTargetPath().GetBuffer(),
                                                    &pAttribute)))
                 && (!(arc = xmlCreateAttributeNode(pJobElement,
                                                    "action",
                                                    pcszSel,
                                                    &pAttribute)))
               )
            {
            }
        }
    }
    */

    if (!arc)
    {

        // dump install variables
        list<FEInstallVar*> listVariables(SHADOW);
        _Engine.GetInstallVars(listVariables,
                               TRUE);       // publics only
        list<FEInstallVar*>::iterator varBegin = listVariables.begin(),
                                      varEnd = listVariables.end();
        for (;
             varBegin != varEnd;
             ++varBegin)
        {
            FEInstallVar *pVar = *varBegin;

            PDOMNODE pVarNode;
            PDOMNODE pAttribute;
            if (    (!(arc = xmlCreateElementNode((PDOMNODE)_pRootElement,
                                                  "var",
                                                  &pVarNode)))
                 && (!(arc = xmlCreateAttributeNode(pVarNode,
                                                    "key",
                                                    pVar->_strVarName.c_str(),
                                                    &pAttribute)))
                 && (!(arc = xmlCreateAttributeNode(pVarNode,
                                                    "value",
                                                    (pVar->GetValue())
                                                        ? "YES" : "NO",
                                                    &pAttribute)))
               )
            {
            }
        }
    }

    if (arc)
    {
        ustring aStrings;
        aStrings._itoa10(arc, _Engine._Locals._cThousands);
        throw FEFatalErrorExcpt(_Engine._Locals,
                                269, // Error %1 occured composing XML document tree.
                                &aStrings, 1);
    }

    XSTRING strDocument;
    xstrInit(&strDocument, 1000);
    if (!(arc = xmlWriteDocument((PDOMDOCUMENTNODE)_pDocument,
                                 "UTF-8",
                                 G_pcszDoctype,
                                 &strDocument)))
    {
        // V0.9.20 (2002-07-03) [umoeller]
        string strFilename(_Engine._Locals._pCodecProcess,
                           _ustrFilename);
        xstrConvertLineFormat(&strDocument,
                              LF2CRLF);
        arc = doshWriteTextFile(strFilename.c_str(),
                                strDocument.psz,
                                NULL,
                                NULL);
    }

    xstrClear(&strDocument);

    if (arc)
    {
        ustring aStrings;
        aStrings._itoa10(arc, _Engine._Locals._cThousands);
        throw FEFatalErrorExcpt(_Engine._Locals,
                                270, // Error %1 occured writing XML document to disk.
                                &aStrings, 1);
    }
}

/*
 *@@ Apply:
 *      reversely to FECID::Write, this loads the XML file
 *      given to the constructor and applies it on the
 *      engine.
 *
 *@@added V0.9.20 (2002-07-03) [umoeller]
 */

VOID FECID::Apply()
{
    APIRET arc;

    PXMLDOM pDom;
    ustring astr[5];
    astr[0] = _ustrFilename;        // common to all error messages
    ULONG cStrings = 1,
          msg = 0;

    if (!(arc = xmlCreateDOM(DF_PARSEDTD | DF_FAIL_IF_NO_DTD | DF_DROP_WHITESPACE,
                             &SysIds,
                             1,
                             NULL,      // no codepage callback, this is UTF-8
                             NULL,      // external entity handler
                             NULL,
                             &pDom)))
    {
        string strFilename(_Engine._Locals._pCodecProcess,
                           _ustrFilename);
        PSZ pszContent;
        ULONG cbContent;
        if (!(arc = doshLoadTextFile(strFilename.c_str(),
                                     &pszContent,
                                     &cbContent)))
        {
            XSTRING xstrDocument;
            xstrInit(&xstrDocument, 0);
            xstrcpy(&xstrDocument,
                    pszContent,
                    cbContent - 1);
            free(pszContent);
            xstrConvertLineFormat(&xstrDocument,
                                  CRLF2LF);

            if (arc = xmlParse(pDom,
                               xstrDocument.psz,
                               xstrDocument.ulLength,
                               TRUE))        // last chunk
            {
                if (    (arc == ERROR_DOM_PARSING)
                     || (arc == ERROR_DOM_VALIDITY)
                   )
                {
                    // parsing or validation error:
                    // prepare the strings for throwing
                    // the exception at the bottom (so we
                    // can still clean up the DOM)
                    astr[1]._itoa10(pDom->ulErrorLine,
                                    _Engine._Locals._cThousands);
                    astr[2]._itoa10(pDom->ulErrorColumn,
                                    _Engine._Locals._cThousands);
                    astr[3].assignCP(_Engine._Locals._pCodecProcess,
                                     pDom->pcszErrorDescription);
                    if (pDom->pxstrFailingNode)
                        astr[4].assignUtf8(pDom->pxstrFailingNode->psz);

                    msg = (arc == ERROR_DOM_PARSING)
                               ? 280   // parsing error
                               : 281;  // validation error
                    cStrings = 5;
                }
            }
            else
            {
                // parsing went fine:
                // run through the DOM and apply stuff on the
                // engine

                PDOMNODE pRoot;
                PLINKLIST pllArchives = NULL;
                if (!(pRoot = xmlGetRootElement(pDom)))
                {
                    msg = 282; // Cannot find archive elements in XML document "%1".
                }
                else if (!(pllArchives = xmlGetElementsByTagName(pRoot,
                                                                 "archive")))
                {
                    msg = 282; // Cannot find archive elements in XML document "%1".
                }

                else
                {
                    PLISTNODE pArchiveNode;
                    for (pArchiveNode = lstQueryFirstNode(pllArchives);
                         (pArchiveNode);
                         pArchiveNode = pArchiveNode->pNext)
                    {
                        PDOMNODE pArchiveElementThis = (PDOMNODE)pArchiveNode->pItemData;

                        const XSTRING *pstrFilename,
                                      *pstrAction,
                                      *pstrPath;

                        // get the attributes
                        if (!(pstrFilename = xmlGetAttribute(pArchiveElementThis,
                                                             "filename")))
                        {
                            msg = 283; // In XML document "%1", "archive" elements have incomplete attributes.
                            break;
                        }

                        // open this archive, parse the script, yadda yadda
                        ustring ustrArchiveFile;
                        ustrArchiveFile.assignUtf8(pstrFilename->psz);
                        _Engine.AppendArchive(ustrArchiveFile);

                        // now go for the jobs in this archive
                        PLINKLIST pllJobs;
                        if (!(pllJobs = xmlGetElementsByTagName(pArchiveElementThis,
                                                                "job")))
                        {
                            astr[1] = ustrArchiveFile;
                            msg = 293; // Cannot find "job" elements in XML document "%1" under archive "%2".
                            break;
                        }

                        PLISTNODE pJobNode;
                        for (pJobNode = lstQueryFirstNode(pllJobs);
                             (pJobNode);
                             pJobNode = pJobNode->pNext)
                        {
                            PDOMNODE pJobElementThis = (PDOMNODE)pJobNode->pItemData;

                            const XSTRING *pstrID,
                                          *pstrAction,
                                          *pstrPath;

                            // get the attributes
                            if (    (!(pstrID = xmlGetAttribute(pJobElementThis,
                                                                "pckid")))
                                 || (!(pstrAction = xmlGetAttribute(pJobElementThis,
                                                                    "action")))
                                 || (!(pstrPath = xmlGetAttribute(pJobElementThis,
                                                                  "path")))
                               )
                            {
                                astr[1] = ustrArchiveFile;
                                msg = 292; // In XML document "%1" under archive "%2", "job" elements have incomplete attributes.
                                break;
                            }

                            // now find the job in the engine
                            // according to the package ID

                            ustring ustrid;
                            ustrid.assignUtf8(pstrID->psz);

                            FEPackageID id(_Engine._Locals,
                                           ustrid,
                                           __FILE__, __LINE__,
                                           FALSE);
                            FEInstallJob *pJob;
                            if (!(pJob = _Engine.FindInstallJob(id)))
                            {
                                astr[1] = ustrid;
                                msg = 284; // In XML document "%1", the "job" element "%2" does not match any package in the given archive.
                                cStrings = 2;
                                break;
                            }

                            // alright, apply install action

                            enJobSelection sel = JOB_UNDEFINED;

                            if (!strcmp(pstrAction->psz, "install"))
                                sel = JOB_INSTALL;
                            else if (!strcmp(pstrAction->psz, "deinstall"))
                                sel = JOB_DEINSTALL;
                            else if (!strcmp(pstrAction->psz, "none"))
                                sel = JOB_INSTALL_IGNORE;
                            else
                            {
                                astr[1] = ustrid;
                                msg = 285; // In XML document "%1", the "job" element "%2" has an invalid "action" attribute.
                                cStrings = 2;
                                break;
                            }

                            if (!pJob->Select(sel))
                            {
                                astr[1] = ustrid;
                                astr[2].assignUtf8(pstrAction->psz);
                                msg = 286; // In XML document "%1", the action "%3" cannot be performed on the "job" "%2".
                                cStrings = 3;
                                break;
                            }

                            // finally, apply target path
                            ustring ustrTargetPath;
                            ustrTargetPath.assignUtf8(pstrPath->psz);
                            pJob->SetTargetPath(ustrTargetPath,
                                                // pass NULL pointer for the list of
                                                // BASE packages; we assume this is set
                                                // correctly
                                                NULL); // _Engine._AllJobsList);

                        } // end for (pJobNode = lstQueryFirstNode(pllTypes);

                        lstFree(&pllJobs);

                        if (msg)
                            break;
                    } // end for (pArchiveNode = lstQueryFirstNode(pllArchives);

                    if (!msg)
                    {
                        // finally, apply install variables
                        // (these are optional)

                        PLINKLIST pllVars = NULL;
                        if (pllVars = xmlGetElementsByTagName(pRoot,
                                                              "var"))
                        {
                            PLISTNODE pVarNode;
                            for (pVarNode = lstQueryFirstNode(pllVars);
                                 (pVarNode);
                                 pVarNode = pVarNode->pNext)
                            {
                                PDOMNODE pVarElementThis = (PDOMNODE)pVarNode->pItemData;

                                const XSTRING *pstrKey,
                                              *pstrValue;

                                // get the attributes
                                if (    (!(pstrKey = xmlGetAttribute(pVarElementThis,
                                                                    "key")))
                                     || (!(pstrValue = xmlGetAttribute(pVarElementThis,
                                                                        "value")))
                                   )
                                {
                                    msg = 287; // In XML document "%1", "var" elements have incomplete attributes.
                                    break;
                                }

                                FEInstallVar *pVar;
                                if (!(pVar = _Engine.FindInstallVar(pstrKey->psz)))
                                {
                                    astr[1].assignCP(_Engine._Locals._pCodecProcess,
                                                     pstrKey->psz);
                                    msg = 288; // In XML document "%1", the "var" element "%2" is not used by any job.
                                    break;
                                }

                                if (!strcmp(pstrValue->psz, "YES"))
                                    pVar->SetValue(TRUE);
                                else
                                    pVar->SetValue(FALSE);
                            }

                            lstFree(&pllVars);
                        }
                    }

                    lstFree(&pllArchives);
                }
            }

            xstrClear(&xstrDocument);
        }

        xmlFreeDOM(pDom);
    }

    if (arc && !msg)
    {
        astr[1]._itoa10(arc, _Engine._Locals._cThousands);
        msg = 279; // Error %2 occured loading the XML document "%1".
        cStrings = 2;
    }

    if (msg)
        throw FEFatalErrorExcpt(_Engine._Locals,
                                msg,
                                astr,
                                cStrings);
}
