/*
 * wipebase.h:
 *      base header file for wipengine.
 *
 *@@include <os2.h>
 */



#ifndef _WIPEBASE_H_
#define _WIPEBASE_H_


#define APPLICATION_REVISION            0x0914 // is 0.9.20
#define APPLICATION_NAME                "WipEngine"
#define DEVELOPER_NAME                  "Teemu Ahola"

/*
 *Message priorities:
 */
#define QUE_MSG_PRIORITY_NORMAL         7
#define QUE_MSG_PRIORITY_HIGHER         4
#define QUE_MSG_PRIORITY_HIGHEST        2
#define QUE_MSG_PRIORITY_LOWER          10
#define QUE_MSG_PRIORITY_LOWEST         14

/*
 *Call-back base values.
 */
#define CB_BASE_MLU                     10
#define CB_BASE_ARC_SUB_SYS             30
#define CB_BASE_ARC_UNIT                50

/*
 * Return value pools.
 */
#define RET_BASE_GLOBAL                 0
#define RET_BASE_ARC_SUB_SYS            50
#define RET_BASE_ARC_UNIT               100
#define RET_BASE_FDU                    150
#define RET_BASE_MLU                    200

/*
 * Global return values.
 */
#define RET_OK                          RET_BASE_GLOBAL + 0
#define RET_ERR_PARAMETER_ERROR         RET_BASE_GLOBAL + 1



/*
 * Definition of AID (Archive ID).
 */
typedef HQUEUE AID;


/*
 *@@FNWIPECALLBACK:
 *  typedef for a call-back function.
 */
typedef LONG (FNWIPECALLBACK)(SHORT, // Call-back type
                              LONG, // Type-related information
                              PVOID,  // A pointer to a type-related data
                              PVOID  // A pointer to a user data
                              );
typedef FNWIPECALLBACK *PFNWIPECALLBACK;


/*
 *@@MsgInfo:
 */
struct MsgInfo {
    AID     _aidSender;
    PVOID   _pData;
    LONG    _lData;
    HEV     _hevSem;
    PVOID   _pUserData;

    MsgInfo() {
        _aidSender = 0;
        _pData = NULL;
        _lData = 0;
        _hevSem = NULLHANDLE;
        _pUserData = NULL;
        }
    ~MsgInfo() {
        // We DO NOT free the memory allocated for _pData in here!
        }
    };


#endif
