/*
 * threadbase.hpp:
 *      header file for threadbase.cpp.
 *      Includes declarations for classes:
 *          ThreadBase
 *
 *  Bases on Christian Wonschina's TXTHREAD sources.
 *
 */

/*
 *      Copyright (C) 2000-2001 Teemu Ahola, Christian Wonschina <fonz>
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation, in version 2 as it comes in the COPYING
 *      file of this distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */


#ifndef _THREADBASE_H_
#define _THREADBASE_H_

//#define PM_IS_USED


// Thread status.
#define TS_NOTSTARTED   0
#define TS_SUSPENDED    1
#define TS_WORKING      2



static void _Optlink ThreadStarter(void *);

/*
 *@@ThreadBase
 *  a base class for thread support in a class. Refer to threadbase.cpp.
 *
 */
class ThreadBase {
    friend class ThreadBase;

    private:
    TID             _tid;
    ULONG           _ulStackSize;
    ULONG volatile  _ulStatus;

    HAB             _habAnchor;
    HMQ             _hmqQueue;


    protected:
    VOID    setStackSize(ULONG);

    #ifdef PM_IS_USED
    VOID    createMQ();
    VOID    deleteMQ();
    VOID    cancelShutdown(BOOL);
    #endif

    public:
    ThreadBase();
    ~ThreadBase();

    TID     execute();
    VOID    suspend();
    VOID    resume();

    VOID    softKill(VOID);
    VOID    kill(VOID);

    VOID    waitThread(VOID);

    ULONG   returnThreadStatus();

    /*
     *@@_ThdFunction
     *  this function is virtual so a class which inheris this class should
     *  implement this function. The function is used inside a thread created
     *  by an object which is a type of this class.
     */
    virtual VOID _ThdFunction() = 0;

    };
#endif
