/*
 * cxmlsubsidizer.h:
 *      header file for cxmlsubsidizer.cpp.
 *
 *@@include "expat\expat.h"
 *@@include "helpers\linklist.h"
 *@@include "helpers\tree.h"
 *@@include "helpers\xml.h"
 */

/*
 *      Copyright (C) 2000-2001 Teemu Ahola.
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation, in version 2 as it comes in the COPYING
 *      file of this distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */


#ifndef _CXMLSUBSIDIZER_H_
#define _CXMLSUBSIDIZER_H_


#define INCL_DOSERRORS
#include <os2.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "setup.h"

#include <vector>

#include "base\bs_base.h"
#include "base\bs_list.h"

#include "helpers\stringh.h"
#include "helpers\xstring.h"
#include "base\bs_string.h"

// XML related includes. Refer to helpers\xml.c.
#include "expat\expat.h" // must come before xml.h
#include "helpers\linklist.h"
#include "helpers\tree.h"
#include "helpers\xml.h"

#include "wipengine\cdomsubsidizer.h"


class CXmlException {

    public:
        BSString _bssError;
        USHORT _usErrorCode;

        CXmlException();
        ~CXmlException();

        CXmlException(CXmlException &);

        CXmlException operator=(CXmlException &);

};


class CXmlSubsidizer {

    public:

        CXmlSubsidizer();
        ~CXmlSubsidizer();
        USHORT Parse(const BSString &);
        BSString Build(BOOL);

    protected:

        CDomSubsidizer *_pDom;

    private:


};



#endif
