/*
 * domsubsidizer.h:
 *      header file for xmlengine.cpp.
 *
 *@@include "expat\expat.h"
 *@@include "helpers\linklist.h"
 *@@include "helpers\tree.h"
 *@@include "helpers\xml.h"
 */

/*
 *      Copyright (C) 2000-2001 Teemu Ahola.
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation, in version 2 as it comes in the COPYING
 *      file of this distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */


#ifndef _CDOMSUBSIDIZER_H_
#define _CDOMSUBSIDIZER_H_

#define INCL_DOSERRORS
#include <os2.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "setup.h"

#include <vector>

#include "base\bs_base.h"
#include "base\bs_list.h"

#include "helpers\stringh.h"
#include "helpers\xstring.h"
#include "base\bs_string.h"

// XML related includes. Refer to helpers\xml.c.
#include "expat\expat.h" // must come before xml.h
#include "helpers\linklist.h"
#include "helpers\tree.h"
#include "helpers\xml.h"


/*
 * Inheritance and usage chain:
 *
 *  CXmlDom
 *      |
 *      ----------------------------------------------
 *                |            |       |             |
 *  CNodeBase<----+------------+-------+----------   |
 *        |       |            |       |         |   |
 *     (inherit)(uses)         |       |         |   |
 *        |       v            |       |         |   |
 *        --CDomNode         (uses)    |         |   |
 *        |       |            |    (uses)       |   |
 *        |       |            v       |         |   |
 *        |       --CDomDocumentNode   |         |   |
 *        |       |       |            |         |   |
 *        |       |     (uses)  --------         |   |
 *        |       |       |     |                |   |
 *        |       |       v     v                |   |
 *        |       --CDomDocTypeNode------        |   |
 *        |                             |        |   |
 *        |                           (uses)     |   |
 *        --CElementParticle            |        |   |
 *        |        ^     |              |        |   |
 *        |        |     |              v        |   |
 *        |      (uses)  --CElementDeclNode      |   |
 *        |        |             |               |   |
 *        |        ---------------               | (uses)
 *        |                                      |   |
 *        --CAttributeDeclBase<------------------+----
 *        |            |                         |
 *        |          (uses)                      |
 *        |            |                       (uses)
 *        |            v                         |
 *        --CAttributeDecl                       |
 *        |           |                          |
 *        |           ----------------------------
 *        |
 *        --CEntityDeclNode
 *        |
 *        |
 *        --CNotationDeclNode
 */


//
// CDomException class:
//

class CDomException {

    public:
        BSString _bssError;
        USHORT _usErrorCode;

        CDomException();
        virtual ~CDomException();

        CDomException(CDomException &);

        CDomException operator=(CDomException &);

};


//
// CNodeBase class:
// Base class.
//
class CNodeBase {

    public:
        CNodeBase(PNODEBASE);
        virtual ~CNodeBase();

        NODEBASETYPE getNodeType();
        BSString *getNodeName();

    protected:

    private:

        PNODEBASE _pNodeBase;

};

//
// CNodeBase class:
// Base class.
//
class CElementParticle : public CNodeBase {

    public:
        CElementParticle(PCMELEMENTPARTICLE);
        virtual ~CElementParticle();


    protected:

    private:

        PCMELEMENTPARTICLE _pElementParticle;

};

//
// CElementDeclNode class:
//

class CElementDeclNode : public CElementParticle {

    public:

        CElementDeclNode(PCMELEMENTDECLNODE);
        virtual ~CElementDeclNode();

        NODEBASETYPE getElementType();
        BSString *getElementName();


    private:

    protected:

        PCMELEMENTDECLNODE _pElementDeclNode;
};


//
// CAttributeDecl class:
//
class CAttributeDecl : public CNodeBase {

    public:

        CAttributeDecl(PCMATTRIBUTEDECL);
        virtual ~CAttributeDecl();

        ATTRIBTYPE getAttributeType();
        BSString *getAttributeName();
        ATTRIBCONSTRAINT getAttributeConstraint();
        BSString *getDefaultValue();

    private:

    protected:

        PCMATTRIBUTEDECL _pAttributeDecl;
};


//
// CAttributeDeclBase class:
//
class CAttributeDeclBase : public CNodeBase {

    public:
        CAttributeDeclBase(PCMATTRIBUTEDECLBASE);
        virtual ~CAttributeDeclBase();

        CAttributeDecl *findAttributeDecl(BSString &);

    private:


    protected:

        PCMATTRIBUTEDECLBASE _pAttributeDeclBase;

};


//
// CDomNode
//
class CDomNode : public CNodeBase {

    public:

        CDomNode(PDOMNODE);
        virtual ~CDomNode();

        BSString *getNodeValue();

        CDomNode *getFirstChild();
        CDomNode *getLastChild();
        CDomNode *getFirstText();
        vector<CDomNode*> *getElementsByTagName(const BSString &);
        BSString *getAttribute(const BSString &);


    private:

    protected:

        PDOMNODE _pDomNode;

};


//
// CDomDocTypeNode
//
class CDomDocTypeNode : public CDomNode {

    public:
        CDomDocTypeNode(PDOMDOCTYPENODE);
        virtual ~CDomDocTypeNode();

        BSString *getPublicId();
        BSString *getSystemId();

        BOOL hasInternalSubset();

    private:

    protected:

        PDOMDOCTYPENODE _pDomDocTypeNode;

};


//
// CDomDocumentNode class:
//
class CDomDocumentNode : public CDomNode {

    public:
        CDomDocumentNode(PDOMDOCUMENTNODE);
        virtual ~CDomDocumentNode();

    private:

    protected:

        PDOMDOCUMENTNODE _pDomDocumentNode;
};



//
// CEntityDeclNode class:
//
class CEntityDeclNode : public CNodeBase {

    public:
        CEntityDeclNode(PCMENTITYDECLNODE);
        virtual ~CEntityDeclNode();

    private:

    protected:

        PCMENTITYDECLNODE _pEntityDeclNode;
};


//
// CNotationDeclNode class:
//
class CNotationDeclNode : public CNodeBase {

    public:
        CNotationDeclNode(PCMNOTATIONDECLNODE);
        virtual ~CNotationDeclNode();

    private:

    protected:

        PCMNOTATIONDECLNODE _pNotationDeclNode;
};


//
// CXmlDom class:
//
class CXmlDom {

    public:
        CXmlDom(XMLDOM*);
        virtual ~CXmlDom();

        CElementDeclNode *findElementDecl(const BSString &);
        CAttributeDeclBase *findAttribDeclBase(const BSString &);
        CDomNode *getRootElement();
        XMLDOM *getXmlDom();

    private:

    protected:
        XMLDOM *_pXmlDom;

};


//
// CDomSubsidizer class:
//

class CDomSubsidizer {

    public:

        enum eParserFlags {eParseComments = DF_PARSECOMMENTS,
                           eParseDtd = DF_PARSEDTD,
                           eFailIfNoDtd = DF_FAIL_IF_NO_DTD,
                           eDropWhiteSpace = DF_DROP_WHITESPACE};

        CDomSubsidizer();
        virtual ~CDomSubsidizer();

        setParserParams(ULONG);
        PXMLDOM getDomTree();

        CXmlDom *_pDom;

    protected:


    private:

        ULONG _ulParserFlags;
        BOOL _initialized;

};


#endif
