/*
 * arcsubsys.h:
 *      header file for asubsys.cpp.
 *
 *@@include <map>
 *@@include "wipengine\fdu.h"
 *@@include "wipengine\threadbase.h"
 *@@include "expat\expat.h"
 *@@include "helpers\linklist.h"
 *@@include "helpers\tree.h"
 *@@include "helpers\xml.h"
 */

/*
 *      Copyright (C) 2000-2001 Teemu Ahola.
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation, in version 2 as it comes in the COPYING
 *      file of this distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

#ifndef _ARCSUBSYS_H_
#define _ARCSUBSYS_H_

/*
 *Default file name:
 */
#define STR_DEFAULT_FILE_NAME           "noname.wpi"

/*
 *Return values:
 */
#define RET_ERR_CALLBACK_NOT_DEFINED    RET_BASE_ARC_SUB_SYS + 0
#define RET_ERR_THREAD_CREATION_FAILED  RET_BASE_ARC_SUB_SYS + 1
#define RET_ERR_INITIALIZATION_FAILED   RET_BASE_ARC_SUB_SYS + 2
#define RET_ERR_ARCHIVE_OPENING_FAILED  RET_BASE_ARC_SUB_SYS + 3
#define RET_ERR_ARCHIVE_NOT_OPENED      RET_BASE_ARC_SUB_SYS + 4

/*
 * Call-back function return values
 */
#define RET_CB_CANCEL                   RET_BASE_ARC_SUB_SYS + 4
#define RET_CB_OVERWRITE_STUB           RET_BASE_ARC_SUB_SYS + 5


/*
 *Queue messages:
 */
#define QUE_MSG_QUIT                    1
#define QUE_MSG_ADD_FILES               2
#define QUE_MSG_DELETE_FILES            3
#define QUE_MSG_QUERY_FILES             4
#define QUE_MSG_OPEN_ARCHIVE_FILE       5
#define QUE_MSG_QUERY_ARCHIVED_FILES    6
#define QUE_MSG_ADD_PACKAGE             8
#define QUE_MSG_CLOSE_ARC               9
#define QUE_MSG_EXTRACT_FILES           10

/*
 *Call-back types:
 */
#define CB_TYPE_FILE_ADDING_COMPLETED       CB_BASE_ARC_SUB_SYS + 0x1
#define CB_TYPE_FILE_QUERYING_COMPLETED     CB_BASE_ARC_SUB_SYS + 0x2
#define CB_TYPE_FILE_DELETING_COMPLETED     CB_BASE_ARC_SUB_SYS + 0x3
#define CB_TYPE_QUIT_COMPLETED              CB_BASE_ARC_SUB_SYS + 0x4
#define CB_TYPE_ERR_INITIALIZATION          CB_BASE_ARC_SUB_SYS + 0x5
#define CB_TYPE_ARCHIVE_FILE_OPENED         CB_BASE_ARC_SUB_SYS + 0x6
#define CB_TYPE_ARCHIVE_FILE_QUERIED        CB_BASE_ARC_SUB_SYS + 0x7
#define CB_TYPE_PACKAGE_ADDED               CB_BASE_ARC_SUB_SYS + 0x9
#define CB_TYPE_STUB_MAY_BE_LOST            CB_BASE_ARC_SUB_SYS + 0xA
#define CB_TYPE_ARCHIVE_FILE_NOT_OPENED     CB_BASE_ARC_SUB_SYS + 0xB
#define CB_TYPE_CLOSING_ARCHIVE_COMPLETED   CB_BASE_ARC_SUB_SYS + 0xC
#define CB_TYPE_EXTRACTING_FILES_COMPLETED  CB_BASE_ARC_SUB_SYS + 0xD

/*
 *Other defines:
 */
#define ALL_PACKAGES                    0xFFFF
#define EA_NAME_SUBJECT                 ".SUBJECT"
#define EA_NAME_VERSION                 ".VERSION"
#define EA_NAME_HISTORY                 ".HISTORY"
#define EA_NAME_COMMENTS                ".COMMENTS"
#define EA_NAME_TYPE                    ".TYPE"
#define EA_NAME_KEYPHRASES              ".KEYPHRASES"
#define EA_HISTORY_ITEM_CREATED         "Created"
#define EA_HISTORY_ITEM_CHANGED         "Changed"
#define EA_HISTORY_ITEM_PRINTED         "Printed"


/*
 * Default callback function.
 */
LONG assDefaultCallBack(SHORT p_sCBType, LONG, PVOID p_pData, PVOID);


class ArcSubSystem: public ThreadBase {
    public:
    HQUEUE              _hQReceiver; // Message queue for receiving.
    private:
    FileDatabaseUnit    _Files;
    HQUEUE              _hQMessageLogger; // MLU's message queue handler.
    HMTX                _mtxSemFiles; // For coordination of _Files usage.
    HMTX                _mtxSemQueName; // For coordination of _bssQueueName usage.
    HEV                 _hevSemInit;  // For initialization syncronization.
    HEV                 _hevSemError;  // For error indication.
    PFNWIPECALLBACK     _pfnWipeCallBack; // A call-back for the archive unit.
    PVOID               _pUserData; // A pointer to a user data. This pointer is used as
                                    // a one of the parameters of the call-back function.
    BSString            _bssQueueName; // Message queue name.
    Boolean             _bArchiveOpened;
    BSString            _bssFullArchiveName;
    BSString            _bssStubFile;
    PEALIST             _peaList; // List for archive's EAs.

    BSString            _bssSubject; // Subject of the archive which will be used
                                     // as .SUBJECT extended archive.
    BSString            _bssArchiveAuthor;
    Boolean             _bNewFile;
    public:
    WIArchiveRW         _Archive;

    public:
    ArcSubSystem(HQUEUE p_hQMLU,
                 PFNWIPECALLBACK p_pfnWipeCallBack,
                 PVOID p_pUserData
                 ) {
        _hQMessageLogger = p_hQMLU;
        // If no callback function is provided, use default.
        if (p_pfnWipeCallBack)
            _pfnWipeCallBack = p_pfnWipeCallBack;
        else
            _pfnWipeCallBack = &assDefaultCallBack;

        _pUserData = p_pUserData;
        _mtxSemFiles = NULLHANDLE;
        _hQReceiver = NULLHANDLE;
        _hevSemInit = NULLHANDLE;
        _hevSemError = NULLHANDLE;
        _mtxSemQueName = NULLHANDLE;
        _bArchiveOpened = FALSE;
        _peaList = NULL;
        _bNewFile = TRUE;
        InitSemaphores();
    }

    ~ArcSubSystem();

    void SetCallBackData(PFNWIPECALLBACK p_pfnWipeCallBack, PVOID p_pUserData) {
        _pfnWipeCallBack = p_pfnWipeCallBack;
        _pUserData = p_pUserData;
    }

    USHORT Start(VOID);

    // Interface helper functions for file handling.
    USHORT InsertFiles(FileVector *, HEV = NULLHANDLE, PVOID = NULL);
    USHORT DeleteFiles(FileVector *, HEV = NULLHANDLE, PVOID = NULL);
    USHORT QueryFiles(FileVector *, HEV = NULLHANDLE, PVOID = NULL);

    // Interface helper functions for WIArchive.
    USHORT OpenArchiveFile(BSString &, HEV = NULLHANDLE, PVOID = NULL);
    USHORT CloseArchiveFile(HEV = NULLHANDLE, PVOID = NULL);
    USHORT QueryArchivedFiles(FileVector *, SHORT, HEV = NULLHANDLE, PVOID = NULL);
    USHORT AddPackage(SHORT, HEV, PVOID = NULL);

    USHORT CloseArchive(HEV = NULLHANDLE, PVOID = NULL);


    private:
    USHORT QueryArchivedFiles(SHORT);
    USHORT AddNonArchivedFiles(SHORT);
    /*USHORT InsertArchivedFiles(FileVector &);
    USHORT DeleteArchivedFiles(FileVector &);*/
    USHORT ExtractArchivedFiles(FileVector &);

    // EA helpers.
    PSZ ReturnEaValue(PSZ, PEALIST);
    USHORT UpdateEas(PEALIST, PEALIST*);
    PSZ ReturnMvEaValue(PSZ, PEALIST, USHORT*);

    // For package handling.
    USHORT AddPackage(SHORT);

    USHORT InsertFiles(FileVector &);
    USHORT DeleteFiles(FileVector &);
    USHORT QueryFiles(FileVector &);
    VOID _ThdFunction();
    VOID InitSemaphores(VOID);

    // Handler methods
    USHORT HandleAddFilesMsg(MsgInfo &);
    USHORT HandleQueryFilesMsg(MsgInfo &);
    USHORT HandleDeleteFilesMsg(MsgInfo &);
    USHORT HandleOpenArchiveFileMsg(MsgInfo &);
    USHORT HandleQuitMsg(MsgInfo &);
    USHORT HandleAddPackageMsg(MsgInfo &);
    USHORT HandleCloseArchiveMsg(MsgInfo &);
    USHORT HandleExtractFilesMsg(MsgInfo &);
};


/*
 *@@ArcSubSystemPtrMap:
 *  typedef for a ArcSubSystem class multimap.
 */
typedef multimap<AID, // key class
                ArcSubSystem*, // data class
                less<AID> // comparsion method
                > ArcSubSystemPtrMap;



#endif

