/*
 *              WicPM - WarpIN Archive Creator for PM
 *                  (c) Copyright Teemu Ahola 2000
 *
 *              WarpIN Script Class 0.9.1
 *
 * script.hpp
 *  Header file for script.cpp.
 *  This file contains class headers for script classes.
 *
 *
 */



#ifndef _SCRIPT_HPP
#define _SCRIPT_HPP

#include <os2.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <direct.h>

#include "..\..\..\include\helpers\stringh.h" // created by Ulrich Mller


#define MAXAPPNAMELENGTH                64
#define MAXVENDORNAMELENGTH             64
#define MAXPCKNAMELENGTH                32
#define MAXINETADDRESSLENGTH            128
#define MAXVERSIONLENGTH                5
#define MAXTITLELENGTH                  64
#define MAXSTATEMENTLENGTH              128
#define MAXSEARCHSTRINGLENGTH           128
#define MAXCLASSNAMELENGTH              256
#define MAXCLASSTITLELENGTH             256
#define MAXCLASSCONFIGLENGTH            256
#define MAXSCRIPTLENGTH                 4096
#define MAXSCRIPTLINELENGTH             256
#define MAXSCRIPTSTRINGLENGTH           256
#define MAXPROFILEAPPLICATIONLENGTH     256
#define MAXPROFILEKEYLENGTH             256
#define MAXPAGETEXTLENGTH               256
#define MAXPAGETITLELENGTH              256
#define MAXNEXTBTNTEXTLENGTH            256
#define MAXMESSAGELENGTH                256
#define MAXOPERATIGSYSTEMLENGTH         64
#define MAXTARGETLENGTH                 256
#define MAXTAGLENGTH                    256
#define MAXATTRIBUTELENGTH              256

// Keyword attributes.
#define KEYWORD_BASE                    1
#define KEYWORD_FIXED                   2
#define KEYWORD_SELECT                  4
#define KEYWORD_NODESELECT              8

// ConfigSys modifiers.
#define MODIFIER_NONE                   0
#define MODIFIER_UNIQUE                 1
#define MODIFIER_ADDRIGHT               2
#define MODIFIER_ADDLEFT                4
#define MODIFIER_ADDTOP                 8
#define MODIFIER_ADDAFTER               16
#define MODIFIER_ADDBEFORE              32
#define MODIFIER_REMOVELINE             64
#define MODIFIER_REMOVEPART             128


// Error codes
#define NO_ERROR                        0

    // Configsys error codes
#define ERR_CONFIGSYS_ADDRIGHT_SETTED   1
#define ERR_CONFIGSYS_ADDLEFT_SETTED    2
#define ERR_CONFIGSYS_UNIQUE_SETTED     4
#define ERR_CONFIGSYS_ADDTOP_SETTED     8
#define ERR_CONFIGSYS_ADDAFTER_SETTED   16
#define ERR_CONFIGSYS_ADDBEFORE_SETTED  32
#define ERR_CONFIGSYS_REMOVELINE_SETTED 64
#define ERR_CONFIGSYS_REMOVEPART_SETTED 128

    // Script parsing errors
#define ERR_PARSE_NULLPOINTER           1


struct SCRIPTERROR
    {
    // Error code.
    USHORT usErrorCode;
    // The number of the line where error is located.
    USHORT usLineNumber;
    // The start offset of the block where error is located.
    PSZ pszStart;
    // The length of the block where error is located.
    ULONG ulLength;
    };


struct PACKAGEIDDATA
    {
    CHAR                szVendor[MAXVENDORNAMELENGTH];
    CHAR                szApplication[MAXAPPNAMELENGTH];
    CHAR                szPackage[MAXPCKNAMELENGTH];
    USHORT              usMajor;
    USHORT              usMinor;
    USHORT              usRevision;
    };


struct REQUIRESDATA
    {
    CHAR                szVendor[MAXVENDORNAMELENGTH];
    CHAR                szApplication[MAXAPPNAMELENGTH];
    CHAR                szPackage[MAXPCKNAMELENGTH];
    USHORT              usMajor;
    USHORT              usMinor;
    USHORT              usRevision;
    };


struct CONFIGSYSDATA
    {
    CHAR                szStatement[MAXSCRIPTSTRINGLENGTH];
    USHORT              usModifiers;
    CHAR                szSearchString[MAXSCRIPTSTRINGLENGTH];
    };


struct REGISTERCLASSDATA
    {
    CHAR                szClassname[MAXCLASSNAMELENGTH];
    CHAR                szDLLPath[CCHMAXPATH];
    };


struct REPLACECLASSDATA
    {
    CHAR                szOldClassName[MAXCLASSNAMELENGTH];
    CHAR                szNewClassName[MAXCLASSNAMELENGTH];
    };


struct CREATEOBJECTDATA
    {
    CHAR                szClassName[MAXCLASSNAMELENGTH];
    CHAR                szTitle[MAXCLASSTITLELENGTH];
    CHAR                szLocation[CCHMAXPATH];
    CHAR                szConfig[MAXCLASSCONFIGLENGTH];
    BOOL                bReplace;
    };


struct PROFILEDATA
    {
    CHAR                szProfile[CCHMAXPATH];
    CHAR                szApplication[MAXPROFILEAPPLICATIONLENGTH];
    CHAR                szKey[MAXPROFILEKEYLENGTH];
    };




/*
 *@@ ScriptIndex class
 *  This class is used in ScriptPackage and ScriptPage classes and it contains datas used
 *  while creating INDEX attribute.
 */
class ScriptIndex
    {
    USHORT              usIndex;

    USHORT              usIndexAttribute;

    public:
        ScriptIndex(USHORT usIndex = 1);
        ~ScriptIndex();

        void SetIndexAttribute(USHORT usIndexAttribute);

        void SetIndex(USHORT usIndex);

        USHORT ReturnIndexAttribute();

        USHORT ReturnIndex();

        PSZ MakeScriptText(BOOL bAttribute = TRUE);

        PSZ BuildFromText(PSZ pszScriptText, SCRIPTERROR **pScriptError,
                         USHORT *usErrorTableSize, ULONG ulLineNumber);
    };




/*
 *@@ ScriptPackageID class
 *  This class is used in ScriptPackage class and it contains datas used
 *  while creating package ID attribute.
 */
class ScriptPackageID
    {
    // Identifier number of packageID. Can be used to determine which
    // package ID is this.
    USHORT              usIndex;

    CHAR                szVendor[MAXVENDORNAMELENGTH];
    CHAR                szApplication[MAXAPPNAMELENGTH];
    CHAR                szPackage[MAXPCKNAMELENGTH];
    USHORT              usMajor;
    USHORT              usMinor;
    USHORT              usRevision;

    public:
        // Constructor for the class
        ScriptPackageID(USHORT usIndex = 1);
        // Destructor for the class
        ~ScriptPackageID();

        void SetIndex(USHORT usIndex);

        // Sets datas to strings
        void SetVendor(const CHAR szVendor[MAXVENDORNAMELENGTH]);
        void SetApplication(const CHAR szApplication[MAXAPPNAMELENGTH]);
        void SetPackage(const CHAR szPackage[MAXPCKNAMELENGTH]);
        void SetMajor(USHORT usMajor);
        void SetMinor(USHORT usMinor);
        void SetRevision(USHORT usRevision);
        void SetPackageID(PACKAGEIDDATA packageIDData);

        const PSZ ReturnVendor();
        const PSZ ReturnApplication();
        const PSZ ReturnPackage();
        USHORT ReturnMajor();
        USHORT ReturnMinor();
        USHORT ReturnRevision();
        PACKAGEIDDATA ReturnPackageID();

        USHORT ReturnIndex();

        PSZ MakeScriptText(BOOL bShowAttribute = TRUE);
        PSZ BuildFromText(PSZ pszAttrText, SCRIPTERROR **pScriptError,
                         USHORT *usErrorTableSize, ULONG ulLineNumber);
    };



/*
 *@@ ScriptTitle class
 *  This class is used in ScriptPackage class and it contains datas used
 *  while creating title attribute.
 */
class ScriptTitle
    {
    USHORT              usIndex;

    CHAR                szTitle[MAXTITLELENGTH];

    public:
        ScriptTitle(USHORT usIndex = 1);
        ~ScriptTitle();

        void SetTitle(const CHAR szTitle[MAXTITLELENGTH]);

        void SetIndex(USHORT usIndex);

        const PSZ ReturnTitle();

        USHORT ReturnIndex();

        PSZ MakeScriptText(BOOL bAttribute = TRUE);

        PSZ BuildFromText(PSZ pszScriptText, SCRIPTERROR **pScriptError,
                         USHORT *usErrorTableSize, ULONG ulLineNumber);
    };



/*
 *@@ ScriptTarget class
 *  This class is used in ScriptPackage class and it contains datas used
 *  while creating target attribute.
 */
class ScriptTarget
    {
    USHORT              usIndex;

    CHAR                szTarget[CCHMAXPATH];

    public:
        ScriptTarget(USHORT usIndex = 1);
        ~ScriptTarget();

        void SetTarget(const CHAR szTarget[CCHMAXPATH]);

        void SetIndex(USHORT usIndex);

        const PSZ ReturnTarget();

        USHORT ReturnIndex();

        PSZ MakeScriptText(BOOL bAttribute = TRUE);

        PSZ BuildFromText(PSZ pszScriptText, SCRIPTERROR **pScriptError,
                         USHORT *usErrorTableSize, ULONG ulLineNumber);
    };



/*
 *@@ ScriptKeyWord class
 *  This class is used in ScriptPackage class and it contains datas used
 *  while creating keyword attribute.
 */
class ScriptKeyWord
    {
    USHORT              usIndex;

    BOOL                bBase;
    BOOL                bFixed;
    BOOL                bSelect;
    BOOL                bNoDeselect;

    public:
        ScriptKeyWord(USHORT usIndex = 1);
        ~ScriptKeyWord();

        void SetBase(BOOL bBase);
        void SetFixed(BOOL bFixed);
        void SetSelect(BOOL bSelect);
        void SetNoDeselect(BOOL bNoDeselect);
            // Old way. Sometimes usefull and is needed on some part of WicPM.
        void SetKeyWord(USHORT usKeyWords);

        void SetIndex(USHORT usIndex);

        BOOL ReturnBase();
        BOOL ReturnFixed();
        BOOL ReturnSelect();
        BOOL ReturnNoDeselect();
        USHORT ReturnKeyWord();

        USHORT ReturnIndex();

        PSZ MakeScriptText(BOOL bAttribute = TRUE, BOOL bLineFeed = FALSE);
    };




/*
 *@@ ScriptRequires class
 *  This class is used in ScriptPackage class and it contains datas used
 *  while creating requires attribute.
 */
class ScriptRequires
    {
    USHORT              usIndex;

    CHAR                szVendor[MAXVENDORNAMELENGTH];
    CHAR                szApplication[MAXAPPNAMELENGTH];
    CHAR                szPackage[MAXPCKNAMELENGTH];
    USHORT              usMajor;
    USHORT              usMinor;
    USHORT              usRevision;

    public:
        // Constructor for the class
        ScriptRequires(USHORT usIndex = 1);
        // Destructor for the class
        ~ScriptRequires();

        // Sets datas to strings
        void SetVendor(const CHAR szVendor[MAXVENDORNAMELENGTH]);
        void SetApplication(const CHAR szApplication[MAXAPPNAMELENGTH]);
        void SetPackage(const CHAR szPackage[MAXPCKNAMELENGTH]);
        void SetMajor(USHORT usMajor);
        void SetMinor(USHORT usMinor);
        void SetRevision(USHORT usRevision);
        void SetRequires(REQUIRESDATA requiresData);

        void SetIndex(USHORT usIndex);

        const PSZ ReturnVendor();
        const PSZ ReturnApplication();
        const PSZ ReturnPackage();
        USHORT ReturnMajor();
        USHORT ReturnMinor();
        USHORT ReturnRevision();
        REQUIRESDATA ReturnRequires();

        USHORT ReturnIndex();

        PSZ MakeScriptText(BOOL bShowAttribute = TRUE);
    };



/*
 *@@ ScriptConfigSys class
 *  This class is used in ScriptPackage class and it contains datas used
 *  while creating configsys attribute.
 */
class ScriptConfigSys
    {
    USHORT              usIndex;

    CHAR                szStatement[MAXSTATEMENTLENGTH];
    BOOL                bUnique;
    BOOL                bAddRight;
    BOOL                bAddLeft;
    BOOL                bAddTop;
    BOOL                bAddAfter;
    BOOL                bAddBefore;
    BOOL                bRemoveLine;
    BOOL                bRemovePart;
    CHAR                szSearchString[MAXSEARCHSTRINGLENGTH];

    public:
        ScriptConfigSys(USHORT usIndex = 1);
        ~ScriptConfigSys();

        void SetStatement(const CHAR szStatement[MAXSTATEMENTLENGTH]);
        USHORT SetUnique(BOOL bUnique);
        USHORT SetAddRight(BOOL bAddRight);
        USHORT SetAddLeft(BOOL bAddLeft);
        USHORT SetAddTop(BOOL bAddTop);
        USHORT SetAddAfter(BOOL bAddAfter);
        USHORT SetAddBefore(BOOL bAddBefore);
        USHORT SetRemoveLine(BOOL bRemoveLine);
        USHORT SetRemovePart(BOOL bRemovePart);
        void SetSearchString(const CHAR szSearchString[MAXSEARCHSTRINGLENGTH]);
        USHORT SetConfigSys(CONFIGSYSDATA configSys);

        void SetIndex(USHORT usIndex);

        const PSZ ReturnStatement();
        BOOL ReturnUnique();
        BOOL ReturnAddRight();
        BOOL ReturnAddLeft();
        BOOL ReturnAddTop();
        BOOL ReturnAddAfter();
        BOOL ReturnAddBefore();
        BOOL ReturnRemoveLine();
        BOOL ReturnRemovePart();
        const PSZ ReturnSearchString();
        CONFIGSYSDATA ReturnConfigSys();

        USHORT ReturnIndex();

        PSZ MakeScriptText(BOOL bAttribute = TRUE);

    };




/*
 *@@ ScriptRegisterClass class
 *  This class is used in ScriptPackage class and it contains datas used
 *  while creating register class attribute.
 */
class ScriptRegisterClass
    {
    USHORT              usIndex;

    CHAR                szClassName[MAXCLASSNAMELENGTH];
    CHAR                szDLLPath[CCHMAXPATH];

    public:
        ScriptRegisterClass(USHORT usIndex = 1);
        ~ScriptRegisterClass();

        void SetClassName(const CHAR szClassName[MAXCLASSNAMELENGTH]);
        void SetDLLPath(const CHAR szDLLPath[CCHMAXPATH]);
        void SetRegisterClass(REGISTERCLASSDATA registerClass);

        void SetIndex(USHORT usIndex);

        const PSZ ReturnClassName();
        const PSZ ReturnDLLPath();
        REGISTERCLASSDATA ReturnRegisterClass();

        USHORT ReturnIndex();

        PSZ MakeScriptText(BOOL bAttribute = TRUE);

    };



/*
 *@@ ScriptReplaceClass class
 *  This class is used in ScriptPackage class and it contains datas used
 *  while creating replace class attribute.
 */
class ScriptReplaceClass
    {
    USHORT              usIndex;

    CHAR                szClassName[MAXCLASSNAMELENGTH];
    CHAR                szNewClassName[MAXCLASSNAMELENGTH];

    public:
        ScriptReplaceClass(USHORT usIndex = 1);
        ~ScriptReplaceClass();

        void SetClassName(const CHAR szClassName[MAXCLASSNAMELENGTH]);
        void SetNewClassName(const CHAR szNewClassName[MAXCLASSNAMELENGTH]);
        void SetReplaceClass(REPLACECLASSDATA replaceClass);

        void SetIndex(USHORT usIndex);

        const PSZ ReturnClassName();
        const PSZ ReturnNewClassName();
        REPLACECLASSDATA ReturnReplaceClass();

        USHORT ReturnIndex();

        PSZ MakeScriptText(BOOL bAttribute = TRUE);

    };



/*
 *@@ ScriptCreateObject class
 *  This class is used in ScriptPackage class and it contains datas used
 *  while creating create object attribute.
 */
class ScriptCreateObject
    {
    USHORT              usIndex;

    CHAR                szClassName[MAXCLASSNAMELENGTH];
    CHAR                szTitle[MAXCLASSTITLELENGTH];
    CHAR                szLocation[CCHMAXPATH];
    CHAR                szConfig[MAXCLASSCONFIGLENGTH];
    BOOL                bReplace;

    public:
        ScriptCreateObject(USHORT usIndex = 1);
        ~ScriptCreateObject();

        void SetClassName(const CHAR szClassName[MAXCLASSNAMELENGTH]);
        void SetTitle(const CHAR szTitle[MAXCLASSTITLELENGTH]);
        void SetLocation(const CHAR szLocation[CCHMAXPATH]);
        void SetConfig(const CHAR szConfig[MAXCLASSCONFIGLENGTH]);
        void SetReplace(BOOL bReplace);
        void SetCreateObject(CREATEOBJECTDATA createObject);

        void SetIndex(USHORT usIndex);

        const PSZ ReturnClassName();
        const PSZ ReturnTitle();
        const PSZ ReturnLocation();
        const PSZ ReturnConfig();
        BOOL ReturnReplace();
        CREATEOBJECTDATA ReturnCreateObject();

        USHORT ReturnIndex();

        PSZ MakeScriptText(BOOL bAttribute = TRUE);

    };




/*
 *@@ ScriptExecute class
 *  This class is used in ScriptPackage class and it contains datas used
 *  while creating execute attribute.
 */
class ScriptExecute
    {
    USHORT              usIndex;

    CHAR                szExecFileParams[CCHMAXPATH];

    public:
        ScriptExecute(USHORT usIndex = 1);
        ~ScriptExecute();

        void SetExecFileParams(const CHAR szExecFileParams[CCHMAXPATH]);

        void SetIndex(USHORT usIndex);

        const PSZ ReturnExecFileParams();

        USHORT ReturnIndex();

        PSZ MakeScriptText(BOOL bAttribute = TRUE);

    };



/*
 *@@ ScriptProfile class
 *  This class is used in ScriptPackage class and it contains datas used
 *  while creating profile attribute.
 */
class ScriptProfile
    {
    USHORT              usIndex;

    CHAR                szProfileString[CCHMAXPATH];
    CHAR                szApplication[MAXPROFILEAPPLICATIONLENGTH];
    CHAR                szKey[MAXPROFILEKEYLENGTH];

    public:
        ScriptProfile(USHORT usIndex = 1);
        ~ScriptProfile();

        void SetProfileString(const CHAR szProfile[CCHMAXPATH]);
        void SetApplication(const CHAR szApplication[MAXPROFILEAPPLICATIONLENGTH]);
        void SetKey(const CHAR szKey[MAXPROFILEKEYLENGTH]);
        void SetProfile(PROFILEDATA profile);

        void SetIndex(USHORT usIndex);

        const PSZ ReturnProfileString();
        const PSZ ReturnApplication();
        const PSZ ReturnKey();
        PROFILEDATA ReturnProfile();

        USHORT ReturnIndex();

        PSZ MakeScriptText(BOOL bAttribute = TRUE);

    };




/*
 *@@ ScriptPackage class
 *  This class is used in ScriptPackage class and it contains datas used
 *  while creating package attribute. This class contains all other classes
 *  related to package. There are two different index ordering modes...
 */
class ScriptPackage
    {
    USHORT              usIndex;

        // Used when removing object from table. If TRUE object indexes are
        // automatically ordered.
        //  Ex. 0, 1, 2, 3, 4
        //  Number 3 is removed -> indexing: 0, 1, 2, 3
        //  New object -> indexing: 0, 1, 2, 3, 4
        //  => New object is now number 4.
        // If FALSE object indexes are not ordered.
        //  Ex. 0, 1, 2, 3, 4
        //  Number 3 is removed -> indexing: 0, 1, 2, 4
        //  New object -> indexing: 0, 1, 2, 4, 3
        //  => New object is now number 3.
    BOOL                bAllowIndexArrangement;

    ScriptIndex         Index;
    PSZ                 pszDescription;
    ScriptPackageID     PckID;
    ScriptTitle         Title;
    ScriptTarget        Target;
    ScriptKeyWord       KeyWords;

    ScriptRequires      *Requires;
    USHORT              usRequiresCount;

    ScriptConfigSys     *ConfigSys;
    USHORT              usConfigSysCount;

    ScriptRegisterClass *RegisterClass;
    USHORT              usRegisterClassCount;

    ScriptReplaceClass  *ReplaceClass;
    USHORT              usReplaceClassCount;

    ScriptCreateObject  *CreateObject;
    USHORT              usCreateObjectCount;

    ScriptExecute       *Execute;
    USHORT              usExecuteCount;

    ScriptProfile       *Profile;
    USHORT              usProfileCount;

    // Functions for finding of unused indexes.
    // Function for copying table to another table.
        // ScriptRequires
    ScriptRequires *CopyTable(ScriptRequires *DestTable, ScriptRequires *SrcTable,
        USHORT usSize, USHORT usSkipIndex = 0);
    void ReBuildIndexes(ScriptRequires *Table, USHORT usTableSize);
    USHORT FindUnusedIndex(ScriptRequires *Table, USHORT usTableSize);
         // ScriptConfigSys
    ScriptConfigSys *CopyTable(ScriptConfigSys *DestTable, ScriptConfigSys *SrcTable,
        USHORT usSize, USHORT usSkipIndex = 0);
    void ReBuildIndexes(ScriptConfigSys *Table, USHORT usTableSize);
    USHORT FindUnusedIndex(ScriptConfigSys *Table, USHORT usTableSize);
         // ScriptRegisterClass
    ScriptRegisterClass *CopyTable(ScriptRegisterClass *DestTable, ScriptRegisterClass *SrcTable,
        USHORT usSize, USHORT usSkipIndex = 0);
    void ReBuildIndexes(ScriptRegisterClass *Table, USHORT usTableSize);
    USHORT FindUnusedIndex(ScriptRegisterClass *Table, USHORT usTableSize);
         // ScriptReplaceClass
    ScriptReplaceClass *CopyTable(ScriptReplaceClass *DestTable, ScriptReplaceClass *SrcTable,
        USHORT usSize, USHORT usSkipIndex = 0);
    void ReBuildIndexes(ScriptReplaceClass *Table, USHORT usTableSize);
    USHORT FindUnusedIndex(ScriptReplaceClass *Table, USHORT usTableSize);
         // ScriptCreateObjectClass
    ScriptCreateObject *CopyTable(ScriptCreateObject *DestTable, ScriptCreateObject *SrcTable,
        USHORT usSize, USHORT usSkipIndex = 0);
    void ReBuildIndexes(ScriptCreateObject *Table, USHORT usTableSize);
    USHORT FindUnusedIndex(ScriptCreateObject *Table, USHORT usTableSize);
         // ScriptCreateObjectClass
    ScriptProfile *CopyTable(ScriptProfile *DestTable, ScriptProfile *SrcTable,
        USHORT usSize, USHORT usSkipIndex = 0);
    void ReBuildIndexes(ScriptProfile *Table, USHORT usTableSize);
    USHORT FindUnusedIndex(ScriptProfile *Table, USHORT usTableSize);
         // ScriptExecuteClass
    ScriptExecute *CopyTable(ScriptExecute *DestTable, ScriptExecute *SrcTable,
        USHORT usSize, USHORT usSkipIndex = 0);
    void ReBuildIndexes(ScriptExecute *Table, USHORT usTableSize);
    USHORT FindUnusedIndex(ScriptExecute *Table, USHORT usTableSize);
    public:
        ScriptPackage(USHORT usIndex = 1, BOOL bAllowIndexArrangement = FALSE);
        ~ScriptPackage();
        // Copy constructor. Needed when adding, removing or moving objects
        // because this class uses dynamic memory management.
        ScriptPackage(ScriptPackage &);
        // Assignment operator. Needed when adding, removing or moving objects.
        ScriptPackage &operator=(const ScriptPackage &);

        USHORT SetDescription(const PSZ pszDescription);
        //SetPackageData(PACKAGEDATA package);

        void SetIndex(USHORT usIndex);

        const PSZ ReturnDescription();
        //PACKAGEDATA ReturnPackageData();

        void SetPackageIndex(USHORT usPckIndex);
        void SetPackageID(PACKAGEIDDATA);
        void SetTitle(const CHAR szTitle[MAXTITLELENGTH]);
        void SetTarget(const CHAR szTarget[MAXTARGETLENGTH]);
        void SetKeyWords(USHORT usKeyWords);
        ScriptIndex *ReturnPackageIndex();
        ScriptPackageID *ReturnPackageIDObject();
        ScriptTitle *ReturnTitleObject();
        ScriptTarget *ReturnTargetObject();
        ScriptKeyWord *ReturnKeyWordObject();

        USHORT ReturnIndex();

        PSZ MakeScriptText(BOOL bAttribute = TRUE);

        // Build package accordingly to pszScriptText. If there is any errors
        // in script text, error information is returned in *pScriptError table.
        PSZ BuildFromText(PSZ pszScriptText, SCRIPTERROR **pScriptError,
                         USHORT *usErrorTableSize, ULONG ulLineNumber);

        // Functions for handling of requires class
            // Creates new implementation of ScriptRequiresClass and returns
            // pointer to the new object.
        ScriptRequires *CreateRequiresObject();
        ScriptRequires *CreateRequiresObject(REQUIRESDATA requiresData);
            // Returns address of ScriptRequires object which index is usIndex.
        ScriptRequires *ReturnRequiresObject(USHORT usIndex);
            // Deletes ScriptRequires object which index is usIndex.
        USHORT DeleteRequiresObject(USHORT usIndex);
            // Deletes ScriptRequires object which address is
            // *ScriptRequiresClass.
        USHORT DeleteRequiresObject(ScriptRequires *ScriptRequiresObject);
            // Returns how many ScriptRequires objectes belongs to ScriptPackage
            // (this) object.
        USHORT ReturnRequiresObjectCount();



        // Functions for handling of configsys object
            // Creates new implementation of ScriptConfigSys and returns
            // pointer to the new object.
        ScriptConfigSys *CreateConfigSysObject();
         ScriptConfigSys *CreateConfigSysObject(CONFIGSYSDATA data);
            // Returns address of ScriptConfigSys object which index is usIndex.
        ScriptConfigSys *ReturnConfigSysObject(USHORT usIndex);
            // Deletes ScriptConfigSys object which index is usIndex.
        USHORT DeleteConfigSysObject(USHORT usIndex);
            // Deletes ScriptConfigSys object which address is
            // *ScriptConfigSysObject.
        USHORT DeleteConfigSysObject(ScriptConfigSys *ScriptConfigSysObject);
            // Returns index of object which address is *ScriptConfigSysObject.
        USHORT ReturnIndexOfConfigSysObject(ScriptConfigSys *ScriptConfigSysObject);
            // Returns how many ScriptConfigSys objectes belongs to ScriptPackage
            // (this) object.
        USHORT ReturnConfigSysObjectCount();



        // Functions for handling of register object
            // Creates new implementation of ScriptRegisterClass and returns
            // pointer to the new object.
        ScriptRegisterClass *CreateRegisterClassObject();
        ScriptRegisterClass *CreateRegisterClassObject(REGISTERCLASSDATA data);
            // Returns address of ScriptRegisterClass object which index is
            // usIndex.
        ScriptRegisterClass *ReturnRegisterClassObject(USHORT usIndex);
            // Deletes ScriptRegisterClass object which index is usIndex.
        USHORT DeleteRegisterClassObject(USHORT usIndex);
            // Deletes ScriptRegisterClass object which address is
            // *ScriptRegisterClassObject.
        USHORT DeleteRegisterClassObject(ScriptRegisterClass
                                        *ScriptRegisterClassObject);
            // Returns how many ScriptRegisterClass objectes belongs to ScriptPackage
            // (this) object.
        USHORT ReturnRegisterClassObjectCount();



        // Functions for handling of replace object
            // Creates new implementation of ScriptReplaceClass and returns
            // pointer to the new object.
        ScriptReplaceClass *CreateReplaceClassObject();
        ScriptReplaceClass *CreateReplaceClassObject(REPLACECLASSDATA data);
            // Returns address of ScriptReplaceClass object which index is
            // usIndex.
        ScriptReplaceClass *ReturnReplaceClassObject(USHORT usIndex);
            // Deletes ScriptReplaceClass object which index is usIndex.
        USHORT DeleteReplaceClassObject(USHORT usIndex);
            // Deletes ScriptReplaceClass object which address is
            // *ScriptReplaceClassObject.
        USHORT DeleteReplaceClassObject(ScriptReplaceClass
                                      *ScriptReplaceClassObject);
            // Returns how many ScriptReplaceClass objectes belongs to ScriptPackage
            // (this) object.
        USHORT ReturnReplaceClassObjectCount();



        // Functions for handling of create object object
            // Creates new implementation of ScriptCreateObject and returns
            // pointer to the new object.
        ScriptCreateObject *CreateCreateObjectObject();
        ScriptCreateObject *CreateCreateObjectObject(CREATEOBJECTDATA data);
            // Returns address of ScriptCreateObject object which index is
            // usIndex.
        ScriptCreateObject *ReturnCreateObjectObject(USHORT usIndex);
            // Deletes ScriptCreateObject object which index is usIndex.
        USHORT DeleteCreateObjectObject(USHORT usIndex);
            // Deletes ScriptCreateObject object which address is
            // *ScriptCreateObjectObject.
        USHORT DeleteCreateObjectObject(ScriptCreateObject
                                      *ScriptCreateObjectObject);
            // Returns how many ScriptCreateObject objectes belongs to ScriptPackage
            // (this) object.
        USHORT ReturnCreateObjectObjectCount();



        // Functions for handling of execute object
            // Creates new implementation of ScriptExecute and returns
            // pointer to the new object.
        ScriptExecute *CreateExecuteObject();
        ScriptExecute *CreateExecuteObject(PSZ pszExecute);
            // Returns address of ScriptExecute object which index is
            // usIndex.
        ScriptExecute *ReturnExecuteObject(USHORT usIndex);
            // Deletes ScriptExecute object which index is usIndex.
        USHORT DeleteExecuteObject(USHORT usIndex);
            // Deletes ScriptExecute object which address is
            // *ScriptExecuteObject.
        USHORT DeleteExecuteObject(ScriptExecute
                                  *ScriptExecuteObject);
            // Returns how many ScriptCreateObject objectes belongs to ScriptPackage
            // (this) object.
        USHORT ReturnExecuteObjectCount();



        // Functions for handling of profile object
            // Creates new implementation of ScriptProfile and returns
            // pointer to the new object.
        ScriptProfile *CreateProfileObject();
        ScriptProfile *CreateProfileObject(PROFILEDATA data);
            // Returns address of ScriptProfile object which index is
            // usIndex.
        ScriptProfile *ReturnProfileObject(USHORT usIndex);
            // Deletes ScriptProfile object which index is usIndex.
        USHORT DeleteProfileObject(USHORT usIndex);
            // Deletes ScriptProfile object which address is
            // *ScriptProfileObject.
        USHORT DeleteProfileObject(ScriptProfile
                                  *ScriptProfileObject);
            // Returns how many ScriptCreateObject objectes belongs to ScriptPackage
            // (this) object.
        USHORT ReturnProfileObjectCount();

        };




/*
 *@@ ScriptGroup class
 *  This class is used in ScriptHead class and it contains datas used
 *  while creating group tag. This class contains all other classes
 *  related to group attribute including package. ScriptGroup object with
 *  bVirtualGroup TRUE is invisible which means that virtual group does not
 *  make any changes to script text in contrast it delegates work to subclass
 *  and package objects. Virtual group is like super group which includes all
 *  other groups and packages. Usually there is only one virtual group per
 *  WarpINScript class or ScriptHead class. There is always atleast one virtual
 *  group per ScriptHead class.
 */
class ScriptGroup
    {
    USHORT              usIndex;

    CHAR                szPageTitle[MAXPAGETITLELENGTH];
    BOOL                bExpanded;
    ScriptGroup         *SubGroup;
    USHORT              usSubGroupCount;
    ScriptPackage       *Package;
    USHORT              usPackageCount;
    BOOL                bVirtualGroup;

    public:
        ScriptGroup(USHORT usIndex = 1, BOOL bVirtualGroup = FALSE);
        ~ScriptGroup();
        ScriptGroup(const ScriptGroup &);
        ScriptGroup &operator=(const ScriptGroup &);

        SetPageTitle(const CHAR szPageTitle[MAXPAGETITLELENGTH]);
        SetExpanded(BOOL bExpanded);

        SetIndex(USHORT usIndex);

        PSZ ReturnPageTitle() const;
        BOOL ReturnExpanded();

        USHORT ReturnIndex();

        PSZ MakeScriptText(BOOL bTag = TRUE);


        // Functions for handling of package class
            // Creates new implementation of ScriptPackage and returns
            // pointer to the new class.
        ScriptPackage *CreatePackageObject();
            // Returns address of ScriptPackage class which index is
            // usIndex.
        ScriptPackage *ReturnPackageObject(USHORT usIndex);
            // Deletes ScriptPackage class which index is usIndex.
        USHORT DeletePackageObject(USHORT usIndex);
            // Deletes ScriptPackage class which address is
            // *ScriptPackageObject.
        USHORT DeletePackageObject(ScriptPackage
                                  *ScriptPackageObject);
            // Returns index of class which address is *ScriptPackageObject.
        USHORT ReturnIndexOfPackageObject(ScriptPackage
                                        *ScriptPackageObject);
            // Returns how many ScriptPackage classes belong to ScriptGroup
            // (this) class.
        USHORT CountOfPackageObject();
            // Moves *PackageObject to *GroupObject.
        USHORT MovePackageObjectToGroupObject(ScriptPackage *PackageObject,
                                            ScriptGroup *GroupObject);

    };




/*
 *@@ ScriptTitleTag class
 *  This class is used in head class and it contains datas used
 *  while creating title tag. This class does not contain other classes.
 */
class ScriptTitleTag
    {
    USHORT              usIndex;

    CHAR                szTitle[MAXTITLELENGTH];

    public:
        ScriptTitleTag(USHORT usIndex = 1);
        ~ScriptTitleTag();

        SetTitle(const CHAR szTitle[MAXTITLELENGTH]);

        SetIndex(USHORT usIndex);

        const PSZ ReturnTitle();

        USHORT ReturnIndex();

        PSZ MakeScriptText(BOOL bTag = TRUE);

    };


/*
 *@@ ScriptMessageTag class
 *  This class is used in head class and it contains datas used
 *  while creating message tag. This class does not contain other classes.
 */
class ScriptMessageTag
    {
    USHORT              usIndex;

    CHAR                szMessage[MAXMESSAGELENGTH];

    public:
        ScriptMessageTag(USHORT usIndex = 1);
        ~ScriptMessageTag();

        SetMessage(const CHAR szMessage[MAXMESSAGELENGTH]);

        SetIndex(USHORT usIndex);

        const PSZ ReturnMessage();

        USHORT ReturnIndex();

        PSZ MakeScriptText(BOOL bTag = TRUE);

    };



/*
 *@@ ScriptHead class
 *  This class is used in WarpINScript class and it contains datas used
 *  while creating head tag. This class contains all other classes
 *  related to head attribute including group, title and message. Although
 *  script does not necessarily contains GROUP tag all ScriptHead classes
 *  contains virtual group. Virtual group is abstract group which contains all
 *  other groups and packages. Virtual group does not add any group tags to
 *  script text. It delegates work to real group classes and package classes.
 *  So all packages and groups can be found from VirtualGroup class.
 */
class ScriptHead
    {
    USHORT              usIndex;

    ScriptMessageTag    Message;
    ScriptTitleTag      Title;
    ScriptGroup         VirtualGroup;

    public:
        ScriptHead(USHORT usIndex);
        ~ScriptHead();

        SetIndex(USHORT usIndex);

        ScriptMessageTag ReturnMessageTagObject();
        ScriptTitleTag ReturnTitleTagObject();
        ScriptGroup ReturnVirtualGroup();

        USHORT ReturnIndex();

        PSZ MakeScriptText(BOOL bTag = TRUE);

    };




/*
 *@@ ScriptNextButton class
 *  This class is used in page class and it contains datas used
 *  while creating nextbutton tag. This class does not contain other classes.
 */
class ScriptNextButton
    {
    USHORT              usIndex;

    USHORT              usTarget;
    CHAR                szNextButtonText[MAXNEXTBTNTEXTLENGTH];

    public:
        ScriptNextButton(USHORT usIndex = 1);
        ~ScriptNextButton();

        SetTarget(USHORT usTarget);
        SetNextButtonText(const CHAR szNextButtonText[MAXNEXTBTNTEXTLENGTH]);
        SetIndex(USHORT usIndex);

        USHORT ReturnTarget();
        const PSZ ReturnNextButtonText();

        USHORT ReturnIndex();

        PSZ MakeScriptText(BOOL bTab = TRUE);

    };




/*
 *@@ ScriptText class
 *  This class is used in page class and it contains datas used
 *  while creating text tag. This class does not contain other classes.
 */
class ScriptText
    {
    USHORT              usIndex;

    CHAR                szText[MAXPAGETEXTLENGTH];

    public:
        ScriptText(USHORT usIndex = 1);
        ~ScriptText();

        SetText(const CHAR szText[MAXPAGETEXTLENGTH]);

        SetIndex(USHORT usIndex);

        const PSZ ReturnText();

        USHORT ReturnIndex();

        PSZ MakeScriptText(BOOL bTag = TRUE);

    };



/*
 *@@ ScriptReadMe class
 *  This class is used in page class and it contains datas used
 *  while creating readme tag. This class does not contain other classes.
 */
class ScriptReadMe
    {
    USHORT              usIndex;

    PSZ                 pszReadMe;

    public:
        ScriptReadMe(USHORT usIndex = 1);
        ~ScriptReadMe();

        SetIndex(USHORT usIndex);

        SetReadMe(const PSZ pszReadMe);
        const PSZ ReturnReadMe();

        USHORT ReturnIndex();

        PSZ MakeScriptText(BOOL bTag = TRUE);

    };





/*
 *@@ ScriptPage class
 *  This class is used in head class and it contains datas used
 *  while creating page tag. This class contains other classes such as readme,
 *  text and nextbutton.
 */
class ScriptPage : public BSRoot
    {
        protected:
            virtual clsid QueryClsId()
            {
                static clsid   id = RegisterClass("ScriptPage");
                return (id);
            }

    private:
    USHORT              usIndex;

    USHORT              usPageIndex;
    USHORT              usPageType;     // Types:
                                        //  PAGE_TYPES_TEXT
                                        //  PAGE_TYPES_README
                                        //  PAGE_TYPES_CONTAINER
                                        //  PAGE_TYPES_CONFIGURE
    ScriptNextButton    NextButton;
    ScriptReadMe        ReadMe;
    ScriptText          Text;

    public:
        ScriptPage(USHORT usIndex = 1);
        ~ScriptPage();

        SetPageIndex(USHORT usPageIndex);
        SetPageType(USHORT usPageType);

        SetIndex(USHORT usIndex);

        USHORT ReturnPageIndex();
        USHORT ReturnPageType();

        ScriptNextButton &ReturnNextButton();
        ScriptReadMe &ReturnReadMe();
        ScriptText &ReturnText();

        USHORT ReturnIndex();

        PSZ MakeScriptText(BOOL bTag = TRUE);

    };




/*
 *@@ ScriptBody class
 *  This class is used in WarpINScript class and it contains datas used
 *  while creating body tag. This class contains page class.
 */
class ScriptBody
    {
    USHORT              usIndex;

    ScriptPage          *Page;
    USHORT              usPageCount;

    public:
        ScriptBody(USHORT usIndex = 1);
        ~ScriptBody();

        // Functions for handling of page class
            // Creates new implementation of ScriptPage and returns
            // pointer to the new class.
        ScriptPage *CreatePageObject();
            // Returns address of ScriptPage class which index is
            // usIndex.
        ScriptPage *ReturnPageObject(USHORT usIndex);
            // Deletes ScriptPage class which index is usIndex.
        USHORT DeletePageObject(USHORT usIndex);
            // Deletes ScriptPage class which address is
            // *ScriptPageObject.
        USHORT DeletePageObject(ScriptPage
                              *ScriptPageObject);
            // Returns index of class which address is *ScriptPageObject.
        USHORT ReturnIndexOfPageObject(ScriptPage
                                     *ScriptPageObject);
            // Returns how many ScriptPage classes belong to ScriptBody
            // (this) class.
        USHORT CountOfPageObject();

        SetIndex(USHORT usIndex);

        USHORT ReturnIndex();

        PSZ MakeScriptText(BOOL bTag = TRUE);

    };



/*
 *@@ ScriptVersion class
 *  This class is used in WarpINScript class and it contains datas used
 *  while creating version attribute. This class contains no other classes.
 */
class ScriptVersion
    {
    USHORT              usIndex;

    USHORT              usMajor;
    USHORT              usMinor;

    public:
        ScriptVersion(USHORT usIndex = 1);
        ~ScriptVersion();

        SetMajor(USHORT usMajor);
        SetMinor(USHORT usMinor);

        SetIndex(USHORT usIndex);

        USHORT ReturnMajor();
        USHORT ReturnMinor();

        USHORT ReturnIndex();

        PSZ MakeScriptText(BOOL bAttribute = TRUE);

    };




/*
 *@@ ScriptOS class
 *  This class is used in WarpINScript class and it contains datas used
 *  while creating operating system attribute. This class contains no other
 *  classes.
 */
class ScriptOS
    {
    USHORT              usIndex;

    CHAR                szOS[MAXOPERATIGSYSTEMLENGTH];

    public:
        ScriptOS(USHORT usIndex = 1);
        ~ScriptOS();

        SetOS(const CHAR szOS[MAXOPERATIGSYSTEMLENGTH]);

        SetIndex(USHORT usIndex);

        const PSZ ReturnOS();

        USHORT ReturnIndex();

        PSZ MakeScriptText(BOOL bAttribute = TRUE);

    };




/*
 *@@ WarpINScript class
 *  This class is WarpIN script handling class and it is used in WicPM. The
 *  implementation of this class is relative to real word WarpNI script.
 *  Only one implementation of this class is needed per WarpIN archive.
 */
class WarpINScript
    {
    ScriptOS            OS;
    ScriptVersion       Version;
    ScriptHead          Head;
    ScriptBody          Body;


    public:
        WarpINScript();
        ~WarpINScript();

        ScriptOS *ReturnOSObject();
        ScriptVersion *ReturnVersionObject();
        ScriptHead *ReturnHeadObject();
        ScriptBody *ReturnBodyObject();

        PSZ MakeScriptText(BOOL bTag = TRUE);

    };




#endif
