/*
 * gui_wicpm.h
 *  Header file for gui_wicpm.c
 *
 *  This file contains declarations wich are platform-specific, in
 *  this case specific to OS/2 Presentation Manager (PM).
 *
 *  Copyright (C) 1999-2000 Teemu Ahola.
 *
 */


#ifndef _GUI_WICPM_H_
#define _GUI_WICPM_H_

#define SPLITBARPOSITIONPERCENTS    60
#define SPLITBARLEFTPOSLIMIT        10
#define SPLITBARRIGHTPOSLIMIT       10




/* MAINWINDOWINFO
 *  General window info structure for storing windows information
 */
typedef struct _MAINWINDOWINFO
    {
    HAB             hab;                            // Handle to an anchor block.
    HWND            hwndMainWnd;                    // Main window handler.
    HWND            hwndMainWndClient;              // Main wnd client handler.
    HWND            hwndMainMenu;                   // The handler of the main menu.
    HWND            hwndSplitWindow;                // Split window handler.
    HWND            hwndObjectWnd;                  // Object window handler.
    CONTAINERINFO   pckContainerInfo;               // Package container info.
    CONTAINERINFO   fileContainerInfo;              // File container info.
    CHAR            szArchiveName[CCHMAXPATH];      // Archive name.
    CHAR            szScriptFileName[CCHMAXPATH];   // Script file name.
    SPLITBARCDATA   mainWndSBarData;                // Main wnd splitbar data structure.
    PLINKLIST       plPackageList;                  // The list of the packages.
    ScriptWarpIN    WarpIN;
    //ScriptGroup     Group;
    TID             tidArchiveThread;

    _MAINWINDOWINFO()
        {
        plPackageList = lstCreate(TRUE);
        }

    } MAINWINDOWINFO, *PMAINWINDOWINFO;

typedef struct
    {
    PAPSZ   papszFQFileName;
    ULONG   ulFQFCount;
    } FILENAMETABLE, *PFILENAMETABLE;


typedef struct _TRADWINPOSDATA
    {
    SWP                 swpMainWindow;
    SWP                 swpAddPckDlg;
    } TRADWINPOSDATA, *PTRADWINPOSDATA;



/*@@WICPMINFO
 *  General window info structure for storing windows information
 */
struct _WICPMINFO
    {
    HAB                 hab;                        // Handle to an anchor block.
    HMQ                 hmq;                        // Message queue handler.
    USHORT              usMode;                     // WicPM mode.
    NLSSTRINGS          nlsStrings;                 // NLS string structure.
    OBJWNDTHREADINFO    objWndThreadInfo;           // Obj wnd thread info structure.
    HWND                hwndMainWnd;                // Main wnd handler.
    HEV                 hevEventMainWndInited;      // The handle of the event semaphore.
    PID                 pidObjWndThread;            // Obj wnd thread ID.
    CHAR                szArchiveFile[CCHMAXPATH];  // Archive to be opened.
    CHAR                szWicPMPath[CCHMAXPATH];    // WicPM.exe path from os2.ini.
    TRADWINPOSDATA      winPos;

    /*@@_WICPMINFO()
     * Constructor.
     *
     */
    _WICPMINFO()
        {
        hab = 0;
        hmq = 0;
        usMode = 0;
        hwndMainWnd = NULLHANDLE;
        *szArchiveFile = '\0';
        strcpy(szWicPMPath, "e:\\testi");
        }
    };
typedef _WICPMINFO WICPMINFO, *PWICPMINFO;

struct StatusDlgInfo
    {
    PID                 tidArcThread;
    HEV                 hevStatusDlgReady;
    PSZ                 pszArchiveFile;
    };




USHORT guiBeginTraditionalMode(HAB, HWND, CHAR [CCHMAXPATH], HEV, HWND *, HMQ *);
USHORT guiInitialize(HAB, USHORT, NLSSTRINGS, HMQ *);
PID guiInitializeObjWndThread(POBJWNDTHREADINFO);
USHORT guiClearUp(PWICPMINFO pWicPMInfo);
DBPackage *FindDBPckItem(PLINKLIST plPackageList, USHORT usIndex);


// Global variables.
extern NLSSTRINGS G_nlsStringTable;


#endif

