/*
 * gui_trad_cntr.h
 *  Header file for gui_trad_cntr.cpp
 *
 *  Copyright (C) 1999-2000 Teemu Ahola.
 *
 */



#ifndef _GUI_TRAD_CNTR_H_
#define _GUI_TRAD_CNTR_H_


// Return values for functions.
#define RET_CNTR_OK                 0
#define RET_CNTR_NULLPOINTERERROR   1
#define RET_CNTR_MEMALLOCERROR      2

// Column count of the containers.
#define CONT_COLUMN_PCK             8
#define CONT_COLUMN_FILE            4
#define CONT_COLUMN_PAGE            2



typedef struct _CONTAINERINFO
    {
    PSZ             pszContainerTitle;
    PFIELDINFO      pFieldInfo;
    PVOID           pvSelectedRecords;
    HWND            hwndContextMenu;
    HWND            hwndContainer;
    ULONG           ulColumns;

    _CONTAINERINFO()
        {
        pszContainerTitle = NULL;
        pFieldInfo = NULL;
        pvSelectedRecords = NULL;
        hwndContextMenu = NULL;
        hwndContainer = NULL;
        ulColumns = 0;
        }
    } CONTAINERINFO, *PCONTAINERINFO;


/* PCKRECORD:
 *  Extended record core. This is used on the package container.
 *
 */
typedef struct _PCKRECORD
    {
    RECORDCORE  recordCore;                     // Standard record core.

    SHORT       sPackage;                       // The number of the package.

    PSZ         pszAuthor;                      // Author information (usually name)
    PSZ         pszApplication;                 // Application name.

    PSZ         pszPackageName;
    PSZ         pszVersion;                     // Pointer to szVersion.
    PSZ         pszTargetPath;                  // Default target path.
    ULONG       ulFiles;                        // Number of files in package.
    ULONG       ulTotalSize;                    // Size of the packages files.

    /*_PCKRECORD()
        {
        sPackage = 0;
        pszAuthor = NULL;
        pszApplication = NULL;
        pszPackageName = NULL;
        pszVersion = szVersion;
        ulFiles = 0;
        ulTotalSize = 0;
        pszTargetPath = NULL;
        szVersion[0] = '\0';
        }*/
    } PCKRECORD, *PPCKRECORD;


typedef struct DBFile : public BSRoot
    {
        public:
            DECLARE_CLASS(DBFile);

        public:
            CHAR szFileName[CCHMAXPATH];
            CHAR szFilePath[CCHMAXPATH];
            CHAR szFileInstallPath[CCHMAXPATH];
            ULONG ulFileSize;

            DBFile() : BSRoot(tDBFile)
                {
                *szFileName = '\0';
                *szFilePath = '\0';
                *szFileInstallPath = '\0';
                ulFileSize = 0;
                }
    };


/* FILERECORD:
 *  Extended record core. This is used on the file container to
 *  store information about packages files.
 */
typedef struct _FILERECORD
    {
    RECORDCORE      recordCore;             /* Standard record core */

    PSZ             pszFileName;
    PSZ             pszFilePath;
    PSZ             pszFileInstallPath;
    ULONG           ulFileSize;
    DBFile          *pDBFile;               // Pointer to corresponding DBFile structure.
    } FILERECORD, *PFILERECORD;




/* PAGERECORD:
 *  Extended record core. This is used on the page container to
 *  store information about script pages.
 */
typedef struct
    {
    RECORDCORE      recordCore;             /* Standard record core */

    USHORT          usPageIndex;
    PSZ             pszPageType;
    } PAGERECORD, *PPAGERECORD;




/*@@DBPackage
 *  A struct for package information used when archive is being built or
 *  package container is being filled.
 */
typedef struct DBPackage : public BSRoot
    {
        public:
            DECLARE_CLASS(DBPackage);

        public:
            USHORT usPckIndexAttr;  // The index attribute of the related package
                                    // in the script. We cannot use pointer to ScritPackage
                                    // class because all ScriptPackage objects are in table
                                    // so if object is added to the table, all pointers should
                                    // be updated.
            CHAR szPackageID[MAXPCKNAMELENGTH];
            CHAR szApplication[MAXAPPNAMELENGTH];
            CHAR szAuthor[MAXVENDORNAMELENGTH];
            CHAR szVersion[MAXVERSIONLENGTH];
            CHAR szPath[CCHMAXPATH];
            ULONG ulFiles;
            ULONG ulTotalSize;
            PLINKLIST plFileList;   // The list of the files which belongs to this package.

            DBPackage() : BSRoot(tDBPackage)
                {
                usPckIndexAttr = 0;
                *szPackageID = '\0';
                *szApplication = '\0';
                *szAuthor = '\0';
                *szVersion = '\0';
                *szPath = '\0';
                ulFiles = 0;
                ulTotalSize = 0;
                plFileList = lstCreate(TRUE);
                }
            ~DBPackage()
                {
                lstFree(&plFileList);
                }
    };




INT guiInitializePckContainer(PCONTAINERINFO pContainerInfo, PNLSSTRINGS pStrings);
INT guiInitializeFileContainer(PCONTAINERINFO pContainerInfo, PNLSSTRINGS pStrings);
INT guiInitializePageContainer(PCONTAINERINFO pContainerInfo, PNLSSTRINGS pStrings);
USHORT guiSetPckContainerRecords(HWND hwndContainer, PLINKLIST plDBPck);
USHORT guiUpdatePckContRecord(HWND hwndContainer, PPCKRECORD pPckRecord,
    DBPackage *pDBPck, BOOL bInvalidate);
USHORT guiSetFileContainerRecords(HWND hwndContainer, PLINKLIST plDBFile);
USHORT guiSetPageContainerRecords(HWND, list<ScriptPage*> *, USHORT);
USHORT guiUpdatePageContRecord(HWND hwndContainer, PPAGERECORD pPageRecord,
                               ScriptPage *pPage, BOOL bInvalidate);
USHORT guiRemoveContainerRecords(HWND hwndContainer, PVOID pvRecords, SHORT sRecords);

#endif
