/******************************************************************************
 *@@sourcefile WIURL.hpp:
 *      Header file for WIURL.cpp.
 *
 *@@include #include "net\WIURL.hpp"
 */

#ifndef WIURL_HPP_INCLUDED
#define WIURL_HPP_INCLUDED

#include <os2.h>
#include "base/bs_string.h"
#include "base/bs_errors.h"

/******************************************************************************
 *@@ WIURL:
 *      <P>Class to store server name, server port and document path as
 *      separate data fields.
 */

class WIURL
{
  friend class WINet;
  private:
    BOOL   _fIsEmpty;
    PSZ    _pszServerName;
    USHORT _usAddressLength;
    PSZ    _pszServerAddress;
    USHORT _usServerPort;
    PSZ    _pszDocumentPath;
  public:
    WIURL();
    WIURL(PCSZ pcszURL);
    WIURL(const WIURL& wiURL);
   ~WIURL();

    BOOL   IsEmpty()          const { return _fIsEmpty;         }
    PCSZ   GetServerName()    const { return _pszServerName;    }
    PCSZ   GetServerAddress() const { return _pszServerAddress; }
    USHORT GetAddressLength() const { return _usAddressLength;  }
    USHORT GetServerPort()    const { return _usServerPort;     }
    PCSZ   GetDocumentPath()  const { return _pszDocumentPath;  }
  protected:
    VOID   SetServerAddress(PCSZ pcszServerAddress, USHORT usAddressLength);
};

/******************************************************************************
 *@@ WIInvalidURLException:
 *      <P>This exception is thrown by <CODE>WIURL::WIURL(PCSZ pcszURL)</CODE>
 *
 *      <CODE>_strDescription</CODE> contains <CODE>pcszURL</CODE> and
 *      an error description.
 */

class WIInvalidURLException : public BSExcptBase
{
  public:
    WIInvalidURLException() { _strDescription = "WIInvalidURLException"; }
    WIInvalidURLException(const WIInvalidURLException& wiInvURLExc)
                            { _strDescription = wiInvURLExc._strDescription; }
};

#endif // not WIURL_HPP_INCLUDED
