#ifndef WISOCKET_HPP_INCLUDED
#define WISOCKET_HPP_INCLUDED

#include <os2.h>

#include <stdio.h>

typedef enum
{
  socket_Success = 0,
  socket_Error_Not_Connected,
  socket_Error_Already_Connected,
  socket_DNS_Lookup_Error,
  socket_Socket_Creation_Error,
  socket_Connect_Error,
  socket_Read_Error
} socket_Error;

class Socket
{
  private:
    bool  bIsConnected;
    int   iSocket;
    FILE *sockIn;
    FILE *sockOut;
  public:
    Socket();
   ~Socket(void);

    socket_Error Connect(const char *hostaddress,
                         unsigned short int addresslength,
                         unsigned short int port);
    socket_Error Disconnect(void);
    socket_Error ReadLine(char *buffer, int bufsize);
    socket_Error ReadChar(char *buffer);
    socket_Error ReadBytes(char *buffer, size_t buflen, size_t* bytesRead);
    socket_Error Printf(const char* format, ...);
};

#endif // not WISOCKET_HPP_INCLUDED
