/******************************************************************************
 *@@sourcefile WIP_HTTP.hpp:
 *      Document me!
 *
 *@@include #include "net\WIP_HTTP.hpp"
 */

#ifndef WIP_HTTP_HPP_INCLUDED
#define WIP_HTTP_HPP_INCLUDED

#include "net\WIProtocol.hpp"
#include "net\WIP_HTTP_Response.hpp"
#include "net\WISocket.hpp"

/******************************************************************************
 *@@ WIP_HTTP:
 *  Class for HTTP encapsulating.
 *  <BR>The abbreviation LWS that can be seen in some places means
 *  Linear White Space and denominates a (possibly mixed) sequence
 *  of spaces (SP) and horizontal tabs (HT). It may include a CLRF
 *  at the begin.
 */

class WIP_HTTP : public WIProtocol
{
  private:
    Socket _socket;
    PCSZ   _pcszSavefileName;
  public:
    WIP_HTTP(WINet* pwiNet);
   ~WIP_HTTP() {}

    BOOL Fetch(WIURL& wiURL, PCSZ pcszSavefileName, BOOL fResume);
  private:
    BOOL GET_Method(WIURL& wiURL);

    WIP_HTTP_Response
         WriteRequest(Socket& socket, WIURL& wiURL, PCSZ pcszMethod);

    BOOL OpenFile(PHFILE phFile, ULONG ulFileSize);
    BOOL FetchToFile(const WIP_HTTP_Response& response, HFILE hFile,
                     const WIURL& wiURL);
    BOOL CloseFile(HFILE hFile);
};

#endif // not WIP_HTTP_HPP_INCLUDED
