
/*
 * gui.h:
 *      header file for gui.c.
 *
 *      This contains only declarations which are platform-specific,
 *      in this case specific to OS/2 Presentation Manager (PM).
 *      warpin.cpp does not see this file. Required GUI callbacks
 *      are therefore declared in calbacks.h instead.
 *
 *      Dialog ID's shared with the resource compiler are now in
 *      dlgids.h (99-10-24) [umoeller].
 *
 *      Copyright (C) 1999-2002 Ulrich Mller.
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation, in version 2 as it comes in the COPYING
 *      file of this distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

#ifndef WARPIN_GUI_HEADER_INCLUDED     // added (99-10-24) [umoeller]
    #define WARPIN_GUI_HEADER_INCLUDED

    /* ******************************************************************
     *
     *  Forward declarations
     *
     ********************************************************************/

    class FEJobBase;

    /* ******************************************************************
     *
     *  WarpIN setup
     *
     ********************************************************************/

    #define WPOBJID_WARPINFOLDER    "<WARPIN_FOLDER>"   // (99-10-22) [umoeller]
    #define WPOBJID_WARPINEXE       "<WARPIN_EXE>"      // (99-10-22) [umoeller]
    #define WPOBJID_WARPINUSERGUIDE "<WARPIN_USERGUIDE>" // V0.9.1 (2000-02-08) [umoeller]
    #define WPOBJID_WARPINPROGGUIDE "<WARPIN_PROGGUIDE>" // V0.9.1 (2000-02-08) [umoeller]

    // OS2.INI application for WarpIN
    #define INIAPP_WARPIN           "WarpIN"            // (99-10-24) [umoeller]
    #define INIKEY_WARPINPATH       "Path"              // (99-10-24) [umoeller]

    /* ******************************************************************
     *
     *  Other declarations
     *
     ********************************************************************/

    // extra window messages used by WarpIN
    #define WPIM_TURNTOPAGE                    (WM_USER+1)
    #define WPIM_QUERYDRIVES                   (WM_USER+2)
    #define WPIM_UPDATE                        (WM_USER+3)
    #define WPIM_FILEEXISTS                    (WM_USER+4)
    #define WPIM_UPDATEPACKAGE                 (WM_USER+5)
    #define WPIM_UPDATEFILE                    (WM_USER+6)
    #define WPIM_UPDATEBYTES                   (WM_USER+7)
    #define WPIM_DONEWITHINSTALL               (WM_USER+8)
    #define WPIM_INSTALLERROR                  (WM_USER+9)
    #define WPIM_FILELOCKEDERROR               (WM_USER+10)
    #define WPIM_PACKAGEREMOVED                (WM_USER+11)
    #define WPIM_ADDSTRING                     (WM_USER+12)
    #define WPIM_DELETE_EXISTINGFILENEWER      (WM_USER+13)
    #define WPIM_DISMISS                       (WM_USER+14)

    /*
     *@@ PACKAGERECORD:
     *      extended record core. This is used on the "Container"
     *      page in "Archive" mode. pJob points to the
     *      corresponding install job, from which the FEPackage
     *      can be retrieved.
     */

    typedef struct _PACKAGERECORD
    {
        RECORDCORE      recc;               // standard record core
        // FEPackage*   pPckInfo;           // linkage to PACKAGEINFO
        FEJobBase       *pJob;              // linkage to corresponding install job (99-11-01) [umoeller]
    } PACKAGERECORD, *PPACKAGERECORD;

    /*
     *@@ DRIVERECORD:
     *      extended record core for "Drive Info" window.
     *      This is only used in "Archive" mode with the
     *      "Container" page.
     *
     *@@changed V0.9.2 (2000-03-04) [umoeller]: made drive bytes double values
     */

    typedef struct _DRIVERECORD
    {
        RECORDCORE     recc;                // standard record core
        ULONG          ulDrive;             // drive no. this recc represents
        double         dFree;               // free space on drive
        double         dRequired;           // required space on drive
        CHAR           szFree[100],
                       szRequired[100];
        PSZ            pszFree,             // points to szFree
                       pszRequired;         // points to szRequired
    } DRIVERECORD, *PDRIVERECORD;

    /*
     *@@ DATABASERECORD:
     *      this is used for the "Database" container,
     *      both for applications (then pFEPackage is NULL)
     *      and packages (then pPackageinfo points to the
     *      package info).
     */

    typedef struct _DATABASERECORD
    {
        RECORDCORE      recc;               // standard record core

        FEDBPackage*    pDBPackage;         // pointer to package;
                                            // for applications, this is NULL

        // the following are used for both applications and packages
        PCSZ            pcszAuthor;
        PCSZ            pcszApplication;

        PSZ             pszApplicationU;    // copy of Unicode application string
                                            // for string comparisons
                                            // V0.9.18 (2002-03-08) [umoeller]

        // the following are used for packages only
        PCSZ            pcszPackageName;
        // CHAR            szVersion[50];      // string composed of version number
        PCSZ            pcszVersion;         // points into package ID V0.9.18 (2002-03-08) [umoeller]
        ULONG           ulFiles;            // copy of pFEPackage->PackHeader.files
        ULONG           ulTotalSize;        // copy of pFEPackage->PackHeader.origsize
        PCSZ            pcszTargetPath;      // points to pFEPackage->szTargetPath
        CDATE           cdateInstall;       // date of install
        CTIME           ctimeInstall;       // time of install

        // status window
        HWND            hwndStatus;         // if != NULLHANDLE, this has the open
                                            // database status window for this package
                                            // (verification or de-installation)
    } DATABASERECORD, *PDATABASERECORD;

    /*
     *@@ FILERECORDCORE:
     *      extended record core for "File List" window
     *      in "Data base" mode.
     */

    typedef struct _FILERECORDCORE
    {
        RECORDCORE     recc;                // standard record core
        CHAR           szFilename[CCHMAXPATH];
        ULONG          ulSize;
        CDATE          cdateCreation;
        CDATE          cdateLastWrite;
    } FILERECORDCORE, *PFILERECORDCORE;

    /*
     *@@ DBCONFIGRECORD:
     *
     *@@added V0.9.1 (2000-01-05) [umoeller]:
     */

    typedef struct _DBCONFIGRECORD
    {
        RECORDCORE      recc;               // standard reecord core
        const char*     pszConfigType;      // static string
        PCSZ            pszConfigData;      // dynamic buffer, must be freed
        BSConfigBase    *pConfig;           // corresponding configuration object
                                            // V0.9.4 (2000-07-01) [umoeller]
    } DBCONFIGRECORD, *PDBCONFIGRECORD;

    /* ******************************************************************
     *
     *  Shared global variables
     *
     ********************************************************************/

    extern WPIGLOBALS   G_WpiGlobals;
        // in warpin.cpp

    // extern FEDatabase*  G_pDatabase;
        // in warpin.cpp

    extern HPOINTER     G_hptrMain;

    extern HWND         G_hwndHelpInstance;
        // in gui.cpp

    extern HWND         G_hwndMainFrame;
        // in gui.cpp

    extern HWND         G_hwndSplashDlg;
        // in gui_shared.cpp

    extern ULONG        G_ulDateFormat,
                        G_ulTimeFormat;
    extern CHAR         G_szDateSep[10],
                        G_szTimeSep[10],
                        G_szThousand[10];
        // in gui.cpp

    /*
     *@@ GUIWaitPointer:
     *
     *@@added V0.9.18 (2002-03-08) [umoeller]
     */

    class GUIWaitPointer
    {
        public:
            ULONG       _hptrOld;

            GUIWaitPointer();
            ~GUIWaitPointer();
    };


    /* ******************************************************************
     *
     *  Prototypes for funcs in gui_shared.c
     *
     ********************************************************************/

    HWND gshrLoadDlg(HWND hwndParent,
                     HWND hwndOwner,
                     PFNWP pfnDlgProc,
                     HMODULE hmod,
                     ULONG idDlg,
                     PVOID pCreateParams);

    PCSZ gshrQueryDefaultFont();

    PCSZ gshrQueryBoldFont();

    VOID gshrMakeHeading(HWND hwndDlg, ULONG id);

    HWND gshrLoadMLE(GUILocals *pLocals,
                     ULONG ulDlgTemplateID,
                     ustring &strText,
                     BOOL fHTML);

    ULONG gshrMLEMessageBox(GUILocals *pLocals,
                            ULONG ulTitleID,
                            ULONG ulMsgID,
                            BOOL fShowCancel,
                            ustring *paStrings = NULL,
                            ULONG cbTable = 0);

    /*
     *@@ DLGWITHHELP:
     *      structure in QWL_USER if
     *      gshr_fnwpDialogWithHelp is used.
     *
     *@@added V0.9.14 (2001-08-09) [umoeller]
     */

    typedef struct _DLGWITHHELP
    {
        GUILocals       *pLocals;
        ULONG           ulHelpPanel;
    } DLGWITHHELP, *PDLGWITHHELP;

    MRESULT EXPENTRY gshr_fnwpDialogWithHelp(HWND hwndDlg,
                                             ULONG msg,
                                             MPARAM mp1,
                                             MPARAM mp2);

    VOID gshrPreferencesDlg(GUILocals *pLocals,
                            HWND hwndOwner);

    #ifdef WIARCHIVE_INCLUDE
        HWND gshrLoadConfirmDlg(HWND hwndOwner,
                                ULONG ulDlgID,
                                PFNWP pfnwp,
                                FEFileError *pfi);
    #endif

    BOOL gshrDisplayHelp(GUILocals *pLocals,
                         ULONG ulHelpPanel);

    BOOL gshrDefWindowProc(GUILocals *pLocals,
                           HWND hwnd,
                           ULONG msg,
                           MPARAM mp1,
                           MPARAM mp2,
                           ULONG ulDefHelpPanel);

    /* ******************************************************************
     *
     *  Help panel IDs in warpin.hlp
     *
     ********************************************************************/

    #define IDHI_MAIN                       1
    #define IDHI_PAGE_TEXTONLY              2       // for MODE_TEXT and MODE_README
    #define IDHI_PAGE_CONTAINER             3
    #define IDHI_PAGE_CONFIGURE             4
    #define IDHI_DATABASE                   5
    #define IDHI_CONFIRM_DEINSTALL          6
    #define IDHI_CONFIRMATIONS_DLG          7
    #define IDHI_DEFAULTPATHS_DLG           8
    #define IDHI_VARPROMPT_DLG              9

    /* ******************************************************************
     *
     *  Database thread
     *
     ********************************************************************/

    /*
     *@@ GUIDatabaseStatus:
     *      required FEDatabaseStatus subclass which
     *      implements the database callback.
     *
     *@@added V0.9.18 (2002-03-08) [umoeller]
     */

    class GUIDatabaseStatus : public FEDatabaseStatus
    {
        public:
            HWND            _hwndStatus;
                    // status window (with progress bar and MLE)

            HWND            _hwndDBPackagesDlg;
                    // if this is NULLHANDLE, the status window is operating
                    // in non-modal mode, and the database gui has opened
                    // the logger in _pLocals; this must
                    // be closed by fnwpDatabaseStatus then.
                    // If this is != NULLHANDLE, we're operating modally,
                    // and this has the window handle of the database
                    // (left view) and the logger has been opened by warpin.cpp,
                    // and therefore is still used.

            ULONG           _ulTask;
                            // one of the following:
                            // -- DBT_VERIFY: do verify on PackagesList
                            // -- DBT_DEINSTALL: deinstall PackagesList

            ULONG           _flDeinstall;
                            // for DBT_DEINSTALL: any or none of the following:
                            // -- DBT_DELETEFILES
                            // -- DBT_UNDOCONFIG

            FEDatabase      &_Database;
                            // reference to database

            // window title
            BSString        _strWindowTitle;

            // the following is updated while the Database thread is running
            BOOL            _fErrorsFound;

            string          _strMsg;
                    // string buf for database callbacks
                    // V0.9.18 (2002-03-08) [umoeller]

            FEDBPackage     *_pPrevPackage;
                    // buf for storing previous package while
                    // callback receives msgs

            virtual ULONG Callback(ULONG ulReportCode,
                                   ULONG ulExtra);

            virtual void OnObjectDeleted(BSDeleteWPSObject *pCfg,
                                         BOOL fSuccess);

            virtual void OnClassUnreplaced(BSUnreplaceClass *pCfg,
                                           BOOL fSuccess);

            virtual void OnClassDeregistered(BSDeregisterClass *pCfg,
                                             BOOL fSuccess);

            virtual void OnCfgSysUndone(BSCfgSysManip *pCfg,
                                        BOOL fSuccess);

            virtual void OnProfileCleared(BSClearProfile *pCfg,
                                          BOOL fSuccess);

            virtual void OnDeExecute(BSDeExecute *pCfg,
                                     int iCode);

            virtual void OnCannotDeleteDirError(const ustring &ustrDirectory,
                                                ULONG cDirsInDir,
                                                ULONG cFilesInDir);

            GUIDatabaseStatus(GUILocals &Locals,
                              ULONG ulTask,
                              ULONG flDeinstall,
                              const string &strWindowTitle, // in: window title
                              HWND hwndDBPackagesDlg)       // in: or NULLHANDLE for non-modal
                : FEDatabaseStatus(Locals),
                  _Database(*Locals._pDatabase),
                  _hwndStatus(NULLHANDLE),      // at this point
                  _ulTask(ulTask),
                  _flDeinstall(flDeinstall),
                  _strWindowTitle(strWindowTitle),
                  _hwndDBPackagesDlg(hwndDBPackagesDlg),
                  _pPrevPackage(NULL),
                  _fErrorsFound(FALSE)
            {
            };

            PCSZ ComposeFullPath(string &str);

            VOID SendString(BOOL fIsErrorMsg);
    };

    /*
     *@@ GUIDatabaseThread:
     *      this class represents the database thread.
     *
     *      After constructing an instance of this,
     *      the database thread is automatically
     *      started.
     *
     *      This data is stored in PTHREADINFO->ulData
     *      to be passed to the database thread.
     *
     *@@changed V0.9.0 (99-11-02) [umoeller]: renamed from DATABASETHREADINFO
     *@@changed V0.9.0 (99-11-03) [umoeller]: thread automatically started now
     *@@changed V0.9.9 (2001-03-30) [umoeller]: added log file
     */

    struct GUIDatabaseThread
    {
        list<FEDBPackage*>      *_pPackagesList;        // changed V0.9.14 (2001-07-07) [umoeller]
                        // package list to work on

        GUIDatabaseStatus       &_Status;
                        // files and packages count passed to callback
                        // (99-11-02) [umoeller]

        GUIDatabaseThread(list<FEDBPackage*> *pPackagesList,
                          GUIDatabaseStatus &Status);

        ~GUIDatabaseThread();
    };

    #ifdef THREADS_HEADER_INCLUDED
        void _Optlink datDatabaseThread(PTHREADINFO pti);
    #endif

#endif
