/* $Id: calbacks.h,v 1.34 2002/07/08 16:49:27 umoeller Exp $ */

/*
 * calbacks.h:
 *      this defines all the callbacks that the GUI must
 *      implement for WarpIN to work.
 *
 *@@include #include <os2.h>
 *@@include #include "wiarchive\wiarchive.h"
 *@@include #include "engine\fe_base.h"
 *@@include #include "frontend\calbacks.h"
 */

/*
 *      Copyright (C) 1998-2002 Ulrich Mller.
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation, in version 2 as it comes in the COPYING
 *      file of this distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

#ifndef WARPIN_CALLBACKS_HEADER_INCLUDED
    #define WARPIN_CALLBACKS_HEADER_INCLUDED

    /* ******************************************************************
     *
     *  Forward declarations
     *
     ********************************************************************/

    class FEJobBase;
    class FEDatabaseStatus;
    class FEDatabase;
    class FEVarPrompt;
    class FEInstallEngine;

    /* ******************************************************************
     *
     *  GUILocals
     *
     ********************************************************************/

    /*
     *@@ GUISETTINGS:
     *      global structure for GUI settings, which
     *      are stored in WARPIN.INI.
     */

    struct GUISETTINGS
    {
        ULONG           ulLeftView;
                            // one of the following:
                            // -- ID_WIMI_DATABASE_TREEVIEW: applications/packages tree
                            // -- ID_WIMI_DATABASE_DETAILSVIEW: packages details
        ULONG           ulRightView;
                            // one of the following:
                            // -- ID_WIMI_VIEW_FILES
                            // -- ID_WIMI_VIEW_CONFIG
    };

    /*
     *@@ GUILocals:
     *      implementation for FELocals (see remarks there).
     *
     *      In addition to implementing the required virtual
     *      methods (which are pure virtual in FELocals),
     *      we initialize some GUI globals here too.
     *
     *@@added V0.9.18 (2002-03-03) [umoeller]
     */

    class GUILocals : public FELocals
    {
        public:
            HMQ         _hmqThread1;

            BOOL        *_pfRestart;

            HINI        _hiniWarpIN;

            ULONG       _ulDisplayCodepage;     // 0 == process default

            GUISETTINGS _GuiSettings;

            FEDatabase  *_pDatabase;            // this now has the global database,
                                                // created in constructor

            HPOINTER    _hptrSelect,
                        _hptrDeselect,
                        _hptrSomeselect,
                        _hptrDeinstall,
                        _hptrError,
                        _hptrQMark,
                        _hptrOK,
                        _hptrNewer,
                        _hptrApp;

            // system mini icon size (16 or 20)
            ULONG       _ulMiniIconSize;

            GUILocals(HAB habThread1,
                      HMQ hmqThread1,
                      CHAR cThousands,
                      BOOL *pfRestart);

            virtual ~GUILocals();

            virtual ULONG ShowMessage(const ustring &ustrTitle,
                                      const ustring &ustrMessage,
                                      ULONG fl);

            virtual VOID OnJobSelectionChanged(FEJobBase *pJob);

            virtual BOOL ConfirmRexxAllowed(const ustring &ustrScript);

            virtual VOID Sleep(ULONG ul);

            virtual APIRET Execute(BSExecute *pExec);

            virtual BSUniCodec& QueryGuiCodec();

            #define SETFL_SAVELOGFILEPATH           0x0001
            void LoadSettings();
            void SaveSettings(ULONG fl);

            BOOL SetWindowTextU(HWND hwnd,
                                const ustring &ustr);

            BOOL SetDlgItemTextU(HWND hwnd,
                                 ULONG id,
                                 const ustring &ustr);

            APIRET GetMessageA(string &strBuf,
                               ULONG ulMsgNumber,
                               ustring *paStrings = NULL,
                               ULONG ulTable = 0);
    };

    #ifdef WARPIN_WEENGINE_HEADER_INCLUDED

        /*
         *@@ GUIInstallEngine:
         *
         *@@added V0.9.20 (2002-07-03) [umoeller]
         */

        class GUIInstallEngine : public FEInstallEngine
        {
            public:
                // "Global status" window
                // moved this here V0.9.20 (2002-07-03) [umoeller]
                HWND                _hwndGlobalStatus;
                ULONG               _ulCurrentBoldID;

                GUIInstallEngine(GUILocals &Locals);

                virtual GUIInstallEngine::~GUIInstallEngine();

                virtual VOID UpdateGlobalStatus(BYTE bStatus);

                virtual PSZ VarPrompt(FEVarPrompt &VarPrompt);

                virtual VOID UpdatePackage(FEInstallJob *pJob,
                                           ULONG ulPckThis,
                                           ULONG ulPcksTotal);

                virtual VOID UpdateFile(WIFileHeader *pwifh,
                                        ULONG ulFileThis,
                                        ULONG ulFilesTotal);

                virtual VOID UpdateBytes(double dBytesDone,
                                         double dBytesTotal);

                virtual int OnFileExists(FEFileError *pfi);

                virtual int OnFileError(FEInstallJob *pJob,
                                        const ustring &ustrErrorMsg,
                                        int iErrorRsp);

                virtual VOID OnDiskFull(char cDriveLetter);

                virtual int OnFileLockedError(FEFileError *pfi,
                                              int iErrorCode);

                virtual void DoneWithInstall(void);
        };

        BOOL guiBeginInstallMode(GUIInstallEngine &Engine);

        BOOL guiStartInstall(GUIInstallEngine &Engine);

        VOID wpiStartInstallThread(GUIInstallEngine &Engine);

        VOID APIENTRY guiOnJobSelectionChanged(FEJobBase *pJob);

    #endif

    /* ******************************************************************
     *
     *  Required GUI callbacks on main thread (gui.cpp)
     *
     ********************************************************************/

    VOID gshrCreateSplash(HMQ hmq);

    VOID gshrDestroySplash(VOID);

    BOOL guiCreateWarpINObjects(GUILocals *pLocals,
                                const ustring &ustrWarpINPath,
                                BOOL fForceRecreateObjects);

    VOID guiStoreWarpINPath(GUILocals *pLocals);

    BOOL guiCheckInstall(GUILocals *pLocals);

    ULONG APIENTRY guiShowMessage2(const BSString &strTitle,
                                   const BSString &strMessage,
                                   ULONG flFlags);


    // VOID APIENTRY guiUpdateGlobalStatus(GUIInstallEngine &Engine, BYTE bStatus);

    // PSZ APIENTRY guiVarPrompt(GUIInstallEngine &Engine,
       //                        FEVarPrompt &VarPrompt);

    /* BOOL APIENTRY guiExecute(GUIInstallEngine &Engine,
                             BSExecute *pExec,
                             BSFileLogger *pLogFile); */

    BOOL APIENTRY guiConfirmRexxAllowed(FELocals *pLocals, const char *pcszScript);

    VOID guiProductInfo(HWND hwndOwner, GUILocals *pLocals, BOOL fLongVersion);

    /* ******************************************************************
     *
     *  Callbacks requiring additional includes
     *
     ********************************************************************/

    /*
    #ifdef MORE_INCLUDES

    void APIENTRY guiUpdatePackage(FEInstallJob *pJob, ULONG ulPckThis, ULONG ulPcksTotal);

    int APIENTRY guiFileError(GUIInstallEngine &Engine,
                              FEInstallJob *pJob,
                              PVOID pData,
                              int iErrorClass,
                              int iErrorCode,
                              int iErrorRsp);
    #endif
    */

    /* ******************************************************************
     *
     *  Required GUI callbacks for Install thread (gui_installing.cpp)
     *
     ********************************************************************/



    /*
    void APIENTRY guiUpdateFile(WIFileHeader *pwifh, ULONG ulFileThis, ULONG ulFilesTotal);

    void APIENTRY guiUpdateBytes(double dBytesDone, double dBytesTotal);

    #ifdef WARPIN_WEENGINE_HEADER_INCLUDED
        int APIENTRY guiFileExists(GUIInstallEngine &Engine,
                                   FEFileError *pfi);

        int APIENTRY guiFileLockedError(GUIInstallEngine &Engine,
                                        FEFileError *pfi,
                                        int iErrorCode);
    #endif
    */

    /* ******************************************************************
     *
     *  Required GUI callbacks for database mode (gui_db.cpp)
     *
     ********************************************************************/

    BOOL guiBeginDatabaseMode(GUILocals *pLocals);

    #ifdef MORE_INCLUDES
    BOOL guiStartVerify(GUILocals *pLocals,
                        list<FEDBPackage*>* pPackagesList,
                        BOOL fModal);

    BOOL guiStartRemove(GUILocals *pLocals,
                        list<FEDBPackage*>* pPackagesList,
                        ULONG flDeinstall,
                        BOOL fModal);
    #endif

#endif

