
/*
 * fe_package_arc.h:
 *      header file for fe_package_arc.cpp.
 *
 *@@include #define INCL_WINSHELLDATA
 *@@include #define INCL_WINWORKPLACE
 *@@include #include <os2.h>
 *@@include #include <string.h>
 *@@include #include "base\bs_errors.h"
 *@@include #include "base\bs_logger.h"
 *@@include #include "base\bs_config.h"
 *@@include #include "frontend\fe_package_arc.h"
 *@@include #include "frontend\warpin.h"
 */

/*
 *      Copyright (C) 1998-2002 Ulrich Mller.
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation, in version 2 as it comes in the COPYING
 *      file of this distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

#ifndef WARPIN_FEPACKAGEARC_HEADER_INCLUDED
    #define WARPIN_FEPACKAGEARC_HEADER_INCLUDED

    class FEPckDeclBase;
    class FEGroupDecl;

    /*
     *@@ FEArcPackageBase:
     *      parent class for the packages used in "install"
     *      mode, that is, every time an archive is involved.
     *
     *      This is for stuff which is shared by both "real" packages
     *      (FEArcPackagePck) and groups (FEArcPackageGroup), which
     *      both inherit from this class.
     *
     *      The constructor is protected because instances of
     *      this class shall never be created directly.
     *
     *      However, this class is used by the lists in the
     *      FEInstallJob and FEArchive classes to store packages.
     *      If you need to find out whether the package is a
     *      group or not, call FEArcPackageBase::IsPackage().
     *      Depending on the return value, you can manually cast
     *      to FEArcPackagePck or FEArcPackageGroup.
     *
     *      Note that FEInstallJob::Is2BeInstalled() returns TRUE
     *      for instances of FEArcPackagePck also, so that one
     *      might be quicker.
     *
     *@@added V0.9.0 (99-11-06) [umoeller]
     *@@changed V0.9.1 (2000-01-07) [umoeller]: renamed from FEArcPackage
     */

    class FEArcPackageBase : public FEPackageBase
    {
        public:
            DECLARE_CLASS(FEArcPackageBase);

        public:
            FEArchive           &_Archive;
                    // the archive this package belongs to;
                    // this always points to a valid archive!

            FEArcPackageGroup   *_pGroup;
                    // the group this package/group belongs to or NULL

            ULONG               _ulSizeRounded;
                    // total uncompressed size in KB (set by FEArchive)

        protected:
            FEArcPackageBase(FEArchive &Archive,
                             FEArcPackageGroup *pGroup,
                             FEPckDeclBase &Decl,
                             BSClassID &Class);

    };

    /*
     *@@ FEArcPackagePck:
     *      FEArcPackageBase subclass for packages in an archive.
     *
     *      These things are created by FEArchive::CreatePackages
     *      according to the install script while WarpIN initializes
     *      itself in "install" mode.
     *
     *@@added V0.9.0 (99-11-06) [umoeller]
     *@@changed V0.9.1 (2000-02-07) [umoeller]: added lotsa new config stuff
     *@@changed V0.9.1 (2000-02-08) [umoeller]: reduced list<> code bloat
     */

    class FEArcPackagePck : public FEArcPackageBase
    {
        public:
            DECLARE_CLASS(FEArcPackagePck);

        public:
            FEPackageID     _PckID;
                    // added V0.9.18 (2002-02-06) [umoeller]

            FEArcPackagePck(FEArchive &Archive,
                            FEArcPackageGroup *pGroup,
                            FEPckDeclBase &Decl);

            VOID Unpack(PFNWICALLBACK pWICallback,
                        void *pvUser);

            VOID AddFileHeader(WIFileHeader* pwifh);

            BOOL Store(HINI hiniDB,
                       PCSZ pcszIDSix);
    };

    /*
     *@@ FEArcPackageGroup:
     *      FEArcPackageBase subclass for groups.
     *
     *      These things are created by FEArchive::CreatePackages
     *      according to the install script while WarpIN initializes
     *      itself in "install" mode.
     *
     *      Groups are only used on the "Container" page.
     *      Groups will never be installed, because they're
     *      only for grouping FEArcPackage's logically.
     *
     *      That's why we have the public GroupMembersList
     *      member here, which is really the only thing
     *      groups are good for.
     *
     *      Note that even though this class inherits
     *      from FEPackageBase, many of the member fields
     *      in there are not used by groups. To avoid this,
     *      we'd have to use multiple inheritance, which
     *      I prefer to avoid. ;-)
     *
     *@@added V0.9.0 (99-11-06) [umoeller]
     */

    class FEArcPackageGroup : public FEArcPackageBase
    {
        public:
            DECLARE_CLASS(FEArcPackageGroup);

        public:
            list<FEArcPackageBase*> _GroupMembersList;
                    // list of packages which are part of this
                    // group; the items on this list can either
                    // be FEArcPackage's or FEArcPackageGroup's.
                    // This list is added to by FEArcPackageBase::FEArcPackageBase.
                    // List is in SHADOW mode V0.9.15 (2001-08-26) [umoeller]

            FEArcPackageGroup(FEArchive &Archive,
                              FEArcPackageGroup *pGroup,
                              FEGroupDecl &Decl);
    };

#endif
