
/*
 * fe_job.h:
 *      header file for fe_job.cpp.
 *
 *@@include #define INCL_WINSHELLDATA
 *@@include #define INCL_WINWORKPLACE
 *@@include #include <os2.h>
 *@@include #include <string.h>
 *@@include #include "base\bs_errors.h"
 *@@include #include "base\bs_config.h"
 *@@include #include "frontend\fe_job.h"
 */

/*
 *      Copyright (C) 1998-2002 Ulrich Mller.
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation, in version 2 as it comes in the COPYING
 *      file of this distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

#ifndef WARPIN_FEWORKER_HEADER_INCLUDED
    #define WARPIN_FEWORKER_HEADER_INCLUDED

    /* ******************************************************************
     *
     *  Forward declarations
     *
     ********************************************************************/

    class FELocals;

    class FEDatabase;
    class FEPackageID;
    class FEArcPackagePck;
    class FEArcPackageGroup;
    class FEDBPackage;

    class FEJobBase;
    class FEInstallJob;
    class FEGroupJob;

    /* ******************************************************************
     *
     *  FEJob class
     *
     ********************************************************************/

    // job class
    // #define JOBCLASS_ERROR                   0
    // #define JOBCLASS_INSTALLJOB     0x00010000
    // #define JOBCLASS_GROUPJOB       0x00020000

    // flags for FEInstallJob.ulJob
    // #define JOB_UNDEFINED                    0

    // #define JOB_INSTALL_IGNORE      0x00010000
    // #define JOB_INSTALL             0x00010001
    // #define JOB_DEINSTALL           0x00010002

    // #define JOB_GROUP_MIXED         0x00020004

    typedef enum
    {
        JOB_UNDEFINED,          // initial value
        JOB_INSTALL_IGNORE,     // well, do nothing
        JOB_INSTALL,            // install package
        JOB_DEINSTALL,          // remove package
        JOB_GROUP_MIXED         // addt'l flag for groups only:
                                // sub-packages have varying flags

    } enJobSelection;

    /*
     *@@ FEJobBase:
     *      job base class, of which the other job
     *      classes are derived. No objects of this
     *      class exist, but only of the subclasses
     *      (FEInstallJob or FEGroupJob).
     *
     *      This class is abstract anyway, so don't
     *      try to create instances of this.
     *
     *      A job is simply another wrapper around a package.
     *      While installing, each job represents a package to
     *      be installed or deinstalled. Jobs contain variable
     *      data for packages which can be deinstalled, while
     *      the packages themselves only represent the (read-only)
     *      data from the script.
     *
     *      See @class_rels for an overview of how the front-end
     *      classes interact.
     *
     *      For example, the package has the target path as specified
     *      in the script, but the job has the target path which was
     *      actually entered by the user.
     *
     *      Jobs are _not_ used in database mode, because the database
     *      operates on (database) packages directly (FEDBPackage).
     *
     *      Each instance of FEInstallJob has a member pointer
     *      to the FEArcPackagePck which is to be installed
     *      or deinstalled.
     *
     *      A list of instances of these classes is built in
     *      FEInstallJob before the GUI starts displaying
     *      the page dialogs. The GUI is responsible for marking
     *      the packages for install, using FEInstallJob::Select.
     *
     *      After the GUI returns control to the front end,
     *      FEInstallEngine will then process the list of install
     *      jobs. For each package which has been successfully
     *      FEInstallEngine::Store will then call FEInstallJob::Store()
     *      to have it stored in the database.
     *
     *      The job classes have been added for several reasons.
     *      For one, with the previous design (working on
     *      packages directly), it was nearly impossible to
     *      implement a working add/remove mode. Secondly, this
     *      design allows WarpIN to work on several archives
     *      at the same time, because the job instances can
     *      now point to packages from several archives.
     */

    class FEJobBase : public BSRoot
    {
        public:
            DECLARE_CLASS(FEJobBase);

        protected:
            // ULONG       _ulJobClass;
                    // removed V0.9.18 (2002-02-06) [umoeller]

            enJobSelection  _Selection;

            FELocals        &_Locals;

            FEJobBase(FEGroupJob *pGroupJob_,
                      FELocals &Locals,
                      BSClassID &Class);

        public:
            FEGroupJob  *_pGroupJob;
                    // the group job we belong to or NULL

            PVOID       _pvGuiData;
                    // for GUI usage: reverse linkage to PACKAGERECORD in cnr

            virtual ~FEJobBase() {};

            virtual FEInstallJob* IsInstallJob();
            virtual FEGroupJob* IsGroupJob();

            enJobSelection QuerySelection() const;

            virtual enJobSelection ToggleSelection() = 0;

            virtual BOOL Select(enJobSelection selNew) = 0;
    };

    /* ******************************************************************
     *
     *  FEInstallJob class
     *
     ********************************************************************/

    // flags for FEInstallJob.ulInstallStatus
    #define INSTALLED_UNKNOWN       0
    #define INSTALLED_NO            1
    #define INSTALLED_IS_OLDER      2
    #define INSTALLED_IS_NEWER      3
    #define INSTALLED_IS_SAME       4

    // flags for FEPackage.ulConfigureFlags
    #define JOB_CONFIGSYS    0x01    // CONFIG.SYS can be updated
    #define JOB_WPSCLASSES   0x02    // WPS classes can be installed
    #define JOB_WPSOBJECTS   0x04    // WPS objects can be created

    /*
     *@@ FEInstallJob:
     *      "install job" class, which represents
     *      a package to be installed. This points
     *      to the FEArcPackagePck to be installed.
     *
     *      See FEJobBase for an introduction to
     *      jobs.
     *
     *      Note that for groups, an instance of
     *      FEGroupJob is created instead.
     */

    class FEInstallJob : virtual public FEJobBase
    {
        public:
            DECLARE_CLASS(FEInstallJob);

        protected:
            ustring      _ustrTargetPath;
                    // target path;
                    // initially copied from FEArcPackagePck,
                    // can be changed later here.
                    // NOTE: V0.9.18 used a BSString with the
                    // process codepage here, but this cannot
                    // work, because this can contain macros
                    // with NLS strings that might not be
                    // supported with the current process codepage.
                    // So use a BSUString here as well (this
                    // caused the unresolved macros with wgts-0-5-2.wpi
                    // and codepage 437).
                    // V0.9.19 (2002-04-14) [umoeller]

        public:
            FEArcPackagePck     &_ArcPackage;
                    // package to be installed or removed
                    // (points to a list item in an FEArchive);
                    // this will always be a package, never a
                    // group, since we have an install job
                    // made this a reference V0.9.18 (2002-03-08) [umoeller]

            /* FEPackageID *_pPackageID;
                    // package ID of the member package;
                    // constructed by CheckInstall
            FEPackageID *_pPackageIDInstalled;
                    // package ID of installed package;
                    // constructed by CheckInstall, if package is installed already;
                    // otherwise it's NULL
            */  // removed the above two
                // V0.9.18 (2002-03-03) [umoeller]

            const FEDBPackage *_pDBPackageInstalled;
                    // V0.9.18 (2002-03-03) [umoeller]
                    // if != NULL, pointer into the database to pck which is
                    // already installed

            ULONG       _ulInstallStatus;
                    // install status, valid after CheckInstall call.
                    // -- INSTALLED_UNKNOWN: CheckInstall not yet called. (99-11-01) [umoeller]
                    // -- INSTALLED_NO: package not installed.
                    // -- INSTALLED_IS_OLDER: package is installed and older than in archive;
                    //                     it should be updated then.
                    // -- INSTALLED_IS_NEWER: package is installed and newer than in archive
                    //                     it should _not_ be updated then.
                    // -- INSTALLED_IS_SAME: package is installed and same as in archive.

            FEInstallJob(FEArcPackagePck &Package,
                         FEGroupJob *pGroupJob,
                         FELocals &Locals);

            virtual ~FEInstallJob();

            virtual FEInstallJob* IsInstallJob();

            BOOL CheckInstall(FEDatabase *pDatabase,
                              WIVersion &version);

            const ustring& QueryTargetPath() const;

            const ustring& QueryPckPackageID() const;

            ULONG QueryPckSizeRounded() const;

            const ustring& QueryPckTitle() const;

            ULONG QueryPckFilesCount() const;

            ULONG QueryPckOrigSize() const;

            BOOL SetTargetPath(const ustring &strNewTargetPath,
                               list<FEJobBase*> *pJobsList);

            BOOL DefaultSelect();

            BOOL RepairSelect();

            BOOL UpdateSelect();

            virtual BOOL Select(enJobSelection selNew);

            virtual enJobSelection ToggleSelection();

            BOOL Is2BeInstalled() const;

            BOOL Is2BeRemoved() const;

            VOID Unpack(PFNWICALLBACK pWICallback,
                        void *pvUser);

            VOID AddFileHeader(WIFileHeader* pwifh);

            BOOL Store(FEDatabase &Database);
    };

    /*
     *@@ FEGroupJob:
     *      "group job" class which represents a
     *      group on the "container" pages.
     */

    class FEGroupJob : virtual public FEJobBase
    {
        public:
            DECLARE_CLASS(FEGroupJob);

        public:
            // list of packages which are part of this
            // group; the items on this list can either
            // be FEInstallJob's or FEGroupJob's
            // List is in SHADOW mode V0.9.15 (2001-08-26) [umoeller]
            list<FEJobBase*> _GroupMembersList;

            const FEArcPackageGroup *_pGroupPackage;
                    // group which is represented by this job

            FEGroupJob(FEArcPackageGroup *pGroup_,
                       FEGroupJob *pGroupJob_,
                       FELocals &Locals);

            virtual FEGroupJob* IsGroupJob();

            virtual enJobSelection ToggleSelection();

            virtual ULONG Select(enJobSelection selNew);

            VOID Update();
    };

#endif
