
/*
 * fe_cid.h:
 *      header file for fe_cid.cpp.
 *
 *@@include #include <os2.h>
 *@@include #include "frontend\fe_job.h"
 *@@include #include "frontend\fe_cid.h"
 */

/*
 *      Copyright (C) 2002 Ulrich Mller.
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation, in version 2 as it comes in the COPYING
 *      file of this distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

#ifndef WARPIN_FECID_HEADER_INCLUDED
    #define WARPIN_FECID_HEADER_INCLUDED

    class FEJobBase;

    /*
     *@@ FECID:
     *      the WarpIN CID class. This encapsulates all
     *      variable information that is needed to set
     *      up an archive for install.
     *
     *      FECID can write itself to disk as an XML
     *      file (taking the values from FEInstallEngine,
     *      see FECID::Write) or load itself from an
     *      XML file and hack up the jobs in an
     *      FEInstallEngine (see FECID::Apply).
     *
     *@@added V0.9.18 (2002-03-08) [umoeller]
     */

    class FECID : public BSRoot
    {
        public:
            DECLARE_CLASS(FECID);

        private:
            FEInstallEngine &_Engine;
            ustring     _ustrFilename;
            PVOID       _pDocument,
                        _pRootElement;

        public:
            FECID::FECID(FEInstallEngine &Engine,
                         const ustring &ustrFilename);

            FECID::~FECID();

            VOID FECID::Write();

            VOID FECID::Apply();
    };

#endif
