
/*
 * fe_archive.h:
 *      header file for fe_archive.cpp.
 *
 *@@added V0.9.0 (99-10-31) [umoeller]
 *@@include #include "base\bs_string.h"
 *@@include #include "base\bs_list.h"
 *@@include #include "base\bs_string.h"
 *@@include #include "base\bs_errors.h"
 *@@include #include "base\bs_logger.h"
 *@@include #include "base\bs_config.h"
 *@@include #include "engine\fe_base.h"
 *@@include #include "engine\fe_script.h"
 *@@include #include "engine\fe_package.h"
 *@@include #include "engine\fe_package_arc.h"
 *@@include #include "engine\fe_archive.h"
 */

/*
 *      Copyright (C) 1999-2002 Ulrich Mller.
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation, in version 2 as it comes in the COPYING
 *      file of this distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

#ifndef WARPIN_FEARCHIVE_HEADER_INCLUDED
    #define WARPIN_FEARCHIVE_HEADER_INCLUDED

    /* ******************************************************************
     *
     *  Forward declarations
     *
     ********************************************************************/

    class FERexx;
    class FEArcPackageBase;
    class FEArcPackagePck;
    class FEArcPackageGroup;
    class FEPackageID;

    /* ******************************************************************
     *
     *  FEArchive declaration
     *
     ********************************************************************/

    /*
     *@@ FEArchive:
     *      front-end archive class. This is a wrapper around
     *      the back-end WIArchive (which is contained as a member)
     *      in "install" mode and implements script parsing and
     *      package management by properly interfacing FEScriptBase
     *      (and subclasses) and FEPackageBase (and subclasses).
     *
     *      Note that archives are not used at all in "database" mode.
     *
     *      See @class_rels for an overview of how the front-end
     *      classes interact.
     *
     *@@added V0.9.0 (99-10-31) [umoeller]
     */

    class FEArchive : public BSRoot
    {
        public:
            DECLARE_CLASS(FEArchive);

        public:
            FELocals                &_Locals;

            ustring                _ustrArcFilename;
                    // archive filename as passed to constructor

            FEArchive               *_pReferencedFrom;
                    // NULL if "root" archive; otherwise this is
                    // an external archive, and this points to
                    // the "mother" archive with the script
                    // V0.9.9 (2001-02-28) [umoeller]

            WIArchive               _Arc;
                    // the back end archive instance
            const WIArcHeader       *_pArcHeader;
                    // pointer to archive header (back end)

            FEScriptBase            *_pScript;
                    // pointer to script V0.9.9 (2001-02-19) [umoeller]

            list<FEArcPackageBase*> *_pPackagesList;
                    // list of package infos (created by FEArchive::ParseScript;
                    // valid after constructor call)

            FEArchive(FELocals &Locals,
                      const ustring &ustrArcFilename,
                      FEArchive *pReferencedFrom = NULL);

            ~FEArchive();

            VOID ParseScript(FERexx &Rexx);

            FEArcPackagePck* FindArcPackage(ULONG ulIndex);

            WIPackHeader* FindPackHeader(ULONG ulIndex);

            FEArcPackagePck* IsInArchive(const FEPackageID &PckID,
                                         PULONG pulComp)
                             const;

            FEPageInfo* FindPageInfo(LONG lIndex);

        private:
            VOID CreatePackages(list<FEPckDeclBase*> &DeclarationsList,
                                FEArcPackageGroup *pParentGroup);

            VOID ExtractArchivePath(ustring& ustrArchiveName);
            VOID PrependArchivePath(ustring& ustrArchiveName);
                    // archive path handling functions (cbo 2000-05-23)

            VOID ResolveRequirements();
    };

#endif
