/* rexx */

parse source . . srcpath
parse arg args

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs
call RxFuncAdd "DSCRxLoadFuncs","rxdscr","DSCRxLoadFuncs"
call DSCRxLoadFuncs


say "Description WPS Classes replacement version 0.93"
say "Copyright (c) 1995 Virtual Objects Software"
dllpath=word(args,1)
phase=word(args,2)


uninst.cmd = filespec("drive",srcpath)||filespec("path",srcpath)||"uninst.cmd"
org_dir=directory()
call directory(filespec("drive",srcpath)||filespec("path",srcpath))

if dllpath='' then do
	say 'Usage: install.cmd <dll-path>'
	say '  where <dll-path> is the directory contained '
	say '  in LIBPATH statement in your CONFIG.SYS'
	signal ExitInst
end
dllpath=CutLastBash(dllpath)

if \DriveIsLocal(dllpath) then do
  say "You should specify the path on local drive."
  say "Do not use remote paths like "||dllpath||"!"
  signal ExitInst
end


bootdrv=QueryBootDrive()


dscrdistr.1="dscrdf.dll"
dscrdistr.2="dscrlst.dll"
dscrdistr.3="install.cmd"
dscrdistr.4="uninst.cmd"
dscrdistr.5="rxdscr.dll"

dscrdistr.0=5



cls.2="DSCRFileList"
cls.1="DSCRDataFile"
dll.2="dscrlst"
dll.1="dscrdf"
cls.0=2
dll.0=2

reinstId="<DSCRReinst>"
call SysDestroyObject(reinstId)
Call SysDestroyObject "<DSCRFileList_TEMP>"

if phase='PhaseTwo' then signal PhaseTwo

if CheckDSCRClasses() then do
  say "Another version of WPS DSCR classes is installed."
  say "To reinstall them or replace with the newer version"
  say "WPS DSCR classes should be unregistered by ..."
  say "... calling uninst.cmd"
  'call '||uninst.cmd
  say " "

  if \DriveIsLocal(srcpath) then do
   
   say "You've started installation from the remote or detached drive."
   say "This may cause reinstallation proccess to be failed. "
   say "Therefore WPS DSCR package files will now be copied to "
   say "your boot drive "QueryBootDrive()
   org_dir=QueryBootDrive()'\TEMP'
   drop found.
   rc=SysFileTree(org_dir, "found","DO")
   if found.0=0 then do
     rc=SysMkDir(org_dir)
     if rc\=0 then do
       say "Error occured while creating "org_dir
       say "SysMkDir return code="rc
       org_dir=QueryBootDrive()
       say "Resetting to "org_dir
     end
   end
   drop found.
   do i=1 to dscrdistr.0 
      'copy '||dscrdistr.i||' '||org_dir||'\'||dscrdistr.i
   end
  end

  /* reinstall */
  say "Creating DLLs' removing script..."
  remove_dll=QueryBootDrive()||"\dscrdll.cmd"
  call SysFileDelete(remove_dll);
  rc=lineout(remove_dll,'@echo off')
  rc=lineout(remove_dll,'echo Removing old WPS DSCR DLLs...')
  if rc\=0 then do
    say 'Error occured while creating 'remove_dll
    signal ExitInst
  end

  do i=1 to dll.0
    remdll=DSCRxDllPath(dll.i)
    if datatype(remdll, "Number")=1 then remdll=dllpath||'\'||dll.i||'.DLL'
     rc=lineout(remove_dll,'del '||remdll)
     if rc\=0 then do
      say 'Error occured while creating 'remove_dll
      signal ExitInst
     end
  end

  say 'Backing up 'config.sys' to 'config.bak
  config.sys=QueryBootDrive()||'\CONFIG.SYS'
  config.bak=QueryBootDrive()||'\CONFIG.DCR'
  drop retC
  answ='Y'
  do while retC\=0 & answ='Y'
     'copy '||config.sys||' '||config.bak
     retC=rc
     if retC\=0 then do 
      say 'Error backing up 'config.sys' to 'config.bak
      say 'Maybe one of the files '||config.sys||' '||config.bak
      say 'is locked by another process...'
      say 'Would you like to try again? (Y/N)'
      pull answer
      answ=substr(toUpper(answer),1,1)
     end
  end
  if retC\=0 then do 
    say "You've cancelled the installation..."
    signal ExitInst
  end 
  rc=lineout(config.sys, " ")
  rc=lineout(config.sys, 'call=C:\OS2\CMD.EXE /Q /C '||remove_dll)
  if rc\=0 then do
    say 'Error occured while replacing updating 'config.sys
    signal ExitInst
  end

  rc=lineout(remove_dll, 'echo Restoring original 'config.sys'...')
  rc=lineout(remove_dll, 'copy 'config.bak' 'config.sys)
  if rc\=0 then do
    say 'Error occured while creating 'remove_dll
    signal ExitInst
  end


  say 'Creating WPS DSCR reinstallation Program object in StartUp folder...'
  rc=SysCreateObject("WPProgram", "WPS DSCR  Reinstall","<WP_START>","EXENAME="||org_dir||'\'||filespec("name",srcpath)||";PARAMETERS="||dllpath||" PhaseTwo;STARTUPDIR="||org_dir||";OBJECTID="||reinstId);
  if rc=0 then do
	say 'Error creating reinstall object in StartUp folder.'
	signal ExitInst
  end
  say "Now you should reboot the Workplace Shell "
  say "to continue reinstallation process."
  signal ExitInst
end

PhaseTwo:

do i=1 to dll.0
  'copy '||dll.i||'.dll '||dllpath
  if rc\=0 then do
	dllDel=dllpath||'\'||dll.i||'.dll'
	say 'File '|| dllDel ||' is locked by the system...'
	say 'To correct this problem you would run UNINST.CMD'
	say 'and then either delete file 'dllDel
        say 'or restart install.cmd again.' 
	say 'Note: if you will not able to perform this under Workplace Shell loaded'
	say '      try to boot in command prompt and perform this action again.'
	say '      (To load under command prompt press Alt-F1 when white square '
	say '       and "OS/2" text appere in the left top corner of the screen' 
	say '       when booting OS/2)'
	drop dllDel
	signal ExitInst
  end
end

'copy rxdscr.dll '||dllpath

do i=1 to cls.0
  retc=SysRegisterObjectClass(cls.i,dll.i) 
  if retc=1 then
         say 'Install successfully completed for the class 'cls.i
  else do
	say 'Error registering class 'cls.i' ('dll.i')'
	say 'Please contact VOS to report this error'
	signal ExitInst
  end            
end

rc= DSCRxReplaceClass('WPDataFile','DSCRDataFile',1)

if rc=0 then do
  say 'Error occured while replacing WPDataFile class'
	signal ExitInst
end
say 'Class WPDataFile successfuly replaced with DSCRDataFile'

rc=DSCRxReplaceClass('WPFolder','DSCRFileList',1)

if rc=0 then do
  say 'Error occured while replacing WPFolder class'
	signal ExitInst
end

say 'Class WPFolder successfuly replaced with DSCRFileList'

say 'WPS DSCR classes installation completed successfuly!'
say 'Now you have to reload Workplace Shell to make changes work.'
say 'The simple way to do that is to reboot your system'

ExitInst:

'pause'
exit(0)


CheckDSCRClasses: procedure expose cls. dll.
/* This procedure returns TRUE (1) if either one of 
 WPS DSCR classes is found in your system */
retVal=0
drop clsFlg.

    call SysQueryClassList "list."
    do i = 1 to list.0
	parse value list.i with clsName	clsDll
        do j=1 to cls.0
		if toUpper(clsName)=toUpper(cls.j) then clsFlg.j=1
	end	
    end
    do j=1 to cls.0
	if clsFlg.j=1 then retVal=1
    end 
return retVal

toUpper: procedure
parse upper arg args
return args

QueryBootDrive: procedure 
fs=SysSearchPath('PATH','CMD.EXE')
drvRet=filespec('drive', fs)
return drvRet

CutLastbash: procedure
parse arg args
l1=lastpos('\',args)
l2=length(args)
if l1=l2 then return substr(args,1,l2-1)
return args


FindDllInLibPath: procedure
parse arg dllName
dllPath=0
bootDrv=QueryBootDrive()
config.sys=bootDrv||"\CONFIG.SYS"
if SysFileSearch('LIBPATH',config.sys,'str.')\=0 then  return 0
target='LIBPATH='
l1=length(target)
do i=str.0 to 1 by -1
 l2=COMPARE(target,toUpper(str.i))-1
 if l1=l2 then do
   LPvalue=substr(str.i,l1+1)
   setlocal
   env='PATH'
   call value env,LPvalue,'OS2ENVIRONMENT'
   dllPath=SysSearchPath(env, dllName||".dll")
   endlocal
   return dllPath
 end
end
return dllPath



DriveIsLocal: procedure
parse arg drvIn
drvIn=filespec("drive",toUpper(drvIn))
retVal=0
map=SysDriveMap("A:","LOCAL")
if pos(drvIn, map)\=0 then return 1
return retVal
