#ifndef _P9080_LIB_H_
#define _P9080_LIB_H_

#ifdef __KERNEL__
    #include "../../../include/kdstdlib.h"
#endif //__KERNEL__
#include "../../../include/windrvr.h"
#include "../../../samples/shared/pci_regs.h"
#include "../../../samples/shared/bits.h"

#ifdef __cplusplus
extern "C" {
#endif

// PLX register definitions 
enum {
    P9080_LAS0RR     = 0x00,
    P9080_LAS0BA     = 0x04,
    P9080_EROMRR     = 0x10,
    P9080_EROMBA     = 0x14,
    P9080_LBRD0      = 0x18,
    P9080_MBOX0      = 0x40,
    P9080_MBOX1      = 0x44,
    P9080_MBOX2      = 0x48,
    P9080_MBOX3      = 0x4c,
    P9080_MBOX4      = 0x50,
    P9080_MBOX5      = 0x54,
    P9080_MBOX6      = 0x58,
    P9080_MBOX7      = 0x5c,
    P9080_P2LDBELL   = 0x60,
    P9080_L2PDBELL   = 0x64,
    P9080_INTCSR     = 0x68,
    P9080_CNTRL      = 0x6c
};

// P9080 local registers
enum {
    P9080_DMAMODE    = 0x80,
    P9080_DMAPADR    = 0x84,
    P9080_DMALADR    = 0x88,
    P9080_DMASIZ     = 0x8c,
    P9080_DMADPR     = 0x90,
    P9080_DMACSR     = 0xA8
};

typedef enum
{
    P9080_DMA_CHANNEL_0 = 0,
    P9080_DMA_CHANNEL_1 = 1
} P9080_DMA_CHANNEL;

typedef enum
{
    P9080_MODE_BYTE   = 0,
    P9080_MODE_WORD   = 1,
    P9080_MODE_DWORD  = 2
} P9080_MODE;

typedef enum
{
    P9080_ADDR_REG     = AD_PCI_BAR0,
    P9080_ADDR_REG_IO  = AD_PCI_BAR1,
    P9080_ADDR_SPACE0  = AD_PCI_BAR2,
    P9080_ADDR_SPACE1  = AD_PCI_BAR3,
    P9080_ADDR_SPACE2  = AD_PCI_BAR4,
    P9080_ADDR_SPACE3  = AD_PCI_BAR5,
    P9080_ADDR_EPROM   = AD_PCI_BAR_EPROM
} P9080_ADDR;

enum { P9080_RANGE_REG = 0x00000080 };

typedef struct P9080_DMA_STRUCT *P9080_DMA_HANDLE;

typedef struct P9080_STRUCT *P9080_HANDLE;

typedef struct
{
    DWORD dwCounter;   // number of interrupts received
    DWORD dwLost;      // number of interrupts not yet dealt with
    BOOL fStopped;     // was interrupt disabled during wait
    DWORD dwStatusReg; // value of status register when interrupt occured
} P9080_INT_RESULT;
typedef void (WINAPI *P9080_INT_HANDLER)( P9080_HANDLE hPlx, P9080_INT_RESULT *intResult);

// options for PLX_Open
enum { P9080_OPEN_USE_INT =   0x1 };
enum { P9080_CS46_EEPROM  =   0x2 };

DWORD P9080_CountCards (DWORD dwVendorID, DWORD dwDeviceID);
BOOL P9080_Open (P9080_HANDLE *phPlx, DWORD dwVendorID, DWORD dwDeviceID, DWORD nCardNum, DWORD dwOptions);
void P9080_Close (P9080_HANDLE hPlx);
BOOL P9080_IsAddrSpaceActive(P9080_HANDLE hPlx, P9080_ADDR addrSpace);
void P9080_GetPciSlot(P9080_HANDLE hPlx, WD_PCI_SLOT *pPciSlot);

void P9080_ReadWriteBlockLocal (P9080_HANDLE hPlx, DWORD dwLocalAddr, PVOID buf, 
                    DWORD dwBytes, BOOL fIsRead, P9080_MODE mode);
void P9080_ReadBlockLocal (P9080_HANDLE hPlx, DWORD dwLocalAddr, PVOID buf, DWORD dwBytes, P9080_MODE mode);
void P9080_WriteBlockLocal (P9080_HANDLE hPlx, DWORD dwLocalAddr, PVOID buf, DWORD dwBytes, P9080_MODE mode);
BYTE P9080_ReadByteLocal (P9080_HANDLE hPlx, DWORD dwLocalAddr);
void P9080_WriteByteLocal (P9080_HANDLE hPlx, DWORD dwLocalAddr, BYTE data);
WORD P9080_ReadWordLocal (P9080_HANDLE hPlx, DWORD dwLocalAddr);
void P9080_WriteWordLocal (P9080_HANDLE hPlx, DWORD dwLocalAddr, WORD data);
DWORD P9080_ReadDWordLocal (P9080_HANDLE hPlx, DWORD dwLocalAddr);
void P9080_WriteDWordLocal (P9080_HANDLE hPlx, DWORD dwLocalAddr, DWORD data);

void P9080_ReadWriteBlock (P9080_HANDLE hPlx, DWORD dwOffset, PVOID buf, 
                    DWORD dwBytes, BOOL fIsRead, P9080_ADDR addrSpace, P9080_MODE mode);
BYTE P9080_ReadByte (P9080_HANDLE hPlx, P9080_ADDR addrSpace, DWORD dwOffset);
void P9080_WriteByte (P9080_HANDLE hPlx, P9080_ADDR addrSpace, DWORD dwOffset, BYTE data);
WORD P9080_ReadWord (P9080_HANDLE hPlx, P9080_ADDR addrSpace, DWORD dwOffset);
void P9080_WriteWord (P9080_HANDLE hPlx, P9080_ADDR addrSpace, DWORD dwOffset, WORD data);
DWORD P9080_ReadDWord (P9080_HANDLE hPlx, P9080_ADDR addrSpace, DWORD dwOffset);
void P9080_WriteDWord (P9080_HANDLE hPlx, P9080_ADDR addrSpace, DWORD dwOffset, DWORD data);
void P9080_ReadBlock (P9080_HANDLE hPlx, DWORD dwOffset, PVOID buf, 
                    DWORD dwBytes, P9080_ADDR addrSpace, P9080_MODE mode);
void P9080_WriteBlock (P9080_HANDLE hPlx, DWORD dwOffset, PVOID buf, 
                     DWORD dwBytes, P9080_ADDR addrSpace, P9080_MODE mode);

// interrupt functions
BOOL P9080_IntIsEnabled (P9080_HANDLE hPlx);
BOOL P9080_IntEnable (P9080_HANDLE hPlx, P9080_INT_HANDLER funcIntHandler);
void P9080_IntDisable (P9080_HANDLE hPlx);

// access registers
DWORD P9080_ReadReg (P9080_HANDLE hPlx, DWORD dwReg);
void P9080_WriteReg (P9080_HANDLE hPlx, DWORD dwReg, DWORD dwData);

// access PCI configuration registers
DWORD P9080_ReadPCIReg(P9080_HANDLE hPlx, DWORD dwReg);
void P9080_WritePCIReg(P9080_HANDLE hPlx, DWORD dwReg, DWORD dwData);

// Start DMA to/from card.
// fIsRead - TRUE: read from card to buffer.  FALSE: write from buffer to card
// dwBytes - number of bytes to transfer (must be a multiple of 4)
// mode - local bus width.
// dwLocalAddr - local address on card to write to / read from
// channel - uses channel 0 or 1 of the 9080
// buf - the buffer to transfer
P9080_DMA_HANDLE P9080_DMAOpen (P9080_HANDLE hPlx, DWORD dwLocalAddr, PVOID buf, 
    DWORD dwBytes, BOOL fIsRead, P9080_MODE mode, P9080_DMA_CHANNEL dmaChannel);
void P9080_DMAClose (P9080_HANDLE hPlx, P9080_DMA_HANDLE hDma);
void P9080_DMAStart (P9080_HANDLE hPlx, P9080_DMA_HANDLE hDma, BOOL fBlocking);
BOOL P9080_DMAIsDone (P9080_HANDLE hPlx, P9080_DMA_HANDLE hDma);
BOOL P9080_DMAReadWriteBlock (P9080_HANDLE hPlx, DWORD dwLocalAddr, PVOID buf, 
    DWORD dwBytes, BOOL fIsRead, P9080_MODE mode, P9080_DMA_CHANNEL dmaChannel);

BOOL P9080_EEPROMReadWord(P9080_HANDLE hPlx, DWORD dwOffset, PWORD pwData);
BOOL P9080_EEPROMWriteWord(P9080_HANDLE hPlx, DWORD dwOffset, WORD wData);
BOOL P9080_EEPROMReadDWord(P9080_HANDLE hPlx, DWORD dwOffset, PDWORD pdwData);
BOOL P9080_EEPROMWriteDWord(P9080_HANDLE hPlx, DWORD dwOffset, DWORD dwData);
BOOL P9080_EEPROMValid(P9080_HANDLE hPlx);


// this string is set to an error message, if one occurs
extern CHAR P9080_ErrorString[];

#ifdef __cplusplus
}
#endif

#endif
