#ifndef _P9060_LIB_H_
#define _P9060_LIB_H_

#include "../../../samples/shared/pci_regs.h"
#include "../../../samples/shared/bits.h"

#ifdef __cplusplus
extern "C" {
#endif

// PLX register definitions 
enum {
    P9060_RANGE_PTOL_0     = 0x00,
    P9060_REMAP_PTOL_0     = 0x04,
    P9060_RANGE_PTOL_EPROM = 0x10,
    P9060_REMAP_PTOL_EPROM = 0x14,
    P9060_REGION_DESC      = 0x18,
    P9060_MAILBOX_0        = 0x40,
    P9060_MAILBOX_1        = 0x44,
    P9060_MAILBOX_2        = 0x48,
    P9060_MAILBOX_3        = 0x4c,
    P9060_MAILBOX_4        = 0x50,
    P9060_MAILBOX_5        = 0x54,
    P9060_MAILBOX_6        = 0x58,
    P9060_MAILBOX_7        = 0x5c,
    P9060_DOORBELL_PTOL    = 0x60,
    P9060_DOORBELL_LTOP    = 0x64,
    P9060_INT_STATUS       = 0x68,
    P9060_MISC_CONTROL     = 0x6c
};

enum { P9060_MODE_DESC       = 0xF9000140 };
enum { P9060_MODE_DESC_BYTE  = 0x00000000 };
enum { P9060_MODE_DESC_WORD  = 0x00010001 };
enum { P9060_MODE_DESC_DWORD = 0x00030003 };

typedef enum
{
    P9060_MODE_BYTE   = 0,
    P9060_MODE_WORD   = 1,
    P9060_MODE_DWORD  = 2
} P9060_MODE;

typedef enum
{
    P9060_ADDR_REG     = AD_PCI_BAR0,
    P9060_ADDR_REG_IO  = AD_PCI_BAR1,
    P9060_ADDR_SPACE0  = AD_PCI_BAR2,
    P9060_ADDR_SPACE1  = AD_PCI_BAR3,
    P9060_ADDR_SPACE2  = AD_PCI_BAR4,
    P9060_ADDR_SPACE3  = AD_PCI_BAR5,
    P9060_ADDR_EPROM   = AD_PCI_BAR_EPROM
} P9060_ADDR;


enum { P9060_RANGE_REG = 0x00000080 };

typedef struct P9060_STRUCT *P9060_HANDLE;
typedef P9060_HANDLE P9060HANDLE;

typedef struct
{
    DWORD dwCounter;   // number of interrupts received
    DWORD dwLost;      // number of interrupts not yet dealt with
    BOOL fStopped;     // was interrupt disabled during wait
    DWORD dwStatusReg; // value of status register when interrupt occured
} P9060_INT_RESULT;
typedef void (WINAPI *P9060_INT_HANDLER)( P9060_HANDLE hPlx, P9060_INT_RESULT *intResult);

typedef struct
{
    WD_INTERRUPT Int;
    HANDLE hThread;
    WD_TRANSFER Trans[2];
    P9060_INT_HANDLER funcIntHandler;
} P9060_INTERRUPT;

typedef struct 
{
    DWORD dwLocalBase;
    DWORD dwMask;
    DWORD dwBytes;
    DWORD dwAddr;
    DWORD dwAddrDirect;
    BOOL  fIsMemory;
} P9060_ADDR_DESC;

typedef struct P9060_STRUCT
{
    HANDLE hWD;
    WD_CARD cardLock;
    WD_PCI_SLOT pciSlot;
    WD_CARD_REGISTER cardReg;
    P9060_ADDR_DESC addrDesc[AD_PCI_BARS];
    DWORD  addrSpace;
    BOOL   fUseInt;
    P9060_INTERRUPT Int;
    DWORD  modeDesc[3];
} P9060_STRUCT;

// options for PLX_Open
enum { P9060_OPEN_USE_INT =   0x1 };
enum { P9060_OPEN_USE_DMA =   0x2 }; // not yet implemented

DWORD P9060_CountCards (DWORD dwVendorID, DWORD dwDeviceID);
BOOL P9060_Open (P9060_HANDLE *phPlx, DWORD dwVendorID, DWORD dwDeviceID, DWORD nCardNum, DWORD dwOptions);
void P9060_Close (P9060_HANDLE hPlx);

BOOL P9060_IsAddrSpaceActive(P9060_HANDLE hPlx, P9060_ADDR addrSpace);

void P9060_ReadWriteBlock (P9060_HANDLE hPlx, DWORD dwLocalAddr, PVOID buf, 
                    DWORD dwBytes, BOOL fIsRead, P9060_MODE mode);
void P9060_ReadBlock (P9060_HANDLE hPlx, DWORD dwLocalAddr, PVOID buf, DWORD dwBytes, P9060_MODE mode);
void P9060_WriteBlock (P9060_HANDLE hPlx, DWORD dwLocalAddr, PVOID buf, DWORD dwBytes, P9060_MODE mode);
BYTE P9060_ReadByte (P9060_HANDLE hPlx, DWORD dwLocalAddr);
void P9060_WriteByte (P9060_HANDLE hPlx, DWORD dwLocalAddr, BYTE data);
WORD P9060_ReadWord (P9060_HANDLE hPlx, DWORD dwLocalAddr);
void P9060_WriteWord (P9060_HANDLE hPlx, DWORD dwLocalAddr, WORD data);
DWORD P9060_ReadDWord (P9060_HANDLE hPlx, DWORD dwLocalAddr);
void P9060_WriteDWord (P9060_HANDLE hPlx, DWORD dwLocalAddr, DWORD data);

BYTE P9060_ReadSpaceByte (P9060_HANDLE hPlx, P9060_ADDR addrSpace, DWORD dwOffset);
void P9060_WriteSpaceByte (P9060_HANDLE hPlx, P9060_ADDR addrSpace, DWORD dwOffset, BYTE data);
WORD P9060_ReadSpaceWord (P9060_HANDLE hPlx, P9060_ADDR addrSpace, DWORD dwOffset);
void P9060_WriteSpaceWord (P9060_HANDLE hPlx, P9060_ADDR addrSpace, DWORD dwOffset, WORD data);
DWORD P9060_ReadSpaceDWord (P9060_HANDLE hPlx, P9060_ADDR addrSpace, DWORD dwOffset);
void P9060_WriteSpaceDWord (P9060_HANDLE hPlx, P9060_ADDR addrSpace, DWORD dwOffset, DWORD data);
void P9060_ReadSpaceBlock (P9060_HANDLE hPlx, DWORD dwOffset, PVOID buf, 
                    DWORD dwBytes, P9060_ADDR addrSpace, P9060_MODE mode);
void P9060_WriteSpaceBlock (P9060_HANDLE hPlx, DWORD dwOffset, PVOID buf, 
                     DWORD dwBytes, P9060_ADDR addrSpace, P9060_MODE mode);

// interrupt functions
BOOL P9060_IntIsEnabled (P9060_HANDLE hPlx);
BOOL P9060_IntEnable (P9060_HANDLE hPlx, P9060_INT_HANDLER funcIntHandler);
void P9060_IntDisable (P9060_HANDLE hPlx);

// access registers
DWORD P9060_ReadReg (P9060_HANDLE hPlx, DWORD dwReg);
void P9060_WriteReg (P9060_HANDLE hPlx, DWORD dwReg, DWORD dwData);

// access PCI configuration registers
DWORD P9060_ReadPCIReg(P9060_HANDLE hPlx, DWORD dwReg);
void P9060_WritePCIReg(P9060_HANDLE hPlx, DWORD dwReg, DWORD dwData);

// this string is set to an error message, if one occurs
extern CHAR P9060_ErrorString[];

#ifdef __cplusplus
}
#endif

#endif
