/*
    OS/2 typedefs and constants for 32-bit development.
*/


#ifndef NULL
#define NULL  0
#endif

#ifndef TRUE
#define TRUE  1
#endif

#ifndef FALSE
#define FALSE 0
#endif

#define FAR
#define NEAR

#define FIELDOFFSET(type, field)   ((SHORT)&(((type *)0)->field))

#define MAKEULONG(l, h)  ((ULONG)(((USHORT)(l)) | ((ULONG)((USHORT)(h))) << 16))
#define MAKELONG(l, h)   ((LONG)MAKEULONG(l, h))
#define MAKEUSHORT(l, h) (((USHORT)(l)) | ((USHORT)(h)) << 8)
#define MAKESHORT(l, h)  ((SHORT)MAKEUSHORT(l, h))

#define LOBYTE(w)   LOUCHAR(w)
#define HIBYTE(w)   HIUCHAR(w)
#define LOUCHAR(w)  ((UCHAR)(w))
#define HIUCHAR(w)  ((UCHAR)(((USHORT)(w) >> 8) & 0xff))
#define LOUSHORT(l) ((USHORT)((ULONG)l))
#define HIUSHORT(l) ((USHORT)(((ULONG)(l) >> 16) & 0xffff))

#define NULLHANDLE  ((LHANDLE)0)

#define APIENTRY16 _Far16 _Pascal
#define PASCAL16   _Far16 _Pascal

#define EXPENTRY  _System
#define APIENTRY  _System

#define CHAR     char
#define SHORT    short
#define LONG     long
#define INT      int
#define VOID     void

typedef unsigned long   APIRET;
typedef unsigned short  APIRET16;

typedef unsigned char   UCHAR,  *PUCHAR;
typedef char            BYTE,   *PBYTE;
typedef unsigned short  USHORT, *PUSHORT;
typedef unsigned int    UINT,   *PUINT;
typedef unsigned long   ULONG,  *PULONG;

typedef unsigned short  SHANDLE;
typedef unsigned long   LHANDLE;

typedef char *PSZ;
typedef char *PCH;
typedef const char *PCSZ;

typedef unsigned long BOOL, *PBOOL;
typedef unsigned LONG BOOL32, *PBOOL32;

typedef CHAR     *PCHAR;
typedef SHORT    *PSHORT;
typedef INT      *PINT;
typedef LONG     *PLONG;

typedef VOID     *PVOID;
typedef PVOID    *PPVOID;

typedef int (APIENTRY _PFN)();
typedef _PFN  *PFN;

typedef USHORT  SEL, *PSEL;

typedef LHANDLE HFILE, *PHFILE;
typedef LHANDLE HMODULE, *PHMODULE;
typedef LHANDLE PID, *PPID;
typedef LHANDLE TID, *PTID;
typedef ULONG   HEV,  *PHEV;
typedef ULONG   HMTX, *PHMTX;
typedef ULONG   HMUX, *PHMUX;
typedef VOID    *HSEM;
typedef HSEM    *PHSEM;
typedef USHORT  SGID;

typedef struct _QWORD {
    ULONG   ulLo;
    ULONG   ulHi;
} QWORD, *PQWORD;
