/*
 *%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 *%	  Copyright (C) 1991, by WATCOM Systems Inc. All rights     %
 *%	  reserved. No part of this software may be reproduced	    %
 *%	  in any form or by any means - graphic, electronic or	    %
 *%	  mechanical, including photocopying, recording, taping     %
 *%	  or information storage and retrieval systems - except     %
 *%	  with the written permission of WATCOM Systems Inc.	    %
 *%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

  Modified:	By:		Reason:
  ---------	---		-------
  18-mar-92	Craig Eisler	defined for NT
  23-nov-92	Craig Eisler	exception handling
  22-feb-95	Greg Bentz	alpha support
  15-sep-95	Greg Bentz	ppc support
  16-oct-95	Greg Bentz	handle embedded whitespace in filenames
--------------------------------------------------------Version-11.0c--------
  05-apr-00	J.B.Schueler	Added a 2nd arg to __NewExceptionHandler to
				indicate that the unhandled exception filter
				should be installed.
*/
#include "variety.h"
#include "widechar.h"
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <malloc.h>
#include <process.h>
#include <windows.h>
#include "ntex.h"
#include "initfini.h"
#include "thread.h"

#ifdef __SW_BR
    _WCRTLINK extern	void	(*__process_fini)(unsigned,unsigned);
#else
    extern void __NTMainInit( void *, void * );
    extern	unsigned	__ASTACKSIZ;	/* alternate stack size */
    extern	char		*__ASTACKPTR;	/* alternate stack pointer */
    extern	unsigned	__ThreadDataSize;

    #ifdef _M_IX86
	#pragma aux	__ASTACKPTR "*"
	#pragma aux	__ASTACKSIZ "*"
    #endif
#endif

_WCRTLINK extern char	*_LpCmdLine;	/* pointer to command line */
_WCRTLINK extern wchar_t*_LpwCmdLine;	/* pointer to command line */

extern void __CommonInit( void );
extern int APIENTRY __F_NAME(WinMain,wWinMain)( HANDLE, HANDLE, CHAR_TYPE*, int );

void __F_NAME(__WinMain,__wWinMain)( void )
{
    #ifdef __SW_BR
    {
	#ifdef _M_IX86
	    REGISTRATION_RECORD rr;
	    __NewExceptionHandler( &rr, 1 );
	#endif
	__process_fini = &__FiniRtns;
	__InitRtns( 255 );
    }
    #else
    {
	REGISTRATION_RECORD	rr;
	thread_data		*tdata;
	__InitRtns( 1 );
	tdata = __alloca( __ThreadDataSize );
	memset( tdata, 0, __ThreadDataSize );
	// tdata->__allocated = 0;
	tdata->__data_size = __ThreadDataSize;
	__NTMainInit( &rr, tdata );
	/* allocate alternate stack for F77 */
	__ASTACKPTR = (char *)alloca( __ASTACKSIZ ) + __ASTACKSIZ;
    }
    #endif
    __CommonInit();
    exit( __F_NAME(WinMain,wWinMain)(
		GetModuleHandle( NULL ),
		0,
		__F_NAME(_LpCmdLine,_LpwCmdLine),
		SW_SHOWDEFAULT ) );
}
#ifdef _M_IX86
    #ifdef __WIDECHAR__
	#pragma aux __wWinMain "*";
    #else
	#pragma aux __WinMain "*";
    #endif
#endif
