/* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
   %       Copyright (C) 1992, by WATCOM Systems Inc. All rights     %
   %       reserved. No part of this software may be reproduced      %
   %       in any form or by any means - graphic, electronic or      %
   %       mechanical, including photocopying, recording, taping     %
   %       or information storage and retrieval systems - except     %
   %       with the written permission of WATCOM Systems Inc.        %
   %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  
   Date		By		Reason
   ----		--		------
   29-nov-93	Brent Williams	initial implementation
*/

#include <stddef.h>

#ifdef __cplusplus
extern "C" {
#endif


#if defined( __NT__ )
    typedef char *editstring;
    #define EDITAPI	__export __stdcall
#elif defined( __WINDOWS__ )
    typedef char far *editstring;
    #define EDITAPI	__export far pascal
#elif defined( __OS2__ )
    typedef char *editstring;
    #define EDITAPI	__syscall
#else
    #error Unsupported OS
    #define EDITAPI
#endif

typedef enum {
    EDIT_MINIMIZE,
    EDIT_RESTORE,
    EDIT_SHOWNORMAL
} show_method;

// this file should be identical for all app implementations
int EDITAPI EDITConnect( void );
int EDITAPI EDITFile( editstring, editstring );
int EDITAPI EDITLocate( long, int, int );
int EDITAPI EDITLocateError( long, int, int, int, editstring );
int EDITAPI EDITShowWindow( show_method );
int EDITAPI EDITDisconnect( void );
int EDITAPI EDITSaveFiles( void );
int EDITAPI EDITSaveThisFile( const char * );
int EDITAPI EDITQueryThisFile( const char * );

#ifdef __cplusplus
};
#endif
