/*
 *%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 *%									   %
 *%	Copyright (C) 1991,1994 by WATCOM International Inc.		   %
 *%	All rights reserved.						   %
 *%									   %
 *%     Permission is granted to anyone to use this example program for	   %
 *%     any purpose on any computer system, subject to the following	   %
 *%	restrictions:							   %
 *%									   %
 *%     1. This example is provided on an "as is" basis, without warranty. %
 *%	   You indemnify, hold harmless and defend WATCOM from and against %
 *%	   any claims or lawsuits, including attorney's, that arise or	   %
 *%	   result from the use or distribution of this example, or any     %
 *%	   modification thereof.					   %
 *%									   %
 *%     2. You may not remove, alter or suppress this notice from this	   %
 *%        example program or any modification thereof.			   %
 *%									   %
 *%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 *
 * UTIL.C
 *
 */
#include <windows.h>
#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>

#include "view.h"

/*
 * UtilMalloc - keeps trying to allocate memory until either the malloc
 * succeeds or the user kills the icon viewer from the task manager.
 */

void *UtilMalloc( unsigned long bytes )
{
    void	*mem;
    char	buff[ 80 ];

    mem = NULL;
    while( ( mem = malloc( bytes ) ) == NULL ) {
	sprintf( buff, 
	   "Memory allocation failed - need %lu bytes.\nTry again?", bytes );
	MessageBox( FrameWindow, buff, NULL, MB_OK | MB_ICONQUESTION );
    }
    return( mem );
}

/*
 * UtilFree - does nothing, but is included in case UtilMalloc changes.
 */

void UtilFree( void *mem )
{
    free( mem );
}
