/*
 *%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 *%									   %
 *%	Copyright (C) 1991, 1994 by WATCOM International Inc. All rights   %
 *%	reserved.    							   %
 *%									   %
 *%     Permission is granted to anyone to use this example program for	   %
 *%     any purpose on any computer system, subject to the following	   %
 *%	restrictions:							   %
 *%									   %
 *%     1. This example is provided on an "as is" basis, without warranty. %
 *%	   You indemnify, hold harmless and defend WATCOM from and against %
 *%	   any claims or lawsuits, including attorney's, that arise or	   %
 *%	   result from the use or distribution of this example, or any     %
 *%	   modification thereof.					   %
 *%									   %
 *%     2. You may not remove, alter or suppress this notice from this	   %
 *%        example program or any modification thereof.			   %
 *%									   %
 *%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

 FLOAT.C

    This file defines the process routines for Float field.

*/

#include <windows.h>
#include <stdio.h>
#include <string.h>
#include "ctltype.h"

    
BOOL ctl_float_start( ctl_elt *elt, HANDLE inst, HWND dlg, void *ptr )
/********************************************************************/
/* start a float field */

{
    char		buf[50];
    char		*str;
    int			dec;
    float		value;
    
    inst = inst;
    
    value = _value_float( ptr, elt );
    sprintf( buf, "%f", value );
    for( str = buf + strlen( buf ) - 1; *str == '0'; --str );
    for( dec = 0; *str != '.'; --str, ++dec );
    if( dec < 2 ) {
        dec = 2;
    }

    sprintf( buf, "%-.*f", dec, value );
    
    SetDlgItemText( dlg, elt->control, buf );
    
    return( TRUE );
}
    
BOOL ctl_float_finish( ctl_elt *elt, HANDLE inst, HWND dlg, void *ptr )
/*********************************************************************/
/* end a float field */

{
    char		str[50];
    float		value;
    
    inst = inst;
    
    GetDlgItemText( dlg, elt->control, str, 50 );
    str[49] = '\0';
    
    if( 1 == sscanf( str, "%f", &value ) ) {
	_value_float( ptr, elt ) = value;
    } else {
	SetFocus( GetDlgItem( dlg, elt->control ) );
	MessageBox( dlg, "Invalid value: please re-enter it", NULL,
					MB_APPLMODAL | MB_ICONHAND | MB_OK );
	return( FALSE );
    }
    
    return( TRUE );
}
