/*
 *%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 *%									   %
 *%	Copyright (C) 1994 by WATCOM International Inc.		   	   %
 *%	All rights reserved.						   %
 *%									   %
 *%     Permission is granted to anyone to use this example program for	   %
 *%     any purpose on any computer system, subject to the following	   %
 *%	restrictions:							   %
 *%									   %
 *%     1. This example is provided on an "as is" basis, without warranty. %
 *%	   You indemnify, hold harmless and defend WATCOM from and against %
 *%	   any claims or lawsuits, including attorney's, that arise or	   %
 *%	   result from the use or distribution of this example, or any     %
 *%	   modification thereof.					   %
 *%									   %
 *%     2. You may not remove, alter or suppress this notice from this	   %
 *%        example program or any modification thereof.			   %
 *%									   %
 *%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 */
// Definitions for the 3D graphics library

typedef enum three_d_attr {
    THREE_D_HORZ_ANGLE,
    THREE_D_VERT_ANGLE,
    THREE_D_ZOOM,
    THREE_D_PERSPECTIVE,
    THREE_D_BRIGHTNESS,
    THREE_D_CONTRAST,
    THREE_D_LIGHT_HORZ,
    THREE_D_LIGHT_VERT,
    THREE_D_LIGHT_DEPTH
} three_d_attr;

typedef int three_d_handle;

#if defined(__OS2__)
    #define ENTRYPOINT  __export _System
    #define WPI_PRES    HPS
#else
    #define RECTL       RECT
    #define WPI_PRES    HDC
    #if defined(__WINDOWS_386__)
        #define ENTRYPOINT
    #else
        #define ENTRYPOINT      __export FAR PASCAL
    #endif
#endif

void ENTRYPOINT three_d_init();
void ENTRYPOINT three_d_fini();
three_d_handle ENTRYPOINT three_d_begin( WPI_PRES dc, RECTL * draw_area );
void ENTRYPOINT three_d_box( three_d_handle handle,
                  float x1, float x2, float y1, float y2, float z1, float z2,
                  unsigned red, unsigned green, unsigned blue );
void ENTRYPOINT three_d_draw( three_d_handle handle );
void ENTRYPOINT three_d_end( three_d_handle handle );

// Attribute setting & changing

int ENTRYPOINT three_d_get( three_d_handle handle, three_d_attr attr );
void ENTRYPOINT three_d_set( three_d_handle handle, three_d_attr attr, int new_val );
