#****************************************************************************
#
#  Work Place Shell - WPSTutorial Sample makefile - SOM 2.0 / IDL version
#
#  This makefile builds the WPSTutorial Object Class and WPSTUTOR.DLL.
#  This class relies on the existence of SHOWDESC.EXE
#
#  Copyright (C) 1993, 1995  IBM Corporation
#
#      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
#      sample code created by IBM Corporation. This sample code is not
#      part of any standard or IBM product and is provided to you solely
#      for  the purpose of assisting you in the development of your
#      applications.  The code is provided "AS IS", without
#      warranty of any kind.  IBM shall not be liable for any damages
#      arising out of your use of the sample code, even if they have been
#      advised of the possibility of such damages.
#
#      NOTE: you will have to modify the environment variables to suit
#            your environment
#
#****************************************************************************

!include ..\..\ibmsamp.inc

#****************************************************************************
#  Dot directive definition area (usually just suffixes)
#****************************************************************************

.SUFFIXES:
.SUFFIXES: .c .obj .dll .idl .h .ih .rc .def

#****************************************************************************
#  Environment Setup for the component(s).
#****************************************************************************

SOMTEMP = .\somtemp


!if [cd $(SOMTEMP)]
!  if [md $(SOMTEMP)]
!    error error creating $(SOMTEMP) directory
!  endif
!else
!  if [cd ..]
!    error - Couldn't cd .. from $(SOMTEMP) directory
!  endif
!endif


#
# Compiler/tools Macros
#

CFLAGS  = $(CFLAG)
CC      = icc
LINK    = LINK386
LDFLAGS = /noi /map /nol /nod /exepack /packcode /packdata /align:16 /CO
DLLLIBS = DDE4NBS + os2386 + somtk


#****************************************************************************
# Set up Macros that will contain all the different dependencies for the
# executables and dlls etc. that are generated.
#****************************************************************************

OBJS = wpstutor.obj

#****************************************************************************
#   Setup the inference rules for compiling source code to
#   object code.
#****************************************************************************

.idl.ih:
        sc -p -v -maddstar -mnoint -S128000 -C128000  $*.idl

.idl.c:
        sc -p -v -maddstar -mnoint -S128000 -C128000 -sc $*.idl

.idl.def:
        sc -p -v -maddstar -mnoint -S128000 -C128000 -s def $*.idl

.c.obj:
        $(CC) $(CFLAG) /Ge- /Ti /O- /Gh -c $<

all: wpstutor.dll

#
# Specific Process Tag
#

wpstutor.ih:  $$(@B).IDL

wpstutor.obj: $$(@B).IH   $$(@B).H  $$(@B).IDL $$(@B).C \
              methodid.h

wpstutor.dll: $$(@B).def $(OBJS) wpstutor.res
         $(LINK) $(LDFLAGS) $(OBJS),$@,,$(DLLLIBS),$*;
         rc -p -x $*.res $*.dll
         mapsym wpstutor.map

wpstutor.res: $$(@B).rc $$(@B).ih $$(@B).ico
         rc -r $*.rc $*.res
