# SCCSID = @(#)makefile 13.7 92/04/22
#**************************************************************************
#
# MAKE file for Tuner Sample Application
#
# Assumes that the environment is set up for development.  Specifically,
# the compiler, linker, rc and ipfc  should be in the path.  Also, the
# environment variables for the tools must be properly set, e.g. LIB,
# INCLUDE, IPFC. This should all be taken care of automatically by
# installing the OS/2 Toolkit and the MMPM/2 Toolkit.
#
#**************************************************************************

CC          = icc
LINK        = link386

BASELIBS    = DDE4MBS.LIB OS2386.LIB MMPM2.LIB

DEBUG       = /Ti+ /O-
LDEBUG      = de

#
# Compilation Switches
#
#     /G3s           : Generate 386 code with no stack checking.
#     /C+            : Compile only one module.
#     /W3            : Warning level.
#     /Gd-           : Link to static C libraries.
#     /Gm+           : Use multithreaded libraries.
#     /DINCL_32      : Use IBM code.
#     /Ti+           : Generate debugging code.
#     /Sm            : Generate debugging code.
#     /O-            : Turn optimization off.
#

COMPILE = /C+ /W3 /Ki- /Kb- /Ss+ /Gd- /Ms /Gm+ /DINCL_32

CFLAGS = $(COMPILE)

#
# Link Switches
#
#    /map     : Creates a listing file containing all pulbic symbols.
#    /nod     : Causes all default libraries to be ignored.
#    /noe     : The linker will not search the extended dictionary.
#    /de      : Generate debugging info
#

LFLAGS  = /map /nod /noe

all: tuner.exe

tuner.exe: tuner.obj tuner.res tuner.def
  $(LINK) tuner.obj, tuner.exe, $(LFLAGS) /ST:20000, $(BASELIBS), tuner.def
  $(RC) tuner.res

tuner.obj: tuner.c tuner.h
  $(CC) $(CFLAGS) tuner.c

tuner.res: tuner.rc tuner.dlg tuner.h tuner.ico
  rc -r tuner.rc
