#################################################################################
#                                                                               #
# Makefile for OS/2 MMPM/2 MCISPY Application                                   #
#                                                                               #
#   Generates one executable and a DLL:                                         #
#   MCISPY.EXE                                                                  #
#   MDM.DLL                                                                     #
#                                                                               #
# Copyright (c) IBM Corporation  1993                                           #
#################################################################################
.SUFFIXES: .com .sys .exe .obj .mbj .def .lrf .rc .ref \
           .lst .sym .map .c .h .lib .msg .ipf .res

NAMEEXE=MCISPY
NAMEDLL=MDM

#################################
# Target Descriptions
#################################
all: MCISPY.exe MCISPY.HLP MCISPY.RES MDM.DLL

reses: MCISPY.res
###########################################################
# Definitions for C Compiler
# Compiler flags:
#    /C+  Compile only
#    /Gd- Static link run time library
#    /Ge- Build a .DLL file
#    /Gm+ Link with multi-threaded version of library
#    /Gs- Remove stack probes
#    /Re  Generate code for C Set/2 run-time environment
#    /J-  Set unspecified char variables to signed char
#    /Kb- Suppress basic diagnostics messages
#    /Ki- Suppress messages about uninitialized variables
#    /Ms  Use SYSTEM linkage for functions
#    /Sm  Allow migration extensions
#    /Sn  Do not allow DBCS
#    /Ss+ Allow double slash format for comments
#    /D   preprocessor macro name INCL_32
###########################################################

CC=icc
###########################################################################
# Definitions for linker
# LIBS:
#    DDE4MBS.LIB - C Set/2 Multi-threaded Standard Library function calls
#    OS2386.LIB  - OS.2 function calls
#    MMPM2.LIB   - MMPM2 function calls
###########################################################################
!ifdef DEBUG
LINK_DEBUG=/CO /DEBUG
C_DEBUG= /Ti+ /O- /Gh
!endif
LINK=link386
MAP = mapsym
CFLAGS = $(C_DEBUG) /Ss /Ms /Ge+ /Re /Q /G3 /C /Gm+
DLLCFLAGS = $(C_DEBUG) /Ss /Ms /Ge- /Re /Q /G3 /C /Gm+  /DINCL_32 /DINCL_OS2MM
LFLAGS= $(LINK_DEBUG)/nod /noi /map /noe /de  /PM:PM /packcode /packdata /exepack
LIBS= DDE4MBS.LIB OS2386.lib MMPM2.LIB

#################################
# Object file lists
#################################

OBJS=mcispy.obj   \
     mcisubs.obj  \
     mcitbl.obj   \
     dlgprocs.obj

DLLOBJS=MDM.OBJ

#################################
# Inference Rules
#################################
.ipf.hlp:
    $(IPFC) $*.ipf > $*.err

.c.obj:
        $(CC) $(CFLAGS) $*.C

MDM.OBJ:
        $(CC) $(DLLCFLAGS) MDM.C


###############################
# Resource File
###############################

$(NAMEEXE).res: $(NAMEEXE).rc $(NAMEEXE).dlg $(NAMEEXE).h
   rc -r MCISPY.rc


$(NAMEEXE).HLP: $(NAMEEXE).ipf $(NAMEEXE).h
   ipfc mcispy.ipf

##################################
# mcispy.exe Target Descriptions
##################################
exe: $(NAMEEXE).exe $(NAMEEXE).h

$(NAMEEXE).exe: $(OBJS) MCISPY.RES mcispy.mak $(NAMEEXE).lrf $(NAMEEXE).def
 $(LINK) $(LFLAGS) $(OBJS), $(NAMEEXE).exe, $(NAMEEXE), $(LIBS), $(NAMEEXE).DEF
 rc  mcispy.res  mcispy.exe
 $(MAP) $(NAMEEXE).map

#######################################################################
#### Note: MDMCMD.RES is in this component directory and if deleted
#### should be reecopied
########################################################################

$(NAMEDLL).dll: $(DLLOBJS)  mcispy.mak $(NAMEDLL).lrf $(NAMEDLL).def
 $(LINK) $(LFLAGS) $(DLLOBJS), mdm.dll, mdm, $(LIBS), mdm.DEF
 $(RC) mdmcmd.res mdm.dll
 $(MAP) $(NAMEDLL).map


$(NAMEEXE).lrf: mcispy.mak
        @echo Make $(NAMEEXE).LRF file
        @echo $(OBJS)                                    > $(NAMEEXE).lrf
        @echo $(NAMEEXE).exe                             >> $(NAMEEXE).lrf
        @echo $(NAMEEXE).map $(LFLAGS)                   >> $(NAMEEXE).lrf
        @echo $(LIBS)                                    >> $(NAMEEXE).lrf
        @echo $(NAMEEXE).def;                            >> $(NAMEEXE).lrf

$(NAMEEXE).def: mcispy.mak
        @echo Make $(NAMEEXE).DEF file
        @echo NAME MCISPY WINDOWAPI                        >  $(NAMEEXE).def
        @echo DESCRIPTION 'Multimedia MCI Message Spy V1.0' >> $(NAMEEXE).def
        @echo STACKSIZE 65536                              >> $(NAMEEXE).def
        @echo HEAPSIZE  40000                              >> $(NAMEEXE).def
        @echo PROTMODE                                     >> $(NAMEEXE).def



#####################################################################
# MDM.DLL Link Response File generation
#####################################################################

$(NAMEDLL).lrf: mcispy.mak
        @echo Make $(NAMEDLL).LRF file
        @echo $(DLLOBJS)                                 > $(NAMEDLL).lrf
        @echo $(NAMEDLL).exe                             >> $(NAMEDLL).lrf
        @echo $(NAMEDLL).map $(LFLAGS)                   >> $(NAMEDLL).lrf
        @echo $(LIBS)                                    >> $(NAMEDLL).lrf
        @echo $(NAMEDLL).def;                            >> $(NAMEDLL).lrf

#####################################################################
# MDM.DLL Module Definition  File generation
#####################################################################
$(NAMEDLL).def: mcispy.mak
        @echo Make $(NAMEDLL).DEF file

        @echo LIBRARY MDM INITINSTANCE TERMINSTANCE        >  $(NAMEDLL).def
        @echo SEGMENTS                                     >>  $(NAMEDLL).def
        @echo   SHR_SEG   CLASS 'DATA' SHARED              >>  $(NAMEDLL).def
        @echo DATA MULTIPLE NONSHARED                      >>  $(NAMEDLL).def
        @echo IMPORTS                                      >> $(NAMEDLL).def
        @echo        mciGetErrorString          = mci.3     >> $(NAMEDLL).def
        @echo        mciQueryDefaultConnections = mci.6     >> $(NAMEDLL).def
        @echo        mciDefaultConnection       = mci.7     >> $(NAMEDLL).def
        @echo        mciQueryConnections        = mci.8     >> $(NAMEDLL).def
        @echo        mciConnection              = mci.9     >> $(NAMEDLL).def
        @echo        mciSetSysValue             = mci.10    >> $(NAMEDLL).def
        @echo        mciQuerySysValue           = mci.11    >> $(NAMEDLL).def
        @echo        mciMakeGroup               = mci.12    >> $(NAMEDLL).def
        @echo        mciDeleteGroup             = mci.13    >> $(NAMEDLL).def
        @echo        mciGetDeviceID             = mci.16    >> $(NAMEDLL).def
        @echo        mdmDriverNotify            = mci.17    >> $(NAMEDLL).def
        @echo        MCI16GETERRORSTRING        = mci.18    >> $(NAMEDLL).def
        @echo        MCI16SENDSTRING            = mci.19    >> $(NAMEDLL).def
        @echo        MCI16GETDEVICEID           = mci.20    >> $(NAMEDLL).def
        @echo        MM_DosLoadModule           = mci.21    >> $(NAMEDLL).def
        @echo EXPORTS                                      >> $(NAMEDLL).def
        @echo        mciSendCommand              @1        >> $(NAMEDLL).def
        @echo        mciSendString               @2        >> $(NAMEDLL).def
        @echo        mciGetErrorString           @3        >> $(NAMEDLL).def
        @echo        mciQueryDefaultConnections  @6        >> $(NAMEDLL).def
        @echo        mciDefaultConnection        @7        >> $(NAMEDLL).def
        @echo        mciQueryConnections         @8        >> $(NAMEDLL).def
        @echo        mciConnection               @9        >> $(NAMEDLL).def
        @echo        mciSetSysValue              @10       >> $(NAMEDLL).def
        @echo        mciQuerySysValue            @11       >> $(NAMEDLL).def
        @echo        mciMakeGroup                @12       >> $(NAMEDLL).def
        @echo        mciDeleteGroup              @13       >> $(NAMEDLL).def
        @echo        mciGetDeviceID              @16       >> $(NAMEDLL).def
        @echo        mdmDriverNotify             @17       >> $(NAMEDLL).def
        @echo        MCI16GETERRORSTRING         @18       >> $(NAMEDLL).def
        @echo        MCI16SENDSTRING             @19       >> $(NAMEDLL).def
        @echo        MCI16GETDEVICEID            @20       >> $(NAMEDLL).def
        @echo        MM_DosLoadModule            @21       >> $(NAMEDLL).def
        @echo        RegisterSpy                 @22       >> $(NAMEDLL).def
        @echo        QueryOpenInstance           @23       >> $(NAMEDLL).def
        @echo        SpySystemSounds             @24       >> $(NAMEDLL).def

